/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.repurposedstructures.world.features;

import com.mojang.serialization.Codec;
import com.telepathicgrunt.repurposedstructures.RepurposedStructures;
import com.telepathicgrunt.repurposedstructures.utils.OpenSimplex2F;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.material.Material;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.NoFeatureConfig;

public class BoulderGiant
extends Feature<NoFeatureConfig> {
    private static final int START_RADIUS = 4;
    protected long seed;
    protected static OpenSimplex2F noiseGen;

    public void setSeed(long seed) {
        if (this.seed != seed || noiseGen == null) {
            noiseGen = new OpenSimplex2F(seed);
            this.seed = seed;
        }
    }

    public BoulderGiant(Codec<NoFeatureConfig> configFactory) {
        super(configFactory);
    }

    public boolean generate(ISeedReader world, ChunkGenerator chunkGenerator, Random random, BlockPos position, NoFeatureConfig config) {
        boolean disabledDiamonds;
        this.setSeed(world.func_72905_C());
        BlockPos.Mutable blockpos$Mutable = new BlockPos.Mutable().func_189533_g((Vector3i)position);
        BlockState blockState = world.func_180495_p((BlockPos)blockpos$Mutable);
        while (blockpos$Mutable.func_177956_o() >= 6) {
            if (blockState.func_185904_a() == Material.field_151579_a || blockState.func_177230_c() != Blocks.field_196658_i && !BoulderGiant.func_227250_b_((Block)blockState.func_177230_c())) {
                blockpos$Mutable.func_189536_c(Direction.DOWN);
                blockState = world.func_180495_p((BlockPos)blockpos$Mutable);
                continue;
            }
            blockpos$Mutable.func_189536_c(Direction.UP);
            break;
        }
        if (blockpos$Mutable.func_177956_o() <= 10 || blockpos$Mutable.func_177956_o() >= 250) {
            return false;
        }
        int chanceRange = RepurposedStructures.RSMainConfig.diamondChanceInGiantBoulders.get();
        boolean bl = disabledDiamonds = chanceRange == 0;
        if (disabledDiamonds) {
            chanceRange = 3000;
        }
        for (int currentCount = 0; currentCount < 3; ++currentCount) {
            int x = 4 + random.nextInt(2);
            int y = 4 + random.nextInt(2);
            int z = 4 + random.nextInt(2);
            float calculatedDistance = (float)(x + y + z) * 0.333f + 0.5f;
            for (BlockPos blockpos : BlockPos.func_218278_a((BlockPos)blockpos$Mutable.func_177982_a(-x, -y, -z), (BlockPos)blockpos$Mutable.func_177982_a(x, y, z))) {
                if (!(blockpos.func_177951_i((Vector3i)blockpos$Mutable) <= (double)(calculatedDistance * calculatedDistance))) continue;
                double noiseValue = noiseGen.noise3_Classic((double)blockpos.func_177958_n() * 0.035, (double)blockpos.func_177956_o() * 0.0075, (double)blockpos.func_177952_p() * 0.035);
                if (blockpos.func_177951_i((Vector3i)blockpos$Mutable) > (double)(calculatedDistance * calculatedDistance * 0.55f) && noiseValue > -0.3 && noiseValue < 0.3) continue;
                int randomChance = random.nextInt(chanceRange);
                if (!disabledDiamonds && randomChance == 0) {
                    world.func_180501_a(blockpos, Blocks.field_150482_ag.func_176223_P(), 4);
                    continue;
                }
                if ((float)randomChance <= (float)chanceRange * 0.001f) {
                    world.func_180501_a(blockpos, Blocks.field_150366_p.func_176223_P(), 4);
                    continue;
                }
                if ((float)randomChance <= (float)chanceRange * 0.05f) {
                    world.func_180501_a(blockpos, Blocks.field_150365_q.func_176223_P(), 4);
                    continue;
                }
                if ((float)randomChance <= (float)chanceRange * 0.257f) {
                    world.func_180501_a(blockpos, Blocks.field_196656_g.func_176223_P(), 4);
                    continue;
                }
                if ((float)randomChance <= (float)chanceRange * 0.25f) {
                    world.func_180501_a(blockpos, Blocks.field_150347_e.func_176223_P(), 4);
                    continue;
                }
                world.func_180501_a(blockpos, Blocks.field_150341_Y.func_176223_P(), 4);
            }
            blockpos$Mutable.func_196234_d(-5 + random.nextInt(10), 0, -5 + random.nextInt(10));
            blockpos$Mutable.func_189534_c(Direction.UP, world.func_201676_a(Heightmap.Type.WORLD_SURFACE_WG, blockpos$Mutable.func_177958_n(), blockpos$Mutable.func_177952_p()) + 1 - random.nextInt(2) - blockpos$Mutable.func_177956_o());
        }
        return true;
    }
}

