/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.repurposedstructures.world.features;

import com.mojang.serialization.Codec;
import com.telepathicgrunt.repurposedstructures.RepurposedStructures;
import java.util.Random;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.LeavesBlock;
import net.minecraft.block.VineBlock;
import net.minecraft.block.material.Material;
import net.minecraft.state.Property;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.LockableLootTileEntity;
import net.minecraft.tileentity.MobSpawnerTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import net.minecraft.world.gen.feature.structure.StructurePiece;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DungeonDarkForest
extends Feature<NoFeatureConfig> {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final ResourceLocation CHEST_LOOT = new ResourceLocation("repurposed_structures:chests/dungeon/dark_forest");
    private static final ResourceLocation SPAWNER_ID = new ResourceLocation("repurposed_structures:dungeon_dark_forest");
    private static final BlockState CAVE_AIR = Blocks.field_201941_jj.func_176223_P();
    private static final BlockState LEAVES = (BlockState)Blocks.field_196574_ab.func_176223_P().func_206870_a((Property)LeavesBlock.field_208494_a, (Comparable)Integer.valueOf(1));
    private static final BlockState LOGS = Blocks.field_196623_P.func_176223_P();
    private static final BlockState SIDEWAYS_LOGS = (BlockState)Blocks.field_196623_P.func_176223_P().func_206870_a((Property)BlockStateProperties.field_208148_A, (Comparable)Direction.Axis.X);
    private static final BlockState PLANKS = Blocks.field_196672_s.func_176223_P();

    public DungeonDarkForest(Codec<NoFeatureConfig> configFactory) {
        super(configFactory);
    }

    public boolean generate(ISeedReader world, ChunkGenerator chunkGenerator, Random random, BlockPos position, NoFeatureConfig config) {
        int z;
        int y;
        int x;
        int randXRange = random.nextInt(2) + 2;
        int xMin = -randXRange - 1;
        int xMax = randXRange + 1;
        int randZRange = random.nextInt(2) + 2;
        int zMin = -randZRange - 1;
        int zMax = randZRange + 1;
        int validOpenings = 0;
        int ceilingOpenings = 0;
        BlockPos.Mutable blockpos$Mutable = new BlockPos.Mutable().func_189533_g((Vector3i)position);
        for (x = xMin; x <= xMax; ++x) {
            for (y = -1; y <= 4; ++y) {
                for (z = zMin; z <= zMax; ++z) {
                    blockpos$Mutable.func_189533_g((Vector3i)position).func_196234_d(x, y, z);
                    Material material = world.func_180495_p((BlockPos)blockpos$Mutable).func_185904_a();
                    boolean flag = material.func_76220_a();
                    if (y == -1 && !flag) {
                        return false;
                    }
                    if (y == 4 && !flag) {
                        ++ceilingOpenings;
                    }
                    if (x != xMin && x != xMax && z != zMin && z != zMax || y != 0 || !world.func_175623_d((BlockPos)blockpos$Mutable) || !world.func_175623_d(blockpos$Mutable.func_177984_a())) continue;
                    ++validOpenings;
                }
            }
        }
        if (validOpenings >= 1 && validOpenings <= 14 && ceilingOpenings < 14) {
            for (x = xMin; x <= xMax; ++x) {
                for (y = 4; y >= -1; --y) {
                    for (z = zMin; z <= zMax; ++z) {
                        blockpos$Mutable.func_189533_g((Vector3i)position).func_196234_d(x, y, z);
                        if (y == 4) {
                            if (random.nextInt(3) == 0) {
                                world.func_180501_a((BlockPos)blockpos$Mutable, SIDEWAYS_LOGS, 2);
                                continue;
                            }
                            world.func_180501_a((BlockPos)blockpos$Mutable, LEAVES, 2);
                            continue;
                        }
                        if (x != xMin && y != -1 && z != zMin && x != xMax && y != 4 && z != zMax) {
                            if (world.func_180495_p((BlockPos)blockpos$Mutable).func_177230_c() == Blocks.field_150486_ae || world.func_180495_p((BlockPos)blockpos$Mutable).func_177230_c() == Blocks.field_150474_ac) continue;
                            world.func_180501_a((BlockPos)blockpos$Mutable, CAVE_AIR, 2);
                            continue;
                        }
                        if (blockpos$Mutable.func_177956_o() >= 0 && !world.func_180495_p(blockpos$Mutable.func_177977_b()).func_185904_a().func_76220_a()) {
                            world.func_180501_a((BlockPos)blockpos$Mutable, CAVE_AIR, 2);
                            continue;
                        }
                        if (!world.func_180495_p((BlockPos)blockpos$Mutable).func_185904_a().func_76220_a() || world.func_180495_p((BlockPos)blockpos$Mutable).func_177230_c() == Blocks.field_150486_ae || world.func_180495_p((BlockPos)blockpos$Mutable).func_177230_c() == Blocks.field_150474_ac) continue;
                        if (y == -1 && random.nextInt(5) != 0) {
                            world.func_180501_a((BlockPos)blockpos$Mutable, PLANKS, 2);
                            continue;
                        }
                        if (random.nextInt(3) == 0) {
                            world.func_180501_a((BlockPos)blockpos$Mutable, LOGS, 2);
                            continue;
                        }
                        world.func_180501_a((BlockPos)blockpos$Mutable, LEAVES, 2);
                    }
                }
            }
            blockpos$Mutable.func_189533_g((Vector3i)position);
            for (x = xMin + 1; x <= xMax - 1; ++x) {
                for (int z2 = zMin + 1; z2 <= zMax - 1; ++z2) {
                    if (x != xMin + 1 && z2 != zMin + 1 && x != xMax - 1 && z2 != zMax - 1) continue;
                    for (int y2 = 3; y2 >= 0; --y2) {
                        Direction face = null;
                        for (Direction facing : Direction.Plane.HORIZONTAL) {
                            Material wallMaterial = world.func_180495_p(blockpos$Mutable.func_177982_a(x, y2, z2).func_177972_a(facing)).func_185904_a();
                            if (wallMaterial != Material.field_151584_j && wallMaterial != Material.field_151575_d) continue;
                            face = facing;
                            break;
                        }
                        if (face == null || random.nextInt(6) != 0) continue;
                        world.func_180501_a(blockpos$Mutable.func_177982_a(x, y2, z2), (BlockState)Blocks.field_150395_bd.func_176223_P().func_206870_a((Property)VineBlock.field_196546_A.get(face), (Comparable)Boolean.valueOf(true)), 2);
                    }
                }
            }
            block10: for (int l3 = 0; l3 < 2; ++l3) {
                for (int j4 = 0; j4 < 3; ++j4) {
                    int x2 = position.func_177958_n() + random.nextInt(randXRange * 2 + 1) - randXRange;
                    int y3 = position.func_177956_o();
                    int z3 = position.func_177952_p() + random.nextInt(randZRange * 2 + 1) - randZRange;
                    blockpos$Mutable.func_181079_c(x2, y3, z3);
                    if (!world.func_175623_d((BlockPos)blockpos$Mutable)) continue;
                    int j3 = 0;
                    for (Direction Direction2 : Direction.Plane.HORIZONTAL) {
                        if (!world.func_180495_p(blockpos$Mutable.func_177972_a(Direction2)).func_185904_a().func_76220_a()) continue;
                        ++j3;
                    }
                    if (j3 != true) continue;
                    world.func_180501_a((BlockPos)blockpos$Mutable, StructurePiece.func_197528_a((IBlockReader)world, (BlockPos)blockpos$Mutable, (BlockState)Blocks.field_150486_ae.func_176223_P()), 2);
                    LockableLootTileEntity.func_195479_a((IBlockReader)world, (Random)random, (BlockPos)blockpos$Mutable, (ResourceLocation)CHEST_LOOT);
                    continue block10;
                }
            }
            world.func_180501_a(position, Blocks.field_150350_a.func_176223_P(), 2);
            world.func_180501_a(position, Blocks.field_150474_ac.func_176223_P(), 2);
            TileEntity tileentity = world.func_175625_s(position);
            if (tileentity instanceof MobSpawnerTileEntity) {
                ((MobSpawnerTileEntity)tileentity).func_145881_a().func_200876_a(RepurposedStructures.mobSpawnerManager.getSpawnerMob(SPAWNER_ID, random));
            } else {
                LOGGER.error("Failed to fetch mob spawner entity at ({}, {}, {})", new Object[]{position.func_177958_n(), position.func_177956_o(), position.func_177952_p()});
            }
            return true;
        }
        return false;
    }
}

