/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.repurposedstructures.world.features;

import com.mojang.serialization.Codec;
import com.telepathicgrunt.repurposedstructures.RepurposedStructures;
import java.util.Random;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.material.Material;
import net.minecraft.tileentity.LockableLootTileEntity;
import net.minecraft.tileentity.MobSpawnerTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import net.minecraft.world.gen.feature.structure.StructurePiece;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DungeonNether
extends Feature<NoFeatureConfig> {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final BlockState CAVE_AIR = Blocks.field_201941_jj.func_176223_P();
    private static final ResourceLocation CHEST_LOOT = new ResourceLocation("repurposed_structures:chests/dungeon/nether");
    private static final ResourceLocation HIGH_SPAWNER_ID = new ResourceLocation("repurposed_structures:dungeon_nether_high");
    private static final ResourceLocation LOW_SPAWNER_ID = new ResourceLocation("repurposed_structures:dungeon_nether_low");

    public DungeonNether(Codec<NoFeatureConfig> configFactory) {
        super(configFactory);
    }

    public boolean generate(ISeedReader world, ChunkGenerator chunkGenerator, Random random, BlockPos position, NoFeatureConfig config) {
        BlockState blockstate;
        int z;
        int y;
        int x;
        int randXRange = random.nextInt(2) + 2;
        int xMin = -randXRange - 1;
        int xMax = randXRange + 1;
        int randZRange = random.nextInt(2) + 2;
        int zMin = -randZRange - 1;
        int zMax = randZRange + 1;
        int validOpenings = 0;
        int ceilingOpenings = 0;
        BlockPos.Mutable blockpos$Mutable = new BlockPos.Mutable().func_189533_g((Vector3i)position);
        for (x = xMin; x <= xMax; ++x) {
            for (y = -1; y <= 4; ++y) {
                for (z = zMin; z <= zMax; ++z) {
                    blockpos$Mutable.func_189533_g((Vector3i)position).func_196234_d(x, y, z);
                    Material material = world.func_180495_p((BlockPos)blockpos$Mutable).func_185904_a();
                    boolean flag = material.func_76220_a();
                    if (y == -1 && !flag) {
                        return false;
                    }
                    if (y == 4 && !flag) {
                        ++ceilingOpenings;
                    }
                    if (x != xMin && x != xMax && z != zMin && z != zMax || y != 0) continue;
                    blockstate = world.func_180495_p((BlockPos)blockpos$Mutable);
                    if (!world.func_175623_d((BlockPos)blockpos$Mutable) && blockstate.func_185904_a() != Material.field_151587_i || !world.func_175623_d(blockpos$Mutable.func_177984_a()) && world.func_180495_p(blockpos$Mutable.func_177984_a()).func_185904_a() != Material.field_151587_i) continue;
                    ++validOpenings;
                }
            }
        }
        if (validOpenings >= 1 && validOpenings <= 14 && ceilingOpenings < 14) {
            for (x = xMin; x <= xMax; ++x) {
                for (y = 3; y >= -1; --y) {
                    for (z = zMin; z <= zMax; ++z) {
                        blockpos$Mutable.func_189533_g((Vector3i)position).func_196234_d(x, y, z);
                        if (x != xMin && y != -1 && z != zMin && x != xMax && y != 4 && z != zMax) {
                            if (world.func_180495_p((BlockPos)blockpos$Mutable).func_177230_c() == Blocks.field_150486_ae || world.func_180495_p((BlockPos)blockpos$Mutable).func_177230_c() == Blocks.field_150474_ac) continue;
                            world.func_180501_a((BlockPos)blockpos$Mutable, CAVE_AIR, 2);
                            continue;
                        }
                        if (blockpos$Mutable.func_177956_o() >= 0 && !world.func_180495_p(blockpos$Mutable.func_177977_b()).func_185904_a().func_76220_a()) {
                            world.func_180501_a((BlockPos)blockpos$Mutable, CAVE_AIR, 2);
                            continue;
                        }
                        if (x == xMin || z == zMin || x == xMax || y == 4 || !world.func_180495_p((BlockPos)blockpos$Mutable).func_185904_a().func_76220_a() || world.func_180495_p((BlockPos)blockpos$Mutable).func_177230_c() == Blocks.field_150486_ae || world.func_180495_p((BlockPos)blockpos$Mutable).func_177230_c() == Blocks.field_150474_ac) continue;
                        if (y == -1 && random.nextInt(4) != 0) {
                            world.func_180501_a((BlockPos)blockpos$Mutable, Blocks.field_196575_bC.func_176223_P(), 2);
                            continue;
                        }
                        world.func_180501_a((BlockPos)blockpos$Mutable, Blocks.field_196653_dH.func_176223_P(), 2);
                    }
                }
            }
            block6: for (int l3 = random.nextInt(3); l3 < 3; ++l3) {
                for (int j4 = 0; j4 < 3; ++j4) {
                    int x2 = position.func_177958_n() + random.nextInt(randXRange * 2 + 1) - randXRange;
                    int y2 = position.func_177956_o();
                    int z2 = position.func_177952_p() + random.nextInt(randZRange * 2 + 1) - randZRange;
                    blockpos$Mutable.func_181079_c(x2, y2, z2);
                    if (!world.func_175623_d((BlockPos)blockpos$Mutable)) continue;
                    int j3 = 0;
                    for (Direction Direction2 : Direction.Plane.HORIZONTAL) {
                        if (!world.func_180495_p(blockpos$Mutable.func_177972_a(Direction2)).func_185904_a().func_76220_a()) continue;
                        ++j3;
                    }
                    if (j3 != true) continue;
                    world.func_180501_a((BlockPos)blockpos$Mutable, StructurePiece.func_197528_a((IBlockReader)world, (BlockPos)blockpos$Mutable, (BlockState)Blocks.field_150486_ae.func_176223_P()), 2);
                    LockableLootTileEntity.func_195479_a((IBlockReader)world, (Random)random, (BlockPos)blockpos$Mutable, (ResourceLocation)CHEST_LOOT);
                    world.func_180501_a(blockpos$Mutable.func_177977_b(), Blocks.field_196653_dH.func_176223_P(), 2);
                    continue block6;
                }
            }
            world.func_180501_a(position, Blocks.field_150350_a.func_176223_P(), 2);
            world.func_180501_a(position, Blocks.field_150474_ac.func_176223_P(), 2);
            world.func_180501_a(position.func_177977_b(), Blocks.field_196653_dH.func_176223_P(), 2);
            TileEntity tileentity = world.func_175625_s(position);
            if (tileentity instanceof MobSpawnerTileEntity) {
                if (position.func_177956_o() < 30) {
                    ((MobSpawnerTileEntity)tileentity).func_145881_a().func_200876_a(RepurposedStructures.mobSpawnerManager.getSpawnerMob(LOW_SPAWNER_ID, random));
                } else {
                    ((MobSpawnerTileEntity)tileentity).func_145881_a().func_200876_a(RepurposedStructures.mobSpawnerManager.getSpawnerMob(HIGH_SPAWNER_ID, random));
                }
            } else {
                LOGGER.error("Failed to fetch mob spawner entity at ({}, {}, {})", new Object[]{position.func_177958_n(), position.func_177956_o(), position.func_177952_p()});
            }
            for (int x3 = xMin - 1; x3 <= xMax + 1; ++x3) {
                for (int y3 = 0; y3 <= 4; ++y3) {
                    for (int z3 = zMin - 1; z3 <= zMax + 1; ++z3) {
                        if (x3 > xMin && x3 < xMax && z3 > zMin && z3 < zMax && y3 != 0 && y3 != 4) continue;
                        blockpos$Mutable.func_189533_g((Vector3i)position).func_196234_d(x3, y3, z3);
                        blockstate = world.func_180495_p((BlockPos)blockpos$Mutable);
                        if (blockstate.func_204520_s().func_206888_e()) continue;
                        world.func_205219_F_().func_205360_a((BlockPos)blockpos$Mutable, (Object)blockstate.func_204520_s().func_206886_c(), 0);
                    }
                }
            }
            return true;
        }
        return false;
    }
}

