/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.repurposedstructures.world.features;

import com.mojang.serialization.Codec;
import com.telepathicgrunt.repurposedstructures.RSStructures;
import java.util.BitSet;
import java.util.Random;
import java.util.function.Predicate;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.material.Material;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.SectionPos;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.NoFeatureConfig;

public class FortressBreakage
extends Feature<NoFeatureConfig> {
    private static final Predicate<BlockState> FORTRESS_BLOCKS = blockState -> {
        if (blockState == null) {
            return false;
        }
        return blockState.func_185904_a() == Material.field_151576_e || blockState.func_185904_a() == Material.field_151578_c || blockState.func_203425_a(Blocks.field_196694_dh) || blockState.func_203425_a(Blocks.field_196692_dg) || blockState.func_203425_a(Blocks.field_196688_de) || blockState.func_203425_a(Blocks.field_196690_df) || blockState.func_203425_a(Blocks.field_150411_aY);
    };

    public FortressBreakage(Codec<NoFeatureConfig> configFactory) {
        super(configFactory);
    }

    public boolean generate(ISeedReader world, ChunkGenerator chunkGenerator, Random random, BlockPos position, NoFeatureConfig config) {
        if (FORTRESS_BLOCKS.test(world.func_180495_p(position.func_177977_b())) && world.func_241827_a(SectionPos.func_218167_a((BlockPos)position), RSStructures.JUNGLE_FORTRESS).findAny().isPresent()) {
            if (random.nextBoolean()) {
                position = position.func_177977_b();
            }
            float f = random.nextFloat() * (float)Math.PI;
            float g = 3.0f;
            int i = 2;
            double d = (float)position.func_177958_n() + MathHelper.func_76126_a((float)f) * g;
            double e = (float)position.func_177958_n() - MathHelper.func_76126_a((float)f) * g;
            double h = (float)position.func_177952_p() + MathHelper.func_76134_b((float)f) * g;
            double j = (float)position.func_177952_p() - MathHelper.func_76134_b((float)f) * g;
            double l = position.func_177956_o() + random.nextInt(3) - 2;
            double m = position.func_177956_o() + random.nextInt(3) - 2;
            int n = position.func_177958_n() - MathHelper.func_76123_f((float)g) - i;
            int o = position.func_177956_o() - 4;
            int p = position.func_177952_p() - MathHelper.func_76123_f((float)g) - i;
            int q = 2 * (MathHelper.func_76123_f((float)g) + i);
            int r = 8;
            for (int s = n; s <= n + q; ++s) {
                int t = p;
                if (t > p + q) continue;
                return this.generateVeinPart((IWorld)world, random, d, e, h, j, l, m, n, o, p, q, r);
            }
            return true;
        }
        return false;
    }

    protected boolean generateVeinPart(IWorld world, Random random, double startX, double endX, double startZ, double endZ, double startY, double endY, int x, int y, int z, int size, int i) {
        double r;
        double q;
        double p;
        double o;
        int m;
        int j = 0;
        BitSet bitSet = new BitSet(size * i * size);
        BlockPos.Mutable mutable = new BlockPos.Mutable();
        double[] ds = new double[96];
        for (m = 0; m < 24; ++m) {
            float f = (float)m / 24.0f;
            o = MathHelper.func_219803_d((double)f, (double)startX, (double)endX);
            p = MathHelper.func_219803_d((double)f, (double)startY, (double)endY);
            q = MathHelper.func_219803_d((double)f, (double)startZ, (double)endZ);
            r = random.nextDouble() * 24.0 / 16.0;
            double l = ((double)(MathHelper.func_76126_a((float)((float)Math.PI * f)) + 1.0f) * r + 1.0) / 2.0;
            ds[m * 4 + 0] = o;
            ds[m * 4 + 1] = p;
            ds[m * 4 + 2] = q;
            ds[m * 4 + 3] = l;
        }
        for (m = 0; m < 23; ++m) {
            if (!(ds[m * 4 + 3] > 0.0)) continue;
            for (int n = m + 1; n < 24; ++n) {
                if (!(ds[n * 4 + 3] > 0.0) || !((r = ds[m * 4 + 3] - ds[n * 4 + 3]) * r > (o = ds[m * 4 + 0] - ds[n * 4 + 0]) * o + (p = ds[m * 4 + 1] - ds[n * 4 + 1]) * p + (q = ds[m * 4 + 2] - ds[n * 4 + 2]) * q)) continue;
                if (r > 0.0) {
                    ds[n * 4 + 3] = -1.0;
                    continue;
                }
                ds[m * 4 + 3] = -1.0;
            }
        }
        for (m = 0; m < 24; ++m) {
            double t = ds[m * 4 + 3];
            if (!(t >= 0.0)) continue;
            double u = ds[m * 4 + 0];
            double v = ds[m * 4 + 1];
            double w = ds[m * 4 + 2];
            int aa = Math.max(MathHelper.func_76128_c((double)(u - t)), x);
            int ab = Math.max(MathHelper.func_76128_c((double)(v - t)), y);
            int ac = Math.max(MathHelper.func_76128_c((double)(w - t)), z);
            int ad = Math.max(MathHelper.func_76128_c((double)(u + t)), aa);
            int ae = Math.max(MathHelper.func_76128_c((double)(v + t)), ab);
            int af = Math.max(MathHelper.func_76128_c((double)(w + t)), ac);
            for (int xx = aa; xx <= ad; ++xx) {
                double ah = ((double)xx + 0.5 - u) / t;
                if (!(ah * ah < 1.0)) continue;
                for (int yy = ab; yy <= ae; ++yy) {
                    double aj = ((double)yy + 0.5 - v) / t;
                    if (!(ah * ah + aj * aj < 1.0)) continue;
                    for (int zz = ac; zz <= af; ++zz) {
                        int am;
                        double al = ((double)zz + 0.5 - w) / t;
                        if (!(ah * ah + aj * aj + al * al < 1.0) || bitSet.get(am = xx - x + (yy - y) * size + (zz - z) * size * i)) continue;
                        bitSet.set(am);
                        mutable.func_181079_c(xx, yy, zz);
                        if (!FORTRESS_BLOCKS.test(world.func_180495_p((BlockPos)mutable))) continue;
                        world.func_180501_a((BlockPos)mutable, Blocks.field_150350_a.func_176223_P(), 2);
                        ++j;
                    }
                }
            }
        }
        return j > 0;
    }
}

