/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.repurposedstructures.world.structures;

import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import com.mojang.serialization.Codec;
import com.telepathicgrunt.repurposedstructures.RSStructures;
import com.telepathicgrunt.repurposedstructures.world.structures.AbstractBaseStructure;
import java.util.Iterator;
import java.util.List;
import net.minecraft.block.BlockState;
import net.minecraft.block.material.Material;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Direction;
import net.minecraft.util.SharedSeedRandom;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.provider.BiomeProvider;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.feature.IFeatureConfig;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import net.minecraft.world.gen.feature.structure.MarginedStructureStart;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraft.world.gen.settings.StructureSeparationSettings;

public abstract class AbstractNetherStructure
extends AbstractBaseStructure {
    private static List<Structure<?>> AVOID_STRUCTURE_LIST = null;

    public AbstractNetherStructure(Codec<NoFeatureConfig> config) {
        super(config);
    }

    protected boolean shouldStartAt(ChunkGenerator chunkGenerator, BiomeProvider biomeSource, long seed, SharedSeedRandom chunkRandom, int chunkX, int chunkZ, Biome biome, ChunkPos chunkPos, NoFeatureConfig defaultFeatureConfig) {
        int radius;
        if (AVOID_STRUCTURE_LIST == null) {
            AVOID_STRUCTURE_LIST = Lists.newArrayList((Iterator)Iterators.concat(RSStructures.NETHER_SHIPWRECKS_LIST.iterator(), RSStructures.NETHER_OUTPOSTS_LIST.iterator(), RSStructures.LARGE_VANILLA_NETHER_STRUCTURE_LIST.iterator()));
            AVOID_STRUCTURE_LIST.add(RSStructures.NETHER_PYRAMID);
        }
        int n = radius = RSStructures.NETHER_OUTPOSTS_LIST.contains((Object)this) ? 6 : 3;
        if (this != RSStructures.WARPED_OUTPOST && this != RSStructures.CRIMSON_OUTPOST && this != RSStructures.NETHER_BRICK_OUTPOST) {
            for (int curChunkX = chunkX - radius; curChunkX <= chunkX + radius; ++curChunkX) {
                for (int curChunkZ = chunkZ - radius; curChunkZ <= chunkZ + radius; ++curChunkZ) {
                    for (Structure<?> structureFeature : AVOID_STRUCTURE_LIST) {
                        StructureSeparationSettings structureConfig = chunkGenerator.func_235957_b_().func_236197_a_(structureFeature);
                        if (structureConfig == null) continue;
                        ChunkPos chunkPos2 = structureFeature.func_236392_a_(structureConfig, seed, chunkRandom, curChunkX, curChunkZ);
                        if (curChunkX != chunkPos2.field_77276_a || curChunkZ != chunkPos2.field_77275_b) continue;
                        return false;
                    }
                }
            }
        }
        return super.func_230363_a_(chunkGenerator, biomeSource, seed, chunkRandom, chunkX, chunkZ, biome, chunkPos, (IFeatureConfig)defaultFeatureConfig);
    }

    public static abstract class AbstractStart
    extends MarginedStructureStart<NoFeatureConfig> {
        public AbstractStart(Structure<NoFeatureConfig> structureIn, int chunkX, int chunkZ, MutableBoundingBox mutableBoundingBox, int referenceIn, long seedIn) {
            super(structureIn, chunkX, chunkZ, mutableBoundingBox, referenceIn, seedIn);
        }

        public BlockPos getHighestLand(ChunkGenerator chunkGenerator) {
            BlockPos.Mutable mutable = new BlockPos.Mutable().func_181079_c(this.field_75074_b.func_215126_f().func_177958_n(), 108, this.field_75074_b.func_215126_f().func_177952_p());
            IBlockReader blockView = chunkGenerator.func_230348_a_(mutable.func_177958_n(), mutable.func_177952_p());
            while (mutable.func_177956_o() > 33) {
                BlockState currentBlockstate = blockView.func_180495_p((BlockPos)mutable);
                if (!currentBlockstate.func_215686_e(blockView, (BlockPos)mutable)) {
                    mutable.func_189536_c(Direction.DOWN);
                    continue;
                }
                if (blockView.func_180495_p(mutable.func_177982_a(0, 3, 0)).func_185904_a() == Material.field_151579_a && this.isValidBlock(currentBlockstate)) break;
                mutable.func_189536_c(Direction.DOWN);
            }
            return mutable;
        }

        public BlockPos getLowestLand(ChunkGenerator chunkGenerator) {
            BlockPos.Mutable mutable = new BlockPos.Mutable().func_181079_c(this.field_75074_b.func_215126_f().func_177958_n(), 35, this.field_75074_b.func_215126_f().func_177952_p());
            IBlockReader blockView = chunkGenerator.func_230348_a_(mutable.func_177958_n(), mutable.func_177952_p());
            BlockState currentBlockstate = blockView.func_180495_p((BlockPos)mutable);
            while (mutable.func_177956_o() <= 108) {
                if (blockView.func_180495_p((BlockPos)mutable).func_185904_a() != Material.field_151579_a && blockView.func_180495_p(mutable.func_177984_a()).func_185904_a() == Material.field_151579_a && blockView.func_180495_p(mutable.func_177981_b(5)).func_185904_a() == Material.field_151579_a && this.isValidBlock(currentBlockstate)) {
                    mutable.func_189536_c(Direction.UP);
                    break;
                }
                mutable.func_189536_c(Direction.UP);
                currentBlockstate = blockView.func_180495_p((BlockPos)mutable);
            }
            return mutable;
        }

        private boolean isValidBlock(BlockState currentBlockstate) {
            return BlockTags.field_241278_aD_.func_230235_a_((Object)currentBlockstate.func_177230_c()) || BlockTags.field_205599_H.func_230235_a_((Object)currentBlockstate.func_177230_c()) || BlockTags.field_203436_u.func_230235_a_((Object)currentBlockstate.func_177230_c()) || BlockTags.field_232873_an_.func_230235_a_((Object)currentBlockstate.func_177230_c()) || BlockTags.field_205213_E.func_230235_a_((Object)currentBlockstate.func_177230_c()) || BlockTags.field_199898_b.func_230235_a_((Object)currentBlockstate.func_177230_c()) || BlockTags.field_200026_c.func_230235_a_((Object)currentBlockstate.func_177230_c()) || BlockTags.field_219755_X.func_230235_a_((Object)currentBlockstate.func_177230_c()) || BlockTags.field_199897_a.func_230235_a_((Object)currentBlockstate.func_177230_c()) || currentBlockstate.func_185904_a() == Material.field_151595_p || currentBlockstate.func_185904_a() == Material.field_151576_e || currentBlockstate.func_185904_a() == Material.field_151578_c;
        }
    }
}

