/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.repurposedstructures.world.structures;

import com.google.common.collect.Lists;
import com.mojang.serialization.Codec;
import com.telepathicgrunt.repurposedstructures.RepurposedStructures;
import com.telepathicgrunt.repurposedstructures.world.structures.RSMineshaftStructure;
import com.telepathicgrunt.repurposedstructures.world.structures.pieces.RSMineshaftPieces;
import java.util.List;
import net.minecraft.entity.EntityType;
import net.minecraft.util.SharedSeedRandom;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.MobSpawnInfo;
import net.minecraft.world.biome.provider.BiomeProvider;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraft.world.gen.settings.StructureSeparationSettings;

public class RSMineshaftEndStructure
extends RSMineshaftStructure {
    private static final List<MobSpawnInfo.Spawners> MONSTER_SPAWNS = Lists.newArrayList((Object[])new MobSpawnInfo.Spawners[]{new MobSpawnInfo.Spawners(EntityType.field_200804_r, 10, 2, 5), new MobSpawnInfo.Spawners(EntityType.field_200803_q, 5, 1, 3)});

    public RSMineshaftEndStructure(Codec<NoFeatureConfig> config, RSMineshaftPieces.Type mineshaftType, double probability, int maxHeight, int minHeight) {
        super(config, mineshaftType, probability, maxHeight, minHeight);
    }

    public List<MobSpawnInfo.Spawners> func_202279_e() {
        return MONSTER_SPAWNS;
    }

    @Override
    protected boolean shouldStartAt(ChunkGenerator chunkGenerator, BiomeProvider biomeSource, long seed, SharedSeedRandom chunkRandom, int chunkX, int chunkZ, Biome biome, ChunkPos chunkPos, NoFeatureConfig featureConfig) {
        StructureSeparationSettings structureConfig = chunkGenerator.func_235957_b_().func_236197_a_((Structure)this);
        if (structureConfig != null) {
            chunkRandom.func_202425_c(seed + (long)structureConfig.func_236673_c_(), chunkX, chunkZ);
            double d = this.probability / 10000.0;
            if (chunkRandom.nextDouble() < d) {
                int landHeight = chunkGenerator.func_222531_c(chunkX << 4, chunkZ << 4, Heightmap.Type.WORLD_SURFACE_WG);
                return RepurposedStructures.RSMineshaftsConfig.barrensIslandsEndMineshafts.get() != false || landHeight > 20;
            }
        }
        return false;
    }
}

