/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.repurposedstructures.world.structures;

import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import com.telepathicgrunt.repurposedstructures.RSStructures;
import com.telepathicgrunt.repurposedstructures.world.structures.AbstractNetherStructure;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import net.minecraft.entity.EntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SharedSeedRandom;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.util.registry.DynamicRegistries;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.MobSpawnInfo;
import net.minecraft.world.biome.provider.BiomeProvider;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.feature.IFeatureConfig;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import net.minecraft.world.gen.feature.jigsaw.JigsawManager;
import net.minecraft.world.gen.feature.jigsaw.JigsawPattern;
import net.minecraft.world.gen.feature.structure.AbstractVillagePiece;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraft.world.gen.feature.structure.VillageConfig;
import net.minecraft.world.gen.feature.template.TemplateManager;
import net.minecraft.world.gen.settings.StructureSeparationSettings;

public class ShipwreckNetherStructure
extends Structure<NoFeatureConfig> {
    private final ResourceLocation START_POOL;
    private final boolean spawnAtSeaLevel;
    private static List<Structure<?>> AVOID_STRUCTURE_LIST = null;
    private static final List<MobSpawnInfo.Spawners> MONSTER_SPAWNS = Lists.newArrayList((Object[])new MobSpawnInfo.Spawners[]{new MobSpawnInfo.Spawners(EntityType.field_200722_aA, 25, 1, 1)});

    public ShipwreckNetherStructure(ResourceLocation start_pool, boolean spawnAtSeaLevel) {
        super(NoFeatureConfig.field_236558_a_);
        this.spawnAtSeaLevel = spawnAtSeaLevel;
        this.START_POOL = start_pool;
        RSStructures.RS_STRUCTURE_START_PIECES.add(start_pool);
    }

    protected boolean shouldStartAt(ChunkGenerator chunkGenerator, BiomeProvider biomeSource, long seed, SharedSeedRandom chunkRandom, int chunkX, int chunkZ, Biome biome, ChunkPos chunkPos, NoFeatureConfig NoFeatureConfig2) {
        BlockPos blockPos;
        if (AVOID_STRUCTURE_LIST == null) {
            AVOID_STRUCTURE_LIST = Lists.newArrayList((Iterator)Iterators.concat(RSStructures.NETHER_OUTPOSTS_LIST.iterator(), RSStructures.NETHER_TEMPLE_LIST.iterator(), RSStructures.NETHER_VILLAGE_LIST.iterator(), RSStructures.LARGE_VANILLA_NETHER_STRUCTURE_LIST.iterator()));
        }
        if (this.spawnAtSeaLevel) {
            blockPos = new BlockPos(chunkX << 4, chunkGenerator.func_230356_f_() + 1, chunkZ << 4);
        } else {
            SharedSeedRandom random = new SharedSeedRandom(seed + (long)(chunkX * (chunkZ * 17)));
            int height = chunkGenerator.func_230356_f_() + random.nextInt(Math.max(chunkGenerator.func_230355_e_() - (chunkGenerator.func_230356_f_() + 30), 1));
            blockPos = new BlockPos(chunkX << 4, height, chunkZ << 4);
        }
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            BlockPos blockPos2 = blockPos.func_177967_a(direction, 8);
            IBlockReader blockView = chunkGenerator.func_230348_a_(blockPos2.func_177958_n(), blockPos2.func_177952_p());
            if (blockView.func_180495_p(blockPos2).func_196958_f() && blockView.func_180495_p(blockPos2.func_177981_b(9)).func_196958_f() && blockView.func_180495_p(blockPos2.func_177981_b(18)).func_196958_f()) continue;
            return false;
        }
        for (int curChunkX = chunkX - 3; curChunkX <= chunkX + 3; ++curChunkX) {
            for (int curChunkZ = chunkZ - 3; curChunkZ <= chunkZ + 3; ++curChunkZ) {
                for (Structure<?> structure : AVOID_STRUCTURE_LIST) {
                    StructureSeparationSettings structureConfig = chunkGenerator.func_235957_b_().func_236197_a_(structure);
                    if (structureConfig == null) continue;
                    ChunkPos chunkPos2 = structure.func_236392_a_(structureConfig, seed, chunkRandom, curChunkX, curChunkZ);
                    if (curChunkX != chunkPos2.field_77276_a || curChunkZ != chunkPos2.field_77275_b) continue;
                    return false;
                }
            }
        }
        return super.func_230363_a_(chunkGenerator, biomeSource, seed, chunkRandom, chunkX, chunkZ, biome, chunkPos, (IFeatureConfig)NoFeatureConfig2);
    }

    public List<MobSpawnInfo.Spawners> func_202279_e() {
        return MONSTER_SPAWNS;
    }

    public Structure.IStartFactory<NoFeatureConfig> func_214557_a() {
        return (x$0, x$1, x$2, x$3, x$4, x$5) -> new Start((Structure<NoFeatureConfig>)x$0, x$1, x$2, x$3, x$4, x$5);
    }

    public class Start
    extends AbstractNetherStructure.AbstractStart {
        private final long seed;

        public Start(Structure<NoFeatureConfig> structureIn, int chunkX, int chunkZ, MutableBoundingBox mutableBoundingBox, int referenceIn, long seedIn) {
            super(structureIn, chunkX, chunkZ, mutableBoundingBox, referenceIn, seedIn);
            this.seed = seedIn;
        }

        public void init(DynamicRegistries dynamicRegistryManager, ChunkGenerator chunkGenerator, TemplateManager structureManager, int chunkX, int chunkZ, Biome biome, NoFeatureConfig NoFeatureConfig2) {
            int placementHeight = chunkGenerator.func_230356_f_();
            if (ShipwreckNetherStructure.this.spawnAtSeaLevel) {
                placementHeight -= 4;
            } else {
                SharedSeedRandom random = new SharedSeedRandom(this.seed + (long)(chunkX * (chunkZ * 17)));
                placementHeight += random.nextInt(Math.max(chunkGenerator.func_230355_e_() - (placementHeight + 30), 1));
            }
            BlockPos blockPos = new BlockPos(chunkX * 16, placementHeight, chunkZ * 16);
            JigsawManager.func_242837_a((DynamicRegistries)dynamicRegistryManager, (VillageConfig)new VillageConfig(() -> (JigsawPattern)dynamicRegistryManager.func_243612_b(Registry.field_243555_ax).func_82594_a(ShipwreckNetherStructure.this.START_POOL), 1), AbstractVillagePiece::new, (ChunkGenerator)chunkGenerator, (TemplateManager)structureManager, (BlockPos)blockPos, (List)this.field_75075_a, (Random)this.field_214631_d, (boolean)true, (boolean)false);
            this.func_202500_a();
        }
    }
}

