/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.repurposedstructures.world.structures.pieces;

import com.telepathicgrunt.repurposedstructures.world.structures.pieces.StructurePieces;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.FlowingFluidBlock;
import net.minecraft.block.material.Material;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.Direction;
import net.minecraft.util.Mirror;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import net.minecraft.world.gen.feature.structure.StructureManager;
import net.minecraft.world.gen.feature.structure.StructurePiece;
import net.minecraft.world.gen.feature.structure.TemplateStructurePiece;
import net.minecraft.world.gen.feature.template.BlockIgnoreStructureProcessor;
import net.minecraft.world.gen.feature.template.PlacementSettings;
import net.minecraft.world.gen.feature.template.StructureProcessor;
import net.minecraft.world.gen.feature.template.Template;
import net.minecraft.world.gen.feature.template.TemplateManager;

public class PyramidFloorPiece {
    public static void func_207617_a(TemplateManager templateManager, BlockPos position, Rotation rotationIn, List<StructurePiece> structurePieceList, Random random, Block block, NoFeatureConfig p_207617_5_) {
        structurePieceList.add((StructurePiece)new Piece(templateManager, position, block, rotationIn));
    }

    public static class Piece
    extends TemplateStructurePiece {
        private final Rotation rotation;
        private final Block block;

        public Piece(TemplateManager templateManager, BlockPos position, Block blockIn, Rotation rotationIn) {
            super(StructurePieces.PYRAMID_FLOOR_PIECE, 0);
            this.field_186178_c = position;
            this.rotation = rotationIn;
            this.block = blockIn;
            this.func_207614_a(templateManager);
        }

        public Piece(TemplateManager templateManager, CompoundNBT data) {
            super(StructurePieces.PYRAMID_FLOOR_PIECE, data);
            this.rotation = Rotation.valueOf((String)data.func_74779_i("Rot"));
            this.block = (Block)Registry.field_212618_g.func_82594_a(new ResourceLocation(data.func_74779_i("Block")));
            this.func_207614_a(templateManager);
        }

        private void func_207614_a(TemplateManager templateManager) {
            Template template = templateManager.func_200220_a(new ResourceLocation("repurposed_structures", "temples/pyramid_badlands_body"));
            PlacementSettings placementsettings = new PlacementSettings().func_186220_a(this.rotation).func_207665_a(new BlockPos(21, 16, 21)).func_186214_a(Mirror.NONE).func_215222_a((StructureProcessor)BlockIgnoreStructureProcessor.field_215204_a);
            this.func_186173_a(template, this.field_186178_c, placementsettings);
        }

        protected void func_143011_b(CompoundNBT tagCompound) {
            super.func_143011_b(tagCompound);
            tagCompound.func_74778_a("Rot", this.rotation.name());
            tagCompound.func_74778_a("Block", Registry.field_212618_g.func_177774_c((Object)this.block).toString());
        }

        public boolean func_230383_a_(ISeedReader world, StructureManager structureAccessor, ChunkGenerator generator, Random random, MutableBoundingBox boundingBox, ChunkPos chunkPos, BlockPos blockPos) {
            BlockPos maxPos;
            BlockPos minPos;
            this.field_186178_c = this.field_186178_c.func_177979_c(2);
            BlockPos rotatedPos = this.field_186177_b.func_207664_d().func_190942_a(this.rotation);
            if (this.rotation == Rotation.CLOCKWISE_90) {
                minPos = new BlockPos(rotatedPos.func_177958_n() + 1, 0, 0);
                maxPos = new BlockPos(1, 0, rotatedPos.func_177952_p());
            } else if (this.rotation == Rotation.CLOCKWISE_180) {
                minPos = new BlockPos(rotatedPos.func_177958_n() + 1, 0, rotatedPos.func_177952_p() + 1);
                maxPos = new BlockPos(1, 0, 1);
            } else if (this.rotation == Rotation.COUNTERCLOCKWISE_90) {
                minPos = new BlockPos(0, 0, rotatedPos.func_177952_p() + 1);
                maxPos = new BlockPos(rotatedPos.func_177958_n(), 0, 1);
            } else {
                minPos = new BlockPos(0, 0, 0);
                maxPos = new BlockPos(rotatedPos.func_177958_n(), 0, rotatedPos.func_177952_p());
            }
            BlockPos.Mutable mutable = new BlockPos.Mutable().func_181079_c(this.field_186178_c.func_177958_n() + minPos.func_177958_n(), this.field_186178_c.func_177956_o(), this.field_186178_c.func_177952_p() + minPos.func_177952_p());
            while (mutable.func_177958_n() < this.field_186178_c.func_177958_n() + maxPos.func_177958_n() && mutable.func_177956_o() > 1) {
                while (mutable.func_177952_p() < this.field_186178_c.func_177952_p() + maxPos.func_177952_p() && mutable.func_177956_o() > 1) {
                    IBlockReader blockview = generator.func_230348_a_(mutable.func_177958_n(), mutable.func_177952_p());
                    BlockState blockState = blockview.func_180495_p((BlockPos)mutable);
                    while ((blockState.func_185904_a() == Material.field_151579_a || blockState.func_177230_c() instanceof FlowingFluidBlock) && mutable.func_177956_o() > 1) {
                        world.func_180501_a((BlockPos)mutable, this.block.func_176223_P(), 3);
                        mutable.func_189536_c(Direction.DOWN);
                        blockState = blockview.func_180495_p((BlockPos)mutable);
                    }
                    mutable.func_181079_c(mutable.func_177958_n(), this.field_186178_c.func_177956_o(), mutable.func_177952_p());
                    mutable.func_196234_d(0, 0, 1);
                }
                mutable.func_181079_c(mutable.func_177958_n(), this.field_186178_c.func_177956_o(), this.field_186178_c.func_177952_p() + minPos.func_177952_p());
                mutable.func_196234_d(1, 0, 0);
            }
            return true;
        }

        protected void func_186175_a(String p_186175_1_, BlockPos p_186175_2_, IServerWorld p_186175_3_, Random p_186175_4_, MutableBoundingBox p_186175_5_) {
        }
    }
}

