/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.repurposedstructures.world.structures.pieces;

import com.google.common.collect.Lists;
import com.telepathicgrunt.repurposedstructures.RepurposedStructures;
import com.telepathicgrunt.repurposedstructures.world.structures.pieces.StructurePieces;
import java.util.List;
import java.util.Random;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.ChorusFlowerBlock;
import net.minecraft.block.DirectionalBlock;
import net.minecraft.block.NetherWartBlock;
import net.minecraft.block.PaneBlock;
import net.minecraft.block.RailBlock;
import net.minecraft.block.RotatedPillarBlock;
import net.minecraft.block.SixWayBlock;
import net.minecraft.block.VineBlock;
import net.minecraft.block.WallTorchBlock;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.item.minecart.ChestMinecartEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.state.Property;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.state.properties.RailShape;
import net.minecraft.tileentity.MobSpawnerTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.DimensionType;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.feature.structure.IStructurePieceType;
import net.minecraft.world.gen.feature.structure.StructureManager;
import net.minecraft.world.gen.feature.structure.StructurePiece;
import net.minecraft.world.gen.feature.template.TemplateManager;

public class RSMineshaftPieces {
    private static final ResourceLocation ICY_CHEST_ID = new ResourceLocation("repurposed_structures:chests/mineshaft/icy");
    private static final ResourceLocation JUNGLE_CHEST_ID = new ResourceLocation("repurposed_structures:chests/mineshaft/jungle");
    private static final ResourceLocation TAIGA_CHEST_ID = new ResourceLocation("repurposed_structures:chests/mineshaft/taiga");
    private static final ResourceLocation DESERT_CHEST_ID = new ResourceLocation("repurposed_structures:chests/mineshaft/desert");
    private static final ResourceLocation END_CHEST_ID = new ResourceLocation("repurposed_structures:chests/mineshaft/end");
    private static final ResourceLocation NETHER_CHEST_ID = new ResourceLocation("repurposed_structures:chests/mineshaft/nether");
    private static final ResourceLocation OCEAN_CHEST_ID = new ResourceLocation("repurposed_structures:chests/mineshaft/ocean");
    private static final ResourceLocation STONE_CHEST_ID = new ResourceLocation("repurposed_structures:chests/mineshaft/stone");
    private static final ResourceLocation SAVANNA_CHEST_ID = new ResourceLocation("repurposed_structures:chests/mineshaft/savanna");
    private static final ResourceLocation SWAMP_OR_DARK_FOREST_CHEST_ID = new ResourceLocation("repurposed_structures:chests/mineshaft/swamp_dark_forest");
    private static final ResourceLocation BIRCH_CHEST_ID = new ResourceLocation("repurposed_structures:chests/mineshaft/birch");
    private static final ResourceLocation ICY_SPAWNER_ID = new ResourceLocation("repurposed_structures:mineshaft_icy");
    private static final ResourceLocation BIRCH_SPAWNER_ID = new ResourceLocation("repurposed_structures:mineshaft_birch");
    private static final ResourceLocation JUNGLE_SPAWNER_ID = new ResourceLocation("repurposed_structures:mineshaft_jungle");
    private static final ResourceLocation TAIGA_SPAWNER_ID = new ResourceLocation("repurposed_structures:mineshaft_taiga");
    private static final ResourceLocation DESERT_SPAWNER_ID = new ResourceLocation("repurposed_structures:mineshaft_desert");
    private static final ResourceLocation STONE_SPAWNER_ID = new ResourceLocation("repurposed_structures:mineshaft_stone");
    private static final ResourceLocation SAVANNA_SPAWNER_ID = new ResourceLocation("repurposed_structures:mineshaft_savanna");
    private static final ResourceLocation SWAMPORDARKFOREST_SPAWNER_ID = new ResourceLocation("repurposed_structures:mineshaft_swamp_or_dark_forest");
    private static final ResourceLocation END_SPAWNER_ID = new ResourceLocation("repurposed_structures:mineshaft_end");
    private static final ResourceLocation NETHER_SPAWNER_ID = new ResourceLocation("repurposed_structures:mineshaft_nether");
    private static final ResourceLocation OCEAN_SPAWNER_ID = new ResourceLocation("repurposed_structures:mineshaft_ocean");

    private static Piece createRandomShaftPiece(List<StructurePiece> p_189940_0_, Random p_189940_1_, int p_189940_2_, int p_189940_3_, int p_189940_4_, Direction p_189940_5_, int p_189940_6_, Type type) {
        int i = p_189940_1_.nextInt(100);
        if (i >= 80) {
            MutableBoundingBox MutableBoundingBox2 = Cross.findCrossing(p_189940_0_, p_189940_1_, p_189940_2_, p_189940_3_, p_189940_4_, p_189940_5_);
            if (MutableBoundingBox2 != null) {
                return new Cross(p_189940_6_, MutableBoundingBox2, p_189940_5_, type);
            }
        } else if (i >= 70) {
            MutableBoundingBox MutableBoundingBox1 = Stairs.findStairs(p_189940_0_, p_189940_1_, p_189940_2_, p_189940_3_, p_189940_4_, p_189940_5_);
            if (MutableBoundingBox1 != null) {
                return new Stairs(p_189940_6_, MutableBoundingBox1, p_189940_5_, type);
            }
        } else {
            MutableBoundingBox MutableBoundingBox2 = Corridor.findCorridorSize(p_189940_0_, p_189940_1_, p_189940_2_, p_189940_3_, p_189940_4_, p_189940_5_);
            if (MutableBoundingBox2 != null) {
                return new Corridor(p_189940_6_, p_189940_1_, MutableBoundingBox2, p_189940_5_, type);
            }
        }
        return null;
    }

    private static Piece generateAndAddPiece(StructurePiece p_189938_0_, List<StructurePiece> p_189938_1_, Random p_189938_2_, int p_189938_3_, int p_189938_4_, int p_189938_5_, Direction p_189938_6_, int p_189938_7_) {
        if (p_189938_7_ > 8) {
            return null;
        }
        if (Math.abs(p_189938_3_ - p_189938_0_.func_74874_b().field_78897_a) <= 80 && Math.abs(p_189938_5_ - p_189938_0_.func_74874_b().field_78896_c) <= 80) {
            Type mapgenmineshaft$type = ((Piece)p_189938_0_).mineShaftType;
            Piece structuremineshaftpieces$peice = RSMineshaftPieces.createRandomShaftPiece(p_189938_1_, p_189938_2_, p_189938_3_, p_189938_4_, p_189938_5_, p_189938_6_, p_189938_7_ + 1, mapgenmineshaft$type);
            if (structuremineshaftpieces$peice != null) {
                p_189938_1_.add(structuremineshaftpieces$peice);
                structuremineshaftpieces$peice.func_74861_a(p_189938_0_, p_189938_1_, p_189938_2_);
            }
            return structuremineshaftpieces$peice;
        }
        return null;
    }

    static abstract class Piece
    extends StructurePiece {
        protected Type mineShaftType;

        public Piece(IStructurePieceType piece, int componentType, Type mineshaftType) {
            super(piece, componentType);
            this.mineShaftType = mineshaftType;
        }

        public Piece(IStructurePieceType piece, CompoundNBT data) {
            super(piece, data);
            this.mineShaftType = Type.byId(data.func_74762_e("MST"));
        }

        protected void func_143011_b(CompoundNBT data) {
            data.func_74768_a("MST", this.mineShaftType.ordinal());
        }

        protected boolean isAirInStructureBoundingBox(IBlockReader worldIn, MutableBoundingBox boundingboxIn) {
            int y;
            int x;
            int xMin = Math.max(this.field_74887_e.field_78897_a - 1, boundingboxIn.field_78897_a);
            int yMin = Math.max(this.field_74887_e.field_78895_b - 1, boundingboxIn.field_78895_b);
            int zMin = Math.max(this.field_74887_e.field_78896_c - 1, boundingboxIn.field_78896_c);
            int xMax = Math.min(this.field_74887_e.field_78893_d + 1, boundingboxIn.field_78893_d);
            int yMax = Math.min(this.field_74887_e.field_78894_e + 1, boundingboxIn.field_78894_e);
            int zMax = Math.min(this.field_74887_e.field_78892_f + 1, boundingboxIn.field_78892_f);
            BlockPos.Mutable blockpos$mutable = new BlockPos.Mutable();
            for (x = xMin; x <= xMax; ++x) {
                for (int z = zMin; z <= zMax; ++z) {
                    if (worldIn.func_180495_p((BlockPos)blockpos$mutable.func_181079_c(x, yMin, z)).func_185904_a() == Material.field_151579_a) {
                        return true;
                    }
                    if (worldIn.func_180495_p((BlockPos)blockpos$mutable.func_181079_c(x, yMax, z)).func_185904_a() != Material.field_151579_a) continue;
                    return true;
                }
            }
            for (x = xMin; x <= xMax; ++x) {
                for (y = yMin; y <= yMax; ++y) {
                    if (worldIn.func_180495_p((BlockPos)blockpos$mutable.func_181079_c(x, y, zMin)).func_185904_a() == Material.field_151579_a) {
                        return true;
                    }
                    if (worldIn.func_180495_p((BlockPos)blockpos$mutable.func_181079_c(x, y, zMax)).func_185904_a() != Material.field_151579_a) continue;
                    return true;
                }
            }
            for (int z = zMin; z <= zMax; ++z) {
                for (y = yMin; y <= yMax; ++y) {
                    if (worldIn.func_180495_p((BlockPos)blockpos$mutable.func_181079_c(xMin, y, z)).func_185904_a() == Material.field_151579_a) {
                        return true;
                    }
                    if (worldIn.func_180495_p((BlockPos)blockpos$mutable.func_181079_c(xMax, y, z)).func_185904_a() != Material.field_151579_a) continue;
                    return true;
                }
            }
            return false;
        }

        protected void fillWithVines(ISeedReader world, Random random, MutableBoundingBox boundingbox, int rarity, int xMin, int yMin, int zMin, int xMax, int yMax, int zMax) {
            for (int x = xMin; x <= xMax; ++x) {
                block1: for (int z = zMin; z <= zMax && random.nextInt(rarity) != 0; ++z) {
                    BlockState vineBlock = (BlockState)Blocks.field_150395_bd.func_176223_P().func_206870_a((Property)VineBlock.field_196546_A.get(Direction.Plane.HORIZONTAL.func_179518_a(random)), (Comparable)Boolean.valueOf(true));
                    int vineLength = 0;
                    for (int y = yMax; y >= yMin; --y) {
                        BlockState aboveBlockState = this.func_175807_a((IBlockReader)world, x, y + 1, z, boundingbox);
                        if (this.func_175807_a((IBlockReader)world, x, y, z, boundingbox).func_196958_f()) {
                            if (aboveBlockState.func_200132_m() || aboveBlockState.func_203425_a(Blocks.field_150395_bd)) {
                                ++vineLength;
                                if (aboveBlockState.func_200132_m()) {
                                    this.setVineBlockState(world, (BlockState)vineBlock.func_206870_a((Property)VineBlock.field_176277_a, (Comparable)Boolean.valueOf(true)), x, y, z, boundingbox);
                                } else {
                                    this.setVineBlockState(world, vineBlock, x, y, z, boundingbox);
                                }
                            } else if (Blocks.field_150395_bd.func_196260_a(vineBlock, (IWorldReader)world, new BlockPos(this.func_74865_a(x, z), this.func_74862_a(y), this.func_74873_b(x, z)))) {
                                this.setVineBlockState(world, vineBlock, x, y, z, boundingbox);
                            }
                        }
                        if (random.nextInt(3) == 0 || vineLength == 4) continue block1;
                    }
                }
            }
        }

        protected void setVineBlockState(ISeedReader worldIn, BlockState blockstateIn, int x, int y, int z, MutableBoundingBox boundingboxIn) {
            BlockPos blockpos = new BlockPos(this.func_74865_a(x, z), this.func_74862_a(y), this.func_74873_b(x, z));
            if (boundingboxIn.func_175898_b((Vector3i)blockpos)) {
                worldIn.func_180501_a(blockpos, blockstateIn, 2);
            }
        }

        protected BlockState getArchTopBlock() {
            switch (this.mineShaftType) {
                case ICY: {
                    return Blocks.field_150403_cj.func_176223_P();
                }
                case JUNGLE: {
                    return (BlockState)Blocks.field_196620_N.func_176223_P().func_206870_a((Property)RotatedPillarBlock.field_176298_M, (Comparable)Direction.Axis.X);
                }
                case TAIGA: {
                    return (BlockState)Blocks.field_203205_S.func_176223_P().func_206870_a((Property)RotatedPillarBlock.field_176298_M, (Comparable)Direction.Axis.X);
                }
                case DESERT: {
                    return Blocks.field_196583_aj.func_176223_P();
                }
                case END: {
                    return (BlockState)Blocks.field_185768_cU.func_176223_P().func_206870_a((Property)RotatedPillarBlock.field_176298_M, (Comparable)Direction.Axis.Z);
                }
                case NETHER: {
                    return Blocks.field_196653_dH.func_176223_P();
                }
                case OCEAN: {
                    return Blocks.field_196781_gR.func_176223_P();
                }
                case STONE: {
                    return Blocks.field_150348_b.func_176223_P();
                }
                case SAVANNA: {
                    return (BlockState)Blocks.field_196621_O.func_176223_P().func_206870_a((Property)RotatedPillarBlock.field_176298_M, (Comparable)Direction.Axis.X);
                }
                case SWAMPORDARKFOREST: {
                    return Blocks.field_196672_s.func_176223_P();
                }
            }
            return (BlockState)Blocks.field_203206_T.func_176223_P().func_206870_a((Property)RotatedPillarBlock.field_176298_M, (Comparable)Direction.Axis.X);
        }

        protected ResourceLocation getChestLoot() {
            switch (this.mineShaftType) {
                case ICY: {
                    return ICY_CHEST_ID;
                }
                case JUNGLE: {
                    return JUNGLE_CHEST_ID;
                }
                case TAIGA: {
                    return TAIGA_CHEST_ID;
                }
                case DESERT: {
                    return DESERT_CHEST_ID;
                }
                case END: {
                    return END_CHEST_ID;
                }
                case NETHER: {
                    return NETHER_CHEST_ID;
                }
                case OCEAN: {
                    return OCEAN_CHEST_ID;
                }
                case STONE: {
                    return STONE_CHEST_ID;
                }
                case SAVANNA: {
                    return SAVANNA_CHEST_ID;
                }
                case SWAMPORDARKFOREST: {
                    return SWAMP_OR_DARK_FOREST_CHEST_ID;
                }
            }
            return BIRCH_CHEST_ID;
        }

        protected BlockState getFloorBlock() {
            switch (this.mineShaftType) {
                case ICY: {
                    return Blocks.field_150432_aD.func_176223_P();
                }
                case JUNGLE: {
                    return Blocks.field_196668_q.func_176223_P();
                }
                case TAIGA: {
                    return Blocks.field_196664_o.func_176223_P();
                }
                case DESERT: {
                    return Blocks.field_196580_bH.func_176223_P();
                }
                case END: {
                    return Blocks.field_185767_cT.func_176223_P();
                }
                case NETHER: {
                    return Blocks.field_196653_dH.func_176223_P();
                }
                case OCEAN: {
                    return Blocks.field_196779_gQ.func_176223_P();
                }
                case STONE: {
                    return Blocks.field_196656_g.func_176223_P();
                }
                case SAVANNA: {
                    return Blocks.field_196670_r.func_176223_P();
                }
                case SWAMPORDARKFOREST: {
                    return Blocks.field_196658_i.func_176223_P();
                }
            }
            return Blocks.field_196666_p.func_176223_P();
        }

        protected BlockState getArchSupportBlock(Random random) {
            switch (this.mineShaftType) {
                case ICY: {
                    return Blocks.field_150432_aD.func_176223_P();
                }
                case JUNGLE: {
                    return Blocks.field_180403_aR.func_176223_P();
                }
                case TAIGA: {
                    return Blocks.field_180408_aP.func_176223_P();
                }
                case DESERT: {
                    return Blocks.field_222417_lF.func_176223_P();
                }
                case END: {
                    return (BlockState)Blocks.field_185768_cU.func_176223_P().func_206870_a((Property)RotatedPillarBlock.field_176298_M, (Comparable)Direction.Axis.Y);
                }
                case NETHER: {
                    return Blocks.field_222414_lC.func_176223_P();
                }
                case OCEAN: {
                    return (BlockState)Blocks.field_222460_lx.func_176223_P().func_206870_a((Property)BlockStateProperties.field_208198_y, (Comparable)Boolean.valueOf(true));
                }
                case STONE: {
                    return random.nextInt(10) < 3 ? Blocks.field_196723_eg.func_176223_P() : Blocks.field_150463_bK.func_176223_P();
                }
                case SAVANNA: {
                    return Blocks.field_180405_aT.func_176223_P();
                }
                case SWAMPORDARKFOREST: {
                    return (BlockState)Blocks.field_196623_P.func_176223_P().func_206870_a((Property)RotatedPillarBlock.field_176298_M, (Comparable)Direction.Axis.Y);
                }
            }
            return Blocks.field_180404_aQ.func_176223_P();
        }

        protected BlockState getFillingBlock() {
            if (this.mineShaftType == Type.OCEAN) {
                return Blocks.field_150355_j.func_176223_P();
            }
            return Blocks.field_201941_jj.func_176223_P();
        }

        protected BlockState getRailBlock() {
            if (this.mineShaftType == Type.OCEAN) {
                return (BlockState)Blocks.field_196636_cW.func_176223_P().func_206870_a((Property)BlockStateProperties.field_208198_y, (Comparable)Boolean.valueOf(true));
            }
            return (BlockState)Blocks.field_150448_aq.func_176223_P().func_206870_a((Property)RailBlock.field_176565_b, (Comparable)RailShape.NORTH_SOUTH);
        }

        protected EntityType<?> getSpawnerMob(Random random) {
            switch (this.mineShaftType) {
                case ICY: {
                    return RepurposedStructures.mobSpawnerManager.getSpawnerMob(ICY_SPAWNER_ID, random);
                }
                case JUNGLE: {
                    return RepurposedStructures.mobSpawnerManager.getSpawnerMob(JUNGLE_SPAWNER_ID, random);
                }
                case TAIGA: {
                    return RepurposedStructures.mobSpawnerManager.getSpawnerMob(TAIGA_SPAWNER_ID, random);
                }
                case DESERT: {
                    return RepurposedStructures.mobSpawnerManager.getSpawnerMob(DESERT_SPAWNER_ID, random);
                }
                case END: {
                    return RepurposedStructures.mobSpawnerManager.getSpawnerMob(END_SPAWNER_ID, random);
                }
                case NETHER: {
                    return RepurposedStructures.mobSpawnerManager.getSpawnerMob(NETHER_SPAWNER_ID, random);
                }
                case OCEAN: {
                    return RepurposedStructures.mobSpawnerManager.getSpawnerMob(OCEAN_SPAWNER_ID, random);
                }
                case STONE: {
                    return RepurposedStructures.mobSpawnerManager.getSpawnerMob(STONE_SPAWNER_ID, random);
                }
                case SAVANNA: {
                    return RepurposedStructures.mobSpawnerManager.getSpawnerMob(SAVANNA_SPAWNER_ID, random);
                }
                case SWAMPORDARKFOREST: {
                    return RepurposedStructures.mobSpawnerManager.getSpawnerMob(SWAMPORDARKFOREST_SPAWNER_ID, random);
                }
            }
            return RepurposedStructures.mobSpawnerManager.getSpawnerMob(BIRCH_SPAWNER_ID, random);
        }

        protected BlockState getDecorativeBlock(Random random) {
            switch (this.mineShaftType) {
                case OCEAN: {
                    return random.nextBoolean() ? Blocks.field_203198_aQ.func_176223_P() : Blocks.field_203199_aR.func_176223_P();
                }
                case ICY: {
                    return Blocks.field_150432_aD.func_176223_P();
                }
                case NETHER: {
                    return Blocks.field_150480_ab.func_176223_P();
                }
                case END: {
                    return (BlockState)Blocks.field_185766_cS.func_176223_P().func_206870_a((Property)ChorusFlowerBlock.field_185607_a, (Comparable)Integer.valueOf(5));
                }
            }
            return Blocks.field_196553_aF.func_176223_P();
        }
    }

    public static class Stairs
    extends Piece {
        public Stairs(int p_i50449_1_, MutableBoundingBox p_i50449_2_, Direction p_i50449_3_, Type p_i50449_4_) {
            super(StructurePieces.MINESHAFT_STAIRS_RS, p_i50449_1_, p_i50449_4_);
            this.func_186164_a(p_i50449_3_);
            this.field_74887_e = p_i50449_2_;
        }

        public Stairs(TemplateManager p_i50450_1_, CompoundNBT p_i50450_2_) {
            super(StructurePieces.MINESHAFT_STAIRS_RS, p_i50450_2_);
        }

        public static MutableBoundingBox findStairs(List<StructurePiece> listIn, Random rand, int x, int y, int z, Direction facing) {
            MutableBoundingBox MutableBoundingBox2 = new MutableBoundingBox(x, y - 5, z, x, y + 2, z);
            switch (facing) {
                default: {
                    MutableBoundingBox2.field_78893_d = x + 2;
                    MutableBoundingBox2.field_78896_c = z - 8;
                    break;
                }
                case SOUTH: {
                    MutableBoundingBox2.field_78893_d = x + 2;
                    MutableBoundingBox2.field_78892_f = z + 8;
                    break;
                }
                case WEST: {
                    MutableBoundingBox2.field_78897_a = x - 8;
                    MutableBoundingBox2.field_78892_f = z + 2;
                    break;
                }
                case EAST: {
                    MutableBoundingBox2.field_78893_d = x + 8;
                    MutableBoundingBox2.field_78892_f = z + 2;
                }
            }
            return StructurePiece.func_74883_a(listIn, (MutableBoundingBox)MutableBoundingBox2) != null ? null : MutableBoundingBox2;
        }

        public void func_74861_a(StructurePiece componentIn, List<StructurePiece> listIn, Random rand) {
            int i = this.func_74877_c();
            Direction enumfacing = this.func_186165_e();
            if (enumfacing != null) {
                switch (enumfacing) {
                    default: {
                        RSMineshaftPieces.generateAndAddPiece(componentIn, listIn, rand, this.field_74887_e.field_78897_a, this.field_74887_e.field_78895_b, this.field_74887_e.field_78896_c - 1, Direction.NORTH, i);
                        break;
                    }
                    case SOUTH: {
                        RSMineshaftPieces.generateAndAddPiece(componentIn, listIn, rand, this.field_74887_e.field_78897_a, this.field_74887_e.field_78895_b, this.field_74887_e.field_78892_f + 1, Direction.SOUTH, i);
                        break;
                    }
                    case WEST: {
                        RSMineshaftPieces.generateAndAddPiece(componentIn, listIn, rand, this.field_74887_e.field_78897_a - 1, this.field_74887_e.field_78895_b, this.field_74887_e.field_78896_c, Direction.WEST, i);
                        break;
                    }
                    case EAST: {
                        RSMineshaftPieces.generateAndAddPiece(componentIn, listIn, rand, this.field_74887_e.field_78893_d + 1, this.field_74887_e.field_78895_b, this.field_74887_e.field_78896_c, Direction.EAST, i);
                    }
                }
            }
        }

        public boolean func_230383_a_(ISeedReader world, StructureManager structureAccessor, ChunkGenerator chunkGenerator, Random random, MutableBoundingBox box, ChunkPos chunkPos, BlockPos blockPos) {
            boolean isOceanType;
            boolean bl = isOceanType = this.mineShaftType == Type.OCEAN;
            if (isOceanType ? this.isAirInStructureBoundingBox((IBlockReader)world, box) : this.func_74860_a((IBlockReader)world, box)) {
                return false;
            }
            this.func_175804_a(world, box, 0, 5, 0, 2, 7, 1, this.getFillingBlock(), this.getFillingBlock(), false);
            this.func_175804_a(world, box, 0, 0, 7, 2, 2, 8, this.getFillingBlock(), this.getFillingBlock(), false);
            for (int i = 0; i < 5; ++i) {
                this.func_175804_a(world, box, 0, 5 - i - (i < 4 ? 1 : 0), 2 + i, 2, 7 - i, 2 + i, this.getFillingBlock(), this.getFillingBlock(), false);
            }
            if (this.mineShaftType == Type.JUNGLE) {
                this.fillWithVines(world, random, box, 5, 0, 0, 0, 2, 7, 8);
            } else if (this.mineShaftType == Type.SWAMPORDARKFOREST) {
                this.fillWithVines(world, random, box, 2, 0, 0, 0, 2, 7, 8);
            }
            return true;
        }
    }

    public static class Room
    extends Piece {
        private final List<MutableBoundingBox> roomsLinkedToTheRoom = Lists.newLinkedList();

        public Room(int p_i47137_1_, Random p_i47137_2_, int p_i47137_3_, int p_i47137_4_, Type p_i47137_5_) {
            super(StructurePieces.MINESHAFT_ROOM_RS, p_i47137_1_, p_i47137_5_);
            this.mineShaftType = p_i47137_5_;
            this.field_74887_e = new MutableBoundingBox(p_i47137_3_, 50, p_i47137_4_, p_i47137_3_ + 7 + p_i47137_2_.nextInt(6), 54 + p_i47137_2_.nextInt(6), p_i47137_4_ + 7 + p_i47137_2_.nextInt(6));
        }

        public Room(TemplateManager p_i50451_1_, CompoundNBT p_i50451_2_) {
            super(StructurePieces.MINESHAFT_ROOM_RS, p_i50451_2_);
            ListNBT listnbt = p_i50451_2_.func_150295_c("Entrances", 11);
            for (int i = 0; i < listnbt.size(); ++i) {
                this.roomsLinkedToTheRoom.add(new MutableBoundingBox(listnbt.func_150306_c(i)));
            }
        }

        @Override
        protected void func_143011_b(CompoundNBT tagCompound) {
            super.func_143011_b(tagCompound);
            ListNBT listnbt = new ListNBT();
            for (MutableBoundingBox mutableboundingbox : this.roomsLinkedToTheRoom) {
                listnbt.add((Object)mutableboundingbox.func_151535_h());
            }
            tagCompound.func_218657_a("Entrances", (INBT)listnbt);
        }

        public void func_74861_a(StructurePiece componentIn, List<StructurePiece> listIn, Random rand) {
            int l;
            int i = this.func_74877_c();
            int k = this.field_74887_e.func_78882_c() - 3 - 1;
            if (k <= 0) {
                k = 1;
            }
            int j = 0;
            while (j < this.field_74887_e.func_78883_b() && (l = j + rand.nextInt(this.field_74887_e.func_78883_b())) + 3 <= this.field_74887_e.func_78883_b()) {
                Piece structuremineshaftpieces$peice = RSMineshaftPieces.generateAndAddPiece(componentIn, listIn, rand, this.field_74887_e.field_78897_a + l, this.field_74887_e.field_78895_b + rand.nextInt(k) + 1, this.field_74887_e.field_78896_c - 1, Direction.NORTH, i);
                if (structuremineshaftpieces$peice != null) {
                    MutableBoundingBox MutableBoundingBox2 = structuremineshaftpieces$peice.func_74874_b();
                    this.roomsLinkedToTheRoom.add(new MutableBoundingBox(MutableBoundingBox2.field_78897_a, MutableBoundingBox2.field_78895_b, this.field_74887_e.field_78896_c, MutableBoundingBox2.field_78893_d, MutableBoundingBox2.field_78894_e, this.field_74887_e.field_78896_c + 1));
                }
                j = l + 4;
            }
            int i1 = 0;
            while (i1 < this.field_74887_e.func_78883_b() && (l = i1 + rand.nextInt(this.field_74887_e.func_78883_b())) + 3 <= this.field_74887_e.func_78883_b()) {
                Piece structuremineshaftpieces$peice1 = RSMineshaftPieces.generateAndAddPiece(componentIn, listIn, rand, this.field_74887_e.field_78897_a + l, this.field_74887_e.field_78895_b + rand.nextInt(k) + 1, this.field_74887_e.field_78892_f + 1, Direction.SOUTH, i);
                if (structuremineshaftpieces$peice1 != null) {
                    MutableBoundingBox MutableBoundingBox1 = structuremineshaftpieces$peice1.func_74874_b();
                    this.roomsLinkedToTheRoom.add(new MutableBoundingBox(MutableBoundingBox1.field_78897_a, MutableBoundingBox1.field_78895_b, this.field_74887_e.field_78892_f - 1, MutableBoundingBox1.field_78893_d, MutableBoundingBox1.field_78894_e, this.field_74887_e.field_78892_f));
                }
                i1 = l + 4;
            }
            int j1 = 0;
            while (j1 < this.field_74887_e.func_78880_d() && (l = j1 + rand.nextInt(this.field_74887_e.func_78880_d())) + 3 <= this.field_74887_e.func_78880_d()) {
                Piece structuremineshaftpieces$peice2 = RSMineshaftPieces.generateAndAddPiece(componentIn, listIn, rand, this.field_74887_e.field_78897_a - 1, this.field_74887_e.field_78895_b + rand.nextInt(k) + 1, this.field_74887_e.field_78896_c + l, Direction.WEST, i);
                if (structuremineshaftpieces$peice2 != null) {
                    MutableBoundingBox MutableBoundingBox2 = structuremineshaftpieces$peice2.func_74874_b();
                    this.roomsLinkedToTheRoom.add(new MutableBoundingBox(this.field_74887_e.field_78897_a, MutableBoundingBox2.field_78895_b, MutableBoundingBox2.field_78896_c, this.field_74887_e.field_78897_a + 1, MutableBoundingBox2.field_78894_e, MutableBoundingBox2.field_78892_f));
                }
                j1 = l + 4;
            }
            int k1 = 0;
            while (k1 < this.field_74887_e.func_78880_d() && (l = k1 + rand.nextInt(this.field_74887_e.func_78880_d())) + 3 <= this.field_74887_e.func_78880_d()) {
                Piece StructurePiece2 = RSMineshaftPieces.generateAndAddPiece(componentIn, listIn, rand, this.field_74887_e.field_78893_d + 1, this.field_74887_e.field_78895_b + rand.nextInt(k) + 1, this.field_74887_e.field_78896_c + l, Direction.EAST, i);
                if (StructurePiece2 != null) {
                    MutableBoundingBox MutableBoundingBox3 = StructurePiece2.func_74874_b();
                    this.roomsLinkedToTheRoom.add(new MutableBoundingBox(this.field_74887_e.field_78893_d - 1, MutableBoundingBox3.field_78895_b, MutableBoundingBox3.field_78896_c, this.field_74887_e.field_78893_d, MutableBoundingBox3.field_78894_e, MutableBoundingBox3.field_78892_f));
                }
                k1 = l + 4;
            }
        }

        public boolean func_230383_a_(ISeedReader world, StructureManager structureAccessor, ChunkGenerator chunkGenerator, Random random, MutableBoundingBox box, ChunkPos chunkPos, BlockPos blockPos) {
            BlockState flooring = this.mineShaftType == Type.NETHER ? Blocks.field_150425_aM.func_176223_P() : (this.mineShaftType == Type.END ? Blocks.field_196806_hJ.func_176223_P() : (this.mineShaftType == Type.OCEAN ? Blocks.field_150435_aG.func_176223_P() : (this.getFloorBlock().func_185904_a() == Material.field_151575_d ? Blocks.field_196660_k.func_176223_P() : this.getFloorBlock())));
            this.func_175804_a(world, box, this.field_74887_e.field_78897_a, this.field_74887_e.field_78895_b, this.field_74887_e.field_78896_c, this.field_74887_e.field_78893_d, this.field_74887_e.field_78895_b, this.field_74887_e.field_78892_f, flooring, this.getFillingBlock(), false);
            this.func_175804_a(world, box, this.field_74887_e.field_78897_a, this.field_74887_e.field_78895_b + 1, this.field_74887_e.field_78896_c, this.field_74887_e.field_78893_d, Math.min(this.field_74887_e.field_78895_b + 3, this.field_74887_e.field_78894_e), this.field_74887_e.field_78892_f, this.getFillingBlock(), this.getFillingBlock(), false);
            if (this.mineShaftType == Type.NETHER) {
                this.func_189914_a(world, box, world.func_201674_k(), 0.3f, this.field_74887_e.field_78897_a, this.field_74887_e.field_78895_b + 1, this.field_74887_e.field_78896_c, this.field_74887_e.field_78893_d, this.field_74887_e.field_78895_b + 1, this.field_74887_e.field_78892_f, (BlockState)Blocks.field_150388_bm.func_176223_P().func_206870_a((Property)NetherWartBlock.field_176486_a, (Comparable)Integer.valueOf(2)), (BlockState)Blocks.field_150388_bm.func_176223_P().func_206870_a((Property)NetherWartBlock.field_176486_a, (Comparable)Integer.valueOf(2)), false, false);
            }
            for (MutableBoundingBox MutableBoundingBox2 : this.roomsLinkedToTheRoom) {
                this.func_175804_a(world, box, MutableBoundingBox2.field_78897_a, MutableBoundingBox2.field_78894_e - 2, MutableBoundingBox2.field_78896_c, MutableBoundingBox2.field_78893_d, MutableBoundingBox2.field_78894_e, MutableBoundingBox2.field_78892_f, this.getFillingBlock(), this.getFillingBlock(), false);
            }
            this.func_180777_a(world, box, this.field_74887_e.field_78897_a, this.field_74887_e.field_78895_b + 4, this.field_74887_e.field_78896_c, this.field_74887_e.field_78893_d, this.field_74887_e.field_78894_e, this.field_74887_e.field_78892_f, this.getFillingBlock(), false);
            if (this.mineShaftType == Type.JUNGLE) {
                this.fillWithVines(world, random, box, 5, this.field_74887_e.field_78897_a, this.field_74887_e.field_78895_b, this.field_74887_e.field_78896_c, this.field_74887_e.field_78893_d, this.field_74887_e.field_78894_e + 4, this.field_74887_e.field_78892_f);
            } else if (this.mineShaftType == Type.SWAMPORDARKFOREST) {
                this.fillWithVines(world, random, box, 2, this.field_74887_e.field_78897_a, this.field_74887_e.field_78895_b, this.field_74887_e.field_78896_c, this.field_74887_e.field_78893_d, this.field_74887_e.field_78894_e + 4, this.field_74887_e.field_78892_f);
            }
            return true;
        }

        public void func_181138_a(int x, int y, int z) {
            super.func_181138_a(x, y, z);
            for (MutableBoundingBox MutableBoundingBox2 : this.roomsLinkedToTheRoom) {
                MutableBoundingBox2.func_78886_a(x, y, z);
            }
        }
    }

    public static class Cross
    extends Piece {
        private final Direction corridorDirection;
        private final boolean isMultipleFloors;

        public Cross(TemplateManager p_i50454_1_, CompoundNBT p_i50454_2_) {
            super(StructurePieces.MINESHAFT_CROSSING_RS, p_i50454_2_);
            this.isMultipleFloors = p_i50454_2_.func_74767_n("tf");
            this.corridorDirection = Direction.func_176731_b((int)p_i50454_2_.func_74762_e("D"));
        }

        @Override
        protected void func_143011_b(CompoundNBT tagCompound) {
            super.func_143011_b(tagCompound);
            tagCompound.func_74757_a("tf", this.isMultipleFloors);
            tagCompound.func_74768_a("D", this.corridorDirection.func_176736_b());
        }

        public Cross(int p_i50455_1_, MutableBoundingBox p_i50455_2_, Direction p_i50455_3_, Type p_i50455_4_) {
            super(StructurePieces.MINESHAFT_CROSSING_RS, p_i50455_1_, p_i50455_4_);
            this.corridorDirection = p_i50455_3_;
            this.field_74887_e = p_i50455_2_;
            this.isMultipleFloors = p_i50455_2_.func_78882_c() > 3;
        }

        public static MutableBoundingBox findCrossing(List<StructurePiece> listIn, Random rand, int x, int y, int z, Direction facing) {
            MutableBoundingBox MutableBoundingBox2 = new MutableBoundingBox(x, y, z, x, y + 2, z);
            if (rand.nextInt(4) == 0) {
                MutableBoundingBox2.field_78894_e += 4;
            }
            switch (facing) {
                default: {
                    MutableBoundingBox2.field_78897_a = x - 1;
                    MutableBoundingBox2.field_78893_d = x + 3;
                    MutableBoundingBox2.field_78896_c = z - 4;
                    break;
                }
                case SOUTH: {
                    MutableBoundingBox2.field_78897_a = x - 1;
                    MutableBoundingBox2.field_78893_d = x + 3;
                    MutableBoundingBox2.field_78892_f = z + 3 + 1;
                    break;
                }
                case WEST: {
                    MutableBoundingBox2.field_78897_a = x - 4;
                    MutableBoundingBox2.field_78896_c = z - 1;
                    MutableBoundingBox2.field_78892_f = z + 3;
                    break;
                }
                case EAST: {
                    MutableBoundingBox2.field_78893_d = x + 3 + 1;
                    MutableBoundingBox2.field_78896_c = z - 1;
                    MutableBoundingBox2.field_78892_f = z + 3;
                }
            }
            return StructurePiece.func_74883_a(listIn, (MutableBoundingBox)MutableBoundingBox2) != null ? null : MutableBoundingBox2;
        }

        public void func_74861_a(StructurePiece componentIn, List<StructurePiece> listIn, Random rand) {
            int i = this.func_74877_c();
            switch (this.corridorDirection) {
                default: {
                    RSMineshaftPieces.generateAndAddPiece(componentIn, listIn, rand, this.field_74887_e.field_78897_a + 1, this.field_74887_e.field_78895_b, this.field_74887_e.field_78896_c - 1, Direction.NORTH, i);
                    RSMineshaftPieces.generateAndAddPiece(componentIn, listIn, rand, this.field_74887_e.field_78897_a - 1, this.field_74887_e.field_78895_b, this.field_74887_e.field_78896_c + 1, Direction.WEST, i);
                    RSMineshaftPieces.generateAndAddPiece(componentIn, listIn, rand, this.field_74887_e.field_78893_d + 1, this.field_74887_e.field_78895_b, this.field_74887_e.field_78896_c + 1, Direction.EAST, i);
                    break;
                }
                case SOUTH: {
                    RSMineshaftPieces.generateAndAddPiece(componentIn, listIn, rand, this.field_74887_e.field_78897_a + 1, this.field_74887_e.field_78895_b, this.field_74887_e.field_78892_f + 1, Direction.SOUTH, i);
                    RSMineshaftPieces.generateAndAddPiece(componentIn, listIn, rand, this.field_74887_e.field_78897_a - 1, this.field_74887_e.field_78895_b, this.field_74887_e.field_78896_c + 1, Direction.WEST, i);
                    RSMineshaftPieces.generateAndAddPiece(componentIn, listIn, rand, this.field_74887_e.field_78893_d + 1, this.field_74887_e.field_78895_b, this.field_74887_e.field_78896_c + 1, Direction.EAST, i);
                    break;
                }
                case WEST: {
                    RSMineshaftPieces.generateAndAddPiece(componentIn, listIn, rand, this.field_74887_e.field_78897_a + 1, this.field_74887_e.field_78895_b, this.field_74887_e.field_78896_c - 1, Direction.NORTH, i);
                    RSMineshaftPieces.generateAndAddPiece(componentIn, listIn, rand, this.field_74887_e.field_78897_a + 1, this.field_74887_e.field_78895_b, this.field_74887_e.field_78892_f + 1, Direction.SOUTH, i);
                    RSMineshaftPieces.generateAndAddPiece(componentIn, listIn, rand, this.field_74887_e.field_78897_a - 1, this.field_74887_e.field_78895_b, this.field_74887_e.field_78896_c + 1, Direction.WEST, i);
                    break;
                }
                case EAST: {
                    RSMineshaftPieces.generateAndAddPiece(componentIn, listIn, rand, this.field_74887_e.field_78897_a + 1, this.field_74887_e.field_78895_b, this.field_74887_e.field_78896_c - 1, Direction.NORTH, i);
                    RSMineshaftPieces.generateAndAddPiece(componentIn, listIn, rand, this.field_74887_e.field_78897_a + 1, this.field_74887_e.field_78895_b, this.field_74887_e.field_78892_f + 1, Direction.SOUTH, i);
                    RSMineshaftPieces.generateAndAddPiece(componentIn, listIn, rand, this.field_74887_e.field_78893_d + 1, this.field_74887_e.field_78895_b, this.field_74887_e.field_78896_c + 1, Direction.EAST, i);
                }
            }
            if (this.isMultipleFloors) {
                if (rand.nextBoolean()) {
                    RSMineshaftPieces.generateAndAddPiece(componentIn, listIn, rand, this.field_74887_e.field_78897_a + 1, this.field_74887_e.field_78895_b + 3 + 1, this.field_74887_e.field_78896_c - 1, Direction.NORTH, i);
                }
                if (rand.nextBoolean()) {
                    RSMineshaftPieces.generateAndAddPiece(componentIn, listIn, rand, this.field_74887_e.field_78897_a - 1, this.field_74887_e.field_78895_b + 3 + 1, this.field_74887_e.field_78896_c + 1, Direction.WEST, i);
                }
                if (rand.nextBoolean()) {
                    RSMineshaftPieces.generateAndAddPiece(componentIn, listIn, rand, this.field_74887_e.field_78893_d + 1, this.field_74887_e.field_78895_b + 3 + 1, this.field_74887_e.field_78896_c + 1, Direction.EAST, i);
                }
                if (rand.nextBoolean()) {
                    RSMineshaftPieces.generateAndAddPiece(componentIn, listIn, rand, this.field_74887_e.field_78897_a + 1, this.field_74887_e.field_78895_b + 3 + 1, this.field_74887_e.field_78892_f + 1, Direction.SOUTH, i);
                }
            }
        }

        public boolean func_230383_a_(ISeedReader world, StructureManager structureAccessor, ChunkGenerator chunkGenerator, Random random, MutableBoundingBox box, ChunkPos chunkPos, BlockPos blockPos) {
            boolean isOceanType;
            boolean bl = isOceanType = this.mineShaftType == Type.OCEAN;
            if (isOceanType ? this.isAirInStructureBoundingBox((IBlockReader)world, box) : this.func_74860_a((IBlockReader)world, box)) {
                return false;
            }
            BlockState iblockstate = this.getFloorBlock();
            if (this.isMultipleFloors) {
                this.func_175804_a(world, box, this.field_74887_e.field_78897_a + 1, this.field_74887_e.field_78895_b, this.field_74887_e.field_78896_c, this.field_74887_e.field_78893_d - 1, this.field_74887_e.field_78895_b + 3 - 1, this.field_74887_e.field_78892_f, this.getFillingBlock(), this.getFillingBlock(), false);
                this.func_175804_a(world, box, this.field_74887_e.field_78897_a, this.field_74887_e.field_78895_b, this.field_74887_e.field_78896_c + 1, this.field_74887_e.field_78893_d, this.field_74887_e.field_78895_b + 3 - 1, this.field_74887_e.field_78892_f - 1, this.getFillingBlock(), this.getFillingBlock(), false);
                this.func_175804_a(world, box, this.field_74887_e.field_78897_a + 1, this.field_74887_e.field_78894_e - 2, this.field_74887_e.field_78896_c, this.field_74887_e.field_78893_d - 1, this.field_74887_e.field_78894_e, this.field_74887_e.field_78892_f, this.getFillingBlock(), this.getFillingBlock(), false);
                this.func_175804_a(world, box, this.field_74887_e.field_78897_a, this.field_74887_e.field_78894_e - 2, this.field_74887_e.field_78896_c + 1, this.field_74887_e.field_78893_d, this.field_74887_e.field_78894_e, this.field_74887_e.field_78892_f - 1, this.getFillingBlock(), this.getFillingBlock(), false);
                this.func_175804_a(world, box, this.field_74887_e.field_78897_a + 1, this.field_74887_e.field_78895_b + 3, this.field_74887_e.field_78896_c + 1, this.field_74887_e.field_78893_d - 1, this.field_74887_e.field_78895_b + 3, this.field_74887_e.field_78892_f - 1, this.getFillingBlock(), this.getFillingBlock(), false);
            } else {
                this.func_175804_a(world, box, this.field_74887_e.field_78897_a + 1, this.field_74887_e.field_78895_b, this.field_74887_e.field_78896_c, this.field_74887_e.field_78893_d - 1, this.field_74887_e.field_78894_e, this.field_74887_e.field_78892_f, this.getFillingBlock(), this.getFillingBlock(), false);
                this.func_175804_a(world, box, this.field_74887_e.field_78897_a, this.field_74887_e.field_78895_b, this.field_74887_e.field_78896_c + 1, this.field_74887_e.field_78893_d, this.field_74887_e.field_78894_e, this.field_74887_e.field_78892_f - 1, this.getFillingBlock(), this.getFillingBlock(), false);
            }
            this.placeSupportPillar(world, box, this.field_74887_e.field_78897_a + 1, this.field_74887_e.field_78895_b, this.field_74887_e.field_78896_c + 1, this.field_74887_e.field_78894_e, isOceanType);
            this.placeSupportPillar(world, box, this.field_74887_e.field_78897_a + 1, this.field_74887_e.field_78895_b, this.field_74887_e.field_78892_f - 1, this.field_74887_e.field_78894_e, isOceanType);
            this.placeSupportPillar(world, box, this.field_74887_e.field_78893_d - 1, this.field_74887_e.field_78895_b, this.field_74887_e.field_78896_c + 1, this.field_74887_e.field_78894_e, isOceanType);
            this.placeSupportPillar(world, box, this.field_74887_e.field_78893_d - 1, this.field_74887_e.field_78895_b, this.field_74887_e.field_78892_f - 1, this.field_74887_e.field_78894_e, isOceanType);
            for (int i = this.field_74887_e.field_78897_a; i <= this.field_74887_e.field_78893_d; ++i) {
                for (int j = this.field_74887_e.field_78896_c; j <= this.field_74887_e.field_78892_f; ++j) {
                    if (this.func_175807_a((IBlockReader)world, i, this.field_74887_e.field_78895_b - 1, j, box).func_185904_a() != (isOceanType ? Material.field_151586_h : Material.field_151579_a) || !this.func_189916_b((IWorldReader)world, i, this.field_74887_e.field_78895_b - 1, j, box)) continue;
                    this.func_175811_a(world, iblockstate, i, this.field_74887_e.field_78895_b - 1, j, box);
                }
            }
            if (this.mineShaftType == Type.JUNGLE) {
                this.fillWithVines(world, random, box, 5, this.field_74887_e.field_78897_a, this.field_74887_e.field_78895_b, this.field_74887_e.field_78896_c, this.field_74887_e.field_78893_d, this.field_74887_e.field_78894_e, this.field_74887_e.field_78892_f);
            } else if (this.mineShaftType == Type.SWAMPORDARKFOREST) {
                this.fillWithVines(world, random, box, 2, this.field_74887_e.field_78897_a, this.field_74887_e.field_78895_b, this.field_74887_e.field_78896_c, this.field_74887_e.field_78893_d, this.field_74887_e.field_78894_e, this.field_74887_e.field_78892_f);
            }
            return true;
        }

        private void placeSupportPillar(ISeedReader world, MutableBoundingBox box, int x, int miny, int z, int maxy, boolean isOceanType) {
            if (this.func_175807_a((IBlockReader)world, x, maxy + 1, z, box).func_185904_a() != (isOceanType ? Material.field_151586_h : Material.field_151579_a)) {
                this.func_175804_a(world, box, x, miny, z, x, maxy, z, this.getFloorBlock().func_203425_a(Blocks.field_196658_i) ? Blocks.field_196698_dj.func_176223_P() : this.getFloorBlock(), this.getFillingBlock(), false);
            }
        }
    }

    public static class Corridor
    extends Piece {
        private final boolean hasRails;
        private final boolean attemptSpawnerCreation;
        private boolean spawnerPlaced;
        private final int sectionCount;

        public Corridor(TemplateManager p_i50456_1_, CompoundNBT p_i50456_2_) {
            super(StructurePieces.MINESHAFT_CORRIDOR_RS, p_i50456_2_);
            this.hasRails = p_i50456_2_.func_74767_n("hr");
            this.attemptSpawnerCreation = p_i50456_2_.func_74767_n("sc");
            this.spawnerPlaced = p_i50456_2_.func_74767_n("hps");
            this.sectionCount = p_i50456_2_.func_74762_e("Num");
        }

        @Override
        protected void func_143011_b(CompoundNBT tagCompound) {
            super.func_143011_b(tagCompound);
            tagCompound.func_74757_a("hr", this.hasRails);
            tagCompound.func_74757_a("sc", this.attemptSpawnerCreation);
            tagCompound.func_74757_a("hps", this.spawnerPlaced);
            tagCompound.func_74768_a("Num", this.sectionCount);
        }

        public Corridor(int p_i47140_1_, Random p_i47140_2_, MutableBoundingBox p_i47140_3_, Direction p_i47140_4_, Type p_i47140_5_) {
            super(StructurePieces.MINESHAFT_CORRIDOR_RS, p_i47140_1_, p_i47140_5_);
            this.func_186164_a(p_i47140_4_);
            this.field_74887_e = p_i47140_3_;
            boolean bl = this.hasRails = p_i47140_2_.nextInt(3) == 0;
            this.attemptSpawnerCreation = this.mineShaftType == Type.END ? !this.hasRails && p_i47140_2_.nextInt(5) == 0 : !this.hasRails && p_i47140_2_.nextInt(20) == 0;
            this.sectionCount = this.func_186165_e() != null && this.func_186165_e().func_176740_k() == Direction.Axis.Z ? p_i47140_3_.func_78880_d() / 5 : p_i47140_3_.func_78883_b() / 5;
        }

        public static MutableBoundingBox findCorridorSize(List<StructurePiece> p_175814_0_, Random rand, int x, int y, int z, Direction facing) {
            int i;
            MutableBoundingBox MutableBoundingBox2 = new MutableBoundingBox(x, y, z, x, y + 2, z);
            for (i = rand.nextInt(3) + 2; i > 0; --i) {
                int j = i * 5;
                switch (facing) {
                    default: {
                        MutableBoundingBox2.field_78893_d = x + 2;
                        MutableBoundingBox2.field_78896_c = z - (j - 1);
                        break;
                    }
                    case SOUTH: {
                        MutableBoundingBox2.field_78893_d = x + 2;
                        MutableBoundingBox2.field_78892_f = z + (j - 1);
                        break;
                    }
                    case WEST: {
                        MutableBoundingBox2.field_78897_a = x - (j - 1);
                        MutableBoundingBox2.field_78892_f = z + 2;
                        break;
                    }
                    case EAST: {
                        MutableBoundingBox2.field_78893_d = x + (j - 1);
                        MutableBoundingBox2.field_78892_f = z + 2;
                    }
                }
                if (StructurePiece.func_74883_a(p_175814_0_, (MutableBoundingBox)MutableBoundingBox2) == null) break;
            }
            return i > 0 ? MutableBoundingBox2 : null;
        }

        public void func_74861_a(StructurePiece componentIn, List<StructurePiece> listIn, Random rand) {
            block24: {
                int i = this.func_74877_c();
                int j = rand.nextInt(4);
                Direction enumfacing = this.func_186165_e();
                if (enumfacing != null) {
                    switch (enumfacing) {
                        default: {
                            if (j <= 1) {
                                RSMineshaftPieces.generateAndAddPiece(componentIn, listIn, rand, this.field_74887_e.field_78897_a, this.field_74887_e.field_78895_b - 1 + rand.nextInt(3), this.field_74887_e.field_78896_c - 1, enumfacing, i);
                                break;
                            }
                            if (j == 2) {
                                RSMineshaftPieces.generateAndAddPiece(componentIn, listIn, rand, this.field_74887_e.field_78897_a - 1, this.field_74887_e.field_78895_b - 1 + rand.nextInt(3), this.field_74887_e.field_78896_c, Direction.WEST, i);
                                break;
                            }
                            RSMineshaftPieces.generateAndAddPiece(componentIn, listIn, rand, this.field_74887_e.field_78893_d + 1, this.field_74887_e.field_78895_b - 1 + rand.nextInt(3), this.field_74887_e.field_78896_c, Direction.EAST, i);
                            break;
                        }
                        case SOUTH: {
                            if (j <= 1) {
                                RSMineshaftPieces.generateAndAddPiece(componentIn, listIn, rand, this.field_74887_e.field_78897_a, this.field_74887_e.field_78895_b - 1 + rand.nextInt(3), this.field_74887_e.field_78892_f + 1, enumfacing, i);
                                break;
                            }
                            if (j == 2) {
                                RSMineshaftPieces.generateAndAddPiece(componentIn, listIn, rand, this.field_74887_e.field_78897_a - 1, this.field_74887_e.field_78895_b - 1 + rand.nextInt(3), this.field_74887_e.field_78892_f - 3, Direction.WEST, i);
                                break;
                            }
                            RSMineshaftPieces.generateAndAddPiece(componentIn, listIn, rand, this.field_74887_e.field_78893_d + 1, this.field_74887_e.field_78895_b - 1 + rand.nextInt(3), this.field_74887_e.field_78892_f - 3, Direction.EAST, i);
                            break;
                        }
                        case WEST: {
                            if (j <= 1) {
                                RSMineshaftPieces.generateAndAddPiece(componentIn, listIn, rand, this.field_74887_e.field_78897_a - 1, this.field_74887_e.field_78895_b - 1 + rand.nextInt(3), this.field_74887_e.field_78896_c, enumfacing, i);
                                break;
                            }
                            if (j == 2) {
                                RSMineshaftPieces.generateAndAddPiece(componentIn, listIn, rand, this.field_74887_e.field_78897_a, this.field_74887_e.field_78895_b - 1 + rand.nextInt(3), this.field_74887_e.field_78896_c - 1, Direction.NORTH, i);
                                break;
                            }
                            RSMineshaftPieces.generateAndAddPiece(componentIn, listIn, rand, this.field_74887_e.field_78897_a, this.field_74887_e.field_78895_b - 1 + rand.nextInt(3), this.field_74887_e.field_78892_f + 1, Direction.SOUTH, i);
                            break;
                        }
                        case EAST: {
                            if (j <= 1) {
                                RSMineshaftPieces.generateAndAddPiece(componentIn, listIn, rand, this.field_74887_e.field_78893_d + 1, this.field_74887_e.field_78895_b - 1 + rand.nextInt(3), this.field_74887_e.field_78896_c, enumfacing, i);
                                break;
                            }
                            if (j == 2) {
                                RSMineshaftPieces.generateAndAddPiece(componentIn, listIn, rand, this.field_74887_e.field_78893_d - 3, this.field_74887_e.field_78895_b - 1 + rand.nextInt(3), this.field_74887_e.field_78896_c - 1, Direction.NORTH, i);
                                break;
                            }
                            RSMineshaftPieces.generateAndAddPiece(componentIn, listIn, rand, this.field_74887_e.field_78893_d - 3, this.field_74887_e.field_78895_b - 1 + rand.nextInt(3), this.field_74887_e.field_78892_f + 1, Direction.SOUTH, i);
                        }
                    }
                }
                if (i >= 8) break block24;
                if (enumfacing != Direction.NORTH && enumfacing != Direction.SOUTH) {
                    int i1 = this.field_74887_e.field_78897_a + 3;
                    while (i1 + 3 <= this.field_74887_e.field_78893_d) {
                        int j1 = rand.nextInt(5);
                        if (j1 == 0) {
                            RSMineshaftPieces.generateAndAddPiece(componentIn, listIn, rand, i1, this.field_74887_e.field_78895_b, this.field_74887_e.field_78896_c - 1, Direction.NORTH, i + 1);
                        } else if (j1 == 1) {
                            RSMineshaftPieces.generateAndAddPiece(componentIn, listIn, rand, i1, this.field_74887_e.field_78895_b, this.field_74887_e.field_78892_f + 1, Direction.SOUTH, i + 1);
                        }
                        i1 += 5;
                    }
                } else {
                    int k = this.field_74887_e.field_78896_c + 3;
                    while (k + 3 <= this.field_74887_e.field_78892_f) {
                        int l = rand.nextInt(5);
                        if (l == 0) {
                            RSMineshaftPieces.generateAndAddPiece(componentIn, listIn, rand, this.field_74887_e.field_78897_a - 1, this.field_74887_e.field_78895_b, k, Direction.WEST, i + 1);
                        } else if (l == 1) {
                            RSMineshaftPieces.generateAndAddPiece(componentIn, listIn, rand, this.field_74887_e.field_78893_d + 1, this.field_74887_e.field_78895_b, k, Direction.EAST, i + 1);
                        }
                        k += 5;
                    }
                }
            }
        }

        protected boolean func_186167_a(ISeedReader world, MutableBoundingBox boundingBox, Random random, int x, int y, int z, ResourceLocation lootTableId) {
            BlockPos blockpos = new BlockPos(this.func_74865_a(x, z), this.func_74862_a(y), this.func_74873_b(x, z));
            Material currentMaterial = world.func_180495_p(blockpos).func_185904_a();
            if (boundingBox.func_175898_b((Vector3i)blockpos) && (currentMaterial == Material.field_151579_a || currentMaterial == Material.field_151586_h)) {
                BlockState blockstate = currentMaterial == Material.field_151579_a ? (BlockState)Blocks.field_150448_aq.func_176223_P().func_206870_a((Property)RailBlock.field_176565_b, (Comparable)(random.nextBoolean() ? RailShape.NORTH_SOUTH : RailShape.EAST_WEST)) : (BlockState)Blocks.field_196636_cW.func_176223_P().func_206870_a((Property)BlockStateProperties.field_208198_y, (Comparable)Boolean.valueOf(true));
                this.func_175811_a(world, blockstate, x, y, z, boundingBox);
                ChestMinecartEntity entityminecartchest = new ChestMinecartEntity((World)world.func_201672_e(), (double)((float)blockpos.func_177958_n() + 0.5f), (double)((float)blockpos.func_177956_o() + 0.5f), (double)((float)blockpos.func_177952_p() + 0.5f));
                entityminecartchest.func_184289_a(lootTableId, random.nextLong());
                world.func_217376_c((Entity)entityminecartchest);
                return true;
            }
            return false;
        }

        public boolean func_230383_a_(ISeedReader world, StructureManager structureAccessor, ChunkGenerator chunkGenerator, Random random, MutableBoundingBox box, ChunkPos chunkPos, BlockPos blockPos) {
            int z;
            int x;
            boolean isOceanType;
            boolean bl = isOceanType = this.mineShaftType == Type.OCEAN;
            if (isOceanType ? this.isAirInStructureBoundingBox((IBlockReader)world, box) : this.func_74860_a((IBlockReader)world, box)) {
                return false;
            }
            int offsetInSection = this.sectionCount * 5 - 1;
            BlockState iblockstate = this.getFloorBlock();
            this.func_175804_a(world, box, 0, 0, 0, 2, 1, offsetInSection, this.getFillingBlock(), this.getFillingBlock(), false);
            this.func_189914_a(world, box, random, 0.8f, 0, 2, 0, 2, 2, offsetInSection, this.getFillingBlock(), this.getFillingBlock(), false, false);
            if (this.attemptSpawnerCreation) {
                if (isOceanType || this.mineShaftType == Type.NETHER || this.mineShaftType == Type.END) {
                    this.func_189914_a(world, box, random, 0.6f, 0, 0, 0, 2, 0, offsetInSection, this.getDecorativeBlock(random), this.getDecorativeBlock(random), false, true);
                    for (x = 0; x <= 2; ++x) {
                        for (z = 0; z <= offsetInSection; ++z) {
                            if (!this.func_175807_a((IBlockReader)world, x, 0, z, box).func_203425_a(Blocks.field_185766_cS)) continue;
                            this.func_175811_a(world, Blocks.field_150377_bs.func_176223_P(), x, -1, z, box);
                        }
                    }
                } else {
                    this.func_189914_a(world, box, random, 0.6f, 0, 0, 0, 2, 1, offsetInSection, this.getDecorativeBlock(random), this.getFillingBlock(), false, true);
                }
            }
            for (int j1 = 0; j1 < this.sectionCount; ++j1) {
                int k1 = 2 + j1 * 5;
                this.placeSupport(world, box, 0, 0, k1, 2, 2, random);
                this.placeDecoration(world, box, random, 0.1f, 0, 2, k1 - 1);
                this.placeDecoration(world, box, random, 0.1f, 2, 2, k1 - 1);
                this.placeDecoration(world, box, random, 0.1f, 0, 2, k1 + 1);
                this.placeDecoration(world, box, random, 0.1f, 2, 2, k1 + 1);
                this.placeDecoration(world, box, random, 0.05f, 0, 2, k1 - 2);
                this.placeDecoration(world, box, random, 0.05f, 2, 2, k1 - 2);
                this.placeDecoration(world, box, random, 0.05f, 0, 2, k1 + 2);
                this.placeDecoration(world, box, random, 0.05f, 2, 2, k1 + 2);
                if (RepurposedStructures.RSMineshaftsConfig.lootChestsMS.get().booleanValue()) {
                    if (random.nextInt(50) == 0) {
                        this.func_186167_a(world, box, random, 2, 0, k1 - 1, this.getChestLoot());
                    }
                    if (random.nextInt(50) == 0) {
                        this.func_186167_a(world, box, random, 0, 0, k1 + 1, this.getChestLoot());
                    }
                }
                if (this.attemptSpawnerCreation && (!this.spawnerPlaced || this.mineShaftType == Type.END && random.nextBoolean())) {
                    int k2;
                    int l1 = this.func_74862_a(0);
                    int i2 = k1 - 1 + random.nextInt(3);
                    int j2 = this.func_74865_a(1, i2);
                    BlockPos blockpos = new BlockPos(j2, l1, k2 = this.func_74873_b(1, i2));
                    if (box.func_175898_b((Vector3i)blockpos) && this.func_189916_b((IWorldReader)world, 1, 0, i2, box)) {
                        this.spawnerPlaced = true;
                        world.func_180501_a(blockpos, Blocks.field_150474_ac.func_176223_P(), 2);
                        TileEntity tileentity = world.func_175625_s(blockpos);
                        if (tileentity instanceof MobSpawnerTileEntity) {
                            ((MobSpawnerTileEntity)tileentity).func_145881_a().func_200876_a(this.getSpawnerMob(random));
                        }
                    }
                }
                if (this.mineShaftType != Type.END || !(random.nextFloat() < 0.3f)) continue;
                this.func_175804_a(world, box, 0, 0, 0, 2, 2, 0, (BlockState)((BlockState)Blocks.field_196769_gJ.func_176223_P().func_206870_a((Property)PaneBlock.field_196411_b, (Comparable)Boolean.valueOf(true))).func_206870_a((Property)PaneBlock.field_196414_y, (Comparable)Boolean.valueOf(true)), (BlockState)((BlockState)Blocks.field_196769_gJ.func_176223_P().func_206870_a((Property)PaneBlock.field_196409_a, (Comparable)Boolean.valueOf(true))).func_206870_a((Property)PaneBlock.field_196413_c, (Comparable)Boolean.valueOf(true)), false);
            }
            for (x = 0; x <= 2; ++x) {
                for (z = 0; z <= offsetInSection; ++z) {
                    BlockState spaceForFloor = this.func_175807_a((IBlockReader)world, x, -1, z, box);
                    if (!(isOceanType ? spaceForFloor.func_185904_a() == Material.field_151586_h : spaceForFloor.func_185904_a() == Material.field_151579_a)) continue;
                    this.func_175811_a(world, iblockstate, x, -1, z, box);
                }
            }
            if (this.hasRails) {
                BlockState blockstate = this.getRailBlock();
                for (int j3 = 0; j3 <= offsetInSection; ++j3) {
                    BlockState spaceForRails = this.func_175807_a((IBlockReader)world, 1, -1, j3, box);
                    if (!(isOceanType ? spaceForRails.func_185904_a() != Material.field_151586_h : spaceForRails.func_185904_a() != Material.field_151579_a)) continue;
                    float f = this.func_189916_b((IWorldReader)world, 1, 0, j3, box) ? 0.7f : 0.9f;
                    this.func_175809_a(world, box, random, f, 1, 0, j3, blockstate);
                }
            }
            if (this.mineShaftType == Type.JUNGLE) {
                this.fillWithVines(world, random, box, 5, 0, 0, 0, 2, 2, offsetInSection);
            } else if (this.mineShaftType == Type.SWAMPORDARKFOREST) {
                this.fillWithVines(world, random, box, 2, 0, 0, 0, 2, 2, offsetInSection);
            }
            return true;
        }

        private void placeSupport(ISeedReader world, MutableBoundingBox boundingBox, int x, int y2, int z, int y, int x2, Random random) {
            BlockState iblockstate = this.getArchTopBlock();
            BlockState iblockstate2 = this.getFillingBlock();
            this.func_175804_a(world, boundingBox, x, y2, z, x, y - 1, z, this.getArchSupportBlock(random), iblockstate2, false);
            this.func_175804_a(world, boundingBox, x2, y2, z, x2, y - 1, z, this.getArchSupportBlock(random), iblockstate2, false);
            this.func_175804_a(world, boundingBox, x, y, z, x2, y, z, iblockstate, iblockstate2, false);
            if (this.mineShaftType == Type.END) {
                if (random.nextFloat() < 0.08f) {
                    this.func_175809_a(world, boundingBox, random, 1.0f, x, y, z - 1, (BlockState)Blocks.field_185764_cQ.func_176223_P().func_206870_a((Property)DirectionalBlock.field_176387_N, (Comparable)Direction.SOUTH));
                    this.func_175809_a(world, boundingBox, random, 1.0f, x, y, z + 1, (BlockState)Blocks.field_185764_cQ.func_176223_P().func_206870_a((Property)DirectionalBlock.field_176387_N, (Comparable)Direction.NORTH));
                }
                if (random.nextFloat() < 0.08f) {
                    this.func_175809_a(world, boundingBox, random, 1.0f, x + 2, y, z - 1, (BlockState)Blocks.field_185764_cQ.func_176223_P().func_206870_a((Property)DirectionalBlock.field_176387_N, (Comparable)Direction.SOUTH));
                    this.func_175809_a(world, boundingBox, random, 1.0f, x + 2, y, z + 1, (BlockState)Blocks.field_185764_cQ.func_176223_P().func_206870_a((Property)DirectionalBlock.field_176387_N, (Comparable)Direction.NORTH));
                }
            } else if (this.mineShaftType == Type.NETHER) {
                if (random.nextFloat() < 0.3f) {
                    this.func_175809_a(world, boundingBox, random, 0.45f, x + 1, y, z, Blocks.field_235383_mw_.func_176223_P());
                } else {
                    this.func_175809_a(world, boundingBox, random, 0.1f, x + 1, y, z - 1, (BlockState)Blocks.field_235340_cR_.func_176223_P().func_206870_a((Property)WallTorchBlock.field_196532_a, (Comparable)Direction.SOUTH));
                    this.func_175809_a(world, boundingBox, random, 0.1f, x + 1, y, z + 1, (BlockState)Blocks.field_235340_cR_.func_176223_P().func_206870_a((Property)WallTorchBlock.field_196532_a, (Comparable)Direction.NORTH));
                }
            } else if (this.mineShaftType == Type.OCEAN) {
                this.func_175809_a(world, boundingBox, random, 0.2f, x + 1, y, z, Blocks.field_180398_cJ.func_176223_P());
            } else if (this.mineShaftType == Type.ICY) {
                this.func_175809_a(world, boundingBox, random, 0.08f, x + 1, y, z - 1, (BlockState)Blocks.field_196677_cy.func_176223_P().func_206870_a((Property)WallTorchBlock.field_196532_a, (Comparable)Direction.SOUTH));
                this.func_175809_a(world, boundingBox, random, 0.08f, x + 1, y, z + 1, (BlockState)Blocks.field_196677_cy.func_176223_P().func_206870_a((Property)WallTorchBlock.field_196532_a, (Comparable)Direction.NORTH));
            } else {
                this.func_175809_a(world, boundingBox, random, 0.08f, x + 1, y, z - 1, (BlockState)Blocks.field_196591_bQ.func_176223_P().func_206870_a((Property)WallTorchBlock.field_196532_a, (Comparable)Direction.SOUTH));
                this.func_175809_a(world, boundingBox, random, 0.08f, x + 1, y, z + 1, (BlockState)Blocks.field_196591_bQ.func_176223_P().func_206870_a((Property)WallTorchBlock.field_196532_a, (Comparable)Direction.NORTH));
            }
        }

        private void placeDecoration(ISeedReader world, MutableBoundingBox box, Random random, float probability, int x, int y, int z) {
            if (world.func_241828_r().func_243612_b(Registry.field_239698_ad_).func_177774_c((Object)world.func_230315_m_()) != DimensionType.field_242710_a || this.func_189916_b((IWorldReader)world, x, y, z, box)) {
                BlockState decorativeBlock = this.getDecorativeBlock(random);
                if (!decorativeBlock.func_203425_a(Blocks.field_196553_aF)) {
                    y = 0;
                }
                this.func_175809_a(world, box, random, probability, x, y, z, decorativeBlock);
                if (this.func_175807_a((IBlockReader)world, x, y, z, box).func_203425_a(Blocks.field_185766_cS)) {
                    this.func_175811_a(world, Blocks.field_150377_bs.func_176223_P(), x, -1, z, box);
                    this.func_175811_a(world, (BlockState)((BlockState)Blocks.field_185765_cR.func_176223_P().func_206870_a((Property)SixWayBlock.field_196496_z, (Comparable)Boolean.valueOf(true))).func_206870_a((Property)SixWayBlock.field_196489_A, (Comparable)Boolean.valueOf(true)), x, 0, z, box);
                    this.func_175811_a(world, (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)Blocks.field_185765_cR.func_176223_P().func_206870_a((Property)SixWayBlock.field_196492_c, (Comparable)Boolean.valueOf(true))).func_206870_a((Property)SixWayBlock.field_196488_a, (Comparable)Boolean.valueOf(true))).func_206870_a((Property)SixWayBlock.field_196490_b, (Comparable)Boolean.valueOf(true))).func_206870_a((Property)SixWayBlock.field_196495_y, (Comparable)Boolean.valueOf(true))).func_206870_a((Property)SixWayBlock.field_196489_A, (Comparable)Boolean.valueOf(true)), x, 1, z, box);
                    if (random.nextBoolean()) {
                        if (this.func_175807_a((IBlockReader)world, x - 1, 1, z, box).func_196958_f()) {
                            this.func_175811_a(world, (BlockState)Blocks.field_185766_cS.func_176223_P().func_206870_a((Property)ChorusFlowerBlock.field_185607_a, (Comparable)Integer.valueOf(5)), x - 1, 1, z, box);
                        } else {
                            this.func_175811_a(world, (BlockState)Blocks.field_185766_cS.func_176223_P().func_206870_a((Property)ChorusFlowerBlock.field_185607_a, (Comparable)Integer.valueOf(5)), x, 1, z, box);
                        }
                    } else if (this.func_175807_a((IBlockReader)world, x + 1, 1, z, box).func_196958_f()) {
                        this.func_175811_a(world, (BlockState)Blocks.field_185766_cS.func_176223_P().func_206870_a((Property)ChorusFlowerBlock.field_185607_a, (Comparable)Integer.valueOf(5)), x + 1, 1, z, box);
                    } else {
                        this.func_175811_a(world, (BlockState)Blocks.field_185766_cS.func_176223_P().func_206870_a((Property)ChorusFlowerBlock.field_185607_a, (Comparable)Integer.valueOf(5)), x, 1, z, box);
                    }
                }
            }
        }
    }

    public static enum Type {
        ICY,
        BIRCH,
        JUNGLE,
        TAIGA,
        DESERT,
        STONE,
        SAVANNA,
        SWAMPORDARKFOREST,
        END,
        NETHER,
        OCEAN;


        public static Type byId(int id) {
            return id >= 0 && id < Type.values().length ? Type.values()[id] : BIRCH;
        }
    }
}

