/*
 * Decompiled with CFR 0.152.
 */
package com.teamaurora.hanami.client.particle;

import com.teamaurora.hanami.client.particle.BlossomParticle;
import com.teamaurora.hanami.client.particle.BlossomPetalParticle;
import net.minecraft.client.Minecraft;
import net.minecraft.particles.BasicParticleType;
import net.minecraft.particles.ParticleType;
import net.minecraftforge.client.event.ParticleFactoryRegisterEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;

public class HanamiParticles {
    public static final DeferredRegister<ParticleType<?>> PARTICLES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.PARTICLE_TYPES, (String)"hanami");
    public static final RegistryObject<BasicParticleType> BLOSSOM_PETAL = HanamiParticles.createBasicParticleType(true, "blossom_petal");
    public static final RegistryObject<BasicParticleType> BLOSSOM = HanamiParticles.createBasicParticleType(true, "blossom");

    private static RegistryObject<BasicParticleType> createBasicParticleType(boolean alwaysShow, String name) {
        RegistryObject particleType = PARTICLES.register(name, () -> new BasicParticleType(alwaysShow));
        return particleType;
    }

    private static boolean checkForNonNullWithReflectionCauseForgeIsBaby(RegistryObject<BasicParticleType> registryObject) {
        return ObfuscationReflectionHelper.getPrivateValue(RegistryObject.class, registryObject, (String)"value") != null;
    }

    @Mod.EventBusSubscriber(modid="hanami", bus=Mod.EventBusSubscriber.Bus.MOD)
    public static class RegisterParticleFactories {
        @SubscribeEvent(priority=EventPriority.LOWEST)
        public static void registerParticleTypes(ParticleFactoryRegisterEvent event) {
            if (HanamiParticles.checkForNonNullWithReflectionCauseForgeIsBaby((RegistryObject<BasicParticleType>)BLOSSOM_PETAL)) {
                Minecraft.func_71410_x().field_71452_i.func_215234_a((ParticleType)BLOSSOM_PETAL.get(), BlossomPetalParticle.Factory::new);
            }
            if (HanamiParticles.checkForNonNullWithReflectionCauseForgeIsBaby((RegistryObject<BasicParticleType>)BLOSSOM)) {
                Minecraft.func_71410_x().field_71452_i.func_215234_a((ParticleType)BLOSSOM.get(), BlossomParticle.Factory::new);
            }
        }
    }
}

