/*
 * Decompiled with CFR 0.152.
 */
package com.teamaurora.hanami.common.entity;

import com.teamaurora.hanami.client.particle.HanamiParticles;
import com.teamaurora.hanami.common.entity.ThrownSakuraBlossomEntity;
import com.teamaurora.hanami.core.registry.HanamiEntities;
import com.teamaurora.hanami.core.registry.HanamiItems;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.block.material.PushReaction;
import net.minecraft.entity.CreatureAttribute;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.Pose;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.ArrowEntity;
import net.minecraft.entity.projectile.PotionEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ItemParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.DamageSource;
import net.minecraft.util.HandSide;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class SakuraBlossomEntity
extends LivingEntity {
    private static final DataParameter<BlockPos> ORIGIN = EntityDataManager.func_187226_a(SakuraBlossomEntity.class, (IDataSerializer)DataSerializers.field_187200_j);
    private static final DataParameter<Boolean> WILD = EntityDataManager.func_187226_a(SakuraBlossomEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    private boolean playedSound;
    private int age = 0;
    private double movCheck;
    private double movCheck1;
    private double movCheck2;
    private double movCheck3;

    public SakuraBlossomEntity(EntityType<? extends SakuraBlossomEntity> blossom, World worldIn) {
        super((EntityType)HanamiEntities.SAKURA_BLOSSOM.get(), worldIn);
    }

    public SakuraBlossomEntity(World worldIn, BlockPos origin, double x, double y, double z, boolean wild) {
        this((EntityType<? extends SakuraBlossomEntity>)((EntityType)HanamiEntities.SAKURA_BLOSSOM.get()), worldIn);
        this.func_70606_j(1.0f);
        this.setOrigin(new BlockPos((Vector3i)origin));
        this.setWild(wild);
        this.func_70107_b(x + 0.5, y, z + 0.5);
        this.func_189654_d(true);
        if (wild) {
            this.field_70760_ar = this.field_70146_Z.nextFloat() * 360.0f;
            this.field_70761_aq = this.field_70146_Z.nextFloat() * 360.0f;
        } else {
            this.field_70760_ar = 180.0f;
            this.field_70761_aq = 180.0f;
        }
        this.field_70177_z = 180.0f;
        this.movCheck = 0.0;
        this.movCheck1 = 0.0;
        this.movCheck2 = 0.0;
        this.movCheck3 = 0.0;
        this.playedSound = wild;
        this.age = 0;
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(ORIGIN, (Object)BlockPos.field_177992_a);
        this.field_70180_af.func_187214_a(WILD, (Object)false);
    }

    public void func_213281_b(CompoundNBT nbt) {
        super.func_213281_b(nbt);
        nbt.func_74772_a("OriginPos", this.getOrigin().func_218275_a());
        nbt.func_74757_a("Wild", this.getWild());
    }

    public void func_70037_a(CompoundNBT nbt) {
        super.func_70037_a(nbt);
        this.setOrigin(BlockPos.func_218283_e((long)nbt.func_74763_f("OriginPos")));
        this.setWild(nbt.func_74767_n("Wild"));
    }

    public void func_70071_h_() {
        int i;
        IParticleData blossoms;
        super.func_70071_h_();
        if (this.age >= 5 && this.movCheck3 == this.func_226278_cu_()) {
            if (!this.getWild()) {
                this.func_184581_c(DamageSource.field_76377_j);
            }
            blossoms = (IParticleData)HanamiParticles.BLOSSOM_PETAL.get();
            for (i = 0; i < 16; ++i) {
                this.field_70170_p.func_195594_a(blossoms, this.getParticleOffset(this.func_226277_ct_()), this.getParticleOffset(this.func_226278_cu_()), this.getParticleOffset(this.func_226281_cx_()), this.getRandWithMagnitude(0.05), this.getRandWithMagnitude(0.03), this.getRandWithMagnitude(0.05));
            }
            this.field_70170_p.func_72960_a((Entity)this, (byte)3);
            this.func_70106_y();
        }
        this.movCheck3 = this.movCheck2;
        this.movCheck2 = this.movCheck1;
        this.movCheck1 = this.movCheck;
        this.movCheck = this.func_226278_cu_();
        if (this.getWild()) {
            this.field_70761_aq = this.field_70760_ar += 3.0f;
        } else {
            this.field_70760_ar = 180.0f;
            this.field_70761_aq = 180.0f;
        }
        this.field_70126_B = 180.0f;
        this.field_70177_z = 180.0f;
        ++this.age;
        if (this.age >= 3600) {
            this.field_70170_p.func_72960_a((Entity)this, (byte)3);
            if (!this.getWild()) {
                this.func_184581_c(DamageSource.field_76377_j);
            }
            this.func_70106_y();
        }
        if (this.getWild()) {
            if ((double)this.field_70170_p.func_130001_d() == 1.0) {
                this.func_213293_j(0.0, Math.max(this.getBreeze(this.func_226277_ct_(), this.func_226281_cx_()), this.func_213322_ci().func_82617_b() - (double)0.1f), -0.15f);
            } else {
                this.func_213293_j(0.0, Math.max(this.getBreeze(this.func_226277_ct_(), this.func_226281_cx_()), this.func_213322_ci().func_82617_b() - (double)0.1f), -0.085f);
            }
        } else {
            this.func_213293_j(0.0, Math.max(-0.0375, this.func_213322_ci().func_82617_b() - (double)0.1f), 0.0);
        }
        if (this.isBlockBlockingPath() || this.isEntityBlockingPath()) {
            if (!this.getWild()) {
                this.func_184581_c(DamageSource.field_76377_j);
            }
            blossoms = (IParticleData)HanamiParticles.BLOSSOM_PETAL.get();
            for (i = 0; i < 16; ++i) {
                this.field_70170_p.func_195594_a(blossoms, this.getParticleOffset(this.func_226277_ct_()), this.getParticleOffset(this.func_226278_cu_()), this.getParticleOffset(this.func_226281_cx_()), this.getRandWithMagnitude(0.05), this.getRandWithMagnitude(0.03), this.getRandWithMagnitude(0.05));
            }
            this.field_70170_p.func_72960_a((Entity)this, (byte)3);
            this.func_70106_y();
        }
        this.func_195061_cb();
        this.func_70066_B();
        if (!this.playedSound) {
            blossoms = (IParticleData)HanamiParticles.BLOSSOM_PETAL.get();
            for (i = 0; i < 16; ++i) {
                this.field_70170_p.func_195594_a(blossoms, this.getParticleOffset(this.func_226277_ct_()), this.getParticleOffset(this.func_226278_cu_()), this.getParticleOffset(this.func_226281_cx_()), this.getRandWithMagnitude(0.05), this.getRandWithMagnitude(0.03), this.getRandWithMagnitude(0.05));
            }
            this.func_184185_a(SoundEvents.field_187546_ae, 1.0f, 1.0f);
            this.playedSound = true;
        }
    }

    public boolean func_85031_j(Entity entityIn) {
        IParticleData blossoms = (IParticleData)HanamiParticles.BLOSSOM_PETAL.get();
        for (int i = 0; i < 16; ++i) {
            this.field_70170_p.func_195594_a(blossoms, this.getParticleOffset(this.func_226277_ct_()), this.getParticleOffset(this.func_226278_cu_()), this.getParticleOffset(this.func_226281_cx_()), this.getRandWithMagnitude(0.05), this.getRandWithMagnitude(0.03), this.getRandWithMagnitude(0.05));
        }
        if (!this.field_70170_p.field_72995_K) {
            if (entityIn instanceof PlayerEntity) {
                PlayerEntity player = (PlayerEntity)entityIn;
                if (!player.field_71075_bZ.field_75098_d) {
                    Block.func_180635_a((World)this.field_70170_p, (BlockPos)this.func_233580_cy_(), (ItemStack)new ItemStack((IItemProvider)HanamiItems.SAKURA_FLOWER.get()));
                }
            } else {
                Block.func_180635_a((World)this.field_70170_p, (BlockPos)this.func_233580_cy_(), (ItemStack)new ItemStack((IItemProvider)HanamiItems.SAKURA_FLOWER.get()));
            }
        }
        this.func_184581_c(DamageSource.field_76377_j);
        this.func_70106_y();
        return true;
    }

    protected void func_70665_d(DamageSource damageSrc, float damageAmount) {
        if (damageSrc.func_76364_f() instanceof ThrownSakuraBlossomEntity || damageSrc.func_76346_g() instanceof ThrownSakuraBlossomEntity) {
            return;
        }
        IParticleData blossoms = (IParticleData)HanamiParticles.BLOSSOM_PETAL.get();
        for (int i = 0; i < 16; ++i) {
            this.field_70170_p.func_195594_a(blossoms, this.getParticleOffset(this.func_226277_ct_()), this.getParticleOffset(this.func_226278_cu_()), this.getParticleOffset(this.func_226281_cx_()), this.getRandWithMagnitude(0.05), this.getRandWithMagnitude(0.03), this.getRandWithMagnitude(0.05));
        }
        if (damageSrc.func_76352_a()) {
            if (!this.func_130014_f_().field_72995_K) {
                Block.func_180635_a((World)this.field_70170_p, (BlockPos)this.func_233580_cy_(), (ItemStack)new ItemStack((IItemProvider)HanamiItems.SAKURA_FLOWER.get()));
            }
            this.func_70106_y();
        } else if (damageSrc == DamageSource.field_76368_d) {
            this.func_70106_y();
        }
        super.func_70665_d(damageSrc, damageAmount);
    }

    public void func_70645_a(DamageSource cause) {
        IParticleData blossoms = (IParticleData)HanamiParticles.BLOSSOM_PETAL.get();
        for (int i = 0; i < 16; ++i) {
            this.field_70170_p.func_195594_a(blossoms, this.getParticleOffset(this.func_226277_ct_()), this.getParticleOffset(this.func_226278_cu_()), this.getParticleOffset(this.func_226281_cx_()), this.getRandWithMagnitude(0.05), this.getRandWithMagnitude(0.03), this.getRandWithMagnitude(0.05));
        }
        this.func_70106_y();
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if (source.func_76346_g() instanceof ArrowEntity || source.func_76364_f() instanceof ArrowEntity) {
            this.func_70665_d(source, amount);
            if (source.func_76346_g() instanceof ArrowEntity) {
                source.func_76346_g().func_70106_y();
            }
            if (source.func_76364_f() instanceof ArrowEntity) {
                source.func_76364_f().func_70106_y();
            }
        }
        return super.func_70097_a(source, amount);
    }

    @OnlyIn(value=Dist.CLIENT)
    private IParticleData makeParticle() {
        ItemStack itemstack = new ItemStack((IItemProvider)HanamiItems.SAKURA_FLOWER.get());
        return itemstack.func_190926_b() ? ParticleTypes.field_197593_D : new ItemParticleData(ParticleTypes.field_197591_B, itemstack);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_70103_a(byte id) {
        if (id == 1) {
            this.func_184185_a(SoundEvents.field_187546_ae, 1.0f, 1.0f);
        } else if (id == 3) {
            IParticleData blossoms = (IParticleData)HanamiParticles.BLOSSOM_PETAL.get();
            for (int i = 0; i < 16; ++i) {
                this.field_70170_p.func_195594_a(blossoms, this.getParticleOffset(this.func_226277_ct_()), this.getParticleOffset(this.func_226278_cu_()), this.getParticleOffset(this.func_226281_cx_()), this.getRandWithMagnitude(0.05), this.getRandWithMagnitude(0.03), this.getRandWithMagnitude(0.05));
            }
        } else {
            super.func_70103_a(id);
        }
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return SoundEvents.field_187546_ae;
    }

    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_187546_ae;
    }

    public boolean func_225503_b_(float distance, float damageMultiplier) {
        return false;
    }

    protected float func_213348_b(Pose poseIn, EntitySize size) {
        return size.field_220316_b;
    }

    public void func_213315_a(MoverType typeIn, Vector3d pos) {
        super.func_213315_a(typeIn, pos);
        if (typeIn == MoverType.PISTON) {
            this.func_184581_c(DamageSource.field_76377_j);
            this.field_70170_p.func_72960_a((Entity)this, (byte)3);
            this.func_70106_y();
        }
    }

    public boolean func_70089_S() {
        return false;
    }

    public ItemStack getPickedResult(RayTraceResult target) {
        return new ItemStack((IItemProvider)HanamiItems.SAKURA_FLOWER.get());
    }

    private double getParticleOffset(double value) {
        return value + this.field_70170_p.field_73012_v.nextDouble() * (double)0.2f - (double)0.1f;
    }

    private double getRandWithMagnitude(double mag) {
        return this.field_70170_p.field_73012_v.nextDouble() * 2.0 * mag - mag;
    }

    private double getBreeze(double x, double z) {
        return -0.025f;
    }

    private boolean isBlockBlockingPath() {
        Vector3d eyePos = this.func_213303_ch().func_72441_c(0.0, 0.0, -0.5);
        return this.field_70170_p.func_217299_a(new RayTraceContext(eyePos, eyePos.func_178787_e(this.func_213322_ci()), RayTraceContext.BlockMode.OUTLINE, RayTraceContext.FluidMode.ANY, (Entity)this)).func_216346_c() != RayTraceResult.Type.MISS;
    }

    private boolean isSpecialBlockBlockingPath() {
        BlockPos pos = this.func_226270_aj_();
        return this.field_70170_p.func_180495_p(pos).func_177230_c() == Blocks.field_150378_br || this.field_70170_p.func_180495_p(pos.func_177984_a()).func_177230_c() == Blocks.field_196651_dG;
    }

    private boolean isEntityBlockingPath() {
        AxisAlignedBB clusterBB = this.func_174813_aQ().func_72317_d(0.0, (double)-0.01f, 0.0);
        List entitiesAbove = this.field_70170_p.func_72839_b(null, clusterBB);
        if (!entitiesAbove.isEmpty()) {
            for (Entity entity : entitiesAbove) {
                if (entity.func_184218_aH() || entity instanceof SakuraBlossomEntity || entity instanceof ItemEntity || entity instanceof PotionEntity || entity instanceof ThrownSakuraBlossomEntity || entity.func_184192_z() == PushReaction.IGNORE) continue;
                return true;
            }
        }
        return false;
    }

    public void setOrigin(BlockPos pos) {
        this.field_70180_af.func_187227_b(ORIGIN, (Object)pos);
    }

    public BlockPos getOrigin() {
        return (BlockPos)this.field_70180_af.func_187225_a(ORIGIN);
    }

    public void setWild(boolean wild) {
        this.field_70180_af.func_187227_b(WILD, (Object)wild);
    }

    public boolean getWild() {
        return (Boolean)this.field_70180_af.func_187225_a(WILD);
    }

    public void func_233627_a_(float strengthIn, double ratioXIn, double ratioZIn) {
    }

    public CreatureAttribute func_70668_bt() {
        return CreatureAttribute.field_223225_d_;
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean func_90999_ad() {
        return false;
    }

    @Nullable
    public AxisAlignedBB func_70114_g(Entity entityIn) {
        return entityIn.func_70104_M() ? entityIn.func_174813_aQ() : null;
    }

    @Nullable
    public AxisAlignedBB func_70046_E() {
        return this.func_174813_aQ();
    }

    protected float func_189749_co() {
        return 0.0f;
    }

    public boolean func_96092_aw() {
        return false;
    }

    public boolean func_70104_M() {
        return true;
    }

    protected boolean func_225502_at_() {
        return false;
    }

    public boolean func_184205_a(Entity entityIn, boolean force) {
        return false;
    }

    public Iterable<ItemStack> func_184193_aE() {
        return NonNullList.func_191197_a((int)4, (Object)ItemStack.field_190927_a);
    }

    public ItemStack func_184582_a(EquipmentSlotType slotIn) {
        return ItemStack.field_190927_a;
    }

    public void func_184201_a(EquipmentSlotType slotIn, ItemStack stack) {
    }

    public HandSide func_184591_cq() {
        return HandSide.RIGHT;
    }

    public static AttributeModifierMap.MutableAttribute setCustomAttributes() {
        return MobEntity.func_233666_p_().func_233815_a_(Attributes.field_233818_a_, 1.0);
    }
}

