/*
 * Decompiled with CFR 0.152.
 */
package com.teamaurora.hanami.common.entity.block;

import com.teamaurora.hanami.client.particle.HanamiParticles;
import com.teamaurora.hanami.core.registry.HanamiEffects;
import com.teamaurora.hanami.core.registry.HanamiEntities;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.Pose;
import net.minecraft.entity.item.TNTEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.network.play.server.SEntityVelocityPacket;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.potion.Effect;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.NetworkHooks;

public class BlombEntity
extends TNTEntity {
    private static final DataParameter<Integer> FUSE = EntityDataManager.func_187226_a(BlombEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Float> POWER = EntityDataManager.func_187226_a(BlombEntity.class, (IDataSerializer)DataSerializers.field_187193_c);
    @Nullable
    private LivingEntity tntPlacedBy;
    private int fuse = 20;

    public BlombEntity(EntityType<? extends BlombEntity> type, World worldIn) {
        super(type, worldIn);
        this.field_70156_m = true;
    }

    public BlombEntity(World worldIn, double x, double y, double z, @Nullable LivingEntity igniter) {
        this((EntityType<? extends BlombEntity>)((EntityType)HanamiEntities.BLOMB.get()), worldIn);
        this.func_70107_b(x, y, z);
        double d0 = worldIn.field_73012_v.nextDouble() * 6.2831854820251465;
        this.func_213293_j(-Math.sin(d0) * 0.02, 0.2f, -Math.cos(d0) * 0.02);
        this.func_184534_a(20);
        this.setPower(1.0f);
        this.field_70169_q = x;
        this.field_70167_r = y;
        this.field_70166_s = z;
        this.tntPlacedBy = igniter;
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(FUSE, (Object)20);
        this.field_70180_af.func_187214_a(POWER, (Object)Float.valueOf(1.0f));
    }

    public void func_70071_h_() {
        boolean toYeet = false;
        if (!this.func_189652_ae()) {
            this.func_213317_d(this.func_213322_ci().func_72441_c(0.0, -0.04, 0.0));
        }
        this.func_213315_a(MoverType.SELF, this.func_213322_ci());
        this.func_213317_d(this.func_213322_ci().func_186678_a(0.98));
        if (this.field_70122_E) {
            this.func_213317_d(this.func_213322_ci().func_216372_d(0.7, -0.5, 0.7));
        }
        --this.fuse;
        if (this.fuse <= 0) {
            this.func_70106_y();
            toYeet = true;
        } else {
            this.func_233566_aG_();
            if (this.field_70170_p.field_72995_K) {
                this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197601_L, this.func_226277_ct_(), this.func_226278_cu_() + 0.5, this.func_226281_cx_(), 0.0, 0.0, 0.0);
            }
        }
        if (toYeet) {
            this.yeet();
        }
    }

    private Vector3d vecSub(Vector3d a, Vector3d b) {
        return new Vector3d(a.func_82615_a() - b.func_82615_a(), a.func_82617_b() - b.func_82617_b(), a.func_82616_c() - b.func_82616_c());
    }

    private Vector3d vecScale(float a, Vector3d b) {
        return new Vector3d((double)a * b.func_82615_a(), (double)a * b.func_82617_b(), (double)a * b.func_82616_c());
    }

    public void yeet() {
        for (int i = 0; i < 128; ++i) {
            this.field_70170_p.func_195594_a((IParticleData)HanamiParticles.BLOSSOM_PETAL.get(), this.getParticleOffset(this.func_226277_ct_()), this.getParticleOffset(this.func_226278_cu_()), this.getParticleOffset(this.func_226281_cx_()), this.getRandWithMagnitude(0.25), this.getRandWithMagnitude(0.25), this.getRandWithMagnitude(0.25));
        }
        if (this.field_70170_p.field_72995_K) {
            this.field_70170_p.func_184134_a(this.func_226277_ct_(), this.func_226283_e_(0.0625), this.func_226281_cx_(), SoundEvents.field_187539_bB, SoundCategory.BLOCKS, 4.0f, (1.0f + (this.field_70170_p.field_73012_v.nextFloat() - this.field_70170_p.field_73012_v.nextFloat()) * 0.2f) * 0.7f, false);
        } else {
            AxisAlignedBB explosionBB = this.func_174813_aQ().func_186662_g(5.0);
            List entitiesAbove = this.field_70170_p.func_72839_b(null, explosionBB);
            if (!entitiesAbove.isEmpty()) {
                for (Entity entity : entitiesAbove) {
                    LivingEntity living;
                    Vector3d offsetVector = this.vecSub(entity.func_213303_ch(), this.func_213303_ch()).func_72432_b();
                    float yeetPower = this.getPower() * (float)(Math.sqrt(18.0) / Math.sqrt(11.0));
                    if (entity instanceof LivingEntity && (living = (LivingEntity)entity).func_70644_a((Effect)HanamiEffects.INSTABILITY.get())) {
                        yeetPower *= (float)Math.sqrt(living.func_70660_b((Effect)HanamiEffects.INSTABILITY.get()).func_76458_c() + 2);
                    }
                    entity.func_70024_g((double)yeetPower * offsetVector.func_82615_a(), (double)yeetPower * offsetVector.func_82617_b(), (double)yeetPower * offsetVector.func_82616_c());
                    if (!(entity instanceof ServerPlayerEntity)) continue;
                    ServerPlayerEntity player = (ServerPlayerEntity)entity;
                    player.field_71135_a.func_147359_a((IPacket)new SEntityVelocityPacket(entity));
                }
            }
        }
    }

    private double getParticleOffset(double value) {
        return value + this.field_70170_p.field_73012_v.nextDouble() - 0.5;
    }

    private double getRandWithMagnitude(double mag) {
        return this.field_70170_p.field_73012_v.nextDouble() * 2.0 * mag - mag;
    }

    protected void func_213281_b(CompoundNBT compound) {
        compound.func_74777_a("Fuse", (short)this.func_184536_l());
        compound.func_74776_a("Power", this.getPower());
    }

    protected void func_70037_a(CompoundNBT compound) {
        this.func_184534_a(compound.func_74765_d("Fuse"));
        this.setPower(compound.func_74760_g("Power"));
    }

    @Nullable
    public LivingEntity func_94083_c() {
        return this.tntPlacedBy;
    }

    protected float func_213316_a(Pose poseIn, EntitySize sizeIn) {
        return 0.0f;
    }

    public void func_184206_a(DataParameter<?> key) {
        if (FUSE.equals(key)) {
            this.fuse = this.func_184535_k();
        }
    }

    public int func_184535_k() {
        return (Integer)this.field_70180_af.func_187225_a(FUSE);
    }

    public int func_184536_l() {
        return this.fuse;
    }

    public void setPower(float power) {
        this.field_70180_af.func_187227_b(POWER, (Object)Float.valueOf(power));
    }

    public float getPower() {
        return ((Float)this.field_70180_af.func_187225_a(POWER)).floatValue();
    }

    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }
}

