/*
 * Decompiled with CFR 0.152.
 */
package com.teamaurora.hanami.common.world.biome;

import com.google.common.collect.ImmutableList;
import com.teamaurora.hanami.core.registry.HanamiBlocks;
import com.teamaurora.hanami.core.registry.HanamiFeatures;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.DefaultBiomeFeatures;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.blockplacer.BlockPlacer;
import net.minecraft.world.gen.blockplacer.SimpleBlockPlacer;
import net.minecraft.world.gen.blockstateprovider.BlockStateProvider;
import net.minecraft.world.gen.blockstateprovider.SimpleBlockStateProvider;
import net.minecraft.world.gen.blockstateprovider.WeightedBlockStateProvider;
import net.minecraft.world.gen.feature.BaseTreeFeatureConfig;
import net.minecraft.world.gen.feature.BlockClusterFeatureConfig;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.IFeatureConfig;
import net.minecraft.world.gen.feature.MultipleWithChanceRandomFeatureConfig;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import net.minecraft.world.gen.feature.ProbabilityConfig;
import net.minecraft.world.gen.feature.SeaGrassConfig;
import net.minecraft.world.gen.placement.AtSurfaceWithExtraConfig;
import net.minecraft.world.gen.placement.ChanceConfig;
import net.minecraft.world.gen.placement.FrequencyConfig;
import net.minecraft.world.gen.placement.IPlacementConfig;
import net.minecraft.world.gen.placement.Placement;
import net.minecraftforge.fml.ModList;

public class HanamiBiomeFeatures {
    private static final BlockState SAKURA_LOG = ((Block)HanamiBlocks.SAKURA_LOG.get()).func_176223_P();
    private static final BlockState SAKURA_LEAVES = ((Block)HanamiBlocks.SAKURA_LEAVES.get()).func_176223_P();
    private static final BlockState CHERRY_SAKURA_LEAVES = ((Block)HanamiBlocks.CHERRY_SAKURA_LEAVES.get()).func_176223_P();
    private static final BlockState ALLIUM = Blocks.field_196609_bf.func_176223_P();
    private static final BlockState PINK_TULIP = Blocks.field_196615_bk.func_176223_P();
    private static final BlockState WHITE_TULIP = Blocks.field_196614_bj.func_176223_P();
    private static final BlockState ORANGE_TULIP = Blocks.field_196613_bi.func_176223_P();
    private static final BlockState AZALEA_BUSH = ((Block)HanamiBlocks.AZALEA_BUSH.get()).func_176223_P();
    public static final BaseTreeFeatureConfig SAKURA_TREE_CONFIG = new BaseTreeFeatureConfig.Builder((BlockStateProvider)new SimpleBlockStateProvider(SAKURA_LOG), (BlockStateProvider)new SimpleBlockStateProvider(SAKURA_LEAVES), null, null, null).func_236700_a_().func_225568_b_();
    public static final BaseTreeFeatureConfig SAKURA_TREE_WITH_CHERRIES_CONFIG = new BaseTreeFeatureConfig.Builder((BlockStateProvider)new SimpleBlockStateProvider(SAKURA_LOG), (BlockStateProvider)new WeightedBlockStateProvider().func_227407_a_(SAKURA_LEAVES, 99).func_227407_a_(CHERRY_SAKURA_LEAVES, 1), null, null, null).func_236700_a_().func_225568_b_();
    public static final BaseTreeFeatureConfig DENSE_SAKURA_TREE_WITH_CHERRIES_CONFIG = new BaseTreeFeatureConfig.Builder((BlockStateProvider)new SimpleBlockStateProvider(SAKURA_LOG), (BlockStateProvider)new WeightedBlockStateProvider().func_227407_a_(SAKURA_LEAVES, 8).func_227407_a_(CHERRY_SAKURA_LEAVES, 2), null, null, null).func_236700_a_().func_225568_b_();
    public static final BlockClusterFeatureConfig TULIP_CONFIG = new BlockClusterFeatureConfig.Builder((BlockStateProvider)new WeightedBlockStateProvider().func_227407_a_(PINK_TULIP, 2).func_227407_a_(WHITE_TULIP, 2).func_227407_a_(ORANGE_TULIP, 1), (BlockPlacer)SimpleBlockPlacer.field_236447_c_).func_227315_a_(64).func_227322_d_();
    public static final BlockClusterFeatureConfig AZALEA_CONFIG = new BlockClusterFeatureConfig.Builder((BlockStateProvider)new SimpleBlockStateProvider(AZALEA_BUSH), (BlockPlacer)SimpleBlockPlacer.field_236447_c_).func_227315_a_(64).func_227322_d_();
    public static final BlockClusterFeatureConfig ALLIUM_CONFIG = new BlockClusterFeatureConfig.Builder((BlockStateProvider)new SimpleBlockStateProvider(ALLIUM), (BlockPlacer)SimpleBlockPlacer.field_236447_c_).func_227315_a_(64).func_227322_d_();

    public static void addKoiPonds(Biome biomeIn) {
        biomeIn.func_203611_a(GenerationStage.Decoration.LAKES, HanamiFeatures.KOI_POND.func_225566_b_((IFeatureConfig)NoFeatureConfig.field_236559_b_).func_227228_a_(Placement.field_215026_l.func_227446_a_((IPlacementConfig)new ChanceConfig(6))));
    }

    public static void addSakuraFeatures(Biome biomeIn) {
        biomeIn.func_203611_a(GenerationStage.Decoration.VEGETAL_DECORATION, HanamiFeatures.SHORT_BAMBOO.func_225566_b_((IFeatureConfig)new ProbabilityConfig(0.0f)).func_227228_a_(Placement.field_215018_d.func_227446_a_((IPlacementConfig)new FrequencyConfig(20))));
        biomeIn.func_203611_a(GenerationStage.Decoration.VEGETAL_DECORATION, HanamiFeatures.SAKURA_TREE_WITH_FALLEN_LEAVES.func_225566_b_((IFeatureConfig)(ModList.get().isLoaded("fruitful") ? SAKURA_TREE_WITH_CHERRIES_CONFIG : SAKURA_TREE_CONFIG)).func_227228_a_(Placement.field_215027_m.func_227446_a_((IPlacementConfig)new AtSurfaceWithExtraConfig(6, 0.1f, 1))));
        biomeIn.func_203611_a(GenerationStage.Decoration.VEGETAL_DECORATION, HanamiFeatures.FALLEN_SAKURA_LEAVES.func_225566_b_((IFeatureConfig)NoFeatureConfig.field_236559_b_).func_227228_a_(Placement.field_215018_d.func_227446_a_((IPlacementConfig)new FrequencyConfig(32))));
    }

    public static void addSakuraHillFeatures(Biome biomeIn) {
        biomeIn.func_203611_a(GenerationStage.Decoration.VEGETAL_DECORATION, HanamiFeatures.SHORT_BAMBOO.func_225566_b_((IFeatureConfig)new ProbabilityConfig(0.0f)).func_227228_a_(Placement.field_215018_d.func_227446_a_((IPlacementConfig)new FrequencyConfig(30))));
        biomeIn.func_203611_a(GenerationStage.Decoration.VEGETAL_DECORATION, HanamiFeatures.SAKURA_TREE_WITH_FALLEN_LEAVES.func_225566_b_((IFeatureConfig)(ModList.get().isLoaded("fruitful") ? SAKURA_TREE_WITH_CHERRIES_CONFIG : SAKURA_TREE_CONFIG)).func_227228_a_(Placement.field_215027_m.func_227446_a_((IPlacementConfig)new AtSurfaceWithExtraConfig(4, 0.1f, 1))));
        biomeIn.func_203611_a(GenerationStage.Decoration.VEGETAL_DECORATION, HanamiFeatures.FALLEN_SAKURA_LEAVES.func_225566_b_((IFeatureConfig)NoFeatureConfig.field_236559_b_).func_227228_a_(Placement.field_215018_d.func_227446_a_((IPlacementConfig)new FrequencyConfig(24))));
    }

    public static void addSparseSakuraFeatures(Biome biomeIn) {
        biomeIn.func_203611_a(GenerationStage.Decoration.VEGETAL_DECORATION, HanamiFeatures.SHORT_BAMBOO.func_225566_b_((IFeatureConfig)new ProbabilityConfig(0.0f)).func_227228_a_(Placement.field_215018_d.func_227446_a_((IPlacementConfig)new FrequencyConfig(25))));
        biomeIn.func_203611_a(GenerationStage.Decoration.VEGETAL_DECORATION, HanamiFeatures.SAKURA_TREE_WITH_FALLEN_LEAVES.func_225566_b_((IFeatureConfig)(ModList.get().isLoaded("fruitful") ? SAKURA_TREE_WITH_CHERRIES_CONFIG : SAKURA_TREE_CONFIG)).func_227228_a_(Placement.field_215027_m.func_227446_a_((IPlacementConfig)new AtSurfaceWithExtraConfig(2, 0.1f, 1))));
        biomeIn.func_203611_a(GenerationStage.Decoration.VEGETAL_DECORATION, HanamiFeatures.FALLEN_SAKURA_LEAVES.func_225566_b_((IFeatureConfig)NoFeatureConfig.field_236559_b_).func_227228_a_(Placement.field_215018_d.func_227446_a_((IPlacementConfig)new FrequencyConfig(16))));
    }

    public static void addSakuraWaterFoliage(Biome biomeIn) {
        biomeIn.func_203611_a(GenerationStage.Decoration.VEGETAL_DECORATION, Feature.field_227248_z_.func_225566_b_((IFeatureConfig)DefaultBiomeFeatures.field_226720_H_).func_227228_a_(Placement.field_215018_d.func_227446_a_((IPlacementConfig)new FrequencyConfig(1))));
        biomeIn.func_203611_a(GenerationStage.Decoration.VEGETAL_DECORATION, Feature.field_203234_at.func_225566_b_((IFeatureConfig)new SeaGrassConfig(64, 0.6)).func_227228_a_(Placement.field_215036_v.func_227446_a_((IPlacementConfig)IPlacementConfig.field_202468_e)));
    }

    public static void addSakuraFlowers(Biome biomeIn) {
        biomeIn.func_203611_a(GenerationStage.Decoration.VEGETAL_DECORATION, Feature.field_202291_ak.func_225566_b_((IFeatureConfig)new MultipleWithChanceRandomFeatureConfig((List)ImmutableList.of((Object)Feature.field_227248_z_.func_225566_b_((IFeatureConfig)DefaultBiomeFeatures.field_226723_K_), (Object)Feature.field_227248_z_.func_225566_b_((IFeatureConfig)AZALEA_CONFIG), (Object)Feature.field_227248_z_.func_225566_b_((IFeatureConfig)DefaultBiomeFeatures.field_226725_M_)), 0)).func_227228_a_(Placement.field_215017_c.func_227446_a_((IPlacementConfig)new FrequencyConfig(2))));
        biomeIn.func_203611_a(GenerationStage.Decoration.VEGETAL_DECORATION, Feature.field_202291_ak.func_225566_b_((IFeatureConfig)new MultipleWithChanceRandomFeatureConfig((List)ImmutableList.of((Object)Feature.field_227248_z_.func_225566_b_((IFeatureConfig)TULIP_CONFIG), (Object)Feature.field_227248_z_.func_225566_b_((IFeatureConfig)ALLIUM_CONFIG), (Object)Feature.field_227247_y_.func_225566_b_((IFeatureConfig)DefaultBiomeFeatures.field_226829_x_)), 0)).func_227228_a_(Placement.field_215017_c.func_227446_a_((IPlacementConfig)new FrequencyConfig(2))));
    }
}

