/*
 * Decompiled with CFR 0.152.
 */
package com.teamaurora.hanami.common.world.gen.feature;

import com.mojang.serialization.Codec;
import com.teamaurora.hanami.core.registry.HanamiBlocks;
import java.util.Random;
import net.minecraft.block.BambooBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.passive.fish.TropicalFishEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.state.Property;
import net.minecraft.state.properties.BambooLeaves;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldWriter;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.IWorldGenerationBaseReader;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import net.minecraft.world.gen.feature.structure.StructureManager;

public class KoiPondFeature
extends Feature<NoFeatureConfig> {
    private static final BlockState BAMBOO_BASE = (BlockState)((BlockState)((BlockState)Blocks.field_222405_kQ.func_176223_P().func_206870_a((Property)BambooBlock.field_220264_d, (Comparable)Integer.valueOf(1))).func_206870_a((Property)BambooBlock.field_220265_e, (Comparable)BambooLeaves.NONE)).func_206870_a((Property)BambooBlock.field_220266_f, (Comparable)Integer.valueOf(0));
    private static final BlockState BAMBOO_LARGE_LEAVES = (BlockState)((BlockState)BAMBOO_BASE.func_206870_a((Property)BambooBlock.field_220265_e, (Comparable)BambooLeaves.LARGE)).func_206870_a((Property)BambooBlock.field_220266_f, (Comparable)Integer.valueOf(1));
    private static final BlockState BAMBOO_SMALL_LEAVES = (BlockState)((BlockState)BAMBOO_BASE.func_206870_a((Property)BambooBlock.field_220265_e, (Comparable)BambooLeaves.SMALL)).func_206870_a((Property)BambooBlock.field_220266_f, (Comparable)Integer.valueOf(1));

    public KoiPondFeature(Codec<NoFeatureConfig> config) {
        super(config);
    }

    public boolean func_230362_a_(ISeedReader worldIn, StructureManager structureManager, ChunkGenerator chunkGenerator, Random rand, BlockPos pos, NoFeatureConfig config) {
        boolean pond8;
        int poolChance = 4;
        boolean pond1 = rand.nextInt(20) < poolChance;
        boolean pond2 = rand.nextInt(20) < poolChance;
        boolean pond3 = rand.nextInt(20) < poolChance;
        boolean pond4 = rand.nextInt(20) < poolChance;
        boolean pond5 = rand.nextInt(20) < poolChance;
        boolean pond6 = rand.nextInt(20) < poolChance;
        boolean pond7 = rand.nextInt(20) < poolChance;
        boolean bl = pond8 = rand.nextInt(20) < poolChance;
        if (pos.func_177956_o() <= 63) {
            return false;
        }
        if (!this.checkPondLoc(worldIn, pos)) {
            return false;
        }
        if (pond1 && !this.checkPondLoc(worldIn, pos.func_177982_a(3, 0, 1))) {
            pond1 = false;
        }
        if (pond2 && !this.checkPondLoc(worldIn, pos.func_177982_a(3, 0, -1))) {
            pond2 = false;
        }
        if (pond3 && !this.checkPondLoc(worldIn, pos.func_177982_a(-3, 0, 1))) {
            pond3 = false;
        }
        if (pond4 && !this.checkPondLoc(worldIn, pos.func_177982_a(-3, 0, -1))) {
            pond4 = false;
        }
        if (pond5 && !this.checkPondLoc(worldIn, pos.func_177982_a(1, 0, 3))) {
            pond5 = false;
        }
        if (pond6 && !this.checkPondLoc(worldIn, pos.func_177982_a(-1, 0, 3))) {
            pond6 = false;
        }
        if (pond7 && !this.checkPondLoc(worldIn, pos.func_177982_a(1, 0, -3))) {
            pond7 = false;
        }
        if (pond8 && !this.checkPondLoc(worldIn, pos.func_177982_a(-1, 0, -3))) {
            pond8 = false;
        }
        boolean flowers = rand.nextInt(4) == 0;
        int flowerType = rand.nextInt(5);
        BlockState flower = flowerType == 0 ? Blocks.field_196609_bf.func_176223_P() : (flowerType == 1 ? Blocks.field_196615_bk.func_176223_P() : (flowerType == 2 ? Blocks.field_196614_bj.func_176223_P() : (flowerType == 3 ? ((Block)HanamiBlocks.AZALEA_BUSH.get()).func_176223_P() : (rand.nextBoolean() ? Blocks.field_196613_bi.func_176223_P() : Blocks.field_222383_bA.func_176223_P()))));
        this.placePondAt(worldIn, pos, rand, flowers, flower);
        if (pond1) {
            this.placePondAt(worldIn, pos.func_177982_a(3, 0, 1), rand, flowers, flower);
        }
        if (pond2) {
            this.placePondAt(worldIn, pos.func_177982_a(3, 0, -1), rand, flowers, flower);
        }
        if (pond3) {
            this.placePondAt(worldIn, pos.func_177982_a(-3, 0, 1), rand, flowers, flower);
        }
        if (pond4) {
            this.placePondAt(worldIn, pos.func_177982_a(-3, 0, -1), rand, flowers, flower);
        }
        if (pond5) {
            this.placePondAt(worldIn, pos.func_177982_a(1, 0, 3), rand, flowers, flower);
        }
        if (pond6) {
            this.placePondAt(worldIn, pos.func_177982_a(-1, 0, 3), rand, flowers, flower);
        }
        if (pond7) {
            this.placePondAt(worldIn, pos.func_177982_a(1, 0, -3), rand, flowers, flower);
        }
        if (pond8) {
            this.placePondAt(worldIn, pos.func_177982_a(-1, 0, -3), rand, flowers, flower);
        }
        int numFeesh = rand.nextInt(3) + 1;
        for (int i = 0; i < numFeesh; ++i) {
            TropicalFishEntity poorFeesh = new TropicalFishEntity(EntityType.field_204262_at, worldIn.func_201672_e());
            poorFeesh.func_70107_b((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p());
            int variantIndx = rand.nextInt(3);
            int variant = 0;
            variant = variantIndx == 0 ? 65536 : (variantIndx == 1 ? 0x7000300 : 0x7000400);
            CompoundNBT feeshNbt = new CompoundNBT();
            feeshNbt.func_74768_a("BucketVariantTag", variant);
            poorFeesh.func_213386_a((IWorld)worldIn, worldIn.func_175649_E(pos), SpawnReason.NATURAL, null, feeshNbt);
            poorFeesh.func_110163_bv();
            worldIn.func_217376_c((Entity)poorFeesh);
        }
        return true;
    }

    private boolean checkPondLoc(ISeedReader worldIn, BlockPos pos) {
        for (BlockPos blockPos : BlockPos.func_218278_a((BlockPos)pos.func_177982_a(-1, -2, -1), (BlockPos)pos.func_177982_a(1, -2, 1))) {
            if (KoiPondFeature.isRightGround((IWorldGenerationBaseReader)worldIn, blockPos)) continue;
            return false;
        }
        for (BlockPos blockPos1 : BlockPos.func_218278_a((BlockPos)pos.func_177982_a(-2, -1, -2), (BlockPos)pos.func_177982_a(2, -1, 2))) {
            if (KoiPondFeature.isRightGround((IWorldGenerationBaseReader)worldIn, blockPos1)) continue;
            return false;
        }
        for (BlockPos blockPos2 : BlockPos.func_218278_a((BlockPos)pos.func_177982_a(3, -1, -1), (BlockPos)pos.func_177982_a(3, -1, 1))) {
            if (KoiPondFeature.isRightGround((IWorldGenerationBaseReader)worldIn, blockPos2)) continue;
            return false;
        }
        for (BlockPos blockPos3 : BlockPos.func_218278_a((BlockPos)pos.func_177982_a(-3, -1, -1), (BlockPos)pos.func_177982_a(-3, -1, 1))) {
            if (KoiPondFeature.isRightGround((IWorldGenerationBaseReader)worldIn, blockPos3)) continue;
            return false;
        }
        for (BlockPos blockPos4 : BlockPos.func_218278_a((BlockPos)pos.func_177982_a(-1, -1, 3), (BlockPos)pos.func_177982_a(1, -1, 3))) {
            if (KoiPondFeature.isRightGround((IWorldGenerationBaseReader)worldIn, blockPos4)) continue;
            return false;
        }
        for (BlockPos blockPos5 : BlockPos.func_218278_a((BlockPos)pos.func_177982_a(-1, -1, -3), (BlockPos)pos.func_177982_a(1, -1, -3))) {
            if (KoiPondFeature.isRightGround((IWorldGenerationBaseReader)worldIn, blockPos5)) continue;
            return false;
        }
        return true;
    }

    private void placePondAt(ISeedReader worldIn, BlockPos pos, Random rand, boolean flowers, BlockState flower) {
        for (BlockPos blockPos : BlockPos.func_218278_a((BlockPos)pos.func_177982_a(-2, -1, -2), (BlockPos)pos.func_177982_a(2, -1, 2))) {
            this.placeWaterAt(worldIn, blockPos);
        }
        for (BlockPos blockPos1 : BlockPos.func_218278_a((BlockPos)pos.func_177982_a(3, -1, -1), (BlockPos)pos.func_177982_a(3, -1, 1))) {
            this.placeWaterAt(worldIn, blockPos1);
        }
        for (BlockPos blockPos2 : BlockPos.func_218278_a((BlockPos)pos.func_177982_a(-3, -1, -1), (BlockPos)pos.func_177982_a(-3, -1, 1))) {
            this.placeWaterAt(worldIn, blockPos2);
        }
        for (BlockPos blockPos3 : BlockPos.func_218278_a((BlockPos)pos.func_177982_a(-1, -1, 3), (BlockPos)pos.func_177982_a(1, -1, 3))) {
            this.placeWaterAt(worldIn, blockPos3);
        }
        for (BlockPos blockPos4 : BlockPos.func_218278_a((BlockPos)pos.func_177982_a(-1, -1, -3), (BlockPos)pos.func_177982_a(1, -1, -3))) {
            this.placeWaterAt(worldIn, blockPos4);
        }
        this.placeWaterAt(worldIn, pos.func_177982_a(0, -2, 0));
        this.placeWaterAt(worldIn, pos.func_177982_a(1, -2, 0));
        this.placeWaterAt(worldIn, pos.func_177982_a(-1, -2, 0));
        this.placeWaterAt(worldIn, pos.func_177982_a(0, -2, 1));
        this.placeWaterAt(worldIn, pos.func_177982_a(0, -2, -1));
        this.placeWaterRandomlyAt(worldIn, pos.func_177982_a(-1, -2, -1), rand);
        this.placeWaterRandomlyAt(worldIn, pos.func_177982_a(-1, -2, 1), rand);
        this.placeWaterRandomlyAt(worldIn, pos.func_177982_a(1, -2, -1), rand);
        this.placeWaterRandomlyAt(worldIn, pos.func_177982_a(1, -2, 1), rand);
        for (BlockPos blockPos5 : BlockPos.func_218278_a((BlockPos)pos.func_177982_a(3, 0, 2), (BlockPos)pos.func_177982_a(-3, 3, -2))) {
            this.placeAirAt(worldIn, blockPos5);
        }
        for (BlockPos blockPos6 : BlockPos.func_218278_a((BlockPos)pos.func_177982_a(2, 0, 3), (BlockPos)pos.func_177982_a(-2, 3, -3))) {
            this.placeAirAt(worldIn, blockPos6);
        }
        for (BlockPos blockPos7 : BlockPos.func_218278_a((BlockPos)pos.func_177982_a(4, 0, 1), (BlockPos)pos.func_177982_a(4, 3, -1))) {
            this.placeAirAt(worldIn, blockPos7);
        }
        for (BlockPos blockPos8 : BlockPos.func_218278_a((BlockPos)pos.func_177982_a(-4, 0, 1), (BlockPos)pos.func_177982_a(-4, 3, -1))) {
            this.placeAirAt(worldIn, blockPos8);
        }
        for (BlockPos blockPos9 : BlockPos.func_218278_a((BlockPos)pos.func_177982_a(1, 0, 4), (BlockPos)pos.func_177982_a(-1, 3, 4))) {
            this.placeAirAt(worldIn, blockPos9);
        }
        for (BlockPos blockPos10 : BlockPos.func_218278_a((BlockPos)pos.func_177982_a(1, 0, -4), (BlockPos)pos.func_177982_a(-1, 3, -4))) {
            this.placeAirAt(worldIn, blockPos10);
        }
        this.placeLilyPadAt(worldIn, pos.func_177982_a(2, 0, 1), rand);
        this.placeLilyPadAt(worldIn, pos.func_177982_a(2, 0, -1), rand);
        this.placeLilyPadAt(worldIn, pos.func_177982_a(-2, 0, 1), rand);
        this.placeLilyPadAt(worldIn, pos.func_177982_a(-2, 0, -1), rand);
        this.placeLilyPadAt(worldIn, pos.func_177982_a(1, 0, 2), rand);
        this.placeLilyPadAt(worldIn, pos.func_177982_a(-1, 0, 2), rand);
        this.placeLilyPadAt(worldIn, pos.func_177982_a(1, 0, -2), rand);
        this.placeLilyPadAt(worldIn, pos.func_177982_a(-1, 0, -2), rand);
        if (flowers) {
            this.placeBambooOrFlowerAt(worldIn, pos.func_177982_a(4, 0, 1), rand, flower);
            this.placeBambooOrFlowerAt(worldIn, pos.func_177982_a(4, 0, -1), rand, flower);
            this.placeBambooOrFlowerAt(worldIn, pos.func_177982_a(-4, 0, 1), rand, flower);
            this.placeBambooOrFlowerAt(worldIn, pos.func_177982_a(-4, 0, -1), rand, flower);
            this.placeBambooOrFlowerAt(worldIn, pos.func_177982_a(1, 0, 4), rand, flower);
            this.placeBambooOrFlowerAt(worldIn, pos.func_177982_a(-1, 0, 4), rand, flower);
            this.placeBambooOrFlowerAt(worldIn, pos.func_177982_a(1, 0, -4), rand, flower);
            this.placeBambooOrFlowerAt(worldIn, pos.func_177982_a(-1, 0, -4), rand, flower);
            this.placeBambooOrFlowerAt(worldIn, pos.func_177982_a(3, 0, 2), rand, flower);
            this.placeBambooOrFlowerAt(worldIn, pos.func_177982_a(3, 0, -2), rand, flower);
            this.placeBambooOrFlowerAt(worldIn, pos.func_177982_a(-3, 0, 2), rand, flower);
            this.placeBambooOrFlowerAt(worldIn, pos.func_177982_a(-3, 0, -2), rand, flower);
            this.placeBambooOrFlowerAt(worldIn, pos.func_177982_a(2, 0, 3), rand, flower);
            this.placeBambooOrFlowerAt(worldIn, pos.func_177982_a(-2, 0, 3), rand, flower);
            this.placeBambooOrFlowerAt(worldIn, pos.func_177982_a(2, 0, -3), rand, flower);
            this.placeBambooOrFlowerAt(worldIn, pos.func_177982_a(-2, 0, -3), rand, flower);
            this.placeBambooOrFlowerAt(worldIn, pos.func_177982_a(4, 0, 0), rand, flower);
            this.placeBambooOrFlowerAt(worldIn, pos.func_177982_a(-4, 0, 0), rand, flower);
            this.placeBambooOrFlowerAt(worldIn, pos.func_177982_a(0, 0, 4), rand, flower);
            this.placeBambooOrFlowerAt(worldIn, pos.func_177982_a(0, 0, -4), rand, flower);
        } else {
            this.placeBambooAt(worldIn, pos.func_177982_a(4, 0, 1), rand);
            this.placeBambooAt(worldIn, pos.func_177982_a(4, 0, -1), rand);
            this.placeBambooAt(worldIn, pos.func_177982_a(-4, 0, 1), rand);
            this.placeBambooAt(worldIn, pos.func_177982_a(-4, 0, -1), rand);
            this.placeBambooAt(worldIn, pos.func_177982_a(1, 0, 4), rand);
            this.placeBambooAt(worldIn, pos.func_177982_a(-1, 0, 4), rand);
            this.placeBambooAt(worldIn, pos.func_177982_a(1, 0, -4), rand);
            this.placeBambooAt(worldIn, pos.func_177982_a(-1, 0, -4), rand);
            this.placeBambooAt(worldIn, pos.func_177982_a(3, 0, 2), rand);
            this.placeBambooAt(worldIn, pos.func_177982_a(3, 0, -2), rand);
            this.placeBambooAt(worldIn, pos.func_177982_a(-3, 0, 2), rand);
            this.placeBambooAt(worldIn, pos.func_177982_a(-3, 0, -2), rand);
            this.placeBambooAt(worldIn, pos.func_177982_a(2, 0, 3), rand);
            this.placeBambooAt(worldIn, pos.func_177982_a(-2, 0, 3), rand);
            this.placeBambooAt(worldIn, pos.func_177982_a(2, 0, -3), rand);
            this.placeBambooAt(worldIn, pos.func_177982_a(-2, 0, -3), rand);
            this.placeBambooAt(worldIn, pos.func_177982_a(4, 0, 0), rand);
            this.placeBambooAt(worldIn, pos.func_177982_a(-4, 0, 0), rand);
            this.placeBambooAt(worldIn, pos.func_177982_a(0, 0, 4), rand);
            this.placeBambooAt(worldIn, pos.func_177982_a(0, 0, -4), rand);
        }
    }

    private void placeBambooOrFlowerAt(ISeedReader worldIn, BlockPos pos, Random rand, BlockState flower) {
        this.placeGrassAt(worldIn, pos.func_177977_b());
        if (rand.nextInt(4) == 0 && worldIn.func_180495_p(pos.func_177977_b()).func_177230_c() == Blocks.field_196658_i) {
            int i = rand.nextInt(3) + 1;
            for (int j = 0; j <= i; ++j) {
                if (!worldIn.func_175623_d(pos.func_177981_b(j))) continue;
                if (i < 3 && j == i || i == 3 && j == i - 1) {
                    this.setLogState((IWorldWriter)worldIn, pos.func_177981_b(j), BAMBOO_SMALL_LEAVES);
                    continue;
                }
                if (i == 3 && j == i) {
                    this.setLogState((IWorldWriter)worldIn, pos.func_177981_b(j), BAMBOO_LARGE_LEAVES);
                    continue;
                }
                this.setLogState((IWorldWriter)worldIn, pos.func_177981_b(j), BAMBOO_BASE);
            }
        } else if (rand.nextInt(3) == 0 && worldIn.func_180495_p(pos.func_177977_b()).func_177230_c() == Blocks.field_196658_i && worldIn.func_175623_d(pos)) {
            this.setLogState((IWorldWriter)worldIn, pos, flower);
        }
    }

    private void placeBambooAt(ISeedReader worldIn, BlockPos pos, Random rand) {
        this.placeGrassAt(worldIn, pos.func_177977_b());
        if (rand.nextInt(4) == 0 && worldIn.func_180495_p(pos.func_177977_b()).func_177230_c() == Blocks.field_196658_i) {
            int i = rand.nextInt(3) + 1;
            for (int j = 0; j <= i; ++j) {
                if (!worldIn.func_175623_d(pos.func_177981_b(j))) continue;
                if (i < 3 && j == i || i == 3 && j == i - 1) {
                    this.setLogState((IWorldWriter)worldIn, pos.func_177981_b(j), BAMBOO_SMALL_LEAVES);
                    continue;
                }
                if (i == 3 && j == i) {
                    this.setLogState((IWorldWriter)worldIn, pos.func_177981_b(j), BAMBOO_LARGE_LEAVES);
                    continue;
                }
                this.setLogState((IWorldWriter)worldIn, pos.func_177981_b(j), BAMBOO_BASE);
            }
        }
    }

    private void placeDirtAt(ISeedReader worldIn, BlockPos pos) {
        if (worldIn.func_180495_p(pos).func_177230_c() == Blocks.field_150350_a || worldIn.func_180495_p(pos).func_177230_c() == Blocks.field_150348_b || worldIn.func_180495_p(pos).func_177230_c() == Blocks.field_201941_jj) {
            this.setLogState((IWorldWriter)worldIn, pos, Blocks.field_150346_d.func_176223_P());
        }
    }

    private void placeGrassAt(ISeedReader worldIn, BlockPos pos) {
        if (worldIn.func_180495_p(pos).func_177230_c() == Blocks.field_150350_a || worldIn.func_180495_p(pos).func_177230_c() == Blocks.field_150346_d || worldIn.func_180495_p(pos).func_177230_c() == Blocks.field_150348_b || worldIn.func_180495_p(pos).func_177230_c() == Blocks.field_201941_jj || worldIn.func_180495_p(pos).func_177230_c() == HanamiBlocks.SAKURA_LEAF_CARPET.get()) {
            this.setLogState((IWorldWriter)worldIn, pos, Blocks.field_196658_i.func_176223_P());
        }
    }

    private void placeLilyPadAt(ISeedReader worldIn, BlockPos pos, Random rand) {
        if (rand.nextInt(3) == 0 && worldIn.func_180495_p(pos).func_177230_c() != HanamiBlocks.SAKURA_LOG.get()) {
            this.setLogState((IWorldWriter)worldIn, pos, Blocks.field_196651_dG.func_176223_P());
        }
    }

    private void placeAirAt(ISeedReader worldIn, BlockPos pos) {
        if (worldIn.func_180495_p(pos).func_177230_c() != HanamiBlocks.SAKURA_LEAVES.get() && worldIn.func_180495_p(pos).func_177230_c() != HanamiBlocks.SAKURA_LOG.get()) {
            this.setLogState((IWorldWriter)worldIn, pos, Blocks.field_150350_a.func_176223_P());
        }
    }

    private void placeWaterRandomlyAt(ISeedReader worldIn, BlockPos pos, Random rand) {
        if (rand.nextBoolean()) {
            this.placeWaterAt(worldIn, pos);
        }
    }

    private void placeWaterAt(ISeedReader worldIn, BlockPos pos) {
        if (worldIn.func_180495_p(pos.func_177984_a()).func_177230_c() == HanamiBlocks.SAKURA_LOG.get()) {
            this.setLogState((IWorldWriter)worldIn, pos, ((Block)HanamiBlocks.SAKURA_LOG.get()).func_176223_P());
        } else {
            this.setLogState((IWorldWriter)worldIn, pos, Blocks.field_150355_j.func_176223_P());
        }
        this.placeDirtAt(worldIn, pos.func_177977_b());
    }

    public static boolean isRightGround(IWorldGenerationBaseReader worldIn, BlockPos pos) {
        return worldIn.func_217375_a(pos, state -> state.func_177230_c() == Blocks.field_196658_i || state.func_177230_c() == Blocks.field_150346_d || state.func_177230_c() == Blocks.field_150348_b);
    }

    protected final void setLogState(IWorldWriter worldIn, BlockPos pos, BlockState state) {
        worldIn.func_180501_a(pos, state, 18);
    }
}

