/*
 * Decompiled with CFR 0.152.
 */
package com.teamaurora.hanami.core.other;

import com.teamaurora.hanami.client.particle.HanamiParticles;
import com.teamaurora.hanami.common.entity.SakuraBlossomEntity;
import com.teamaurora.hanami.common.entity.ThrownSakuraBlossomEntity;
import com.teamaurora.hanami.core.registry.HanamiBlocks;
import com.teamaurora.hanami.core.registry.HanamiEffects;
import java.util.Random;
import net.minecraft.block.Blocks;
import net.minecraft.block.LeavesBlock;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Food;
import net.minecraft.item.ItemStack;
import net.minecraft.particles.IParticleData;
import net.minecraft.potion.Effect;
import net.minecraft.state.Property;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.ProjectileImpactEvent;
import net.minecraftforge.event.entity.living.LivingEntityUseItemEvent;
import net.minecraftforge.event.entity.living.LivingKnockBackEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="hanami")
public class HanamiEvents {
    @SubscribeEvent
    public static void livingKnockBack(LivingKnockBackEvent event) {
        LivingEntity entity = event.getEntityLiving();
        if (entity.func_70644_a((Effect)HanamiEffects.INSTABILITY.get())) {
            int amplifier = entity.func_70660_b((Effect)HanamiEffects.INSTABILITY.get()).func_76458_c();
            event.setStrength(event.getStrength() * (float)(2 + amplifier));
        }
    }

    @SubscribeEvent
    public static void livingEntityUseItemFinish(LivingEntityUseItemEvent.Finish event) {
        int amplifier;
        ItemStack item = event.getItem();
        LivingEntity entity = event.getEntityLiving();
        if (entity.func_70644_a((Effect)HanamiEffects.NOURISHING.get())) {
            amplifier = entity.func_70660_b((Effect)HanamiEffects.NOURISHING.get()).func_76458_c();
            if (item.func_222117_E()) {
                int foodToAdd = 2 * (amplifier + 1);
                if (entity instanceof PlayerEntity) {
                    PlayerEntity player = (PlayerEntity)entity;
                    player.func_71024_bL().func_75122_a(foodToAdd, 0.0f);
                }
            }
        }
        if (entity.func_70644_a((Effect)HanamiEffects.UNSALUTARY.get())) {
            amplifier = entity.func_70660_b((Effect)HanamiEffects.UNSALUTARY.get()).func_76458_c();
            if (item.func_222117_E()) {
                Food food = item.func_77973_b().func_219967_s();
                int foodToRemove = Math.min(2 * (amplifier + 1), food.func_221466_a());
                if (entity instanceof PlayerEntity) {
                    PlayerEntity player = (PlayerEntity)entity;
                    player.func_71024_bL().func_75122_a(foodToRemove * -1, 0.0f);
                }
            }
        }
    }

    @SubscribeEvent
    public static void playerTick(TickEvent.PlayerTickEvent event) {
        float spawnChance;
        PlayerEntity player = event.player;
        Vector3d playerPos = player.func_213303_ch();
        BlockPos playerBlockPos = new BlockPos(Math.floor(playerPos.func_82615_a()), Math.floor(playerPos.func_82617_b()), Math.floor(playerPos.func_82616_c()));
        World world = event.player.field_70170_p;
        float modifiedSpawnChance = spawnChance = 0.001f;
        if (world.func_72896_J() || world.func_72911_I()) {
            modifiedSpawnChance += spawnChance;
        }
        if (world.func_130001_d() == 1.0f) {
            modifiedSpawnChance += 2.0f * spawnChance;
        }
        if (world.field_73012_v.nextFloat() < modifiedSpawnChance) {
            for (BlockPos blockPos : BlockPos.func_218278_a((BlockPos)playerBlockPos.func_177982_a(-10, -10, -10), (BlockPos)playerBlockPos.func_177982_a(10, 10, 10))) {
                if (blockPos.func_177956_o() <= 1 || blockPos.func_177956_o() >= world.func_217301_I() || world.func_180495_p(blockPos).func_177230_c() != HanamiBlocks.SAKURA_LEAVES.get() || ((Boolean)world.func_180495_p(blockPos).func_177229_b((Property)LeavesBlock.field_208495_b)).booleanValue() || world.func_180495_p(blockPos.func_177977_b()).func_177230_c() != Blocks.field_150350_a || world.func_180495_p(blockPos.func_177977_b().func_177978_c()).func_177230_c() != Blocks.field_150350_a || world.field_73012_v.nextInt(40) != 0 || !(world instanceof ServerWorld)) continue;
                SakuraBlossomEntity blossom = new SakuraBlossomEntity(world, blockPos, blockPos.func_177958_n(), blockPos.func_177956_o() - 1, blockPos.func_177952_p(), true);
                world.func_217376_c((Entity)blossom);
            }
        }
    }

    @SubscribeEvent
    public void projectileImpact(ProjectileImpactEvent event) {
        Entity entity = event.getEntity();
        World world = entity.func_130014_f_();
        if (entity instanceof ThrownSakuraBlossomEntity && event.getRayTraceResult().func_216346_c() != RayTraceResult.Type.MISS && !world.field_72995_K) {
            IParticleData blossoms = (IParticleData)HanamiParticles.BLOSSOM_PETAL.get();
            Random rand = world.func_201674_k();
            for (int i = 0; i < 16; ++i) {
                world.func_195594_a(blossoms, this.getParticleOffset(entity.func_226277_ct_(), rand), this.getParticleOffset(entity.func_226278_cu_(), rand), this.getParticleOffset(entity.func_226281_cx_(), rand), this.getRandWithMagnitude(0.05, rand), this.getRandWithMagnitude(0.03, rand), this.getRandWithMagnitude(0.05, rand));
            }
        }
    }

    private double getParticleOffset(double value, Random rand) {
        return value + rand.nextDouble() * (double)0.2f - (double)0.1f;
    }

    private double getRandWithMagnitude(double mag, Random rand) {
        return rand.nextDouble() * 2.0 * mag - mag;
    }
}

