/*
 * Decompiled with CFR 0.152.
 */
package com.teamaurora.hanami.core.other;

import com.google.gson.JsonObject;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.loot.LootContext;
import net.minecraft.loot.conditions.ILootCondition;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.loot.GlobalLootModifierSerializer;
import net.minecraftforge.common.loot.LootModifier;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;

@Mod.EventBusSubscriber(modid="hanami", bus=Mod.EventBusSubscriber.Bus.MOD)
public class HanamiLootModifiers {
    @SubscribeEvent
    public static void registerModifierSerializers(@Nonnull RegistryEvent.Register<GlobalLootModifierSerializer<?>> event) {
        event.getRegistry().register((IForgeRegistryEntry)new FruitfulModifier.Serializer().setRegistryName(new ResourceLocation("hanami", "fruitful")));
    }

    public static class FruitfulModifier
    extends LootModifier {
        private final Item cherry;

        public FruitfulModifier(ILootCondition[] conditionsIn, Item cherryItem) {
            super(conditionsIn);
            this.cherry = cherryItem;
        }

        @Nonnull
        protected List<ItemStack> doApply(List<ItemStack> generatedLoot, LootContext context) {
            if (ModList.get().isLoaded("fruitful")) {
                generatedLoot.removeIf(x -> x.func_77973_b() == this.cherry);
            }
            return generatedLoot;
        }

        private static class Serializer
        extends GlobalLootModifierSerializer<FruitfulModifier> {
            private Serializer() {
            }

            public FruitfulModifier read(ResourceLocation name, JsonObject object, ILootCondition[] conditionsIn) {
                Item cherryItem = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(JSONUtils.func_151200_h((JsonObject)object, (String)"cherryItem")));
                return new FruitfulModifier(conditionsIn, cherryItem);
            }
        }
    }
}

