/*
 * Decompiled with CFR 0.152.
 */
package com.teamaurora.hanami.core.registry;

import com.teamaurora.hanami.common.world.biome.SakuraForestBiome;
import com.teamaurora.hanami.common.world.biome.SakuraForestEdgeBiome;
import com.teamaurora.hanami.common.world.biome.SakuraMountainsBiome;
import com.teamaurora.hanami.common.world.biome.SakuraPlateauBiome;
import com.teamaurora.hanami.common.world.biome.SakuraRollingHillsBiome;
import com.teamaurora.hanami.common.world.biome.SakuraValleyBiome;
import com.teamaurora.hanami.core.HanamiConfig;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.common.BiomeManager;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;

@Mod.EventBusSubscriber(modid="hanami", bus=Mod.EventBusSubscriber.Bus.MOD)
public class HanamiBiomes {
    public static final DeferredRegister<Biome> BIOMES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BIOMES, (String)"hanami");
    public static final RegistryObject<Biome> SAKURA_FOREST = BIOMES.register("sakura_forest", SakuraForestBiome::new);
    public static final RegistryObject<Biome> SAKURA_FOREST_EDGE = BIOMES.register("sakura_forest_edge", SakuraForestEdgeBiome::new);
    public static final RegistryObject<Biome> SAKURA_PLATEAU = BIOMES.register("sakura_plateau", SakuraPlateauBiome::new);
    public static final RegistryObject<Biome> SAKURA_ROLLING_HILLS = BIOMES.register("sakura_rolling_hills", SakuraRollingHillsBiome::new);
    public static final RegistryObject<Biome> SAKURA_VALLEY = BIOMES.register("sakura_valley", SakuraValleyBiome::new);
    public static final RegistryObject<Biome> SAKURA_MOUNTAINS = BIOMES.register("sakura_mountains", SakuraMountainsBiome::new);

    public static void registerBiomesToDictionary() {
        BiomeManager.addBiome((BiomeManager.BiomeType)BiomeManager.BiomeType.WARM, (BiomeManager.BiomeEntry)new BiomeManager.BiomeEntry((Biome)SAKURA_FOREST.get(), ((Integer)HanamiConfig.COMMON.sakuraForestWeight.get()).intValue()));
        BiomeManager.addBiome((BiomeManager.BiomeType)BiomeManager.BiomeType.WARM, (BiomeManager.BiomeEntry)new BiomeManager.BiomeEntry((Biome)SAKURA_ROLLING_HILLS.get(), ((Integer)HanamiConfig.COMMON.sakuraRollingHillsWeight.get()).intValue()));
        BiomeManager.addBiome((BiomeManager.BiomeType)BiomeManager.BiomeType.WARM, (BiomeManager.BiomeEntry)new BiomeManager.BiomeEntry((Biome)SAKURA_MOUNTAINS.get(), ((Integer)HanamiConfig.COMMON.sakuraMountainsWeight.get()).intValue()));
    }

    public static void addBiomeTypes() {
        BiomeDictionary.addTypes((Biome)((Biome)SAKURA_FOREST.get()), (BiomeDictionary.Type[])new BiomeDictionary.Type[]{BiomeDictionary.Type.FOREST, BiomeDictionary.Type.OVERWORLD});
        BiomeDictionary.addTypes((Biome)((Biome)SAKURA_FOREST_EDGE.get()), (BiomeDictionary.Type[])new BiomeDictionary.Type[]{BiomeDictionary.Type.SPARSE, BiomeDictionary.Type.FOREST, BiomeDictionary.Type.OVERWORLD});
        BiomeDictionary.addTypes((Biome)((Biome)SAKURA_PLATEAU.get()), (BiomeDictionary.Type[])new BiomeDictionary.Type[]{BiomeDictionary.Type.SPARSE, BiomeDictionary.Type.FOREST, BiomeDictionary.Type.PLATEAU, BiomeDictionary.Type.OVERWORLD});
        BiomeDictionary.addTypes((Biome)((Biome)SAKURA_ROLLING_HILLS.get()), (BiomeDictionary.Type[])new BiomeDictionary.Type[]{BiomeDictionary.Type.FOREST, BiomeDictionary.Type.RARE, BiomeDictionary.Type.HILLS, BiomeDictionary.Type.OVERWORLD});
        BiomeDictionary.addTypes((Biome)((Biome)SAKURA_VALLEY.get()), (BiomeDictionary.Type[])new BiomeDictionary.Type[]{BiomeDictionary.Type.SPARSE, BiomeDictionary.Type.RARE, BiomeDictionary.Type.FOREST, BiomeDictionary.Type.OVERWORLD});
        BiomeDictionary.addTypes((Biome)((Biome)SAKURA_MOUNTAINS.get()), (BiomeDictionary.Type[])new BiomeDictionary.Type[]{BiomeDictionary.Type.RARE, BiomeDictionary.Type.FOREST, BiomeDictionary.Type.HILLS, BiomeDictionary.Type.OVERWORLD});
    }
}

