/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.base.client.config;

import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import vazkii.quark.base.Quark;
import vazkii.quark.base.client.config.ConfigCategory;
import vazkii.quark.base.client.config.ConfigObject;
import vazkii.quark.base.client.config.IConfigElement;
import vazkii.quark.base.module.ModuleCategory;
import vazkii.quark.base.module.config.IConfigCallback;

@OnlyIn(value=Dist.CLIENT)
public final class IngameConfigHandler
implements IConfigCallback {
    public static final IngameConfigHandler INSTANCE = new IngameConfigHandler();
    public Map<String, ConfigCategory> topLevelCategories = new LinkedHashMap<String, ConfigCategory>();
    private ConfigCategory currCategory = null;

    private IngameConfigHandler() {
    }

    @Override
    public void push(String s, String comment) {
        ConfigCategory newCategory = null;
        if (this.currCategory == null) {
            newCategory = new ConfigCategory(s, comment, null);
            this.topLevelCategories.put(s, newCategory);
        } else {
            newCategory = this.currCategory.addCategory(s, comment);
        }
        this.currCategory = newCategory;
    }

    @Override
    public void pop() {
        if (this.currCategory != null) {
            this.currCategory.close();
            this.currCategory = this.currCategory.getParent();
        }
    }

    @Override
    public <T> void addEntry(String name, T default_, Supplier<T> getter, String comment, Predicate<Object> restriction) {
        if (this.currCategory != null) {
            this.currCategory.addObject(name, default_, getter, comment, restriction);
        }
    }

    public ConfigObject<Boolean> getCategoryEnabledObject(ModuleCategory category) {
        return this.topLevelCategories.get("categories").getModuleOption(category);
    }

    public ConfigCategory getConfigCategory(ModuleCategory category) {
        return this.topLevelCategories.get(category == null ? "general" : category.name);
    }

    public void refresh() {
        this.topLevelCategories.values().forEach(IConfigElement::refresh);
    }

    public void debug() {
        if (!Quark.DEBUG_MODE) {
            return;
        }
        this.writeToFile(new File("config", "quark-common.toml-generated"));
    }

    public void commit() {
        for (ConfigCategory c : this.topLevelCategories.values()) {
            if (!c.isDirty()) continue;
            this.save();
            return;
        }
    }

    private void save() {
        this.writeToFile(new File("config", "quark-common.toml"));
        for (ConfigCategory c1 : this.topLevelCategories.values()) {
            c1.clean();
        }
    }

    private void writeToFile(File file) {
        try {
            file.createNewFile();
            PrintStream stream = new PrintStream(file);
            for (String name : this.topLevelCategories.keySet()) {
                this.topLevelCategories.get(name).print("", stream);
            }
            stream.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

