/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.base.client.config.gui;

import com.mojang.blaze3d.matrix.MatrixStack;
import net.minecraft.client.gui.IGuiEventListener;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.TextFieldWidget;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import vazkii.quark.base.client.config.gui.AbstractQScreen;
import vazkii.quark.base.client.config.obj.AbstractStringInputObject;

public class StringInputScreen<T>
extends AbstractQScreen {
    private final AbstractStringInputObject<T> object;
    private TextFieldWidget input;
    private Button resetButton;
    private Button doneButton;
    private boolean errored = false;

    public StringInputScreen(Screen parent, AbstractStringInputObject<T> object) {
        super(parent);
        this.object = object;
    }

    @Override
    public void func_230430_a_(MatrixStack mstack, int mouseX, int mouseY, float pticks) {
        this.func_230446_a_(mstack);
        super.func_230430_a_(mstack, mouseX, mouseY, pticks);
        this.func_238472_a_(mstack, this.field_230712_o_, (ITextProperties)new StringTextComponent(this.object.getGuiDisplayName()).func_240701_a_(new TextFormatting[]{TextFormatting.BOLD}), this.field_230708_k_ / 2, 20, 0xFFFFFF);
        this.func_238471_a_(mstack, this.field_230712_o_, I18n.func_135052_a((String)"quark.gui.config.defaultvalue", (Object[])new Object[]{this.object.defaultObj}), this.field_230708_k_ / 2, 30, 0xFFFFFF);
        this.input.func_230430_a_(mstack, mouseX, mouseY, pticks);
    }

    protected void func_231160_c_() {
        super.func_231160_c_();
        int pad = 3;
        int bWidth = 121;
        int left = (this.field_230708_k_ - (bWidth + pad) * 3) / 2;
        int vStart = this.field_230709_l_ - 30;
        this.func_230480_a_((Widget)new Button(left, vStart, bWidth, 20, (ITextComponent)new TranslationTextComponent("quark.gui.config.default"), this::setDefault));
        this.resetButton = new Button(left + bWidth + pad, vStart, bWidth, 20, (ITextComponent)new TranslationTextComponent("quark.gui.config.discard"), this::reset);
        this.func_230480_a_((Widget)this.resetButton);
        this.doneButton = new Button(left + (bWidth + pad) * 2, vStart, bWidth, 20, (ITextComponent)new TranslationTextComponent("gui.done"), this::save);
        this.func_230480_a_((Widget)this.doneButton);
        this.input = new TextFieldWidget(this.field_230712_o_, this.field_230708_k_ / 2 - 100, 60, 200, 20, (ITextComponent)new StringTextComponent(""));
        this.input.func_200675_a(this.object::isStringValid);
        this.input.func_146203_f(this.object.getMaxStringLength());
        this.input.func_212954_a(this::update);
        this.func_212928_a((IGuiEventListener)this.input);
        this.field_230705_e_.add(this.input);
        this.update();
    }

    public void func_231023_e_() {
        this.input.func_146178_a();
    }

    public boolean func_231046_a_(int key, int mouseX, int mouseY) {
        switch (key) {
            case 256: {
                this.reset(null);
                return true;
            }
            case 257: {
                if (this.errored) break;
                this.save(null);
                return true;
            }
        }
        return super.func_231046_a_(key, mouseX, mouseY);
    }

    public boolean func_231044_a_(double x, double y, int button) {
        if (this.input.func_231044_a_(x, y, button)) {
            return true;
        }
        return super.func_231044_a_(x, y, button);
    }

    private void setDefault(Button button) {
        this.object.reset(true);
        this.update();
        this.save(button);
    }

    private void reset(Button button) {
        this.object.reset(false);
        this.update();
        this.save(button);
    }

    private void save(Button button) {
        if (!this.errored) {
            this.object.setCurrentObj(this.object.fromString(this.input.func_146179_b()));
            this.returnToParent(button);
        }
    }

    private void update() {
        this.input.func_146180_a(this.object.getCurrentObj().toString());
        this.update(this.input.func_146179_b());
    }

    private void update(String s) {
        T val = this.object.fromString(s);
        this.errored = val == null || this.object.restriction != null && !this.object.restriction.test(val);
        this.input.func_146193_g(this.errored ? 0xFF0000 : 0xFFFFFF);
        this.resetButton.field_230693_o_ = this.errored || this.object.wouldBeDirty(val);
        this.doneButton.field_230693_o_ = !this.errored;
    }
}

