/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.base.world.config;

import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.world.biome.Biome;
import vazkii.quark.base.module.config.Config;
import vazkii.quark.base.module.config.ConfigFlagManager;
import vazkii.quark.base.world.config.IBiomeConfig;

public class StrictBiomeConfig
implements IBiomeConfig {
    @Config(name="Biomes")
    private List<String> biomeStrings;
    @Config
    private boolean isBlacklist;

    public StrictBiomeConfig(boolean isBlacklist, String ... biomes) {
        this.isBlacklist = isBlacklist;
        this.biomeStrings = new LinkedList<String>();
        this.biomeStrings.addAll(Arrays.asList(biomes));
    }

    @Override
    public boolean canSpawn(Biome b) {
        return this.biomeStrings.contains(b.getRegistryName().toString()) != this.isBlacklist;
    }

    @Override
    public void onReload(ConfigFlagManager flagManager) {
    }
}

