/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.building.module;

import com.google.common.collect.Maps;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.model.ModelResourceLocation;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntityType;
import net.minecraft.item.DyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.Items;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import vazkii.arl.util.RegistryHelper;
import vazkii.quark.base.module.LoadModule;
import vazkii.quark.base.module.Module;
import vazkii.quark.base.module.ModuleCategory;
import vazkii.quark.building.client.render.ColoredItemFrameRenderer;
import vazkii.quark.building.client.render.GlassItemFrameRenderer;
import vazkii.quark.building.entity.ColoredItemFrameEntity;
import vazkii.quark.building.entity.GlassItemFrameEntity;
import vazkii.quark.building.item.QuarkItemFrameItem;

@LoadModule(category=ModuleCategory.BUILDING)
public class ItemFramesModule
extends Module {
    public static Item glassFrame;
    private static Map<DyeColor, Item> coloredFrames;
    public static EntityType<GlassItemFrameEntity> glassFrameEntity;
    public static EntityType<ColoredItemFrameEntity> coloredFrameEntity;

    public static Item getColoredFrame(DyeColor color) {
        return coloredFrames.getOrDefault(color, Items.field_151160_bD);
    }

    @Override
    public void construct() {
        glassFrameEntity = EntityType.Builder.func_220322_a(GlassItemFrameEntity::new, (EntityClassification)EntityClassification.MISC).func_220321_a(0.5f, 0.5f).setTrackingRange(10).setUpdateInterval(Integer.MAX_VALUE).setShouldReceiveVelocityUpdates(false).setCustomClientFactory((spawnEntity, world) -> new GlassItemFrameEntity((EntityType<? extends GlassItemFrameEntity>)glassFrameEntity, (World)world)).func_206830_a("glass_frame");
        RegistryHelper.register(glassFrameEntity, (String)"glass_frame");
        coloredFrameEntity = EntityType.Builder.func_220322_a(ColoredItemFrameEntity::new, (EntityClassification)EntityClassification.MISC).func_220321_a(0.5f, 0.5f).setTrackingRange(10).setUpdateInterval(Integer.MAX_VALUE).setCustomClientFactory((spawnEntity, world) -> new ColoredItemFrameEntity((EntityType<? extends ColoredItemFrameEntity>)coloredFrameEntity, (World)world)).setShouldReceiveVelocityUpdates(false).func_206830_a("colored_frame");
        RegistryHelper.register(coloredFrameEntity, (String)"colored_frame");
        glassFrame = new QuarkItemFrameItem("glass_item_frame", this, GlassItemFrameEntity::new, new Item.Properties().func_200916_a(ItemGroup.field_78031_c));
        for (DyeColor color : DyeColor.values()) {
            coloredFrames.put(color, (Item)new QuarkItemFrameItem(color.func_176762_d() + "_item_frame", this, (world, pos, dir) -> new ColoredItemFrameEntity((World)world, (BlockPos)pos, (Direction)dir, color.func_196059_a()), new Item.Properties().func_200916_a(ItemGroup.field_78031_c)));
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void clientSetup() {
        Minecraft mc = Minecraft.func_71410_x();
        RenderingRegistry.registerEntityRenderingHandler(glassFrameEntity, manager -> new GlassItemFrameRenderer(manager, mc.func_175599_af()));
        RenderingRegistry.registerEntityRenderingHandler(coloredFrameEntity, manager -> new ColoredItemFrameRenderer(manager, mc.func_175599_af()));
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void modelRegistry() {
        ModelLoader.addSpecialModel((ResourceLocation)new ModelResourceLocation(new ResourceLocation("quark", "glass_frame"), "inventory"));
        for (DyeColor color : DyeColor.values()) {
            ModelLoader.addSpecialModel((ResourceLocation)new ModelResourceLocation(new ResourceLocation("quark", color.func_176610_l() + "_frame_empty"), "inventory"));
            ModelLoader.addSpecialModel((ResourceLocation)new ModelResourceLocation(new ResourceLocation("quark", color.func_176610_l() + "_frame_map"), "inventory"));
        }
    }

    static {
        coloredFrames = Maps.newEnumMap(DyeColor.class);
    }
}

