/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.building.module;

import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.GlobalEntityTypeAttributes;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import vazkii.arl.util.RegistryHelper;
import vazkii.quark.base.module.LoadModule;
import vazkii.quark.base.module.Module;
import vazkii.quark.base.module.ModuleCategory;
import vazkii.quark.building.client.render.LeashKnot2Renderer;
import vazkii.quark.building.entity.LeashKnot2Entity;

@LoadModule(category=ModuleCategory.BUILDING, hasSubscriptions=true)
public class TieLeadsToFencesModule
extends Module {
    public static EntityType<LeashKnot2Entity> leashKnot2Entity;
    public static ITag<Block> leadConnectableTag;

    @Override
    public void construct() {
        leashKnot2Entity = EntityType.Builder.func_220322_a(LeashKnot2Entity::new, (EntityClassification)EntityClassification.MISC).func_220321_a(0.375f, 0.5f).setTrackingRange(10).setUpdateInterval(Integer.MAX_VALUE).setShouldReceiveVelocityUpdates(false).setCustomClientFactory((spawnEntity, world) -> new LeashKnot2Entity((EntityType<? extends LeashKnot2Entity>)leashKnot2Entity, (World)world)).func_206830_a("leash_knot_fake");
        RegistryHelper.register(leashKnot2Entity, (String)"leash_knot_fake");
    }

    @Override
    public void setup() {
        GlobalEntityTypeAttributes.put(leashKnot2Entity, (AttributeModifierMap)MobEntity.func_233666_p_().func_233813_a_());
        leadConnectableTag = BlockTags.func_199894_a((String)"quark:lead_connectable");
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void clientSetup() {
        RenderingRegistry.registerEntityRenderingHandler(leashKnot2Entity, manager -> new LeashKnot2Renderer(manager));
    }

    @SubscribeEvent
    public void onRightClick(PlayerInteractEvent.RightClickBlock event) {
        World world = event.getWorld();
        if (world.field_72995_K || event.getHand() != Hand.MAIN_HAND) {
            return;
        }
        PlayerEntity player = event.getPlayer();
        ItemStack stack = player.func_184586_b(event.getHand());
        BlockPos pos = event.getPos();
        BlockState state = world.func_180495_p(pos);
        if (stack.func_77973_b() == Items.field_151058_ca && state.func_177230_c().func_203417_a(leadConnectableTag)) {
            for (MobEntity mob : world.func_217357_a(MobEntity.class, new AxisAlignedBB(player.func_226277_ct_() - 7.0, player.func_226278_cu_() - 7.0, player.func_226281_cx_() - 7.0, player.func_226277_ct_() + 7.0, player.func_226278_cu_() + 7.0, player.func_226281_cx_() + 7.0))) {
                if (mob.func_110166_bE() != player) continue;
                return;
            }
            LeashKnot2Entity knot = new LeashKnot2Entity(leashKnot2Entity, world);
            knot.func_70107_b((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5 - 0.125, (double)pos.func_177952_p() + 0.5);
            world.func_217376_c((Entity)knot);
            knot.func_110162_b((Entity)player, true);
            if (!player.func_184812_l_()) {
                stack.func_190918_g(1);
            }
            world.func_184133_a(null, pos, SoundEvents.field_187748_db, SoundCategory.BLOCKS, 1.0f, 1.0f);
            event.setCanceled(true);
        }
    }
}

