/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.client.module;

import com.google.common.collect.ListMultimap;
import com.google.common.collect.Multimaps;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import vazkii.quark.base.module.LoadModule;
import vazkii.quark.base.module.Module;
import vazkii.quark.base.module.ModuleCategory;
import vazkii.quark.base.module.config.Config;
import vazkii.quark.client.render.variant.VariantBeeRenderer;
import vazkii.quark.client.render.variant.VariantChickenRenderer;
import vazkii.quark.client.render.variant.VariantCowRenderer;
import vazkii.quark.client.render.variant.VariantLlamaRenderer;
import vazkii.quark.client.render.variant.VariantPigRenderer;
import vazkii.quark.client.render.variant.VariantRabbitRenderer;

@LoadModule(category=ModuleCategory.CLIENT, hasSubscriptions=true, subscribeOn={Dist.CLIENT})
public class VariantAnimalTexturesModule
extends Module {
    private static ListMultimap<VariantTextureType, ResourceLocation> textures;
    private static Map<VariantTextureType, ResourceLocation> shinyTextures;
    private static final int COW_COUNT = 4;
    private static final int PIG_COUNT = 3;
    private static final int CHICKEN_COUNT = 6;
    @Config
    public static boolean enableCow;
    @Config
    public static boolean enablePig;
    @Config
    public static boolean enableChicken;
    @Config
    public static boolean enableShinyRabbit;
    @Config
    public static boolean enableShinyLlama;
    @Config
    public static boolean enableLGBTBees;
    @Config
    public static boolean everyBeeIsLGBT;
    @Config(description="The chance for an animal to have a special \"Shiny\" skin, like a shiny pokemon. This is 1 in X. Set to 0 to disable.")
    public static int shinyAnimalChance;

    @Override
    public void clientSetup() {
        if (!this.enabled) {
            return;
        }
        textures = Multimaps.newListMultimap(new EnumMap(VariantTextureType.class), ArrayList::new);
        shinyTextures = new HashMap<VariantTextureType, ResourceLocation>();
        VariantAnimalTexturesModule.registerTextures(VariantTextureType.COW, 4, new ResourceLocation("textures/entity/cow/cow.png"));
        VariantAnimalTexturesModule.registerTextures(VariantTextureType.PIG, 3, new ResourceLocation("textures/entity/pig/pig.png"));
        VariantAnimalTexturesModule.registerTextures(VariantTextureType.CHICKEN, 6, new ResourceLocation("textures/entity/chicken.png"));
        VariantAnimalTexturesModule.registerShiny(VariantTextureType.RABBIT);
        VariantAnimalTexturesModule.registerShiny(VariantTextureType.LLAMA);
        if (enableCow) {
            RenderingRegistry.registerEntityRenderingHandler((EntityType)EntityType.field_200796_j, VariantCowRenderer::new);
        }
        if (enablePig) {
            RenderingRegistry.registerEntityRenderingHandler((EntityType)EntityType.field_200784_X, VariantPigRenderer::new);
        }
        if (enableChicken) {
            RenderingRegistry.registerEntityRenderingHandler((EntityType)EntityType.field_200795_i, VariantChickenRenderer::new);
        }
        if (enableShinyRabbit) {
            RenderingRegistry.registerEntityRenderingHandler((EntityType)EntityType.field_200736_ab, VariantRabbitRenderer::new);
        }
        if (enableShinyLlama) {
            RenderingRegistry.registerEntityRenderingHandler((EntityType)EntityType.field_200769_I, VariantLlamaRenderer::new);
        }
        if (enableLGBTBees) {
            RenderingRegistry.registerEntityRenderingHandler((EntityType)EntityType.field_226289_e_, VariantBeeRenderer::new);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static ResourceLocation getTextureOrShiny(Entity e, VariantTextureType type, boolean enabled) {
        return VariantAnimalTexturesModule.getTextureOrShiny(e, type, () -> VariantAnimalTexturesModule.getRandomTexture(e, type, enabled));
    }

    @OnlyIn(value=Dist.CLIENT)
    public static ResourceLocation getTextureOrShiny(Entity e, VariantTextureType type, Supplier<ResourceLocation> nonShiny) {
        UUID id = e.func_110124_au();
        long most = id.getMostSignificantBits();
        if (shinyAnimalChance > 0 && most % (long)shinyAnimalChance == 0L) {
            return shinyTextures.get((Object)type);
        }
        return nonShiny.get();
    }

    @OnlyIn(value=Dist.CLIENT)
    private static ResourceLocation getRandomTexture(Entity e, VariantTextureType type, boolean enabled) {
        List styles = textures.get((Object)type);
        if (!enabled) {
            return (ResourceLocation)styles.get(styles.size() - 1);
        }
        UUID id = e.func_110124_au();
        long most = id.getMostSignificantBits();
        int choice = Math.abs((int)(most % (long)styles.size()));
        return (ResourceLocation)styles.get(choice);
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void registerTextures(VariantTextureType type, int count, ResourceLocation vanilla) {
        String name = type.name().toLowerCase(Locale.ROOT);
        for (int i = 1; i < count + 1; ++i) {
            textures.put((Object)type, (Object)new ResourceLocation("quark", String.format("textures/model/entity/variants/%s%d.png", name, i)));
        }
        if (vanilla != null) {
            textures.put((Object)type, (Object)vanilla);
        }
        VariantAnimalTexturesModule.registerShiny(type);
    }

    private static void registerShiny(VariantTextureType type) {
        shinyTextures.put(type, new ResourceLocation("quark", String.format("textures/model/entity/variants/%s_shiny.png", type.name().toLowerCase(Locale.ROOT))));
    }

    static {
        enableCow = true;
        enablePig = true;
        enableChicken = true;
        enableShinyRabbit = true;
        enableShinyLlama = true;
        enableLGBTBees = true;
        everyBeeIsLGBT = false;
        shinyAnimalChance = 2048;
    }

    public static enum VariantTextureType {
        COW,
        PIG,
        CHICKEN,
        LLAMA,
        RABBIT;

    }
}

