/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.management.module;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.client.MainWindow;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.renderer.ItemRenderer;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import vazkii.quark.base.client.ModKeybindHandler;
import vazkii.quark.base.module.LoadModule;
import vazkii.quark.base.module.Module;
import vazkii.quark.base.module.ModuleCategory;
import vazkii.quark.base.network.QuarkNetwork;
import vazkii.quark.base.network.message.ChangeHotbarMessage;

@LoadModule(category=ModuleCategory.MANAGEMENT, hasSubscriptions=true, subscribeOn={Dist.CLIENT})
public class HotbarChangerModule
extends Module {
    @OnlyIn(value=Dist.CLIENT)
    private static KeyBinding changeHotbarKey;
    private static final ResourceLocation WIDGETS;
    private static final int ANIMATION_TIME = 10;
    private static final int MAX_HEIGHT = 90;
    private static final int ANIM_PER_TICK = 9;
    public static int height;
    public static int currentHeldItem;
    public static boolean animating;
    public static boolean keyDown;
    public static boolean hotbarChangeOpen;
    public static boolean shifting;

    @Override
    public void clientSetup() {
        changeHotbarKey = ModKeybindHandler.init("change_hotbar", "z", "quark.gui.keygroup.misc");
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public void onMouseInput(InputEvent.MouseInputEvent event) {
        this.acceptInput();
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public void onKeyInput(InputEvent.KeyInputEvent event) {
        this.acceptInput();
    }

    private void acceptInput() {
        Minecraft mc = Minecraft.func_71410_x();
        boolean down = changeHotbarKey.func_151470_d();
        boolean wasDown = keyDown;
        keyDown = down;
        if (mc.func_195544_aj()) {
            if (down && !wasDown) {
                hotbarChangeOpen = !hotbarChangeOpen;
            } else if (hotbarChangeOpen) {
                for (int i = 0; i < 3; ++i) {
                    if (!mc.field_71474_y.field_151456_ac[i].func_151470_d()) continue;
                    QuarkNetwork.sendToServer(new ChangeHotbarMessage(i + 1));
                    hotbarChangeOpen = false;
                    currentHeldItem = mc.field_71439_g.field_71071_by.field_70461_c;
                    return;
                }
            }
        }
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public void hudPre(RenderGameOverlayEvent.Pre event) {
        float shift = -this.getRealHeight(event.getPartialTicks()) + 22.0f;
        if (shift < 0.0f) {
            if (event.getType() == RenderGameOverlayEvent.ElementType.HEALTH) {
                RenderSystem.translatef((float)0.0f, (float)shift, (float)0.0f);
                shifting = true;
            } else if (shifting && (event.getType() == RenderGameOverlayEvent.ElementType.DEBUG || event.getType() == RenderGameOverlayEvent.ElementType.POTION_ICONS)) {
                RenderSystem.translatef((float)0.0f, (float)(-shift), (float)0.0f);
                shifting = false;
            }
        }
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public void hudPost(RenderGameOverlayEvent.Post event) {
        if (height <= 0) {
            return;
        }
        Minecraft mc = Minecraft.func_71410_x();
        ClientPlayerEntity player = mc.field_71439_g;
        MatrixStack matrix = event.getMatrixStack();
        if (event.getType() == RenderGameOverlayEvent.ElementType.HOTBAR) {
            int i;
            MainWindow res = event.getWindow();
            float realHeight = this.getRealHeight(event.getPartialTicks());
            float xStart = (float)res.func_198107_o() / 2.0f - 91.0f;
            float yStart = (float)res.func_198087_p() - realHeight;
            ItemRenderer render = mc.func_175599_af();
            RenderSystem.pushMatrix();
            RenderSystem.enableBlend();
            RenderSystem.blendFunc((int)770, (int)771);
            mc.field_71446_o.func_110577_a(WIDGETS);
            for (i = 0; i < 3; ++i) {
                RenderSystem.pushMatrix();
                RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)0.75f);
                RenderSystem.translatef((float)xStart, (float)(yStart + (float)(i * 21)), (float)0.0f);
                mc.field_71456_v.func_238474_b_(matrix, 0, 0, 0, 0, 182, 22);
                RenderSystem.popMatrix();
            }
            for (i = 0; i < 3; ++i) {
                mc.field_71466_p.func_238405_a_(matrix, TextFormatting.BOLD + Integer.toString(i + 1), xStart - 9.0f, yStart + (float)(i * 21) + 7.0f, 0xFFFFFF);
            }
            RenderHelper.func_227780_a_();
            RenderSystem.translatef((float)xStart, (float)yStart, (float)0.0f);
            for (i = 0; i < 27; ++i) {
                ItemStack invStack = player.field_71071_by.func_70301_a(i + 9);
                int x = i % 9 * 20 + 3;
                int y = i / 9 * 21 + 3;
                render.func_180450_b(invStack, x, y);
                render.func_175030_a(mc.field_71466_p, invStack, x, y);
            }
            RenderHelper.func_74518_a();
            RenderSystem.popMatrix();
        }
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public void onTick(TickEvent.ClientTickEvent event) {
        ClientPlayerEntity player;
        if (event.phase == TickEvent.Phase.END && (player = Minecraft.func_71410_x().field_71439_g) != null && currentHeldItem != -1 && player.field_71071_by.field_70461_c != currentHeldItem) {
            player.field_71071_by.field_70461_c = currentHeldItem;
            currentHeldItem = -1;
        }
        if (hotbarChangeOpen && height < 90) {
            height += 9;
            animating = true;
        } else if (!hotbarChangeOpen && height > 0) {
            height -= 9;
            animating = true;
        } else {
            animating = false;
        }
    }

    private float getRealHeight(float part) {
        if (!animating) {
            return height;
        }
        return (float)height + part * 9.0f * (float)(hotbarChangeOpen ? 1 : -1);
    }

    static {
        WIDGETS = new ResourceLocation("textures/gui/widgets.png");
        height = 0;
        currentHeldItem = -1;
    }
}

