/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.management.module;

import java.util.function.BooleanSupplier;
import net.minecraft.client.settings.KeyBinding;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import vazkii.quark.base.client.InventoryButtonHandler;
import vazkii.quark.base.client.ModKeybindHandler;
import vazkii.quark.base.module.LoadModule;
import vazkii.quark.base.module.Module;
import vazkii.quark.base.module.ModuleCategory;
import vazkii.quark.base.module.config.Config;
import vazkii.quark.base.network.QuarkNetwork;
import vazkii.quark.base.network.message.SortInventoryMessage;
import vazkii.quark.management.client.gui.MiniInventoryButton;

@LoadModule(category=ModuleCategory.MANAGEMENT)
public class InventorySortingModule
extends Module {
    @Config
    public static boolean enablePlayerInventory = true;
    @Config
    public static boolean enablePlayerInventoryInChests = true;
    @Config
    public static boolean enableChests = true;

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void clientSetup() {
        KeyBinding sortPlayer = ModKeybindHandler.init("sort_player", null, "quark.gui.keygroup.inv");
        InventoryButtonHandler.addButtonProvider((Module)this, InventoryButtonHandler.ButtonTargetType.PLAYER_INVENTORY, 0, sortPlayer, screen -> {
            if (enablePlayerInventory) {
                QuarkNetwork.sendToServer(new SortInventoryMessage(true));
            }
        }, this.provider("sort", true, () -> enablePlayerInventory));
        InventoryButtonHandler.addButtonProvider((Module)this, InventoryButtonHandler.ButtonTargetType.CONTAINER_PLAYER_INVENTORY, 0, sortPlayer, screen -> {
            if (enablePlayerInventoryInChests) {
                QuarkNetwork.sendToServer(new SortInventoryMessage(true));
            }
        }, this.provider("sort_inventory", true, () -> enablePlayerInventoryInChests));
        InventoryButtonHandler.addButtonProvider((Module)this, InventoryButtonHandler.ButtonTargetType.CONTAINER_INVENTORY, 0, "sort_container", screen -> {
            if (enableChests) {
                QuarkNetwork.sendToServer(new SortInventoryMessage(false));
            }
        }, this.provider("sort_container", false, () -> enableChests));
    }

    @OnlyIn(value=Dist.CLIENT)
    private InventoryButtonHandler.ButtonProvider provider(String tooltip, boolean forcePlayer, BooleanSupplier condition) {
        return (parent, x, y) -> !condition.getAsBoolean() ? null : new MiniInventoryButton(parent, 0, x, y, "quark.gui.button." + tooltip, b -> QuarkNetwork.sendToServer(new SortInventoryMessage(forcePlayer)));
    }
}

