/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.mobs.entity;

import com.google.common.collect.Lists;
import java.time.DayOfWeek;
import java.time.LocalDate;
import java.util.Calendar;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Blocks;
import net.minecraft.block.SoundType;
import net.minecraft.entity.AgeableEntity;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.controller.JumpController;
import net.minecraft.entity.ai.controller.MovementController;
import net.minecraft.entity.ai.goal.BreedGoal;
import net.minecraft.entity.ai.goal.FollowParentGoal;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.PanicGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.ai.goal.WaterAvoidingRandomWalkingGoal;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.PacketBuffer;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.pathfinding.Path;
import net.minecraft.tags.ITag;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.common.IForgeShearable;
import net.minecraftforge.fml.common.registry.IEntityAdditionalSpawnData;
import net.minecraftforge.fml.network.NetworkHooks;
import vazkii.quark.base.handler.MiscUtil;
import vazkii.quark.base.handler.QuarkSounds;
import vazkii.quark.base.proxy.CommonProxy;
import vazkii.quark.mobs.ai.FavorBlockGoal;
import vazkii.quark.mobs.ai.PassivePassengerGoal;
import vazkii.quark.mobs.ai.TemptGoalButNice;
import vazkii.quark.mobs.module.FrogsModule;

public class FrogEntity
extends AnimalEntity
implements IEntityAdditionalSpawnData,
IForgeShearable {
    public static final ResourceLocation FROG_LOOT_TABLE = new ResourceLocation("quark", "entities/frog");
    private static final DataParameter<Integer> TALK_TIME = EntityDataManager.func_187226_a(FrogEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Float> SIZE_MODIFIER = EntityDataManager.func_187226_a(FrogEntity.class, (IDataSerializer)DataSerializers.field_187193_c);
    private static final DataParameter<Boolean> HAS_SWEATER = EntityDataManager.func_187226_a(FrogEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> VOID = EntityDataManager.func_187226_a(FrogEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final UUID VOID_MODIFIER_UUID = UUID.fromString("212dbecc-7525-4137-a74b-361cc128d24f");
    public int spawnCd = -1;
    public int spawnChain = 30;
    public boolean isDuplicate = false;
    private boolean sweatered = false;
    private Ingredient[] temptationItems;
    private int droppedLegs = -1;
    private int jumpTicks;
    private int jumpDuration;
    private boolean wasOnGround;
    private int currentMoveTypeDuration;

    public FrogEntity(EntityType<? extends FrogEntity> type, World worldIn) {
        this(type, worldIn, 1.0f);
    }

    public FrogEntity(EntityType<? extends FrogEntity> type, World worldIn, float sizeModifier) {
        super(type, worldIn);
        if (sizeModifier != 1.0f) {
            this.field_70180_af.func_187227_b(SIZE_MODIFIER, (Object)Float.valueOf(sizeModifier));
        }
        this.field_70767_i = new FrogJumpController();
        this.field_70765_h = new FrogMoveController();
        this.setMovementSpeed(0.0);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(TALK_TIME, (Object)0);
        this.field_70180_af.func_187214_a(SIZE_MODIFIER, (Object)Float.valueOf(1.0f));
        this.field_70180_af.func_187214_a(HAS_SWEATER, (Object)false);
        this.field_70180_af.func_187214_a(VOID, (Object)false);
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (Goal)new PassivePassengerGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(1, (Goal)new SwimGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(2, (Goal)new FrogPanicGoal(1.25));
        this.field_70714_bg.func_75776_a(3, (Goal)new BreedGoal((AnimalEntity)this, 1.0));
        this.field_70714_bg.func_75776_a(4, (Goal)new TemptGoalButNice((CreatureEntity)this, 1.2, false, this.getTemptationItems(false), this.getTemptationItems(true)));
        this.field_70714_bg.func_75776_a(5, (Goal)new FollowParentGoal((AnimalEntity)this, 1.1));
        this.field_70714_bg.func_75776_a(6, (Goal)new FavorBlockGoal((CreatureEntity)this, 1.0, Blocks.field_196651_dG));
        this.field_70714_bg.func_75776_a(7, (Goal)new WaterAvoidingRandomWalkingGoal((CreatureEntity)this, 1.0, 0.5f));
        this.field_70714_bg.func_75776_a(8, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 6.0f));
        this.field_70714_bg.func_75776_a(9, (Goal)new LookRandomlyGoal((MobEntity)this));
    }

    public static AttributeModifierMap.MutableAttribute prepareAttributes() {
        return MobEntity.func_233666_p_().func_233815_a_(Attributes.field_233818_a_, 10.0).func_233815_a_(Attributes.field_233821_d_, 0.25).func_233814_a_((Attribute)ForgeMod.ENTITY_GRAVITY.get());
    }

    @Nonnull
    public MovementController func_70605_aq() {
        return this.field_70765_h;
    }

    @Nonnull
    public JumpController func_70683_ar() {
        return this.field_70767_i;
    }

    public boolean func_225503_b_(float distance, float damageMultiplier) {
        return false;
    }

    protected float func_213348_b(@Nonnull Pose pose, EntitySize size) {
        return 0.2f * size.field_220316_b;
    }

    public boolean func_70094_T() {
        return MiscUtil.isEntityInsideOpaqueBlock((Entity)this);
    }

    public int getTalkTime() {
        return (Integer)this.field_70180_af.func_187225_a(TALK_TIME);
    }

    public float getSizeModifier() {
        return ((Float)this.field_70180_af.func_187225_a(SIZE_MODIFIER)).floatValue();
    }

    public static boolean canBeSweatered() {
        Calendar calendar = Calendar.getInstance();
        return calendar.get(2) + 1 == 4 && calendar.get(5) == 1;
    }

    public void func_70071_h_() {
        ITextComponent name;
        if (!this.field_70170_p.field_72995_K && !this.sweatered) {
            this.setSweater(CommonProxy.jingleTheBells && this.func_110124_au().getLeastSignificantBits() % 10L == 0L);
            this.sweatered = true;
        }
        if (this.jumpTicks != this.jumpDuration) {
            ++this.jumpTicks;
        } else if (this.jumpDuration != 0) {
            this.jumpTicks = 0;
            this.jumpDuration = 0;
            this.func_70637_d(false);
        }
        if (!this.isVoid() && this.func_145818_k_() && this.func_226278_cu_() <= 0.0 && (name = this.func_200201_e()) != null && name.func_150261_e().equals("Jack")) {
            this.setVoid(true);
        }
        super.func_70071_h_();
        int talkTime = this.getTalkTime();
        if (talkTime > 0) {
            this.field_70180_af.func_187227_b(TALK_TIME, (Object)(talkTime - 1));
        }
        if (FrogsModule.enableBigFunny && this.spawnCd > 0 && this.spawnChain > 0) {
            --this.spawnCd;
            if (this.spawnCd == 0 && !this.field_70170_p.field_72995_K) {
                float multiplier = 0.8f;
                FrogEntity newFrog = new FrogEntity(FrogsModule.frogType, this.field_70170_p);
                Vector3d pos = this.func_213303_ch();
                newFrog.func_70107_b(pos.field_72450_a, pos.field_72448_b, pos.field_72449_c);
                newFrog.func_213293_j((Math.random() - 0.5) * (double)multiplier, (Math.random() - 0.5) * (double)multiplier, (Math.random() - 0.5) * (double)multiplier);
                newFrog.isDuplicate = true;
                newFrog.spawnCd = 2;
                newFrog.spawnChain = this.spawnChain - 1;
                this.field_70170_p.func_217376_c((Entity)newFrog);
                this.spawnChain = 0;
            }
        }
        if (this.isVoid() && this.func_226278_cu_() > 320.0) {
            this.func_70076_C();
        }
        this.field_70126_B = this.field_70758_at;
        this.field_70177_z = this.field_70759_as;
    }

    protected boolean func_146066_aG() {
        return !this.isDuplicate && super.func_146066_aG();
    }

    @Nonnull
    protected ResourceLocation func_184647_J() {
        return FROG_LOOT_TABLE;
    }

    protected void func_213354_a(@Nonnull DamageSource source, boolean damagedByPlayer) {
        this.droppedLegs = 0;
        super.func_213354_a(source, damagedByPlayer);
        this.droppedLegs = -1;
    }

    @Nullable
    public ItemEntity func_70099_a(@Nonnull ItemStack stack, float offsetY) {
        if (this.droppedLegs >= 0) {
            int count = Math.max(4 - this.droppedLegs, 0);
            this.droppedLegs += stack.func_190916_E();
            if (stack.func_190916_E() > count) {
                ItemStack copy = stack.func_77946_l();
                copy.func_190918_g(count);
                copy.func_190925_c("display").func_74778_a("LocName", "item.quark.frog_maybe_leg.name");
                stack = stack.func_77946_l();
                stack.func_190918_g(copy.func_190916_E());
                super.func_70099_a(copy, offsetY);
            }
        }
        return super.func_70099_a(stack, offsetY);
    }

    @Nonnull
    public ActionResultType func_230254_b_(@Nonnull PlayerEntity player, @Nonnull Hand hand) {
        ActionResultType parent = super.func_230254_b_(player, hand);
        if (parent == ActionResultType.SUCCESS) {
            return parent;
        }
        ItemStack stack = player.func_184586_b(hand);
        LocalDate date = LocalDate.now();
        if (DayOfWeek.from(date) == DayOfWeek.WEDNESDAY && stack.func_77973_b() == Items.field_151113_aN) {
            if (!this.field_70170_p.field_72995_K && this.spawnChain > 0 && !this.isDuplicate) {
                if (FrogsModule.enableBigFunny) {
                    this.spawnCd = 50;
                    this.field_70180_af.func_187227_b(TALK_TIME, (Object)80);
                }
                Vector3d pos = this.func_213303_ch();
                this.field_70170_p.func_184148_a(null, pos.field_72450_a, pos.field_72448_b, pos.field_72449_c, QuarkSounds.ENTITY_FROG_WEDNESDAY, SoundCategory.NEUTRAL, 1.0f, 1.0f);
            }
            return ActionResultType.SUCCESS;
        }
        if (stack.func_77973_b().func_206844_a((ITag)ItemTags.field_199904_a) && !this.hasSweater()) {
            if (!this.field_70170_p.field_72995_K) {
                this.setSweater(true);
                Vector3d pos = this.func_213303_ch();
                this.field_70170_p.func_184148_a(null, pos.field_72450_a, pos.field_72448_b, pos.field_72449_c, SoundType.field_185854_g.func_185841_e(), SoundCategory.PLAYERS, 1.0f, 1.0f);
                stack.func_190918_g(1);
            }
            player.func_184609_a(hand);
            return ActionResultType.SUCCESS;
        }
        return ActionResultType.PASS;
    }

    public boolean isShearable(@Nonnull ItemStack item, World world, BlockPos pos) {
        return this.hasSweater();
    }

    @Nonnull
    public List<ItemStack> onSheared(PlayerEntity player, @Nonnull ItemStack item, World iworld, BlockPos pos, int fortune) {
        this.setSweater(false);
        Vector3d epos = this.func_213303_ch();
        this.field_70170_p.func_184148_a(null, epos.field_72450_a, epos.field_72448_b, epos.field_72449_c, SoundEvents.field_187763_eJ, SoundCategory.PLAYERS, 1.0f, 1.0f);
        return Lists.newArrayList();
    }

    @Nullable
    public AgeableEntity func_90011_a(@Nonnull AgeableEntity otherParent) {
        if (this.isDuplicate) {
            return null;
        }
        float sizeMod = this.getSizeModifier();
        if (otherParent instanceof FrogEntity) {
            if (((FrogEntity)otherParent).isDuplicate) {
                return null;
            }
            sizeMod += ((FrogEntity)otherParent).getSizeModifier();
            sizeMod /= 2.0f;
        }
        double regression = this.field_70146_Z.nextGaussian() / 20.0;
        regression *= Math.abs(((double)sizeMod + regression) / (double)sizeMod);
        return new FrogEntity(FrogsModule.frogType, this.field_70170_p, MathHelper.func_76131_a((float)(sizeMod + (float)regression), (float)0.25f, (float)2.0f));
    }

    public boolean func_70877_b(ItemStack stack) {
        LocalDate date = LocalDate.now();
        return !stack.func_190926_b() && (FrogsModule.enableBigFunny && DayOfWeek.from(date) == DayOfWeek.WEDNESDAY ? this.getTemptationItems(true) : this.getTemptationItems(false)).test(stack);
    }

    private Ingredient getTemptationItems(boolean nice) {
        if (this.temptationItems == null) {
            this.temptationItems = new Ingredient[]{Ingredient.merge((Collection)Lists.newArrayList((Object[])new Ingredient[]{Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_151070_bp}), Ingredient.func_199805_a((ITag)ItemTags.field_206964_G)})), Ingredient.merge((Collection)Lists.newArrayList((Object[])new Ingredient[]{Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_151070_bp, Items.field_151113_aN}), Ingredient.func_199805_a((ITag)ItemTags.field_206964_G)}))};
        }
        return this.temptationItems[nice ? 1 : 0];
    }

    public void func_70037_a(@Nonnull CompoundNBT compound) {
        super.func_70037_a(compound);
        this.spawnCd = compound.func_74762_e("Cooldown");
        if (compound.func_74764_b("Chain")) {
            this.spawnChain = compound.func_74762_e("Chain");
        }
        this.field_70180_af.func_187227_b(TALK_TIME, (Object)compound.func_74762_e("DudeAmount"));
        float sizeModifier = compound.func_74764_b("FrogAmount") ? compound.func_74760_g("FrogAmount") : 1.0f;
        this.field_70180_af.func_187227_b(SIZE_MODIFIER, (Object)Float.valueOf(sizeModifier));
        this.isDuplicate = compound.func_74767_n("FakeFrog");
        this.sweatered = compound.func_74767_n("SweaterComp");
        this.setSweater(compound.func_74767_n("Sweater"));
        this.setVoid(compound.func_74767_n("Jack"));
    }

    public void func_213281_b(@Nonnull CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74776_a("FrogAmount", this.getSizeModifier());
        compound.func_74768_a("Cooldown", this.spawnCd);
        compound.func_74768_a("Chain", this.spawnChain);
        compound.func_74768_a("DudeAmount", this.getTalkTime());
        compound.func_74757_a("FakeFrog", this.isDuplicate);
        compound.func_74757_a("SweaterComp", this.sweatered);
        compound.func_74757_a("Sweater", this.hasSweater());
        compound.func_74757_a("Jack", this.isVoid());
    }

    protected SoundEvent func_184639_G() {
        return QuarkSounds.ENTITY_FROG_IDLE;
    }

    protected SoundEvent func_184601_bQ(@Nonnull DamageSource damageSourceIn) {
        return QuarkSounds.ENTITY_FROG_HURT;
    }

    protected SoundEvent func_184615_bR() {
        return QuarkSounds.ENTITY_FROG_DIE;
    }

    protected SoundEvent getJumpSound() {
        return QuarkSounds.ENTITY_FROG_JUMP;
    }

    public boolean hasSweater() {
        return (Boolean)this.field_70180_af.func_187225_a(HAS_SWEATER);
    }

    public void setSweater(boolean sweater) {
        this.field_70180_af.func_187227_b(HAS_SWEATER, (Object)sweater);
    }

    public boolean isVoid() {
        return (Boolean)this.field_70180_af.func_187225_a(VOID);
    }

    protected float func_175134_bD() {
        float motion = super.func_175134_bD();
        if (this.isVoid()) {
            return -motion;
        }
        return motion;
    }

    public void setVoid(boolean jack) {
        if (jack && this.func_110148_a((Attribute)ForgeMod.ENTITY_GRAVITY.get()).func_111127_a(VOID_MODIFIER_UUID) == null) {
            this.func_110148_a((Attribute)ForgeMod.ENTITY_GRAVITY.get()).func_233769_c_(new AttributeModifier(VOID_MODIFIER_UUID, "Void gravity", -2.0, AttributeModifier.Operation.MULTIPLY_BASE));
        } else {
            this.func_110148_a((Attribute)ForgeMod.ENTITY_GRAVITY.get()).func_233770_c_(VOID_MODIFIER_UUID);
        }
        this.field_70180_af.func_187227_b(VOID, (Object)jack);
    }

    public void func_70619_bc() {
        if (this.currentMoveTypeDuration > 0) {
            --this.currentMoveTypeDuration;
        }
        if (this.field_70122_E) {
            FrogJumpController jumpHelper;
            if (!this.wasOnGround) {
                this.func_70637_d(false);
                this.checkLandingDelay();
            }
            if (!(jumpHelper = (FrogJumpController)this.field_70767_i).getIsJumping()) {
                if (this.field_70765_h.func_75640_a() && this.currentMoveTypeDuration == 0) {
                    Path path = this.field_70699_by.func_75505_d();
                    Vector3d Vector3d2 = new Vector3d(this.field_70765_h.func_179917_d(), this.field_70765_h.func_179919_e(), this.field_70765_h.func_179918_f());
                    if (path != null && path.func_75873_e() < path.func_75874_d()) {
                        Vector3d2 = path.func_75878_a((Entity)this);
                    }
                    this.calculateRotationYaw(Vector3d2.field_72450_a, Vector3d2.field_72449_c);
                    this.startJumping();
                }
            } else if (!jumpHelper.canJump()) {
                this.enableJumpControl();
            }
        }
        this.wasOnGround = this.field_70122_E;
    }

    public boolean func_230269_aK_() {
        return false;
    }

    private void calculateRotationYaw(double x, double z) {
        Vector3d pos = this.func_213303_ch();
        this.field_70177_z = (float)(MathHelper.func_181159_b((double)(z - pos.field_72449_c), (double)(x - pos.field_72450_a)) * 57.29577951308232) - 90.0f;
    }

    private void enableJumpControl() {
        ((FrogJumpController)this.field_70767_i).setCanJump(true);
    }

    private void disableJumpControl() {
        ((FrogJumpController)this.field_70767_i).setCanJump(false);
    }

    private void updateMoveTypeDuration() {
        this.currentMoveTypeDuration = this.field_70765_h.func_75638_b() < 2.2 ? 10 : 1;
    }

    private void checkLandingDelay() {
        this.updateMoveTypeDuration();
        this.disableJumpControl();
    }

    public void func_184206_a(@Nonnull DataParameter<?> parameter) {
        if (parameter.equals(SIZE_MODIFIER)) {
            this.func_213323_x_();
        }
        super.func_184206_a(parameter);
    }

    protected void func_70664_aZ() {
        super.func_70664_aZ();
        double d0 = this.field_70765_h.func_75638_b();
        if (d0 > 0.0) {
            Vector3d motion = this.func_213322_ci();
            double d1 = motion.field_72450_a * motion.field_72450_a + motion.field_72449_c * motion.field_72449_c;
            if (d1 < 0.01) {
                this.func_213309_a(0.1f, new Vector3d(0.0, 0.0, 1.0));
            }
        }
        if (!this.field_70170_p.field_72995_K) {
            this.field_70170_p.func_72960_a((Entity)this, (byte)1);
        }
    }

    public void setMovementSpeed(double newSpeed) {
        this.func_70661_as().func_75489_a(newSpeed);
        this.field_70765_h.func_75642_a(this.field_70765_h.func_179917_d(), this.field_70765_h.func_179919_e(), this.field_70765_h.func_179918_f(), newSpeed);
    }

    public void func_70637_d(boolean jumping) {
        super.func_70637_d(jumping);
        if (jumping) {
            this.func_184185_a(this.getJumpSound(), this.func_70599_aP(), ((this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.2f + 1.0f) * 0.8f);
        }
    }

    public void startJumping() {
        this.func_70637_d(true);
        this.jumpDuration = 10;
        this.jumpTicks = 0;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_70103_a(byte id) {
        if (id == 1) {
            this.jumpDuration = 10;
            this.jumpTicks = 0;
        } else {
            super.func_70103_a(id);
        }
    }

    @Nonnull
    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public void writeSpawnData(PacketBuffer buffer) {
        buffer.writeFloat(this.getSizeModifier());
    }

    public void readSpawnData(PacketBuffer buffer) {
        this.field_70180_af.func_187227_b(SIZE_MODIFIER, (Object)Float.valueOf(buffer.readFloat()));
    }

    public class FrogPanicGoal
    extends PanicGoal {
        public FrogPanicGoal(double speedIn) {
            super((CreatureEntity)FrogEntity.this, speedIn);
        }

        public void func_75246_d() {
            super.func_75246_d();
            FrogEntity.this.setMovementSpeed(this.field_75265_b);
        }
    }

    public class FrogMoveController
    extends MovementController {
        private double nextJumpSpeed;

        public FrogMoveController() {
            super((MobEntity)FrogEntity.this);
        }

        public void func_75641_c() {
            if (FrogEntity.this.field_70122_E && !FrogEntity.this.field_70703_bu && !((FrogJumpController)FrogEntity.this.field_70767_i).getIsJumping()) {
                FrogEntity.this.setMovementSpeed(0.0);
            } else if (this.func_75640_a()) {
                FrogEntity.this.setMovementSpeed(this.nextJumpSpeed);
            }
            super.func_75641_c();
        }

        public void func_75642_a(double x, double y, double z, double speedIn) {
            if (FrogEntity.this.func_70090_H()) {
                speedIn = 1.5;
            }
            super.func_75642_a(x, y, z, speedIn);
            if (speedIn > 0.0) {
                this.nextJumpSpeed = speedIn;
            }
        }
    }

    public class FrogJumpController
    extends JumpController {
        private boolean canJump;

        public FrogJumpController() {
            super((MobEntity)FrogEntity.this);
        }

        public boolean getIsJumping() {
            return this.field_75662_b;
        }

        public boolean canJump() {
            return this.canJump;
        }

        public void setCanJump(boolean canJumpIn) {
            this.canJump = canJumpIn;
        }

        public void func_75661_b() {
            if (this.field_75662_b) {
                FrogEntity.this.startJumping();
                this.field_75662_b = false;
            }
        }
    }
}

