/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.oddities.client.render;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.Iterator;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.ItemRenderer;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Direction;
import net.minecraft.util.math.vector.Vector3f;
import vazkii.quark.oddities.tile.PipeTileEntity;

public class PipeTileEntityRenderer
extends TileEntityRenderer<PipeTileEntity> {
    private Random random = new Random();

    public PipeTileEntityRenderer(TileEntityRendererDispatcher p_i226006_1_) {
        super(p_i226006_1_);
    }

    public void render(PipeTileEntity te, float pticks, MatrixStack matrix, IRenderTypeBuffer buffer, int light, int overlay) {
        matrix.func_227860_a_();
        matrix.func_227861_a_(0.5, 0.5, 0.5);
        ItemRenderer render = Minecraft.func_71410_x().func_175599_af();
        Iterator<PipeTileEntity.PipeItem> items = te.getItemIterator();
        while (items.hasNext()) {
            this.renderItem(items.next(), render, matrix, buffer, pticks, light, overlay);
        }
        matrix.func_227865_b_();
    }

    private void renderItem(PipeTileEntity.PipeItem item, ItemRenderer render, MatrixStack matrix, IRenderTypeBuffer buffer, float partial, int light, int overlay) {
        matrix.func_227860_a_();
        float scale = 0.4f;
        float fract = item.getTimeFract(partial);
        float shiftFract = fract - 0.5f;
        Direction face = item.outgoingFace;
        if ((double)fract < 0.5) {
            face = item.incomingFace.func_176734_d();
        }
        float offX = (float)face.func_82601_c() * 1.0f;
        float offY = (float)face.func_96559_d() * 1.0f;
        float offZ = (float)face.func_82599_e() * 1.0f;
        matrix.func_227861_a_((double)(offX * shiftFract), (double)(offY * shiftFract), (double)(offZ * shiftFract));
        matrix.func_227862_a_(scale, scale, scale);
        float speed = 4.0f;
        matrix.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(((float)item.timeInWorld + partial) * speed));
        int seed = item.stack.func_190926_b() ? 187 : Item.func_150891_b((Item)item.stack.func_77973_b());
        this.random.setSeed(seed);
        int count = this.getModelCount(item.stack);
        for (int i = 0; i < count; ++i) {
            matrix.func_227860_a_();
            if (i > 0) {
                float spread = 0.15f;
                float x = (this.random.nextFloat() * 2.0f - 1.0f) * spread;
                float y = (this.random.nextFloat() * 2.0f - 1.0f) * spread;
                float z = (this.random.nextFloat() * 2.0f - 1.0f) * spread;
                matrix.func_227861_a_((double)x, (double)y, (double)z);
            }
            render.func_229110_a_(item.stack, ItemCameraTransforms.TransformType.FIXED, light, overlay, matrix, buffer);
            matrix.func_227865_b_();
        }
        matrix.func_227865_b_();
    }

    protected int getModelCount(ItemStack stack) {
        if (stack.func_190916_E() > 48) {
            return 5;
        }
        if (stack.func_190916_E() > 32) {
            return 4;
        }
        if (stack.func_190916_E() > 16) {
            return 3;
        }
        if (stack.func_190916_E() > 1) {
            return 2;
        }
        return 1;
    }
}

