/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.oddities.render;

import com.mojang.blaze3d.matrix.MatrixStack;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.Atlases;
import net.minecraft.client.renderer.BlockRendererDispatcher;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.renderer.model.ModelManager;
import net.minecraft.client.renderer.texture.AtlasTexture;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.entity.Entity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import vazkii.arl.util.ClientTicker;
import vazkii.quark.oddities.entity.TotemOfHoldingEntity;
import vazkii.quark.oddities.module.TotemOfHoldingModule;

@OnlyIn(value=Dist.CLIENT)
public class TotemOfHoldingRenderer
extends EntityRenderer<TotemOfHoldingEntity> {
    public TotemOfHoldingRenderer(EntityRendererManager manager) {
        super(manager);
    }

    public void render(TotemOfHoldingEntity entity, float entityYaw, float partialTicks, @Nonnull MatrixStack matrixStackIn, @Nonnull IRenderTypeBuffer bufferIn, int packedLightIn) {
        int deathTicks = entity.getDeathTicks();
        boolean dying = entity.isDying();
        float time = (float)ClientTicker.ticksInGame + partialTicks;
        float scale = !dying ? 1.0f : Math.max(0.0f, 40.0f - ((float)deathTicks + partialTicks)) / 40.0f;
        float rotation = time + (!dying ? 0.0f : ((float)deathTicks + partialTicks) * 5.0f);
        double translation = !dying ? Math.sin((double)time * 0.03) * 0.1 : (double)(((float)deathTicks + partialTicks) / 40.0f * 5.0f);
        Minecraft mc = Minecraft.func_71410_x();
        BlockRendererDispatcher dispatcher = mc.func_175602_ab();
        ModelManager modelManager = mc.func_209506_al();
        matrixStackIn.func_227860_a_();
        matrixStackIn.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(rotation));
        matrixStackIn.func_227861_a_(0.0, translation, 0.0);
        matrixStackIn.func_227862_a_(scale, scale, scale);
        matrixStackIn.func_227861_a_(-0.5, 0.0, -0.5);
        dispatcher.func_175019_b().func_228804_a_(matrixStackIn.func_227866_c_(), bufferIn.getBuffer(Atlases.func_228783_h_()), null, modelManager.func_174953_a(TotemOfHoldingModule.MODEL_LOC), 1.0f, 1.0f, 1.0f, packedLightIn, OverlayTexture.field_229196_a_);
        matrixStackIn.func_227865_b_();
        super.func_225623_a_((Entity)entity, entityYaw, partialTicks, matrixStackIn, bufferIn, packedLightIn);
    }

    protected int getBlockLight(TotemOfHoldingEntity entityIn, BlockPos position) {
        return 15;
    }

    protected boolean canRenderName(TotemOfHoldingEntity entity) {
        if (entity.func_145818_k_()) {
            Minecraft mc = Minecraft.func_71410_x();
            return !mc.field_71474_y.field_74319_N && mc.field_71476_x != null && mc.field_71476_x.func_216346_c() == RayTraceResult.Type.ENTITY && ((EntityRayTraceResult)mc.field_71476_x).hitInfo == entity;
        }
        return false;
    }

    @Nonnull
    public ResourceLocation getEntityTexture(@Nonnull TotemOfHoldingEntity entity) {
        return AtlasTexture.field_110575_b;
    }
}

