/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.tools.item;

import javax.annotation.Nonnull;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.monster.SlimeEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SharedSeedRandom;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import vazkii.arl.util.ItemNBTHelper;
import vazkii.quark.base.item.QuarkItem;
import vazkii.quark.base.module.Module;

public class SlimeInABucketItem
extends QuarkItem {
    public static final String TAG_ENTITY_DATA = "slime_nbt";
    public static final String TAG_EXCITED = "excited";

    public SlimeInABucketItem(Module module) {
        super("slime_in_a_bucket", module, new Item.Properties().func_200917_a(1).func_200916_a(ItemGroup.field_78026_f).func_200919_a(Items.field_151133_ar));
    }

    public void func_77663_a(ItemStack stack, World world, Entity entity, int itemSlot, boolean isSelected) {
        if (world instanceof ServerWorld) {
            Vector3d pos = entity.func_213303_ch();
            int x = MathHelper.func_76128_c((double)pos.field_72450_a);
            int z = MathHelper.func_76128_c((double)pos.field_72449_c);
            boolean slime = SlimeInABucketItem.isSlimeChunk((ServerWorld)world, x, z);
            boolean excited = ItemNBTHelper.getBoolean((ItemStack)stack, (String)TAG_EXCITED, (boolean)false);
            if (excited != slime) {
                ItemNBTHelper.setBoolean((ItemStack)stack, (String)TAG_EXCITED, (boolean)slime);
            }
        }
    }

    @Nonnull
    public ActionResultType func_195939_a(ItemUseContext context) {
        BlockPos pos = context.func_195995_a();
        Direction facing = context.func_196000_l();
        World worldIn = context.func_195991_k();
        PlayerEntity playerIn = context.func_195999_j();
        Hand hand = context.func_221531_n();
        double x = (double)pos.func_177958_n() + 0.5 + (double)facing.func_82601_c();
        double y = (double)pos.func_177956_o() + 0.5 + (double)facing.func_96559_d();
        double z = (double)pos.func_177952_p() + 0.5 + (double)facing.func_82599_e();
        if (!worldIn.field_72995_K) {
            SlimeEntity slime = new SlimeEntity(EntityType.field_200743_ai, worldIn);
            CompoundNBT data = ItemNBTHelper.getCompound((ItemStack)playerIn.func_184586_b(hand), (String)TAG_ENTITY_DATA, (boolean)true);
            if (data != null) {
                slime.func_70020_e(data);
            } else {
                slime.func_110148_a(Attributes.field_233818_a_).func_111128_a(1.0);
                slime.func_110148_a(Attributes.field_233821_d_).func_111128_a(0.3);
                slime.func_70606_j(slime.func_110138_aP());
            }
            slime.func_70107_b(x, y, z);
            worldIn.func_217376_c((Entity)slime);
            playerIn.func_184609_a(hand);
        }
        if (!playerIn.func_184812_l_()) {
            playerIn.func_184611_a(hand, new ItemStack((IItemProvider)Items.field_151133_ar));
        }
        return ActionResultType.SUCCESS;
    }

    @Nonnull
    public ITextComponent func_200295_i(@Nonnull ItemStack stack) {
        CompoundNBT cmp;
        if (stack.func_77942_o() && (cmp = ItemNBTHelper.getCompound((ItemStack)stack, (String)TAG_ENTITY_DATA, (boolean)false)) != null && cmp.func_74764_b("CustomName")) {
            IFormattableTextComponent custom = ITextComponent.Serializer.func_240643_a_((String)cmp.func_74779_i("CustomName"));
            return new TranslationTextComponent("item.quark.slime_in_a_bucket.named", new Object[]{custom});
        }
        return super.func_200295_i(stack);
    }

    public static boolean isSlimeChunk(ServerWorld world, int x, int z) {
        ChunkPos chunkpos = new ChunkPos(new BlockPos(x, 0, z));
        return SharedSeedRandom.func_205190_a((int)chunkpos.field_77276_a, (int)chunkpos.field_77275_b, (long)world.func_72905_C(), (long)987234911L).nextInt(10) == 0;
    }
}

