/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.tools.module;

import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentData;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.item.EnchantedBookItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.loot.ILootSerializer;
import net.minecraft.loot.ItemLootEntry;
import net.minecraft.loot.LootEntry;
import net.minecraft.loot.LootFunctionType;
import net.minecraft.loot.LootTables;
import net.minecraft.loot.conditions.ILootCondition;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraftforge.event.AnvilUpdateEvent;
import net.minecraftforge.event.LootTableLoadEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.registries.ForgeRegistries;
import vazkii.quark.base.handler.MiscUtil;
import vazkii.quark.base.module.LoadModule;
import vazkii.quark.base.module.Module;
import vazkii.quark.base.module.ModuleCategory;
import vazkii.quark.base.module.config.Config;
import vazkii.quark.tools.item.AncientTomeItem;
import vazkii.quark.tools.loot.EnchantTome;
import vazkii.quark.world.module.MonsterBoxModule;

@LoadModule(category=ModuleCategory.TOOLS, hasSubscriptions=true)
public class AncientTomesModule
extends Module {
    @Config
    public static int dungeonWeight = 20;
    @Config
    public static int libraryWeight = 30;
    @Config
    public static int monsterBoxWeight = 5;
    @Config
    public static int itemQuality = 2;
    @Config
    public static int mergeCost = 35;
    @Config
    public static int applyCost = 35;
    public static LootFunctionType tomeEnchantType;
    @Config(name="Valid Enchantments")
    public static List<String> enchantNames;
    public static Item ancient_tome;
    public static final List<Enchantment> validEnchants;
    private static boolean initialized;

    @SubscribeEvent
    public void onLootTableLoad(LootTableLoadEvent event) {
        int weight = 0;
        if (event.getName().equals((Object)LootTables.field_186426_h)) {
            weight = libraryWeight;
        } else if (event.getName().equals((Object)LootTables.field_186422_d)) {
            weight = dungeonWeight;
        } else if (event.getName().equals((Object)MonsterBoxModule.MONSTER_BOX_LOOT_TABLE)) {
            weight = monsterBoxWeight;
        }
        if (weight > 0) {
            LootEntry entry = ItemLootEntry.func_216168_a((IItemProvider)ancient_tome).func_216086_a(weight).func_216085_b(itemQuality).func_212841_b_(() -> new EnchantTome(new ILootCondition[0])).func_216081_b();
            MiscUtil.addToLootTable(event.getTable(), entry);
        }
    }

    @Override
    public void construct() {
        ancient_tome = new AncientTomeItem(this);
        tomeEnchantType = new LootFunctionType((ILootSerializer)new EnchantTome.Serializer());
        Registry.func_218322_a((Registry)Registry.field_239694_aZ_, (ResourceLocation)new ResourceLocation("quark", "tome_enchant"), (Object)tomeEnchantType);
    }

    @Override
    public void setup() {
        this.setupEnchantList();
        initialized = true;
    }

    @SubscribeEvent
    public void onAnvilUpdate(AnvilUpdateEvent event) {
        ItemStack left = event.getLeft();
        ItemStack right = event.getRight();
        if (!left.func_190926_b() && !right.func_190926_b()) {
            if (left.func_77973_b() == Items.field_151134_bR && right.func_77973_b() == ancient_tome) {
                this.handleTome(left, right, event);
            } else if (right.func_77973_b() == Items.field_151134_bR && left.func_77973_b() == ancient_tome) {
                this.handleTome(right, left, event);
            } else if (right.func_77973_b() == Items.field_151134_bR) {
                Map enchants = EnchantmentHelper.func_82781_a((ItemStack)right);
                Map currentEnchants = EnchantmentHelper.func_82781_a((ItemStack)left);
                boolean hasOverLevel = false;
                boolean hasMatching = false;
                for (Map.Entry entry : enchants.entrySet()) {
                    Enchantment enchantment = (Enchantment)entry.getKey();
                    if (enchantment == null) continue;
                    int level = (Integer)entry.getValue();
                    if (level > enchantment.func_77325_b()) {
                        hasOverLevel = true;
                        if (!enchantment.func_92089_a(left)) continue;
                        hasMatching = true;
                        Iterator iterator = currentEnchants.keySet().iterator();
                        while (iterator.hasNext()) {
                            Enchantment comparingEnchantment = (Enchantment)iterator.next();
                            if (comparingEnchantment == enchantment || comparingEnchantment.func_191560_c(enchantment)) continue;
                            iterator.remove();
                        }
                        currentEnchants.put(enchantment, level);
                        continue;
                    }
                    if (!enchantment.func_92089_a(left)) continue;
                    boolean compatible = true;
                    for (Enchantment comparingEnchantment : currentEnchants.keySet()) {
                        if (comparingEnchantment == enchantment || comparingEnchantment == null || comparingEnchantment.func_191560_c(enchantment)) continue;
                        compatible = false;
                        break;
                    }
                    if (!compatible) continue;
                    currentEnchants.put(enchantment, level);
                }
                if (hasOverLevel) {
                    if (hasMatching) {
                        ItemStack out = left.func_77946_l();
                        EnchantmentHelper.func_82782_a((Map)currentEnchants, (ItemStack)out);
                        String name = event.getName();
                        int cost = applyCost;
                        if (name != null && !name.isEmpty()) {
                            out.func_200302_a((ITextComponent)new StringTextComponent(name));
                            ++cost;
                        }
                        event.setOutput(out);
                        event.setCost(cost);
                    } else {
                        event.setCanceled(true);
                    }
                }
            }
        }
    }

    private void handleTome(ItemStack book, ItemStack tome, AnvilUpdateEvent event) {
        Map enchantsBook = EnchantmentHelper.func_82781_a((ItemStack)book);
        Map<Enchantment, Integer> enchantsTome = AncientTomesModule.getTomeEnchantments(tome);
        if (enchantsTome == null) {
            return;
        }
        for (Map.Entry<Enchantment, Integer> entry : enchantsTome.entrySet()) {
            if (enchantsBook.getOrDefault(entry.getKey(), 0).equals(entry.getValue())) {
                enchantsBook.put(entry.getKey(), Math.min(entry.getValue(), entry.getKey().func_77325_b()) + 1);
                continue;
            }
            return;
        }
        ItemStack output = new ItemStack((IItemProvider)Items.field_151134_bR);
        for (Map.Entry entry : enchantsBook.entrySet()) {
            EnchantedBookItem.func_92115_a((ItemStack)output, (EnchantmentData)new EnchantmentData((Enchantment)entry.getKey(), ((Integer)entry.getValue()).intValue()));
        }
        event.setOutput(output);
        event.setCost(mergeCost);
    }

    private static List<String> generateDefaultEnchantmentList() {
        Enchantment[] enchants = new Enchantment[]{Enchantments.field_180309_e, Enchantments.field_92091_k, Enchantments.field_185302_k, Enchantments.field_185303_l, Enchantments.field_180312_n, Enchantments.field_180313_o, Enchantments.field_77334_n, Enchantments.field_185304_p, Enchantments.field_191530_r, Enchantments.field_185305_q, Enchantments.field_185307_s, Enchantments.field_185308_t, Enchantments.field_185309_u, Enchantments.field_185310_v, Enchantments.field_151370_z, Enchantments.field_151369_A, Enchantments.field_203193_C, Enchantments.field_203195_E, Enchantments.field_203194_D, Enchantments.field_222194_I};
        ArrayList<String> strings = new ArrayList<String>();
        for (Enchantment e : enchants) {
            if (e == null || e.getRegistryName() == null) continue;
            strings.add(e.getRegistryName().toString());
        }
        return strings;
    }

    @Override
    public void configChanged() {
        if (initialized) {
            this.setupEnchantList();
        }
    }

    private void setupEnchantList() {
        MiscUtil.initializeEnchantmentList(enchantNames, validEnchants);
        validEnchants.removeIf(ench -> ench.func_77325_b() == 1);
    }

    public static Map<Enchantment, Integer> getTomeEnchantments(ItemStack stack) {
        if (stack.func_77973_b() != ancient_tome) {
            return null;
        }
        LinkedHashMap map = Maps.newLinkedHashMap();
        ListNBT listnbt = EnchantedBookItem.func_92110_g((ItemStack)stack);
        for (int i = 0; i < listnbt.size(); ++i) {
            CompoundNBT compoundnbt = listnbt.func_150305_b(i);
            Enchantment e = (Enchantment)ForgeRegistries.ENCHANTMENTS.getValue(ResourceLocation.func_208304_a((String)compoundnbt.func_74779_i("id")));
            map.put(e, compoundnbt.func_74762_e("lvl"));
        }
        return map;
    }

    static {
        enchantNames = AncientTomesModule.generateDefaultEnchantmentList();
        validEnchants = new ArrayList<Enchantment>();
        initialized = false;
    }
}

