/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.tools.module;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import java.io.File;
import java.sql.Date;
import java.text.SimpleDateFormat;
import net.minecraft.client.MainWindow;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.SimpleSound;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.client.shader.Framebuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.ScreenShotHelper;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.text.KeybindTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.client.event.ScreenshotEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import vazkii.quark.base.client.ModKeybindHandler;
import vazkii.quark.base.handler.QuarkSounds;
import vazkii.quark.base.module.LoadModule;
import vazkii.quark.base.module.Module;
import vazkii.quark.base.module.ModuleCategory;

@LoadModule(category=ModuleCategory.TOOLS, hasSubscriptions=true, subscribeOn={Dist.CLIENT})
public class CameraModule
extends Module {
    private static final int RULER_COLOR = 0x33000000;
    private static final int RULERS = 4;
    private static final int BORERS = 6;
    private static final int OVERLAYS = 5;
    private static final ResourceLocation[] SHADERS = new ResourceLocation[]{null, new ResourceLocation("quark", "shaders/post/grayscale.json"), new ResourceLocation("quark", "shaders/post/sepia.json"), new ResourceLocation("quark", "shaders/post/desaturate.json"), new ResourceLocation("quark", "shaders/post/oversaturate.json"), new ResourceLocation("quark", "shaders/post/cool.json"), new ResourceLocation("quark", "shaders/post/warm.json"), new ResourceLocation("quark", "shaders/post/conjugate.json"), new ResourceLocation("quark", "shaders/post/redfocus.json"), new ResourceLocation("quark", "shaders/post/greenfocus.json"), new ResourceLocation("quark", "shaders/post/bluefocus.json"), new ResourceLocation("quark", "shaders/post/yellowfocus.json"), new ResourceLocation("shaders/post/bumpy.json"), new ResourceLocation("shaders/post/notch.json"), new ResourceLocation("shaders/post/creeper.json"), new ResourceLocation("quark", "shaders/post/enderman.json"), new ResourceLocation("quark", "shaders/post/bits.json"), new ResourceLocation("shaders/post/blobs.json"), new ResourceLocation("shaders/post/pencil.json"), new ResourceLocation("quark", "shaders/post/watercolor.json"), new ResourceLocation("quark", "shaders/post/monochrome.json"), new ResourceLocation("shaders/post/sobel.json")};
    @OnlyIn(value=Dist.CLIENT)
    private static KeyBinding cameraModeKey;
    private static int currentHeldItem;
    private static int currShader;
    private static int currRulers;
    private static int currBorders;
    private static int currOverlay;
    private static boolean queuedRefresh;
    private static boolean queueScreenshot;
    private static boolean screenshotting;
    private static boolean cameraMode;

    @Override
    public void clientSetup() {
        cameraModeKey = ModKeybindHandler.init("camera_mode", "f12", "quark.gui.keygroup.misc");
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public void screenshotTaken(ScreenshotEvent event) {
        screenshotting = false;
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public void keystroke(InputEvent.KeyInputEvent event) {
        Minecraft mc = Minecraft.func_71410_x();
        if (mc.field_71441_e != null && event.getAction() == 1) {
            if (cameraModeKey.func_151470_d()) {
                cameraMode = !cameraMode;
                queuedRefresh = true;
                return;
            }
            if (cameraMode && mc.field_71462_r == null) {
                int key = event.getKey();
                boolean affected = false;
                boolean sneak = mc.field_71439_g.func_226273_bm_();
                switch (key) {
                    case 49: {
                        currShader = CameraModule.cycle(currShader, SHADERS.length, sneak);
                        affected = true;
                        break;
                    }
                    case 50: {
                        currRulers = CameraModule.cycle(currRulers, 4, sneak);
                        affected = true;
                        break;
                    }
                    case 51: {
                        currBorders = CameraModule.cycle(currBorders, 6, sneak);
                        affected = true;
                        break;
                    }
                    case 52: {
                        currOverlay = CameraModule.cycle(currOverlay, 5, sneak);
                        affected = true;
                        break;
                    }
                    case 53: {
                        if (!sneak) break;
                        currShader = 0;
                        currRulers = 0;
                        currBorders = 0;
                        currOverlay = 0;
                        affected = true;
                        break;
                    }
                    case 257: {
                        if (!queueScreenshot && !screenshotting) {
                            mc.func_147118_V().func_147682_a((ISound)SimpleSound.func_184371_a((SoundEvent)QuarkSounds.ITEM_CAMERA_SHUTTER, (float)1.0f));
                        }
                        queueScreenshot = true;
                    }
                }
                if (affected) {
                    queuedRefresh = true;
                    currentHeldItem = mc.field_71439_g.field_71071_by.field_70461_c;
                }
            }
        }
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public void renderTick(TickEvent.RenderTickEvent event) {
        ClientPlayerEntity player;
        Minecraft mc = Minecraft.func_71410_x();
        if (mc.field_71441_e == null) {
            cameraMode = false;
        }
        if ((player = mc.field_71439_g) != null && currentHeldItem != -1 && player.field_71071_by.field_70461_c != currentHeldItem) {
            player.field_71071_by.field_70461_c = currentHeldItem;
            currentHeldItem = -1;
        }
        if (queuedRefresh) {
            CameraModule.refreshShader();
        }
        if (event.phase == TickEvent.Phase.END && cameraMode && mc.field_71462_r == null) {
            if (queueScreenshot) {
                screenshotting = true;
            }
            MatrixStack stack = new MatrixStack();
            CameraModule.renderCameraHUD(mc, stack);
            if (queueScreenshot) {
                queueScreenshot = false;
                ScreenShotHelper.func_148260_a((File)mc.field_71412_D, (int)mc.func_228018_at_().func_198109_k(), (int)mc.func_228018_at_().func_198091_l(), (Framebuffer)mc.func_147110_a(), msg -> mc.execute(() -> mc.field_71456_v.func_146158_b().func_146227_a(msg)));
            }
        }
    }

    private static void renderCameraHUD(Minecraft mc, MatrixStack matrix) {
        MainWindow mw = mc.func_228018_at_();
        int twidth = mw.func_198107_o();
        int theight = mw.func_198087_p();
        int width = twidth;
        int height = theight;
        int paddingHoriz = 0;
        int paddingVert = 0;
        int paddingColor = -16777216;
        double targetAspect = -1.0;
        switch (currBorders) {
            case 1: {
                targetAspect = 1.0;
                break;
            }
            case 2: {
                targetAspect = 1.3333333333333333;
                break;
            }
            case 3: {
                targetAspect = 1.7777777777777777;
                break;
            }
            case 4: {
                targetAspect = 2.3333333333333335;
                break;
            }
            case 5: {
                int border;
                paddingHoriz = border = (int)(20.0 * ((double)(twidth * theight) / 518400.0));
                paddingVert = border;
                paddingColor = -1;
            }
        }
        if (targetAspect > 0.0) {
            double currAspect = (double)width / (double)height;
            if (currAspect > targetAspect) {
                int desiredWidth = (int)((double)height * targetAspect);
                paddingHoriz = (width - desiredWidth) / 2;
            } else if (currAspect < targetAspect) {
                int desiredHeight = (int)((double)width / targetAspect);
                paddingVert = (height - desiredHeight) / 2;
            }
        }
        width -= paddingHoriz * 2;
        height -= paddingVert * 2;
        if (paddingHoriz > 0) {
            Screen.func_238467_a_((MatrixStack)matrix, (int)0, (int)0, (int)paddingHoriz, (int)theight, (int)paddingColor);
            Screen.func_238467_a_((MatrixStack)matrix, (int)(twidth - paddingHoriz), (int)0, (int)twidth, (int)theight, (int)paddingColor);
        }
        if (paddingVert > 0) {
            Screen.func_238467_a_((MatrixStack)matrix, (int)0, (int)0, (int)twidth, (int)paddingVert, (int)paddingColor);
            Screen.func_238467_a_((MatrixStack)matrix, (int)0, (int)(theight - paddingVert), (int)twidth, (int)theight, (int)paddingColor);
        }
        String overlayText = "";
        boolean overlayShadow = true;
        double overlayScale = 2.0;
        int overlayColor = -1;
        int overlayX = -1;
        int overlayY = -1;
        switch (currOverlay) {
            case 1: {
                overlayText = new SimpleDateFormat("MM/dd/yyyy").format(new Date(System.currentTimeMillis()));
                overlayColor = 0xF77700;
                break;
            }
            case 2: {
                String worldName = "N/A";
                if (mc.func_71401_C() != null) {
                    worldName = mc.func_71401_C().func_213142_bd();
                } else if (mc.func_147104_D() != null) {
                    worldName = mc.func_147104_D().field_78847_a;
                }
                overlayText = I18n.func_135052_a((String)"quark.camera.greetings", (Object[])new Object[]{worldName});
                overlayX = paddingHoriz + 20;
                overlayY = paddingVert + 20;
                overlayScale = 3.0;
                overlayColor = 15684645;
                break;
            }
            case 3: {
                overlayText = mc.field_71439_g.func_146103_bH().getName();
                overlayScale = 6.0;
                overlayShadow = false;
                overlayColor = 0x44000000;
                break;
            }
            case 4: {
                overlayText = mc.field_71439_g.func_184614_ca().func_200301_q().getString();
                overlayX = twidth / 2 - mc.field_71466_p.func_78256_a(overlayText);
                overlayY = paddingVert + 40;
            }
        }
        if (overlayX == -1) {
            overlayX = twidth - paddingHoriz - mc.field_71466_p.func_78256_a(overlayText) * (int)overlayScale - 40;
        }
        if (overlayY == -1) {
            overlayY = theight - paddingVert - 10 - 10 * (int)overlayScale;
        }
        if (!overlayText.isEmpty()) {
            RenderSystem.pushMatrix();
            RenderSystem.translatef((float)overlayX, (float)overlayY, (float)0.0f);
            RenderSystem.scaled((double)overlayScale, (double)overlayScale, (double)1.0);
            if (overlayShadow) {
                mc.field_71466_p.func_238405_a_(matrix, overlayText, 0.0f, 0.0f, overlayColor);
            } else {
                mc.field_71466_p.func_238421_b_(matrix, overlayText, 0.0f, 0.0f, overlayColor);
            }
            RenderSystem.popMatrix();
        }
        if (!screenshotting) {
            RenderSystem.pushMatrix();
            RenderSystem.translatef((float)paddingHoriz, (float)paddingVert, (float)0.0f);
            switch (currRulers) {
                case 1: {
                    CameraModule.vruler(matrix, width / 3, height);
                    CameraModule.vruler(matrix, width / 3 * 2, height);
                    CameraModule.hruler(matrix, height / 3, width);
                    CameraModule.hruler(matrix, height / 3 * 2, width);
                    break;
                }
                case 2: {
                    double phi1 = 0.3831417624521073;
                    double phi2 = 0.6168582375478928;
                    CameraModule.vruler(matrix, (int)((double)width * phi1), height);
                    CameraModule.vruler(matrix, (int)((double)width * phi2), height);
                    CameraModule.hruler(matrix, (int)((double)height * phi1), width);
                    CameraModule.hruler(matrix, (int)((double)height * phi2), width);
                    break;
                }
                case 3: {
                    CameraModule.vruler(matrix, width / 2, height);
                    CameraModule.hruler(matrix, height / 2, width);
                }
            }
            RenderSystem.popMatrix();
            int left = 30;
            int top = theight - 65;
            ResourceLocation shader = SHADERS[currShader];
            String text = "none";
            if (shader != null) {
                text = shader.func_110623_a().replaceAll(".+/(.+)\\.json", "$1");
            }
            text = TextFormatting.BOLD + "[1] " + TextFormatting.RESET + I18n.func_135052_a((String)"quark.camera.filter", (Object[])new Object[0]) + TextFormatting.GOLD + I18n.func_135052_a((String)("quark.camera.filter." + text), (Object[])new Object[0]);
            mc.field_71466_p.func_238405_a_(matrix, text, (float)left, (float)top, 0xFFFFFF);
            text = TextFormatting.BOLD + "[2] " + TextFormatting.RESET + I18n.func_135052_a((String)"quark.camera.rulers", (Object[])new Object[0]) + TextFormatting.GOLD + I18n.func_135052_a((String)("quark.camera.rulers" + currRulers), (Object[])new Object[0]);
            mc.field_71466_p.func_238405_a_(matrix, text, (float)left, (float)(top + 12), 0xFFFFFF);
            text = TextFormatting.BOLD + "[3] " + TextFormatting.RESET + I18n.func_135052_a((String)"quark.camera.borders", (Object[])new Object[0]) + TextFormatting.GOLD + I18n.func_135052_a((String)("quark.camera.borders" + currBorders), (Object[])new Object[0]);
            mc.field_71466_p.func_238405_a_(matrix, text, (float)left, (float)(top + 24), 0xFFFFFF);
            text = TextFormatting.BOLD + "[4] " + TextFormatting.RESET + I18n.func_135052_a((String)"quark.camera.overlay", (Object[])new Object[0]) + TextFormatting.GOLD + I18n.func_135052_a((String)("quark.camera.overlay" + currOverlay), (Object[])new Object[0]);
            mc.field_71466_p.func_238405_a_(matrix, text, (float)left, (float)(top + 36), 0xFFFFFF);
            text = TextFormatting.BOLD + "[5] " + TextFormatting.RESET + I18n.func_135052_a((String)"quark.camera.reset", (Object[])new Object[0]);
            mc.field_71466_p.func_238405_a_(matrix, text, (float)left, (float)(top + 48), 0xFFFFFF);
            text = TextFormatting.AQUA + I18n.func_135052_a((String)"quark.camera.header", (Object[])new Object[0]);
            mc.field_71466_p.func_238405_a_(matrix, text, (float)(twidth / 2 - mc.field_71466_p.func_78256_a(text) / 2), 6.0f, 0xFFFFFF);
            text = I18n.func_135052_a((String)"quark.camera.info", (Object[])new Object[]{new KeybindTextComponent("quark.keybind.camera_mode").getString()});
            mc.field_71466_p.func_238405_a_(matrix, text, (float)(twidth / 2 - mc.field_71466_p.func_78256_a(text) / 2), 16.0f, 0xFFFFFF);
            ResourceLocation CAMERA_TEXTURE = new ResourceLocation("quark", "textures/misc/camera.png");
            mc.field_71446_o.func_110577_a(CAMERA_TEXTURE);
            Screen.func_238464_a_((MatrixStack)matrix, (int)(left - 22), (int)(top + 18), (int)0, (float)0.0f, (float)0.0f, (int)16, (int)16, (int)16, (int)16);
        }
    }

    private static void refreshShader() {
        ResourceLocation shader;
        if (queuedRefresh) {
            queuedRefresh = false;
        }
        Minecraft mc = Minecraft.func_71410_x();
        GameRenderer render = mc.field_71460_t;
        mc.field_71474_y.field_74319_N = cameraMode;
        if (cameraMode && (shader = SHADERS[currShader]) != null) {
            render.func_175069_a(shader);
            return;
        }
        render.func_175066_a(null);
    }

    private static void vruler(MatrixStack matrix, int x, int height) {
        Screen.func_238467_a_((MatrixStack)matrix, (int)x, (int)0, (int)(x + 1), (int)height, (int)0x33000000);
    }

    private static void hruler(MatrixStack matrix, int y, int width) {
        Screen.func_238467_a_((MatrixStack)matrix, (int)0, (int)y, (int)width, (int)(y + 1), (int)0x33000000);
    }

    private static int cycle(int curr, int max, boolean neg) {
        int val = curr + (neg ? -1 : 1);
        if (val < 0) {
            val = max - 1;
        } else if (val >= max) {
            val = 0;
        }
        return val;
    }

    static {
        currentHeldItem = -1;
        currShader = 0;
        currRulers = 0;
        currBorders = 0;
        currOverlay = 0;
        queuedRefresh = false;
        queueScreenshot = false;
        screenshotting = false;
    }
}

