/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.tools.module;

import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.entity.Entity;
import net.minecraft.entity.merchant.villager.VillagerProfession;
import net.minecraft.entity.merchant.villager.VillagerTrades;
import net.minecraft.item.FilledMapItem;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.MerchantOffer;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.Biomes;
import net.minecraft.world.server.ServerWorld;
import net.minecraft.world.storage.MapData;
import net.minecraft.world.storage.MapDecoration;
import net.minecraftforge.event.village.VillagerTradesEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.registries.ForgeRegistries;
import vazkii.quark.base.Quark;
import vazkii.quark.base.handler.MiscUtil;
import vazkii.quark.base.module.LoadModule;
import vazkii.quark.base.module.Module;
import vazkii.quark.base.module.ModuleCategory;
import vazkii.quark.base.module.config.Config;
import vazkii.quark.base.module.config.IConfigType;

@LoadModule(category=ModuleCategory.TOOLS, hasSubscriptions=true)
public class PathfinderMapsModule
extends Module {
    public static List<TradeInfo> builtinTrades = new LinkedList<TradeInfo>();
    public static List<TradeInfo> customTrades = new LinkedList<TradeInfo>();
    public static List<TradeInfo> tradeList = new LinkedList<TradeInfo>();
    @Config(description="In this section you can add custom Pathfinder Maps. This works for both vanilla and modded biomes.\nEach custom map must be on its own line.\nThe format for a custom map is as follows:\n<id>,<level>,<min_price>,<max_price>,<color>,<name>\n\nWith the following descriptions:\n - <id> being the biome's ID NAME. You can find vanilla names here - https://minecraft.gamepedia.com/Biome#Biome_IDs\n - <level> being the Cartographer villager level required for the map to be unlockable\n - <min_price> being the cheapest (in Emeralds) the map can be\n - <max_price> being the most expensive (in Emeralds) the map can be\n - <color> being a hex color (without the #) for the map to display. You can generate one here - http://htmlcolorcodes.com/\n - <name> being the display name of the map\n\nHere's an example of a map to locate Ice Mountains:\nminecraft:ice_mountains,2,8,14,7FE4FF,Ice Mountains Pathfinder Map")
    private List<String> customs = new LinkedList<String>();
    @Config
    public static int xpFromTrade = 5;

    private static String getBiomeDescriptor(Biome biome) {
        ResourceLocation rl = biome.getRegistryName();
        if (rl == null) {
            return "unknown";
        }
        return rl.func_110623_a();
    }

    @Override
    public void construct() {
        this.loadTradeInfo(Biomes.field_76774_n, true, 4, 8, 14, 8381695);
        this.loadTradeInfo(Biomes.field_76770_e, true, 4, 8, 14, 0x8A8A8A);
        this.loadTradeInfo(Biomes.field_150585_R, true, 4, 8, 14, 22794);
        this.loadTradeInfo(Biomes.field_76769_d, true, 4, 8, 14, 13416782);
        this.loadTradeInfo(Biomes.field_150588_X, true, 4, 8, 14, 10200418);
        this.loadTradeInfo(Biomes.field_76780_h, true, 4, 12, 18, 2242319);
        this.loadTradeInfo(Biomes.field_150578_U, true, 4, 12, 18, 5980703);
        this.loadTradeInfo(Biomes.field_185444_T, true, 5, 12, 18, 14449642);
        this.loadTradeInfo(Biomes.field_76782_w, true, 5, 16, 22, 2274816);
        this.loadTradeInfo(Biomes.field_222370_aw, true, 5, 16, 22, 4055575);
        this.loadTradeInfo(Biomes.field_150589_Z, true, 5, 16, 22, 13008674);
        this.loadTradeInfo(Biomes.field_76789_p, true, 5, 20, 26, 5063283);
        this.loadTradeInfo(Biomes.field_185445_W, true, 5, 20, 26, 4314825);
    }

    @SubscribeEvent
    public void onTradesLoaded(VillagerTradesEvent event) {
        if (event.getType() == VillagerProfession.field_221154_d) {
            Int2ObjectMap trades = event.getTrades();
            tradeList.forEach(info -> ((List)trades.get(info.level)).add(new PathfinderMapTrade((TradeInfo)info)));
        }
    }

    @Override
    public void configChanged() {
        tradeList.clear();
        customTrades.clear();
        this.loadCustomMaps(this.customs);
        tradeList.addAll(builtinTrades);
        tradeList.addAll(customTrades);
    }

    private void loadTradeInfo(Biome biome, boolean enabled, int level, int minPrice, int maxPrice, int color) {
        builtinTrades.add(new TradeInfo(biome, enabled, level, minPrice, maxPrice, color));
    }

    private void loadCustomTradeInfo(Biome biome, boolean enabled, int level, int minPrice, int maxPrice, int color, String name) {
        customTrades.add(new TradeInfo(biome, enabled, level, minPrice, maxPrice, color, name));
    }

    private void loadCustomTradeInfo(String line) throws IllegalArgumentException {
        String[] tokens = line.split(",");
        if (tokens.length != 6) {
            throw new IllegalArgumentException("Wrong number of parameters " + tokens.length + " (expected 6)");
        }
        ResourceLocation biomeName = new ResourceLocation(tokens[0]);
        if (!ForgeRegistries.BIOMES.containsKey(biomeName)) {
            throw new IllegalArgumentException("No biome exists with name " + biomeName);
        }
        Biome biome = (Biome)ForgeRegistries.BIOMES.getValue(biomeName);
        int level = Integer.parseInt(tokens[1]);
        int minPrice = Integer.parseInt(tokens[2]);
        int maxPrice = Integer.parseInt(tokens[3]);
        int color = Integer.parseInt(tokens[4], 16);
        String name = tokens[5];
        this.loadCustomTradeInfo(biome, true, level, minPrice, maxPrice, color, name);
    }

    private void loadCustomMaps(Iterable<String> lines) {
        for (String s : lines) {
            try {
                this.loadCustomTradeInfo(s);
            }
            catch (IllegalArgumentException e) {
                Quark.LOG.warn("[Custom Pathfinder Maps] Error while reading custom map string \"%s\"", (Object)s);
                Quark.LOG.warn("[Custom Pathfinder Maps] - %s", (Object)e.getMessage());
            }
        }
    }

    public static ItemStack createMap(World world, BlockPos pos, TradeInfo info) {
        if (!(world instanceof ServerWorld)) {
            return ItemStack.field_190927_a;
        }
        BlockPos biomePos = MiscUtil.locateBiome((ServerWorld)world, info.biome, pos);
        if (biomePos == null) {
            return ItemStack.field_190927_a;
        }
        ItemStack stack = FilledMapItem.func_195952_a((World)world, (int)biomePos.func_177958_n(), (int)biomePos.func_177952_p(), (byte)2, (boolean)true, (boolean)true);
        FilledMapItem.func_226642_a_((ServerWorld)((ServerWorld)world), (ItemStack)stack);
        MapData.func_191094_a((ItemStack)stack, (BlockPos)biomePos, (String)"+", (MapDecoration.Type)MapDecoration.Type.RED_X);
        stack.func_200302_a((ITextComponent)new TranslationTextComponent(info.name));
        return stack;
    }

    public static class TradeInfo
    implements IConfigType {
        public final Biome biome;
        public final int color;
        public final String name;
        @Config
        public boolean enabled;
        @Config
        public final int level;
        @Config
        public final int minPrice;
        @Config
        public final int maxPrice;

        TradeInfo(Biome biome, boolean enabled, int level, int minPrice, int maxPrice, int color) {
            this(biome, enabled, level, minPrice, maxPrice, color, "item.quark.biome_map." + PathfinderMapsModule.getBiomeDescriptor(biome));
        }

        TradeInfo(Biome biome, boolean enabled, int level, int minPrice, int maxPrice, int color, String name) {
            this.biome = biome;
            this.enabled = enabled;
            this.level = level;
            this.minPrice = minPrice;
            this.maxPrice = maxPrice;
            this.color = color;
            this.name = name;
        }
    }

    private static class PathfinderMapTrade
    implements VillagerTrades.ITrade {
        public final TradeInfo info;

        public PathfinderMapTrade(TradeInfo info) {
            this.info = info;
        }

        public MerchantOffer func_221182_a(@Nonnull Entity entity, @Nonnull Random random) {
            if (!this.info.enabled) {
                return null;
            }
            int i = random.nextInt(this.info.maxPrice - this.info.minPrice + 1) + this.info.minPrice;
            ItemStack itemstack = PathfinderMapsModule.createMap(entity.field_70170_p, entity.func_233580_cy_(), this.info);
            if (itemstack.func_190926_b()) {
                return null;
            }
            return new MerchantOffer(new ItemStack((IItemProvider)Items.field_151166_bC, i), new ItemStack((IItemProvider)Items.field_151111_aL), itemstack, 12, xpFromTrade * Math.max(1, this.info.level - 1), 0.2f);
        }
    }
}

