/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.tweaks.module;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.List;
import java.util.Objects;
import net.minecraft.block.BlockState;
import net.minecraft.client.MainWindow;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import org.apache.commons.lang3.tuple.Pair;
import vazkii.quark.base.handler.RayTraceHandler;
import vazkii.quark.base.module.LoadModule;
import vazkii.quark.base.module.Module;
import vazkii.quark.base.module.ModuleCategory;
import vazkii.quark.base.module.config.Config;

@LoadModule(category=ModuleCategory.TWEAKS, hasSubscriptions=true)
public class ReacharoundPlacingModule
extends Module {
    @Config
    @Config.Min(value=0.0)
    @Config.Max(value=1.0)
    public double leniency = 0.5;
    @Config
    public List<String> whitelist = Lists.newArrayList();
    @Config
    public String display = "[  ]";
    @Config
    public String displayHorizontal = "<  >";
    private Pair<BlockPos, Direction> currentTarget;
    private int ticksDisplayed;

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public void onRender(RenderGameOverlayEvent.Pre event) {
        if (event.getType() != RenderGameOverlayEvent.ElementType.CROSSHAIRS) {
            return;
        }
        Minecraft mc = Minecraft.func_71410_x();
        ClientPlayerEntity player = mc.field_71439_g;
        if (player != null && this.currentTarget != null) {
            MainWindow res = event.getWindow();
            MatrixStack matrix = event.getMatrixStack();
            String text = ((Direction)this.currentTarget.getRight()).func_176740_k() == Direction.Axis.Y ? this.display : this.displayHorizontal;
            RenderSystem.pushMatrix();
            RenderSystem.translatef((float)((float)res.func_198107_o() / 2.0f), (float)((float)res.func_198087_p() / 2.0f - 4.0f), (float)0.0f);
            float scale = Math.min(5.0f, (float)this.ticksDisplayed + event.getPartialTicks()) / 5.0f;
            scale *= scale;
            int opacity = (int)(255.0f * scale) << 24;
            RenderSystem.scaled((double)scale, (double)1.0, (double)1.0);
            RenderSystem.translatef((float)((float)(-mc.field_71466_p.func_78256_a(text)) / 2.0f), (float)0.0f, (float)0.0f);
            mc.field_71466_p.func_238421_b_(matrix, text, 0.0f, 0.0f, 0xFFFFFF | opacity);
            RenderSystem.popMatrix();
        }
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public void clientTick(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            this.currentTarget = null;
            ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
            if (player != null) {
                this.currentTarget = this.getPlayerReacharoundTarget((PlayerEntity)player);
            }
            if (this.currentTarget != null) {
                if (this.ticksDisplayed < 5) {
                    ++this.ticksDisplayed;
                }
            } else {
                this.ticksDisplayed = 0;
            }
        }
    }

    @SubscribeEvent
    public void onRightClick(PlayerInteractEvent.RightClickItem event) {
        ItemStack stack = event.getItemStack();
        PlayerEntity player = event.getPlayer();
        Pair<BlockPos, Direction> pair = this.getPlayerReacharoundTarget(player);
        if (pair != null) {
            BlockPos pos = (BlockPos)pair.getLeft();
            Direction dir = (Direction)pair.getRight();
            int count = stack.func_190916_E();
            Hand hand = event.getHand();
            ItemUseContext context = new ItemUseContext(player, hand, new BlockRayTraceResult(new Vector3d(0.5, 1.0, 0.5), dir, pos, false));
            ActionResultType res = stack.func_77973_b().func_195939_a(context);
            if (res != ActionResultType.PASS) {
                event.setCanceled(true);
                event.setCancellationResult(res);
                if (res == ActionResultType.SUCCESS) {
                    player.func_184609_a(hand);
                }
                if (player.func_184812_l_() && stack.func_190916_E() < count) {
                    stack.func_190920_e(count);
                }
            }
        }
    }

    private Pair<BlockPos, Direction> getPlayerReacharoundTarget(PlayerEntity player) {
        Vector3d ray;
        if (!this.validateReacharoundStack(player.func_184614_ca()) && !this.validateReacharoundStack(player.func_184592_cb())) {
            return null;
        }
        World world = player.field_70170_p;
        Pair<Vector3d, Vector3d> params = RayTraceHandler.getEntityParams((Entity)player);
        double range = RayTraceHandler.getEntityRange((LivingEntity)player);
        Vector3d rayPos = (Vector3d)params.getLeft();
        RayTraceResult normalRes = RayTraceHandler.rayTrace((Entity)player, world, rayPos, ray = ((Vector3d)params.getRight()).func_186678_a(range), RayTraceContext.BlockMode.OUTLINE, RayTraceContext.FluidMode.NONE);
        if (normalRes.func_216346_c() == RayTraceResult.Type.MISS) {
            Pair<BlockPos, Direction> target = this.getPlayerVerticalReacharoundTarget(player, world, rayPos, ray);
            if (target != null) {
                return target;
            }
            target = this.getPlayerHorizontalReacharoundTarget(player, world, rayPos, ray);
            if (target != null) {
                return target;
            }
        }
        return null;
    }

    private Pair<BlockPos, Direction> getPlayerVerticalReacharoundTarget(PlayerEntity player, World world, Vector3d rayPos, Vector3d ray) {
        if (player.field_70125_A < 0.0f) {
            return null;
        }
        RayTraceResult take2Res = RayTraceHandler.rayTrace((Entity)player, world, rayPos = rayPos.func_72441_c(0.0, this.leniency, 0.0), ray, RayTraceContext.BlockMode.OUTLINE, RayTraceContext.FluidMode.NONE);
        if (take2Res.func_216346_c() == RayTraceResult.Type.BLOCK && take2Res instanceof BlockRayTraceResult) {
            BlockPos pos = ((BlockRayTraceResult)take2Res).func_216350_a().func_177977_b();
            BlockState state = world.func_180495_p(pos);
            if (player.func_213303_ch().field_72448_b - (double)pos.func_177956_o() > 1.0 && (world.func_175623_d(pos) || state.func_185904_a().func_76222_j())) {
                return Pair.of((Object)pos, (Object)Direction.DOWN);
            }
        }
        return null;
    }

    private Pair<BlockPos, Direction> getPlayerHorizontalReacharoundTarget(PlayerEntity player, World world, Vector3d rayPos, Vector3d ray) {
        Direction dir = Direction.func_176733_a((double)player.field_70177_z);
        RayTraceResult take2Res = RayTraceHandler.rayTrace((Entity)player, world, rayPos = rayPos.func_178786_a(this.leniency * (double)dir.func_82601_c(), 0.0, this.leniency * (double)dir.func_82599_e()), ray, RayTraceContext.BlockMode.OUTLINE, RayTraceContext.FluidMode.NONE);
        if (take2Res.func_216346_c() == RayTraceResult.Type.BLOCK && take2Res instanceof BlockRayTraceResult) {
            BlockPos pos = ((BlockRayTraceResult)take2Res).func_216350_a().func_177972_a(dir);
            BlockState state = world.func_180495_p(pos);
            if (world.func_175623_d(pos) || state.func_185904_a().func_76222_j()) {
                return Pair.of((Object)pos, (Object)dir.func_176734_d());
            }
        }
        return null;
    }

    private boolean validateReacharoundStack(ItemStack stack) {
        Item item = stack.func_77973_b();
        return item instanceof BlockItem || this.whitelist.contains(Objects.toString(item.getRegistryName()));
    }
}

