/*
 * Decompiled with CFR 0.152.
 */
package com.farcr.savageandravage.core.registry;

import com.farcr.savageandravage.client.render.CreepieRenderer;
import com.farcr.savageandravage.client.render.GrieferRenderer;
import com.farcr.savageandravage.client.render.NoModelRenderer;
import com.farcr.savageandravage.client.render.RunePrisonRenderer;
import com.farcr.savageandravage.client.render.SkeletonVillagerRenderer;
import com.farcr.savageandravage.client.render.SporeBombRenderer;
import com.farcr.savageandravage.common.entity.BurningBannerEntity;
import com.farcr.savageandravage.common.entity.CreeperSporeCloudEntity;
import com.farcr.savageandravage.common.entity.CreepieEntity;
import com.farcr.savageandravage.common.entity.GrieferEntity;
import com.farcr.savageandravage.common.entity.RunePrisonEntity;
import com.farcr.savageandravage.common.entity.SkeletonVillagerEntity;
import com.farcr.savageandravage.common.entity.block.SporeBombEntity;
import com.farcr.savageandravage.core.SavageAndRavage;
import com.teamabnormals.abnormals_core.core.utils.RegistryHelper;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntitySpawnPlacementRegistry;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.GlobalEntityTypeAttributes;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.monster.SkeletonEntity;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.Heightmap;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;

@Mod.EventBusSubscriber(modid="savageandravage", bus=Mod.EventBusSubscriber.Bus.MOD)
public class SREntities {
    public static final RegistryHelper HELPER = SavageAndRavage.REGISTRY_HELPER;
    public static final DeferredRegister<EntityType<?>> ENTITIES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ENTITIES, (String)"savageandravage");
    public static final RegistryObject<EntityType<CreepieEntity>> CREEPIE = HELPER.createLivingEntity("creepie", CreepieEntity::new, EntityClassification.CREATURE, 0.85f, 1.9f);
    public static final RegistryObject<EntityType<SkeletonVillagerEntity>> SKELETON_VILLAGER = HELPER.createLivingEntity("skeleton_villager", SkeletonVillagerEntity::new, EntityClassification.MONSTER, 0.6f, 1.99f);
    public static final RegistryObject<EntityType<GrieferEntity>> GRIEFER = HELPER.createLivingEntity("griefer", GrieferEntity::new, EntityClassification.MONSTER, 0.6f, 1.99f);
    public static final RegistryObject<EntityType<CreeperSporeCloudEntity>> CREEPER_SPORE_CLOUD = ENTITIES.register("creeper_spore_cloud", () -> EntityType.Builder.func_220322_a(CreeperSporeCloudEntity::new, (EntityClassification)EntityClassification.MISC).func_220320_c().func_220321_a(0.25f, 0.25f).func_206830_a("savageandravage:creeper_spore_cloud"));
    public static final RegistryObject<EntityType<SporeBombEntity>> SPORE_BOMB = ENTITIES.register("spore_bomb", () -> EntityType.Builder.func_220322_a(SporeBombEntity::new, (EntityClassification)EntityClassification.MISC).func_220320_c().func_220321_a(0.98f, 0.98f).func_206830_a("savageandravage:spore_bomb"));
    public static final RegistryObject<EntityType<BurningBannerEntity>> BURNING_BANNER = ENTITIES.register("burning_banner", () -> EntityType.Builder.func_220322_a(BurningBannerEntity::new, (EntityClassification)EntityClassification.MISC).func_220320_c().func_206830_a("savageandravage:burning_banner"));
    public static final RegistryObject<EntityType<RunePrisonEntity>> RUNE_PRISON = ENTITIES.register("rune_prison", () -> EntityType.Builder.func_220322_a(RunePrisonEntity::new, (EntityClassification)EntityClassification.MISC).func_220320_c().func_220321_a(1.35f, 0.7f).func_206830_a("savageandravage:rune_prison"));

    @OnlyIn(value=Dist.CLIENT)
    public static void registerRendering() {
        RenderingRegistry.registerEntityRenderingHandler((EntityType)((EntityType)CREEPIE.get()), CreepieRenderer::new);
        RenderingRegistry.registerEntityRenderingHandler((EntityType)((EntityType)SKELETON_VILLAGER.get()), SkeletonVillagerRenderer::new);
        RenderingRegistry.registerEntityRenderingHandler((EntityType)((EntityType)GRIEFER.get()), GrieferRenderer::new);
        RenderingRegistry.registerEntityRenderingHandler((EntityType)((EntityType)CREEPER_SPORE_CLOUD.get()), NoModelRenderer::new);
        RenderingRegistry.registerEntityRenderingHandler((EntityType)((EntityType)SPORE_BOMB.get()), SporeBombRenderer::new);
        RenderingRegistry.registerEntityRenderingHandler((EntityType)((EntityType)BURNING_BANNER.get()), NoModelRenderer::new);
        RenderingRegistry.registerEntityRenderingHandler((EntityType)((EntityType)RUNE_PRISON.get()), RunePrisonRenderer::new);
    }

    public static void addEntitySpawns() {
        EntitySpawnPlacementRegistry.func_209343_a((EntityType)((EntityType)SKELETON_VILLAGER.get()), (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, MonsterEntity::func_223325_c);
        ForgeRegistries.BIOMES.getValues().forEach(SREntities::addSpawns);
    }

    public static void addSpawns(Biome biome) {
        if (BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.OVERWORLD) && biome.func_201856_r() != Biome.Category.MUSHROOM && biome.func_201856_r() != Biome.Category.NONE) {
            biome.func_201866_a(EntityClassification.MONSTER, new Biome.SpawnListEntry((EntityType)SKELETON_VILLAGER.get(), 5, 5, 5));
        }
    }

    @Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
    public static class mojangWhy {
        @SubscribeEvent(priority=EventPriority.LOWEST)
        public static void imstuff(RegistryEvent.Register<EntityType<?>> event) {
            GlobalEntityTypeAttributes.put((EntityType)((EntityType)CREEPIE.get()), (AttributeModifierMap)CreepieEntity.func_234200_m_().func_233813_a_());
            GlobalEntityTypeAttributes.put((EntityType)((EntityType)GRIEFER.get()), (AttributeModifierMap)GrieferEntity.func_234296_eI_().func_233813_a_());
            GlobalEntityTypeAttributes.put((EntityType)((EntityType)SKELETON_VILLAGER.get()), (AttributeModifierMap)SkeletonEntity.func_234275_m_().func_233813_a_());
        }
    }
}

