/*
 * Decompiled with CFR 0.152.
 */
package com.natamus.collective.functions;

import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public class WorldFunctions {
    public static void setWorldTime(ServerWorld serverworld, Integer time) {
        if (time < 0 || time > 24000) {
            return;
        }
        Integer days = WorldFunctions.getTotalDaysPassed(serverworld);
        serverworld.func_241114_a_((long)(time + days * 24000));
    }

    public static int getTotalTimePassed(ServerWorld serverworld) {
        return (int)serverworld.func_72820_D();
    }

    public static int getTotalDaysPassed(ServerWorld serverworld) {
        Integer currenttime = WorldFunctions.getTotalTimePassed(serverworld);
        Integer days = (int)Math.floor((double)currenttime.intValue() / 24000.0);
        return days;
    }

    public static int getWorldTime(ServerWorld serverworld) {
        return WorldFunctions.getTotalTimePassed(serverworld) - WorldFunctions.getTotalDaysPassed(serverworld) * 24000;
    }

    public static String getWorldDimensionName(World world) {
        return ((ServerWorld)world).func_234923_W_().func_240901_a_().toString();
    }

    public static boolean isOverworld(World world) {
        return WorldFunctions.getWorldDimensionName(world).toLowerCase().contains("overworld");
    }

    public static boolean isNether(World world) {
        return WorldFunctions.getWorldDimensionName(world).toLowerCase().contains("nether");
    }

    public static boolean isEnd(World world) {
        return WorldFunctions.getWorldDimensionName(world).toLowerCase().contains("end");
    }
}

