/*
 * Decompiled with CFR 0.152.
 */
package com.minecraftabnormals.atmospheric.common.world.gen.feature;

import com.minecraftabnormals.atmospheric.common.block.MonkeyBrushBlock;
import com.minecraftabnormals.atmospheric.core.registry.AtmosphericBlocks;
import com.mojang.serialization.Codec;
import com.teamabnormals.abnormals_core.core.utils.TreeUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.SaplingBlock;
import net.minecraft.state.Property;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldWriter;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.IWorldGenerationBaseReader;
import net.minecraft.world.gen.IWorldGenerationReader;
import net.minecraft.world.gen.feature.BaseTreeFeatureConfig;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.structure.StructureManager;

public class RosewoodTreeFeature
extends Feature<BaseTreeFeatureConfig> {
    private List<Block> brushes = new ArrayList<Block>();

    public RosewoodTreeFeature(Codec<BaseTreeFeatureConfig> config) {
        super(config);
    }

    public boolean func_230362_a_(ISeedReader worldIn, StructureManager manager, ChunkGenerator generator, Random rand, BlockPos position, BaseTreeFeatureConfig config) {
        if (rand.nextInt(250) == 0) {
            if (rand.nextInt(2) == 0) {
                this.brushes.add((Block)AtmosphericBlocks.WARM_MONKEY_BRUSH.get());
            }
            if (rand.nextInt(3) == 0) {
                this.brushes.add((Block)AtmosphericBlocks.HOT_MONKEY_BRUSH.get());
            }
            if (rand.nextInt(4) == 0) {
                this.brushes.add((Block)AtmosphericBlocks.SCALDING_MONKEY_BRUSH.get());
            }
        } else {
            this.brushes.clear();
        }
        int branches = 2 + rand.nextInt(3);
        int height = 4 + rand.nextInt(2) + rand.nextInt(3) + rand.nextInt(3);
        boolean flag = true;
        if (position.func_177956_o() >= 1 && position.func_177956_o() + height + 1 <= worldIn.func_217301_I()) {
            for (int j = position.func_177956_o(); j <= position.func_177956_o() + 1 + height; ++j) {
                int k = 1;
                if (j == position.func_177956_o()) {
                    k = 0;
                }
                if (j >= position.func_177956_o() + 1 + height - 2) {
                    k = 2;
                }
                BlockPos.Mutable blockpos$mutableblockpos = new BlockPos.Mutable();
                for (int l = position.func_177958_n() - k; l <= position.func_177958_n() + k && flag; ++l) {
                    for (int i1 = position.func_177952_p() - k; i1 <= position.func_177952_p() + k && flag; ++i1) {
                        if (j >= 0 && j < worldIn.func_217301_I()) {
                            if (TreeUtils.isAirOrLeaves((IWorldGenerationBaseReader)worldIn, (BlockPos)blockpos$mutableblockpos.func_181079_c(l, j, i1))) continue;
                            flag = false;
                            continue;
                        }
                        flag = false;
                    }
                }
            }
            if (!flag) {
                return false;
            }
            if (TreeUtils.isValidGround((IWorld)worldIn, (BlockPos)position.func_177977_b(), (SaplingBlock)((SaplingBlock)AtmosphericBlocks.ROSEWOOD_SAPLING.get())) && position.func_177956_o() < worldIn.func_217301_I() - branches - 1) {
                TreeUtils.setDirtAt((IWorld)worldIn, (BlockPos)position.func_177977_b());
                ArrayList<BlockPos> logsPlaced = new ArrayList<BlockPos>();
                int logX = position.func_177958_n();
                int logZ = position.func_177952_p();
                boolean canopy = false;
                for (int k1 = 0; k1 < height; ++k1) {
                    int logY = position.func_177956_o() + k1;
                    BlockPos blockpos = new BlockPos(logX, logY, logZ);
                    if (TreeUtils.isAirOrLeaves((IWorldGenerationBaseReader)worldIn, (BlockPos)blockpos)) {
                        TreeUtils.placeDirectionalLogAt((IWorldWriter)worldIn, (BlockPos)blockpos, (Direction)Direction.UP, (Random)rand, (BaseTreeFeatureConfig)config);
                        logsPlaced.add(blockpos);
                    }
                    if (rand.nextInt(6) != 0 || k1 <= 3 || k1 >= height || canopy) continue;
                    int leafSize = 1 + rand.nextInt(2);
                    for (int k3 = -leafSize; k3 <= leafSize; ++k3) {
                        for (int j4 = -leafSize; j4 <= leafSize; ++j4) {
                            if (Math.abs(k3) == leafSize && Math.abs(j4) == leafSize) continue;
                            TreeUtils.placeLeafAt((IWorldGenerationReader)worldIn, (BlockPos)blockpos.func_177982_a(k3, 0, j4), (Random)rand, (BaseTreeFeatureConfig)config);
                        }
                    }
                    canopy = true;
                }
                ArrayList<String> directions = new ArrayList<String>();
                for (int k2 = 0; k2 < branches; ++k2) {
                    int j4;
                    int k3;
                    Direction offset = Direction.Plane.HORIZONTAL.func_179518_a(rand);
                    while (directions.contains(offset.toString())) {
                        offset = Direction.Plane.HORIZONTAL.func_179518_a(rand);
                    }
                    directions.add(offset.toString());
                    int turns = 1 + rand.nextInt(3);
                    BlockPos currentPos = position.func_177967_a(Direction.UP, height - 1);
                    int branchLength = 0;
                    int branchHeight = 0;
                    for (int k4 = 0; k4 < turns; ++k4) {
                        branchLength = 1 + rand.nextInt(2) + rand.nextInt(2);
                        branchHeight = 1 + rand.nextInt(3) + rand.nextInt(2);
                        this.createHorizontalLog(branchLength, (IWorldGenerationReader)worldIn, currentPos, offset, rand, config, logsPlaced);
                        this.createVerticalLog(branchHeight, (IWorldGenerationReader)worldIn, currentPos.func_177967_a(offset, branchLength), rand, config, logsPlaced);
                        currentPos = currentPos.func_177967_a(offset, branchLength).func_177967_a(Direction.UP, branchHeight);
                    }
                    int leafSize = 2 + rand.nextInt(2);
                    int leafSizeTop = 0;
                    leafSizeTop = leafSize == 2 ? leafSize - 1 : leafSize - 1 - rand.nextInt(2);
                    for (k3 = -leafSize; k3 <= leafSize; ++k3) {
                        for (j4 = -leafSize; j4 <= leafSize; ++j4) {
                            if (Math.abs(k3) == leafSize && Math.abs(j4) == leafSize) continue;
                            TreeUtils.placeLeafAt((IWorldGenerationReader)worldIn, (BlockPos)currentPos.func_177982_a(k3, 0, j4), (Random)rand, (BaseTreeFeatureConfig)config);
                        }
                    }
                    currentPos = currentPos.func_177967_a(Direction.UP, 1);
                    for (k3 = -leafSizeTop; k3 <= leafSizeTop; ++k3) {
                        for (j4 = -leafSizeTop; j4 <= leafSizeTop; ++j4) {
                            if (Math.abs(k3) == leafSizeTop && Math.abs(j4) == leafSizeTop) continue;
                            TreeUtils.placeLeafAt((IWorldGenerationReader)worldIn, (BlockPos)currentPos.func_177982_a(k3, 0, j4), (Random)rand, (BaseTreeFeatureConfig)config);
                        }
                    }
                    logX = position.func_177958_n();
                    logZ = position.func_177952_p();
                }
                if (!this.brushes.isEmpty()) {
                    for (BlockPos pos : logsPlaced) {
                        for (Direction direction2 : Direction.values()) {
                            if (!TreeUtils.isAir((IWorldGenerationBaseReader)worldIn, (BlockPos)pos.func_177972_a(direction2)) || rand.nextInt(3) != 0) continue;
                            worldIn.func_180501_a(pos.func_177972_a(direction2), (BlockState)this.brushes.get(rand.nextInt(this.brushes.size())).func_176223_P().func_206870_a((Property)MonkeyBrushBlock.FACING, (Comparable)direction2), 18);
                        }
                    }
                }
                return true;
            }
            return false;
        }
        return false;
    }

    private void createHorizontalLog(int branchLength, IWorldGenerationReader worldIn, BlockPos pos, Direction direction, Random rand, BaseTreeFeatureConfig config, List<BlockPos> logsPlaced) {
        int logX = pos.func_177958_n();
        int logY = pos.func_177956_o();
        int logZ = pos.func_177952_p();
        for (int k3 = 0; k3 < branchLength; ++k3) {
            BlockPos blockpos1 = new BlockPos(logX += direction.func_82601_c(), logY, logZ += direction.func_82599_e());
            if (!TreeUtils.isAirOrLeaves((IWorldGenerationBaseReader)worldIn, (BlockPos)blockpos1)) continue;
            TreeUtils.placeDirectionalLogAt((IWorldWriter)worldIn, (BlockPos)blockpos1, (Direction)direction, (Random)rand, (BaseTreeFeatureConfig)config);
            logsPlaced.add(blockpos1);
        }
    }

    private void createVerticalLog(int branchHeight, IWorldGenerationReader worldIn, BlockPos pos, Random rand, BaseTreeFeatureConfig config, List<BlockPos> logsPlaced) {
        int logX = pos.func_177958_n();
        int logY = pos.func_177956_o();
        int logZ = pos.func_177952_p();
        boolean canopy = false;
        for (int k1 = 0; k1 < branchHeight; ++k1) {
            BlockPos blockpos;
            if (TreeUtils.isAirOrLeaves((IWorldGenerationBaseReader)worldIn, (BlockPos)(blockpos = new BlockPos(logX, ++logY, logZ)))) {
                TreeUtils.placeDirectionalLogAt((IWorldWriter)worldIn, (BlockPos)blockpos, (Direction)Direction.UP, (Random)rand, (BaseTreeFeatureConfig)config);
                logsPlaced.add(blockpos);
            }
            if (rand.nextInt(6) != 0 || canopy) continue;
            int leafSize = 1 + rand.nextInt(2);
            for (int k3 = -leafSize; k3 <= leafSize; ++k3) {
                for (int j4 = -leafSize; j4 <= leafSize; ++j4) {
                    if (Math.abs(k3) == leafSize && Math.abs(j4) == leafSize) continue;
                    TreeUtils.placeLeafAt((IWorldGenerationReader)worldIn, (BlockPos)blockpos.func_177982_a(k3, 0, j4), (Random)rand, (BaseTreeFeatureConfig)config);
                }
            }
            canopy = true;
        }
    }
}

