/*
 * Decompiled with CFR 0.152.
 */
package com.minecraftabnormals.atmospheric.core.registry;

import com.minecraftabnormals.atmospheric.common.world.biome.AtmosphericBiomeFeatures;
import com.minecraftabnormals.atmospheric.common.world.gen.feature.AloeVeraFeature;
import com.minecraftabnormals.atmospheric.common.world.gen.feature.BarrelCactusFeature;
import com.minecraftabnormals.atmospheric.common.world.gen.feature.CoarseDirtPatchFeature;
import com.minecraftabnormals.atmospheric.common.world.gen.feature.DirectionalFlowersFeature;
import com.minecraftabnormals.atmospheric.common.world.gen.feature.DuneRocksFeature;
import com.minecraftabnormals.atmospheric.common.world.gen.feature.PassionVineFeature;
import com.minecraftabnormals.atmospheric.common.world.gen.feature.PodzolFeature;
import com.minecraftabnormals.atmospheric.common.world.gen.feature.RosewoodTreeFeature;
import com.minecraftabnormals.atmospheric.common.world.gen.feature.RosewoodWaterTreeFeature;
import com.minecraftabnormals.atmospheric.common.world.gen.feature.SurfaceFossilFeature;
import com.minecraftabnormals.atmospheric.common.world.gen.feature.YuccaFlowerFeature;
import com.minecraftabnormals.atmospheric.common.world.gen.feature.YuccaTreeFeature;
import com.minecraftabnormals.atmospheric.common.world.gen.feature.config.YuccaTreeFeatureConfig;
import com.minecraftabnormals.atmospheric.common.world.gen.surfacebuilders.DunesSurfaceBuilder;
import com.minecraftabnormals.atmospheric.common.world.gen.surfacebuilders.WaveyDunesSurfaceBuilder;
import com.minecraftabnormals.atmospheric.core.registry.AtmosphericBiomes;
import com.minecraftabnormals.atmospheric.core.registry.AtmosphericBlocks;
import com.mojang.serialization.Codec;
import java.util.HashSet;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.Biomes;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.carver.ConfiguredCarver;
import net.minecraft.world.gen.feature.BaseTreeFeatureConfig;
import net.minecraft.world.gen.feature.BlockBlobConfig;
import net.minecraft.world.gen.feature.BlockClusterFeatureConfig;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import net.minecraft.world.gen.feature.ProbabilityConfig;
import net.minecraft.world.gen.feature.SphereReplaceConfig;
import net.minecraft.world.gen.surfacebuilders.SurfaceBuilder;
import net.minecraft.world.gen.surfacebuilders.SurfaceBuilderConfig;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;

@Mod.EventBusSubscriber(modid="atmospheric", bus=Mod.EventBusSubscriber.Bus.MOD)
public class AtmosphericFeatures {
    public static final Feature<ProbabilityConfig> PODZOL = new PodzolFeature((Codec<ProbabilityConfig>)ProbabilityConfig.field_236576_b_);
    public static final Feature<NoFeatureConfig> SURFACE_FOSSIL = new SurfaceFossilFeature((Codec<NoFeatureConfig>)NoFeatureConfig.field_236558_a_);
    public static final Feature<SphereReplaceConfig> COARSE_DIRT_PATCH = new CoarseDirtPatchFeature((Codec<SphereReplaceConfig>)SphereReplaceConfig.field_236516_a_);
    public static final Feature<NoFeatureConfig> WARM_MONKEY_BRUSH = new DirectionalFlowersFeature((Codec<NoFeatureConfig>)NoFeatureConfig.field_236558_a_, 1);
    public static final Feature<NoFeatureConfig> HOT_MONKEY_BRUSH = new DirectionalFlowersFeature((Codec<NoFeatureConfig>)NoFeatureConfig.field_236558_a_, 2);
    public static final Feature<NoFeatureConfig> SCALDING_MONKEY_BRUSH = new DirectionalFlowersFeature((Codec<NoFeatureConfig>)NoFeatureConfig.field_236558_a_, 3);
    public static final Feature<BaseTreeFeatureConfig> ROSEWOOD_TREE = new RosewoodTreeFeature((Codec<BaseTreeFeatureConfig>)BaseTreeFeatureConfig.field_236676_a_);
    public static final Feature<BaseTreeFeatureConfig> ROSEWOOD_WATER_TREE = new RosewoodWaterTreeFeature((Codec<BaseTreeFeatureConfig>)BaseTreeFeatureConfig.field_236676_a_);
    public static final Feature<YuccaTreeFeatureConfig> YUCCA_TREE = new YuccaTreeFeature(YuccaTreeFeatureConfig.CODEC_YUCCA_TREE_FEATURE_CONFIG);
    public static final Feature<NoFeatureConfig> PASSION_VINE = new PassionVineFeature((Codec<NoFeatureConfig>)NoFeatureConfig.field_236558_a_);
    public static final Feature<BlockClusterFeatureConfig> BARREL_CACTUS = new BarrelCactusFeature((Codec<BlockClusterFeatureConfig>)BlockClusterFeatureConfig.field_236587_a_);
    public static final Feature<BlockClusterFeatureConfig> ALOE_VERA = new AloeVeraFeature((Codec<BlockClusterFeatureConfig>)BlockClusterFeatureConfig.field_236587_a_);
    public static final Feature<BlockClusterFeatureConfig> YUCCA_FLOWER = new YuccaFlowerFeature((Codec<BlockClusterFeatureConfig>)BlockClusterFeatureConfig.field_236587_a_);
    public static final Feature<BlockBlobConfig> DUNE_ROCKS = new DuneRocksFeature((Codec<BlockBlobConfig>)BlockBlobConfig.field_236449_a_);
    public static final SurfaceBuilder<SurfaceBuilderConfig> DUNES = new DunesSurfaceBuilder((Codec<SurfaceBuilderConfig>)SurfaceBuilderConfig.field_237203_a_);
    public static final SurfaceBuilder<SurfaceBuilderConfig> WAVEY_DUNES = new WaveyDunesSurfaceBuilder((Codec<SurfaceBuilderConfig>)SurfaceBuilderConfig.field_237203_a_);

    @SubscribeEvent
    public static void registerFeatures(RegistryEvent.Register<Feature<?>> event) {
        event.getRegistry().registerAll((IForgeRegistryEntry[])new Feature[]{(Feature)PODZOL.setRegistryName("atmospheric", "podzol"), (Feature)DUNE_ROCKS.setRegistryName("atmospheric", "dune_rocks"), (Feature)SURFACE_FOSSIL.setRegistryName("atmospheric", "surface_fossil"), (Feature)COARSE_DIRT_PATCH.setRegistryName("atmospheric", "coarse_dirt_patch"), (Feature)WARM_MONKEY_BRUSH.setRegistryName("atmospheric", "warm_monkey_brush"), (Feature)HOT_MONKEY_BRUSH.setRegistryName("atmospheric", "hot_monkey_brush"), (Feature)SCALDING_MONKEY_BRUSH.setRegistryName("atmospheric", "scalding_monkey_brush"), (Feature)PASSION_VINE.setRegistryName("atmospheric", "passion_vine"), (Feature)BARREL_CACTUS.setRegistryName("atmospheric", "barrel_cactus"), (Feature)ALOE_VERA.setRegistryName("atmospheric", "aloe_vera"), (Feature)YUCCA_FLOWER.setRegistryName("atmospheric", "yucca_flower"), (Feature)ROSEWOOD_TREE.setRegistryName("atmospheric", "rosewood_tree"), (Feature)ROSEWOOD_WATER_TREE.setRegistryName("atmospheric", "rosewood_water_tree"), (Feature)YUCCA_TREE.setRegistryName("atmospheric", "yucca_tree")});
    }

    public static void addCarvables() {
        HashSet<IForgeRegistryEntry> allBlocksToCarve = new HashSet<IForgeRegistryEntry>();
        allBlocksToCarve.add(AtmosphericBlocks.ARID_SAND.get());
        allBlocksToCarve.add(AtmosphericBlocks.ARID_SANDSTONE.get());
        allBlocksToCarve.add(AtmosphericBlocks.RED_ARID_SAND.get());
        allBlocksToCarve.add(AtmosphericBlocks.RED_ARID_SANDSTONE.get());
        for (GenerationStage.Carving carverStage : GenerationStage.Carving.values()) {
            for (ConfiguredCarver carver : ((Biome)AtmosphericBiomes.DUNES.get()).func_203603_a(carverStage)) {
                allBlocksToCarve.addAll(carver.field_222732_a.field_222718_j);
                carver.field_222732_a.field_222718_j = allBlocksToCarve;
            }
        }
    }

    @SubscribeEvent
    public static void registerSurfaceBuilders(RegistryEvent.Register<SurfaceBuilder<?>> event) {
        event.getRegistry().registerAll((IForgeRegistryEntry[])new SurfaceBuilder[]{(SurfaceBuilder)DUNES.setRegistryName("atmospheric", "dunes_builder"), (SurfaceBuilder)WAVEY_DUNES.setRegistryName("atmospheric", "wavey_dunes")});
    }

    public static void generateFeatures() {
        ForgeRegistries.BIOMES.getValues().forEach(AtmosphericFeatures::generate);
    }

    public static void generate(Biome biome) {
        if (biome == Biomes.field_76769_d || biome == Biomes.field_76786_s) {
            AtmosphericBiomeFeatures.addYuccaTrees(biome, 0, 0.005f, 1);
        }
        if (biome == Biomes.field_185438_aj || biome == Biomes.field_150607_aa) {
            AtmosphericBiomeFeatures.addYuccaTrees(biome, 0, 0.25f, 1);
        }
        if (biome == Biomes.field_185435_ag || biome == Biomes.field_185436_ah) {
            AtmosphericBiomeFeatures.addYuccaTrees(biome, 0, 0.15f, 1);
        }
    }
}

