/*
 * Decompiled with CFR 0.152.
 */
package com.teammetallurgy.aquaculture.client.renderer.entity;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.teammetallurgy.aquaculture.client.renderer.entity.layers.JellyfishLayer;
import com.teammetallurgy.aquaculture.client.renderer.entity.model.FishCatchfishModel;
import com.teammetallurgy.aquaculture.client.renderer.entity.model.FishLargeModel;
import com.teammetallurgy.aquaculture.client.renderer.entity.model.FishLongnoseModel;
import com.teammetallurgy.aquaculture.client.renderer.entity.model.FishMediumModel;
import com.teammetallurgy.aquaculture.client.renderer.entity.model.FishSmallModel;
import com.teammetallurgy.aquaculture.client.renderer.entity.model.JellyfishModel;
import com.teammetallurgy.aquaculture.entity.AquaFishEntity;
import com.teammetallurgy.aquaculture.entity.FishType;
import javax.annotation.Nonnull;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.model.EntityModel;
import net.minecraft.client.renderer.entity.model.TropicalFishBModel;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3f;

public class AquaFishRenderer
extends MobRenderer<AquaFishEntity, EntityModel<AquaFishEntity>> {
    private static final ResourceLocation DEFAULT_LOCATION = new ResourceLocation("aquaculture", "textures/entity/fish/atlantic_cod.png");
    private static final TropicalFishBModel<AquaFishEntity> TROPICAL_FISH_B_MODEL = new TropicalFishBModel(0.0f);
    private static final FishSmallModel<AquaFishEntity> SMALL_MODEL = new FishSmallModel();
    private static final FishMediumModel<AquaFishEntity> MEDIUM_MODEL = new FishMediumModel();
    private static final FishLargeModel<AquaFishEntity> LARGE_MODEL = new FishLargeModel();
    private static final FishLongnoseModel<AquaFishEntity> LONGNOSE_MODEL = new FishLongnoseModel();
    private static final FishCatchfishModel<AquaFishEntity> CATFISH_MODEL = new FishCatchfishModel();
    private static final JellyfishModel<AquaFishEntity> JELLYFISH_MODEL = new JellyfishModel();

    public AquaFishRenderer(EntityRendererManager manager, boolean isJellyfish) {
        super(manager, MEDIUM_MODEL, 0.35f);
        if (isJellyfish) {
            this.func_177094_a(new JellyfishLayer(this));
        }
    }

    public void render(@Nonnull AquaFishEntity fishEntity, float entityYaw, float partialTicks, @Nonnull MatrixStack matrixStack, @Nonnull IRenderTypeBuffer buffer, int i) {
        switch (AquaFishEntity.TYPES.get(fishEntity.func_200600_R())) {
            case SMALL: {
                this.field_77045_g = SMALL_MODEL;
                break;
            }
            case LARGE: {
                this.field_77045_g = LARGE_MODEL;
                break;
            }
            case LONGNOSE: {
                this.field_77045_g = LONGNOSE_MODEL;
                break;
            }
            case CATFISH: {
                this.field_77045_g = CATFISH_MODEL;
                break;
            }
            case JELLYFISH: {
                this.field_77045_g = JELLYFISH_MODEL;
                break;
            }
            case HALIBUT: {
                this.field_77045_g = TROPICAL_FISH_B_MODEL;
                break;
            }
            default: {
                this.field_77045_g = MEDIUM_MODEL;
            }
        }
        super.func_225623_a_((MobEntity)fishEntity, entityYaw, partialTicks, matrixStack, buffer, i);
    }

    @Nonnull
    public ResourceLocation getEntityTexture(@Nonnull AquaFishEntity fishEntity) {
        ResourceLocation location = fishEntity.func_200600_R().getRegistryName();
        if (location != null) {
            return new ResourceLocation("aquaculture", "textures/entity/fish/" + location.func_110623_a() + ".png");
        }
        return DEFAULT_LOCATION;
    }

    protected void applyRotations(AquaFishEntity fishEntity, @Nonnull MatrixStack matrixStack, float ageInTicks, float rotationYaw, float partialTicks) {
        super.func_225621_a_((LivingEntity)fishEntity, matrixStack, ageInTicks, rotationYaw, partialTicks);
        FishType fishType = AquaFishEntity.TYPES.get(fishEntity.func_200600_R());
        if (fishType != FishType.JELLYFISH) {
            float salmonRotation = 1.0f;
            float salmonMultiplier = 1.0f;
            if (fishType == FishType.LONGNOSE && !fishEntity.func_70090_H()) {
                salmonRotation = 1.3f;
                salmonMultiplier = 1.7f;
            }
            float fishRotation = fishType == FishType.LONGNOSE ? salmonRotation * 4.3f * MathHelper.func_76126_a((float)(salmonMultiplier * 0.6f * ageInTicks)) : 4.3f * MathHelper.func_76126_a((float)(0.6f * ageInTicks));
            matrixStack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(fishRotation));
            if (fishType == FishType.LONGNOSE) {
                matrixStack.func_227861_a_(0.0, 0.0, (double)-0.4f);
            }
            if (!fishEntity.func_70090_H() && fishType != FishType.HALIBUT) {
                if (fishType == FishType.MEDIUM || fishType == FishType.LARGE || fishType == FishType.CATFISH) {
                    matrixStack.func_227861_a_((double)0.1f, (double)0.1f, (double)-0.1f);
                } else {
                    matrixStack.func_227861_a_((double)0.2f, (double)0.1f, 0.0);
                }
                matrixStack.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(90.0f));
            }
            if (fishType == FishType.HALIBUT) {
                matrixStack.func_227861_a_((double)-0.4f, (double)0.1f, 0.0);
                matrixStack.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(-90.0f));
            }
        }
    }

    protected void preRenderCallback(AquaFishEntity fishEntity, MatrixStack matrixStack, float partialTickTime) {
        ResourceLocation location = fishEntity.func_200600_R().getRegistryName();
        float scale = 0.0f;
        if (location != null) {
            switch (location.func_110623_a()) {
                case "minnow": {
                    scale = 0.5f;
                    break;
                }
                case "synodontis": {
                    scale = 0.8f;
                    break;
                }
                case "brown_trout": 
                case "piranha": {
                    scale = 0.9f;
                    break;
                }
                case "pollock": {
                    scale = 1.1f;
                    break;
                }
                case "atlantic_cod": 
                case "blackfish": 
                case "catfish": 
                case "tambaqui": {
                    scale = 1.2f;
                    break;
                }
                case "pacific_halibut": 
                case "atlantic_halibut": 
                case "capitaine": 
                case "largemouth_bass": 
                case "gar": 
                case "arapaima": 
                case "tuna": {
                    scale = 1.4f;
                }
            }
        }
        if (scale > 0.0f) {
            matrixStack.func_227860_a_();
            matrixStack.func_227862_a_(scale, scale, scale);
            matrixStack.func_227865_b_();
        }
    }
}

