/*
 * Decompiled with CFR 0.152.
 */
package com.minecraftabnormals.upgrade_aquatic.client.render.gui;

import com.minecraftabnormals.upgrade_aquatic.common.entities.thrasher.ThrasherEntity;
import com.minecraftabnormals.upgrade_aquatic.core.config.Config;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.stats.StatisticsManager;
import net.minecraft.stats.Stats;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.DimensionType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.client.gui.ForgeIngameGui;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="upgrade_aquatic", value={Dist.CLIENT})
public class RenderOverlays {
    private static final Minecraft MC = Minecraft.func_71410_x();

    @SubscribeEvent
    public static void renderOverlays(RenderGameOverlayEvent event) {
        if (event.getType() == RenderGameOverlayEvent.ElementType.VIGNETTE) {
            int scaledWidth = MC.func_228018_at_().func_198107_o();
            int scaledHeight = MC.func_228018_at_().func_198087_p();
            ClientPlayerEntity player = RenderOverlays.MC.field_71439_g;
            StatisticsManager statisticsManager = player.func_146107_m();
            int sleepTime = statisticsManager.func_77444_a(Stats.field_199092_j.func_199076_b((Object)Stats.field_203284_n));
            int configuredTime = (Integer)Config.CLIENT.daysTillRenderInsomniaOverlay.get();
            float opacity = 0.0f;
            if (sleepTime == 24000 * configuredTime) {
                opacity = 0.25f;
            } else if (sleepTime == 24000 * configuredTime + 100) {
                opacity = 0.45f;
            } else if (sleepTime == 24000 * configuredTime + 200) {
                opacity = 0.65f;
            } else if (sleepTime == 24000 * configuredTime + 300) {
                opacity = 0.85f;
            } else if (sleepTime == 24000 * configuredTime + 400) {
                opacity = 0.9f;
            } else if (sleepTime >= 24000 * configuredTime + 500) {
                opacity = 1.0f;
            } else if (sleepTime < 24000 * configuredTime) {
                opacity = 0.0f;
            }
            if (RenderOverlays.MC.field_71474_y.field_74320_O == 0 && (Integer)Config.CLIENT.daysTillRenderInsomniaOverlay.get() != 0 && RenderOverlays.MC.field_71439_g.func_130014_f_().func_234922_V_() == DimensionType.field_235999_c_) {
                MatrixStack stack = event.getMatrixStack();
                stack.func_227860_a_();
                RenderOverlays.MC.field_71446_o.func_110577_a(new ResourceLocation("upgrade_aquatic", "textures/gui/overlay/insomnia.png"));
                RenderSystem.enableBlend();
                RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
                RenderSystem.color3f((float)1.0f, (float)1.0f, (float)1.0f);
                RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)opacity);
                Tessellator tessellator = Tessellator.func_178181_a();
                BufferBuilder bufferbuilder = tessellator.func_178180_c();
                bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181707_g);
                bufferbuilder.func_225582_a_(0.0, (double)scaledHeight, -90.0).func_225583_a_(0.0f, 1.0f).func_181675_d();
                bufferbuilder.func_225582_a_((double)scaledWidth, (double)scaledHeight, -90.0).func_225583_a_(1.0f, 1.0f).func_181675_d();
                bufferbuilder.func_225582_a_((double)scaledWidth, 0.0, -90.0).func_225583_a_(1.0f, 0.0f).func_181675_d();
                bufferbuilder.func_225582_a_(0.0, 0.0, -90.0).func_225583_a_(0.0f, 0.0f).func_181675_d();
                tessellator.func_78381_a();
                stack.func_227865_b_();
            }
        }
    }

    @SubscribeEvent
    public static void renderScuteOverAir(RenderGameOverlayEvent.Pre event) {
        if (event.getType() == RenderGameOverlayEvent.ElementType.AIR) {
            int scaledWidth = MC.func_228018_at_().func_198107_o();
            int scaledHeight = MC.func_228018_at_().func_198087_p();
            ClientPlayerEntity player = RenderOverlays.MC.field_71439_g;
            boolean inWater = player.func_208600_a((ITag)FluidTags.field_206959_a);
            if (inWater) {
                ItemStack turtleHelmet = ItemStack.field_190927_a;
                for (ItemStack stack : player.func_184193_aE()) {
                    if (stack.func_77973_b() != Items.field_203179_ao) continue;
                    turtleHelmet = stack;
                }
                if (!turtleHelmet.func_190926_b()) {
                    event.setCanceled(true);
                    MatrixStack stack = event.getMatrixStack();
                    stack.func_227860_a_();
                    RenderSystem.enableBlend();
                    int left = scaledWidth / 2 + 91;
                    int top = scaledHeight - ForgeIngameGui.right_height;
                    int durability = turtleHelmet.func_77952_i();
                    int maxDurability = turtleHelmet.func_77958_k();
                    RenderOverlays.MC.field_71446_o.func_110577_a(new ResourceLocation("upgrade_aquatic", "textures/gui/overlay/scute_bubble_depleted.png"));
                    for (int i = 0; i < 10; ++i) {
                        int l = left - i * 8 - 9;
                        int l2 = l + 9;
                        int t = top;
                        int t2 = t + 9;
                        Tessellator tessellator = Tessellator.func_178181_a();
                        BufferBuilder bufferbuilder = tessellator.func_178180_c();
                        bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181707_g);
                        bufferbuilder.func_225582_a_((double)l, (double)t2, 0.0).func_225583_a_(0.0f, 1.0f).func_181675_d();
                        bufferbuilder.func_225582_a_((double)l2, (double)t2, 0.0).func_225583_a_(1.0f, 1.0f).func_181675_d();
                        bufferbuilder.func_225582_a_((double)l2, (double)t, 0.0).func_225583_a_(1.0f, 0.0f).func_181675_d();
                        bufferbuilder.func_225582_a_((double)l, (double)t, 0.0).func_225583_a_(0.0f, 0.0f).func_181675_d();
                        tessellator.func_78381_a();
                    }
                    RenderOverlays.MC.field_71446_o.func_110577_a(new ResourceLocation("upgrade_aquatic", "textures/gui/overlay/scute_bubble.png"));
                    double amount = MathHelper.func_151237_a((double)(10.0 - Math.floor((double)durability / (double)maxDurability * 10.0)), (double)1.0, (double)10.0);
                    int i = 0;
                    while ((double)i < amount) {
                        int l = left - i * 8 - 9;
                        int l2 = l + 9;
                        int t = top;
                        int t2 = t + 9;
                        Tessellator tessellator = Tessellator.func_178181_a();
                        BufferBuilder bufferbuilder = tessellator.func_178180_c();
                        bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181707_g);
                        bufferbuilder.func_225582_a_((double)l, (double)t2, 0.0).func_225583_a_(0.0f, 1.0f).func_181675_d();
                        bufferbuilder.func_225582_a_((double)l2, (double)t2, 0.0).func_225583_a_(1.0f, 1.0f).func_181675_d();
                        bufferbuilder.func_225582_a_((double)l2, (double)t, 0.0).func_225583_a_(1.0f, 0.0f).func_181675_d();
                        bufferbuilder.func_225582_a_((double)l, (double)t, 0.0).func_225583_a_(0.0f, 0.0f).func_181675_d();
                        tessellator.func_78381_a();
                        ++i;
                    }
                    ForgeIngameGui.right_height += 10;
                    RenderSystem.disableBlend();
                    stack.func_227865_b_();
                }
            }
        }
        if (event.getType() == RenderGameOverlayEvent.ElementType.TEXT && RenderOverlays.MC.field_71439_g.func_184218_aH() && RenderOverlays.MC.field_71439_g.func_184187_bx() instanceof ThrasherEntity && RenderOverlays.MC.field_71456_v.field_73838_g.getString().equals(I18n.func_135052_a((String)"mount.onboard", (Object[])new Object[]{I18n.func_135052_a((String)"key.keyboard.left.shift", (Object[])new Object[0])}))) {
            RenderOverlays.MC.field_71456_v.func_175188_a((ITextComponent)new StringTextComponent(""), false);
        }
    }
}

