/*
 * Decompiled with CFR 0.152.
 */
package com.minecraftabnormals.upgrade_aquatic.common.entities;

import com.minecraftabnormals.upgrade_aquatic.common.entities.thrasher.ThrasherEntity;
import com.minecraftabnormals.upgrade_aquatic.core.registry.UAEntities;
import com.minecraftabnormals.upgrade_aquatic.core.registry.UAItems;
import com.teamabnormals.abnormals_core.common.entity.BucketableWaterMobEntity;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.Pose;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.controller.MovementController;
import net.minecraft.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.PanicGoal;
import net.minecraft.entity.ai.goal.RandomSwimmingGoal;
import net.minecraft.entity.passive.SquidEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.pathfinding.PathNavigator;
import net.minecraft.pathfinding.SwimmerPathNavigator;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.EntityPredicates;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;

public class NautilusEntity
extends BucketableWaterMobEntity {
    private static final DataParameter<Boolean> MOVING = EntityDataManager.func_187226_a(NautilusEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> FLEEING = EntityDataManager.func_187226_a(NautilusEntity.class, (IDataSerializer)DataSerializers.field_187198_h);

    public NautilusEntity(EntityType<? extends NautilusEntity> type, World worldIn) {
        super(type, worldIn);
        this.field_70765_h = new MoveHelperController(this);
    }

    public NautilusEntity(World world, double posX, double posY, double posZ) {
        this((EntityType<? extends NautilusEntity>)((EntityType)UAEntities.NAUTILUS.get()), world);
        this.func_70107_b(posX, posY, posZ);
    }

    public static AttributeModifierMap.MutableAttribute registerAttributes() {
        return MobEntity.func_233666_p_().func_233815_a_(Attributes.field_233818_a_, 18.0);
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (Goal)new PanicGoal((CreatureEntity)this, 1.65));
        this.field_70714_bg.func_75776_a(2, (Goal)new AvoidEntityGoal<PlayerEntity>((CreatureEntity)this, PlayerEntity.class, 9.0f, 1.5, 1.2, EntityPredicates.field_180132_d::test){

            public void func_75249_e() {
                ((NautilusEntity)this.field_75380_a).setFleeing(true);
                super.func_75249_e();
            }

            public void func_75251_c() {
                ((NautilusEntity)this.field_75380_a).setFleeing(false);
                super.func_75251_c();
            }
        });
        this.field_70714_bg.func_75776_a(2, (Goal)new AvoidEntityGoal<SquidEntity>((CreatureEntity)this, SquidEntity.class, 9.0f, 1.5, 1.2, EntityPredicates.field_180132_d::test){

            public void func_75249_e() {
                ((NautilusEntity)this.field_75380_a).setFleeing(true);
                super.func_75249_e();
            }

            public void func_75251_c() {
                ((NautilusEntity)this.field_75380_a).setFleeing(false);
                super.func_75251_c();
            }
        });
        this.field_70714_bg.func_75776_a(2, (Goal)new AvoidEntityGoal<ThrasherEntity>((CreatureEntity)this, ThrasherEntity.class, 9.0f, 1.5, 1.2, EntityPredicates.field_180132_d::test){

            public void func_75249_e() {
                ((NautilusEntity)this.field_75380_a).setFleeing(true);
                super.func_75249_e();
            }

            public void func_75251_c() {
                ((NautilusEntity)this.field_75380_a).setFleeing(false);
                super.func_75251_c();
            }
        });
        this.field_70714_bg.func_75776_a(4, (Goal)new SwimGoal(this));
    }

    protected PathNavigator func_175447_b(World worldIn) {
        return new SwimmerPathNavigator((MobEntity)this, worldIn);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(MOVING, (Object)false);
        this.field_70180_af.func_187214_a(FLEEING, (Object)false);
    }

    public boolean isFleeing() {
        return (Boolean)this.field_70180_af.func_187225_a(FLEEING);
    }

    public void setFleeing(boolean p_203706_1_) {
        this.field_70180_af.func_187227_b(FLEEING, (Object)p_203706_1_);
    }

    public boolean isMoving() {
        return (Boolean)this.field_70180_af.func_187225_a(MOVING);
    }

    public void setMoving(boolean p_203706_1_) {
        this.field_70180_af.func_187227_b(MOVING, (Object)p_203706_1_);
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74757_a("Moving", this.isMoving());
        compound.func_74757_a("Fleeing", this.isMoving());
    }

    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        this.setMoving(compound.func_74767_n("Moving"));
        this.setMoving(compound.func_74767_n("Fleeing"));
    }

    public ItemStack getBucket() {
        return new ItemStack((IItemProvider)UAItems.NAUTILUS_BUCKET.get());
    }

    public void func_70636_d() {
        if (this.isMoving() && this.func_70090_H() && this.field_205013_W) {
            Vector3d vec3d1 = this.func_70676_i(0.0f);
            if (this.func_130014_f_().func_82737_E() % 2L == 0L) {
                this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197612_e, this.func_226277_ct_() + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.func_213311_cf() - vec3d1.field_72450_a * 0.75, this.func_226278_cu_() + this.field_70146_Z.nextDouble() * (double)this.func_213302_cg() - vec3d1.field_72448_b * 1.0, this.func_226281_cx_() + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.func_213311_cf() - vec3d1.field_72449_c * 0.75, 0.0, 0.0, 0.0);
            }
        }
        super.func_70636_d();
    }

    public void func_213352_e(Vector3d p_213352_1_) {
        if (this.func_70613_aW() && this.func_70090_H()) {
            this.func_213309_a(0.01f, p_213352_1_);
            this.func_213315_a(MoverType.SELF, this.func_213322_ci());
            this.func_213317_d(this.func_213322_ci().func_186678_a(0.9));
            if (this.func_70638_az() == null) {
                this.func_213317_d(this.func_213322_ci().func_72441_c(0.0, -0.005, 0.0));
            }
        } else {
            super.func_213352_e(p_213352_1_);
        }
    }

    public void func_203004_j(boolean downwards) {
    }

    public void func_203002_i(boolean downwards) {
    }

    protected float func_213348_b(Pose poseIn, EntitySize sizeIn) {
        return sizeIn.field_220316_b * 0.65f;
    }

    public ItemStack getPickedResult(RayTraceResult target) {
        return new ItemStack((IItemProvider)UAItems.NAUTILUS_SPAWN_EGG.get());
    }

    public int func_70641_bl() {
        return 8;
    }

    static class SwimGoal
    extends RandomSwimmingGoal {
        public final NautilusEntity nautilus;

        public SwimGoal(NautilusEntity nautilus) {
            super((CreatureEntity)nautilus, 1.0, 30);
            this.nautilus = nautilus;
        }

        public boolean func_75250_a() {
            return super.func_75250_a();
        }
    }

    static class MoveHelperController
    extends MovementController {
        private final NautilusEntity nautilus;

        MoveHelperController(NautilusEntity nautilus) {
            super((MobEntity)nautilus);
            this.nautilus = nautilus;
        }

        public void func_75641_c() {
            if (this.nautilus.func_208600_a((ITag)FluidTags.field_206959_a)) {
                this.nautilus.func_213317_d(this.nautilus.func_213322_ci().func_72441_c(0.0, 0.005, 0.0));
            }
            if (this.field_188491_h == MovementController.Action.MOVE_TO && !this.nautilus.func_70661_as().func_75500_f()) {
                double d0 = this.field_75646_b - this.nautilus.func_226277_ct_();
                double d1 = this.field_75647_c - this.nautilus.func_226278_cu_();
                double d2 = this.field_75644_d - this.nautilus.func_226281_cx_();
                double d3 = MathHelper.func_76133_a((double)(d0 * d0 + d1 * d1 + d2 * d2));
                float f = (float)(MathHelper.func_181159_b((double)d2, (double)d0) * 57.2957763671875) - 90.0f;
                this.nautilus.field_70761_aq = this.nautilus.field_70177_z = this.func_75639_a(this.nautilus.field_70177_z, f, 90.0f);
                float f1 = (float)(this.field_75645_e * this.nautilus.func_110148_a(Attributes.field_233821_d_).func_111126_e());
                this.nautilus.func_70659_e(MathHelper.func_219799_g((float)0.125f, (float)this.nautilus.func_70689_ay(), (float)f1));
                this.nautilus.func_213317_d(this.nautilus.func_213322_ci().func_72441_c(0.0, (double)this.nautilus.func_70689_ay() * (d1 /= d3) * 0.03, 0.0));
                this.nautilus.setMoving(true);
            } else {
                this.nautilus.func_70659_e(0.0f);
                this.nautilus.setMoving(false);
            }
        }
    }
}

