/*
 * Decompiled with CFR 0.152.
 */
package com.minecraftabnormals.upgrade_aquatic.common.entities.jellyfish;

import com.minecraftabnormals.upgrade_aquatic.common.blocks.JellyTorchBlock;
import com.minecraftabnormals.upgrade_aquatic.common.network.RotateJellyfishMessage;
import com.minecraftabnormals.upgrade_aquatic.core.UpgradeAquatic;
import com.minecraftabnormals.upgrade_aquatic.core.other.UADamageSources;
import com.minecraftabnormals.upgrade_aquatic.core.registry.UABlocks;
import com.minecraftabnormals.upgrade_aquatic.core.registry.UAItems;
import com.teamabnormals.abnormals_core.common.entity.BucketableWaterMobEntity;
import com.teamabnormals.abnormals_core.core.library.endimator.Endimation;
import com.teamabnormals.abnormals_core.core.library.endimator.entity.IEndimatedEntity;
import com.teamabnormals.abnormals_core.core.utils.MathUtils;
import java.util.Random;
import java.util.function.Predicate;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.passive.TurtleEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.particles.IParticleData;
import net.minecraft.pathfinding.PathNavigator;
import net.minecraft.pathfinding.SwimmerPathNavigator;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.PacketDistributor;

public abstract class AbstractJellyfishEntity
extends BucketableWaterMobEntity
implements IEndimatedEntity {
    private static final Predicate<LivingEntity> CAN_STING = entity -> {
        if (entity instanceof PlayerEntity) {
            return !entity.func_175149_v() && !((PlayerEntity)entity).func_184812_l_();
        }
        return !entity.func_175149_v() && !(entity instanceof AbstractJellyfishEntity) && !(entity instanceof TurtleEntity);
    };
    protected static final DataParameter<Integer> COOLDOWN = EntityDataManager.func_187226_a(AbstractJellyfishEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    private Endimation playingEndimation = BLANK_ANIMATION;
    private int animationTick;
    public float[] lockedRotations = new float[2];

    public AbstractJellyfishEntity(EntityType<? extends AbstractJellyfishEntity> type, World world) {
        super(type, world);
    }

    public static AttributeModifierMap.MutableAttribute registerAttributes() {
        return MobEntity.func_233666_p_().func_233815_a_(Attributes.field_233823_f_, 2.0);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(COOLDOWN, (Object)0);
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        this.endimateTick();
        this.getRotationController().tick();
        this.field_70761_aq = 0.0f;
        this.field_70759_as = 0.0f;
        this.field_70177_z = 0.0f;
        if (this.func_70613_aW()) {
            if (!this.func_184218_aH()) {
                this.getRotationController().rotate(this.lockedRotations[0], this.lockedRotations[1], 25);
            } else {
                this.getRotationController().rotate(0.0f, 0.0f, 1);
                this.func_70050_g(this.func_205010_bg());
            }
        }
        if (this.hasCooldown()) {
            if (this.func_70613_aW()) {
                this.setCooldown(this.getCooldown() - 1);
            }
            if (this.field_70170_p.field_72995_K && this.field_70170_p.func_82737_E() % 4L == 0L) {
                for (int i = 0; i < 2; ++i) {
                    this.field_70170_p.func_195594_a((IParticleData)JellyTorchBlock.getBlobParticleType(this.getJellyTorchType()), this.func_226282_d_(0.5), this.func_226278_cu_() + (double)this.func_70047_e(), this.func_226287_g_(0.5), MathUtils.makeNegativeRandomly((double)(this.field_70146_Z.nextDouble() * (double)0.05f), (Random)this.func_70681_au()), -this.field_70146_Z.nextDouble() * (double)0.05f, MathUtils.makeNegativeRandomly((double)(this.field_70146_Z.nextDouble() * (double)0.05f), (Random)this.func_70681_au()));
                }
            }
        }
        if (this.func_70089_S()) {
            for (LivingEntity entities : this.field_70170_p.func_175647_a(LivingEntity.class, this.func_174813_aQ().func_186662_g(0.15), CAN_STING)) {
                if (!entities.func_70089_S()) continue;
                this.stingEntity(entities);
            }
            if (this.func_70090_H() && this.isNoEndimationPlaying()) {
                this.func_213317_d(this.func_213322_ci().func_178786_a(0.0, (double)0.005f, 0.0));
            }
        }
    }

    public void func_213352_e(Vector3d Vector3d2) {
        if (this.func_70613_aW() && this.func_70090_H()) {
            this.func_213309_a(0.01f, Vector3d2);
            this.func_213315_a(MoverType.SELF, this.func_213322_ci());
            this.func_213317_d(this.func_213322_ci().func_186678_a(0.75));
        } else {
            super.func_213352_e(Vector3d2);
        }
    }

    public boolean willBeBoostedOutOfWater(float yaw, float pitch) {
        block8: {
            block7: {
                float xMotion = -MathHelper.func_76126_a((float)(yaw * ((float)Math.PI / 180))) * MathHelper.func_76134_b((float)(pitch * ((float)Math.PI / 180)));
                float yMotion = -MathHelper.func_76126_a((float)(pitch * ((float)Math.PI / 180)));
                float zMotion = MathHelper.func_76134_b((float)(yaw * ((float)Math.PI / 180))) * MathHelper.func_76134_b((float)(pitch * ((float)Math.PI / 180)));
                Vector3d motion = new Vector3d((double)xMotion, (double)yMotion, (double)zMotion).func_72432_b().func_186678_a((double)0.55f);
                if (this.field_70170_p.func_175623_d(new BlockPos(this.func_213303_ch().func_178787_e(motion)))) {
                    return true;
                }
                if (!(pitch <= 75.0f) || !(pitch >= -75.0f)) break block7;
                BlockPos pos = this.func_233580_cy_();
                BlockPos.Mutable blockpos = new BlockPos.Mutable();
                for (int x = pos.func_177958_n() - 1; x < pos.func_177958_n() + 2; ++x) {
                    for (int y = pos.func_177956_o(); y < pos.func_177956_o() + 2; ++y) {
                        for (int z = pos.func_177952_p() - 1; z < pos.func_177952_p() + 2; ++z) {
                            blockpos.func_181079_c(x, y, z);
                            if (!this.field_70170_p.func_175623_d(blockpos.func_177984_a()) || !this.field_70170_p.func_204610_c((BlockPos)blockpos).func_206884_a((ITag)FluidTags.field_206959_a)) continue;
                            return true;
                        }
                    }
                }
                break block8;
            }
            if (!(pitch <= 180.0f) || !(pitch >= -180.0f) || !(pitch < -75.0f)) break block8;
            BlockPos pos = this.func_233580_cy_();
            BlockPos.Mutable blockpos = new BlockPos.Mutable();
            for (int x = pos.func_177958_n() - 1; x < pos.func_177958_n() + 2; ++x) {
                for (int y = pos.func_177956_o(); y < pos.func_177956_o() - 2; ++y) {
                    for (int z = pos.func_177952_p() - 1; z < pos.func_177952_p() + 2; ++z) {
                        blockpos.func_181079_c(x, y, z);
                        if (!this.field_70170_p.func_175623_d(blockpos.func_177977_b()) || !this.field_70170_p.func_204610_c((BlockPos)blockpos).func_206884_a((ITag)FluidTags.field_206959_a)) continue;
                        return true;
                    }
                }
            }
        }
        return false;
    }

    public PathNavigator func_70661_as() {
        return new SwimmerPathNavigator((MobEntity)this, this.field_70170_p);
    }

    public ActionResultType func_230254_b_(PlayerEntity player, Hand hand) {
        ItemStack itemstack = player.func_184586_b(hand);
        Item item = itemstack.func_77973_b();
        if (itemstack.func_190926_b() && this.func_200200_C_().getString().toLowerCase().trim().equals("jellysox345")) {
            this.func_184220_m((Entity)player);
            return ActionResultType.SUCCESS;
        }
        if (item == UAItems.PRISMARINE_ROD.get() && !this.hasCooldown()) {
            Random rand = new Random();
            if (this.func_70613_aW() && rand.nextFloat() < this.getCooldownChance()) {
                this.setCooldown(20 * (rand.nextInt(16) + 15));
            }
            itemstack.func_190918_g(1);
            player.func_191521_c(AbstractJellyfishEntity.getTorchByType(this.getJellyTorchType()));
            return ActionResultType.SUCCESS;
        }
        return super.func_230254_b_(player, hand);
    }

    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        this.setCooldown(compound.func_74762_e("CooldownTicks"));
        this.lockedRotations[0] = compound.func_74760_g("LockedYaw");
        this.lockedRotations[1] = compound.func_74760_g("LockedPitch");
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74768_a("CooldownTicks", this.getCooldown());
        compound.func_74776_a("LockedYaw", this.lockedRotations[0]);
        compound.func_74776_a("LockedPitch", this.lockedRotations[1]);
    }

    public int getCooldown() {
        return (Integer)this.field_70180_af.func_187225_a(COOLDOWN);
    }

    public void setCooldown(int ticks) {
        this.field_70180_af.func_187227_b(COOLDOWN, (Object)ticks);
    }

    public boolean hasCooldown() {
        return this.getCooldown() > 0;
    }

    public Endimation getPlayingEndimation() {
        return this.playingEndimation;
    }

    public int getAnimationTick() {
        return this.animationTick;
    }

    public void setAnimationTick(int animationTick) {
        this.animationTick = animationTick;
    }

    public void setPlayingEndimation(Endimation endimationToPlay) {
        this.onEndimationEnd(this.playingEndimation);
        this.playingEndimation = endimationToPlay;
        this.setAnimationTick(0);
    }

    public ItemStack getBucket() {
        return new ItemStack((IItemProvider)UAItems.JELLYFISH_BUCKET.get());
    }

    public ItemStack getPickedResult(RayTraceResult target) {
        return new ItemStack((IItemProvider)UAItems.JELLYFISH_SPAWN_EGG.get());
    }

    public abstract RotationController getRotationController();

    public abstract void readBucketData(CompoundNBT var1);

    public abstract String getBucketName();

    public abstract JellyTorchBlock.JellyTorchType getJellyTorchType();

    public abstract float getCooldownChance();

    public int getIdSuffix() {
        return this.getJellyTorchType().ordinal();
    }

    public boolean stingEntity(LivingEntity livingEntity) {
        return livingEntity.func_70097_a(UADamageSources.causeJellyfishDamage(this), (float)this.func_110148_a(Attributes.field_233823_f_).func_111126_e());
    }

    public ITextComponent getYieldingTorchMessage() {
        JellyTorchBlock.JellyTorchType torchType = this.getJellyTorchType();
        return new TranslationTextComponent("tooltip.upgrade_aquatic.yielding_jelly_torch").func_240699_a_(TextFormatting.GRAY).func_230529_a_((ITextComponent)new TranslationTextComponent("tooltip.upgrade_aquatic." + torchType.toString().toLowerCase() + "_jelly_torch").func_240699_a_(torchType.color));
    }

    public static ItemStack getTorchByType(JellyTorchBlock.JellyTorchType type) {
        switch (type) {
            default: {
                return new ItemStack((IItemProvider)UABlocks.RED_JELLY_TORCH.get());
            }
            case ORANGE: {
                return new ItemStack((IItemProvider)UABlocks.ORANGE_JELLY_TORCH.get());
            }
            case YELLOW: {
                return new ItemStack((IItemProvider)UABlocks.YELLOW_JELLY_TORCH.get());
            }
            case GREEN: {
                return new ItemStack((IItemProvider)UABlocks.GREEN_JELLY_TORCH.get());
            }
            case BLUE: {
                return new ItemStack((IItemProvider)UABlocks.BLUE_JELLY_TORCH.get());
            }
            case PINK: {
                return new ItemStack((IItemProvider)UABlocks.PINK_JELLY_TORCH.get());
            }
            case PURPLE: {
                return new ItemStack((IItemProvider)UABlocks.PURPLE_JELLY_TORCH.get());
            }
            case WHITE: 
        }
        return new ItemStack((IItemProvider)UABlocks.WHITE_JELLY_TORCH.get());
    }

    public static <J extends AbstractJellyfishEntity> boolean defaultSpawnCondition(EntityType<J> entity, IWorld world, SpawnReason reason, BlockPos pos, Random random) {
        return pos.func_177956_o() > 45 && pos.func_177956_o() < world.func_181545_F();
    }

    public static class BucketData {
        public final String entityId;

        public BucketData(String entityId) {
            this.entityId = entityId;
        }

        public static BucketData read(CompoundNBT compound) {
            return new BucketData(compound.func_74779_i("EntityId"));
        }

        public static CompoundNBT write(BucketData data) {
            CompoundNBT compound = new CompoundNBT();
            compound.func_74778_a("EntityId", data.entityId);
            return compound;
        }
    }

    public static class RotationController {
        private AbstractJellyfishEntity jellyfish;
        private float prevYaw;
        private float yaw;
        private float startingYaw;
        private float prevPitch;
        private float pitch;
        private float startingPitch;
        private float setYaw;
        private float setPitch;
        private int tickLength;
        private int ticksSinceNotRotating;
        public boolean rotating;

        RotationController(AbstractJellyfishEntity jellyfish) {
            this.jellyfish = jellyfish;
        }

        protected void tick() {
            this.prevYaw = this.yaw;
            this.prevPitch = this.pitch;
            if (!this.rotating) {
                ++this.ticksSinceNotRotating;
                if (this.ticksSinceNotRotating > 5) {
                    if (this.setYaw != 0.0f) {
                        this.startingYaw = this.yaw;
                    }
                    if (this.setPitch != 0.0f) {
                        this.startingPitch = this.pitch;
                    }
                    this.setYaw = 0.0f;
                    this.setPitch = 0.0f;
                    this.tickLength = 20;
                }
            }
            this.yaw = this.clamp(this.setYaw - this.startingYaw <= 0.0f, this.yaw + (this.setYaw - this.startingYaw) / (float)this.tickLength, this.startingYaw, this.setYaw);
            this.pitch = this.clamp(this.setPitch - this.startingPitch <= 0.0f, this.pitch + (this.setPitch - this.startingPitch) / (float)this.tickLength, this.startingPitch, this.setPitch);
            this.rotating = false;
        }

        private float clamp(boolean invert, float num, float min, float max) {
            if (invert) {
                return num > max ? num : max;
            }
            if (num < min) {
                return min;
            }
            return num > max ? max : num;
        }

        public void rotate(float yaw, float pitch, int tickLength) {
            if (this.setYaw != yaw) {
                this.startingYaw = this.yaw;
            }
            if (this.setPitch != pitch) {
                this.startingPitch = this.pitch;
            }
            this.setYaw = yaw;
            this.setPitch = pitch;
            this.tickLength = tickLength;
            this.rotating = true;
            this.ticksSinceNotRotating = 0;
            if (!this.jellyfish.field_70170_p.field_72995_K) {
                UpgradeAquatic.CHANNEL.send(PacketDistributor.TRACKING_ENTITY.with(() -> this.jellyfish), (Object)new RotateJellyfishMessage(this.jellyfish.func_145782_y(), tickLength, yaw, pitch));
            }
        }

        public float[] getRotations(float ptc) {
            return new float[]{MathHelper.func_219799_g((float)ptc, (float)this.prevYaw, (float)this.yaw), MathHelper.func_219799_g((float)ptc, (float)this.prevPitch, (float)this.pitch)};
        }

        public void addVelocityForLookDirection(float force, float sizeScale) {
            float[] rotations = this.getRotations(1.0f);
            float yaw = rotations[0] + this.jellyfish.field_70177_z;
            float pitch = rotations[1] - 90.0f;
            float x = -MathHelper.func_76126_a((float)(yaw * ((float)Math.PI / 180))) * MathHelper.func_76134_b((float)(pitch * ((float)Math.PI / 180)));
            float y = -MathHelper.func_76126_a((float)(pitch * ((float)Math.PI / 180)));
            float z = MathHelper.func_76134_b((float)(yaw * ((float)Math.PI / 180))) * MathHelper.func_76134_b((float)(pitch * ((float)Math.PI / 180)));
            Vector3d motion = new Vector3d((double)x, (double)y, (double)z).func_72432_b().func_186678_a((double)force).func_186678_a((double)sizeScale);
            this.jellyfish.func_70024_g(motion.field_72450_a, motion.field_72448_b, motion.field_72449_c);
        }
    }
}

