/*
 * Decompiled with CFR 0.152.
 */
package com.minecraftabnormals.upgrade_aquatic.common.entities.jellyfish;

import com.minecraftabnormals.upgrade_aquatic.common.blocks.JellyTorchBlock;
import com.minecraftabnormals.upgrade_aquatic.common.entities.jellyfish.AbstractJellyfishEntity;
import com.minecraftabnormals.upgrade_aquatic.common.entities.jellyfish.ai.BoxJellyfishHuntGoal;
import com.minecraftabnormals.upgrade_aquatic.common.entities.jellyfish.ai.JellyfishBoostGoal;
import com.minecraftabnormals.upgrade_aquatic.common.entities.jellyfish.ai.JellyfishSwinIntoDirectionGoal;
import com.teamabnormals.abnormals_core.common.entity.ai.PredicateAttackGoal;
import com.teamabnormals.abnormals_core.core.library.endimator.Endimation;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.passive.fish.AbstractFishEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;

public class BoxJellyfishEntity
extends AbstractJellyfishEntity {
    public static final DataParameter<Integer> COLOR = EntityDataManager.func_187226_a(BoxJellyfishEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    public static final DataParameter<Float> SIZE = EntityDataManager.func_187226_a(BoxJellyfishEntity.class, (IDataSerializer)DataSerializers.field_187193_c);
    public static final Endimation SWIM_ANIMATION = new Endimation(20);
    public static final Endimation BOOST_ANIMATION = new Endimation(20);
    private AbstractJellyfishEntity.RotationController rotationController = new AbstractJellyfishEntity.RotationController(this);
    private int huntingCooldown;

    public BoxJellyfishEntity(EntityType<? extends BoxJellyfishEntity> type, World world) {
        super(type, world);
    }

    public static AttributeModifierMap.MutableAttribute registerAttributes() {
        return MobEntity.func_233666_p_().func_233815_a_(Attributes.field_233823_f_, 5.0);
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(COLOR, (Object)0);
        this.field_70180_af.func_187214_a(SIZE, (Object)Float.valueOf(1.0f));
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(1, (Goal)new BoxJellyfishHuntGoal(this));
        this.field_70714_bg.func_75776_a(2, (Goal)new JellyfishSwinIntoDirectionGoal(this, SWIM_ANIMATION));
        this.field_70714_bg.func_75776_a(3, (Goal)new JellyfishBoostGoal(this, BOOST_ANIMATION));
        this.field_70715_bh.func_75776_a(1, (Goal)new PredicateAttackGoal((MobEntity)this, AbstractFishEntity.class, 150, true, true, null, owner -> !((BoxJellyfishEntity)((Object)owner)).hasCooldown() && !((BoxJellyfishEntity)((Object)owner)).hasHuntingCooldown()));
    }

    public void func_184206_a(DataParameter<?> key) {
        super.func_184206_a(key);
        if (SIZE.equals(key)) {
            this.func_213323_x_();
        }
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.hasHuntingCooldown()) {
            --this.huntingCooldown;
        }
        if (this.isEndimationPlaying(BOOST_ANIMATION) && this.func_70090_H()) {
            this.func_213317_d(this.func_213322_ci().func_186678_a((double)1.15f));
        }
    }

    public void onEndimationStart(Endimation endimation) {
        if (endimation == SWIM_ANIMATION) {
            this.getRotationController().addVelocityForLookDirection(0.6f, this.getSize());
        } else if (endimation == BOOST_ANIMATION) {
            this.getRotationController().addVelocityForLookDirection(0.25f, this.getSize());
        }
    }

    @Override
    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        this.setColor(MathHelper.func_76125_a((int)compound.func_74762_e("JellyColor"), (int)0, (int)2));
        this.huntingCooldown = compound.func_74762_e("HuntingCooldown");
        this.setSize(compound.func_74760_g("Size"), false);
    }

    @Override
    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74768_a("JellyColor", this.getColor());
        compound.func_74768_a("HuntingCooldown", this.huntingCooldown);
        compound.func_74776_a("Size", this.getSize());
    }

    public ILivingEntityData func_213386_a(IWorld worldIn, DifficultyInstance difficultyIn, SpawnReason reason, ILivingEntityData spawnDataIn, CompoundNBT dataTag) {
        spawnDataIn = super.func_213386_a(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
        boolean updateSize = false;
        float size = this.func_70681_au().nextFloat() < 0.85f ? 1.0f : (this.func_70681_au().nextBoolean() ? 0.5f : 0.65f);
        int color = this.func_70681_au().nextInt(3);
        if (dataTag == null || !this.isFromBucket()) {
            if (spawnDataIn instanceof SpawnData) {
                size = ((SpawnData)spawnDataIn).size;
                color = ((SpawnData)spawnDataIn).color;
            } else if (!this.isFromBucket()) {
                spawnDataIn = new SpawnData(size, color);
                updateSize = true;
            }
        }
        this.setSize(size, updateSize);
        this.setColor(color);
        return spawnDataIn;
    }

    public EntitySize func_213305_a(Pose pose) {
        return super.func_213305_a(pose).func_220313_a(this.getSize());
    }

    public int getColor() {
        return (Integer)this.field_70180_af.func_187225_a(COLOR);
    }

    public void setColor(int color) {
        this.field_70180_af.func_187227_b(COLOR, (Object)color);
    }

    public void setHuntingCooldown() {
        this.huntingCooldown = this.func_70681_au().nextInt(1600) + 1200;
    }

    public boolean hasHuntingCooldown() {
        return this.huntingCooldown > 0;
    }

    public float getSize() {
        return ((Float)this.field_70180_af.func_187225_a(SIZE)).floatValue();
    }

    public void setSize(float size, boolean updateHealth) {
        this.field_70180_af.func_187227_b(SIZE, (Object)Float.valueOf(size));
        this.func_110148_a(Attributes.field_233818_a_).func_111128_a(8.0 * (double)size);
        if (updateHealth) {
            this.func_70606_j(this.func_110138_aP());
        }
    }

    protected float func_213348_b(Pose poseIn, EntitySize size) {
        return size.field_220316_b * 0.5f;
    }

    protected void setBucketData(ItemStack bucket) {
        if (this.func_145818_k_()) {
            bucket.func_200302_a(this.func_200201_e());
        }
        BoxJellyfishBucketData data = new BoxJellyfishBucketData(this.getColor(), this.getSize());
        bucket.func_196082_o().func_218657_a("JellyfishTag", (INBT)BoxJellyfishBucketData.write(data));
    }

    @Override
    public String getBucketName() {
        switch (this.getColor()) {
            default: {
                return "box";
            }
            case 1: {
                return "red_box";
            }
            case 2: 
        }
        return "white_box";
    }

    @Override
    public JellyTorchBlock.JellyTorchType getJellyTorchType() {
        switch (this.getColor()) {
            default: {
                return JellyTorchBlock.JellyTorchType.BLUE;
            }
            case 1: {
                return JellyTorchBlock.JellyTorchType.RED;
            }
            case 2: 
        }
        return JellyTorchBlock.JellyTorchType.WHITE;
    }

    @Override
    public float getCooldownChance() {
        return this.getSize() >= 1.0f ? 0.05f : (this.getSize() < 0.5f ? 0.1f : 0.15f);
    }

    @Override
    public boolean stingEntity(LivingEntity livingEntity) {
        if (super.stingEntity(livingEntity)) {
            livingEntity.func_195064_c(new EffectInstance(Effects.field_76436_u, 600, 1));
            if (this.func_70638_az() == null) {
                this.func_70624_b(livingEntity);
            }
            return true;
        }
        return false;
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if (super.func_70097_a(source, amount)) {
            Entity entity = source.func_76346_g();
            if (!(!(entity instanceof LivingEntity) || this.func_70638_az() != null || ((LivingEntity)entity).func_175149_v() || entity instanceof PlayerEntity && ((PlayerEntity)entity).func_184812_l_())) {
                this.func_70624_b((LivingEntity)entity);
            }
            return true;
        }
        return false;
    }

    @Override
    public void readBucketData(CompoundNBT compound) {
        BoxJellyfishBucketData jellyData = BoxJellyfishBucketData.read(compound);
        this.setColor(jellyData.color);
        this.setSize(jellyData.size, true);
    }

    public Endimation[] getEndimations() {
        return new Endimation[]{SWIM_ANIMATION, BOOST_ANIMATION};
    }

    @Override
    public AbstractJellyfishEntity.RotationController getRotationController() {
        return this.rotationController;
    }

    public int func_70641_bl() {
        return 3;
    }

    public static class BoxJellyfishBucketData
    extends AbstractJellyfishEntity.BucketData {
        private final int color;
        private final float size;

        public BoxJellyfishBucketData(int color, float size) {
            super("box_jellyfish");
            this.color = color;
            this.size = size;
        }

        public static BoxJellyfishBucketData read(CompoundNBT compound) {
            return new BoxJellyfishBucketData(compound.func_74762_e("Color"), compound.func_74760_g("Size"));
        }

        public static CompoundNBT write(BoxJellyfishBucketData data) {
            CompoundNBT compound = new CompoundNBT();
            compound.func_74778_a("EntityId", data.entityId);
            compound.func_74768_a("Color", data.color);
            compound.func_74776_a("Size", data.size);
            return compound;
        }
    }

    class SpawnData
    implements ILivingEntityData {
        public final float size;
        public final int color;

        public SpawnData(float size, int color) {
            this.size = size;
            this.color = color;
        }
    }
}

