/*
 * Decompiled with CFR 0.152.
 */
package com.minecraftabnormals.upgrade_aquatic.common.entities.jellyfish;

import com.minecraftabnormals.upgrade_aquatic.common.blocks.JellyTorchBlock;
import com.minecraftabnormals.upgrade_aquatic.common.entities.jellyfish.AbstractJellyfishEntity;
import com.minecraftabnormals.upgrade_aquatic.common.entities.jellyfish.ai.CassiopeaHideInSeagrassGoal;
import com.minecraftabnormals.upgrade_aquatic.common.entities.jellyfish.ai.CassiopeaJellyfishFlipGoal;
import com.minecraftabnormals.upgrade_aquatic.common.entities.jellyfish.ai.JellyfishBoostGoal;
import com.minecraftabnormals.upgrade_aquatic.common.entities.jellyfish.ai.JellyfishSwinIntoDirectionGoal;
import com.minecraftabnormals.upgrade_aquatic.core.other.UADamageSources;
import com.teamabnormals.abnormals_core.core.library.endimator.Endimation;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;

public class CassiopeaJellyfishEntity
extends AbstractJellyfishEntity {
    public static final DataParameter<Integer> COLOR = EntityDataManager.func_187226_a(CassiopeaJellyfishEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    public static final DataParameter<Float> SIZE = EntityDataManager.func_187226_a(CassiopeaJellyfishEntity.class, (IDataSerializer)DataSerializers.field_187193_c);
    public static final Endimation SWIM_ANIMATION = new Endimation(20);
    public static final Endimation BOOST_ANIMATION = new Endimation(20);
    private AbstractJellyfishEntity.RotationController rotationController = new AbstractJellyfishEntity.RotationController(this);
    public int upsideDownCooldown;
    public int hideCooldown;

    public CassiopeaJellyfishEntity(EntityType<? extends AbstractJellyfishEntity> type, World world) {
        super(type, world);
    }

    public static AttributeModifierMap.MutableAttribute registerAttributes() {
        return MobEntity.func_233666_p_().func_233815_a_(Attributes.field_233823_f_, 1.0);
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(COLOR, (Object)0);
        this.field_70180_af.func_187214_a(SIZE, (Object)Float.valueOf(0.85f));
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(1, (Goal)new CassiopeaHideInSeagrassGoal(this));
        this.field_70714_bg.func_75776_a(2, (Goal)new CassiopeaJellyfishFlipGoal(this));
        this.field_70714_bg.func_75776_a(2, (Goal)new JellyfishSwinIntoDirectionGoal(this, SWIM_ANIMATION));
        this.field_70714_bg.func_75776_a(3, (Goal)new JellyfishBoostGoal(this, BOOST_ANIMATION));
        this.field_70715_bh.func_75776_a(2, (Goal)new HurtByTargetGoal((CreatureEntity)this, new Class[0]));
    }

    public void func_184206_a(DataParameter<?> key) {
        super.func_184206_a(key);
        if (SIZE.equals(key)) {
            this.func_213323_x_();
        }
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.hasUpsideDownCooldown()) {
            --this.upsideDownCooldown;
        }
        if (this.hasHideCooldown()) {
            --this.hideCooldown;
        }
        if (this.isEndimationPlaying(BOOST_ANIMATION) && this.func_70090_H()) {
            this.func_213317_d(this.func_213322_ci().func_186678_a((double)1.15f));
        }
    }

    public ILivingEntityData func_213386_a(IWorld worldIn, DifficultyInstance difficultyIn, SpawnReason reason, ILivingEntityData spawnDataIn, CompoundNBT dataTag) {
        spawnDataIn = super.func_213386_a(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
        boolean updateSize = false;
        float size = this.func_70681_au().nextFloat() < 0.9f ? 1.0f : 0.425f;
        int color = this.func_70681_au().nextInt(3);
        if (dataTag == null || !this.isFromBucket()) {
            if (spawnDataIn instanceof SpawnData) {
                size = ((SpawnData)spawnDataIn).size;
                color = ((SpawnData)spawnDataIn).color;
            } else if (!this.isFromBucket()) {
                spawnDataIn = new SpawnData(size, color);
                updateSize = true;
            }
        }
        this.setSize(size, updateSize);
        this.setColor(color);
        return spawnDataIn;
    }

    @Override
    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        this.setColor(MathHelper.func_76125_a((int)compound.func_74762_e("JellyColor"), (int)0, (int)2));
        this.setSize(compound.func_74760_g("Size"), false);
        this.upsideDownCooldown = compound.func_74762_e("UpsideDownCooldown");
        this.hideCooldown = compound.func_74762_e("HideCooldown");
    }

    @Override
    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74768_a("JellyColor", this.getColor());
        compound.func_74776_a("Size", this.getSize());
        compound.func_74768_a("UpsideDownCooldown", this.upsideDownCooldown);
        compound.func_74768_a("HideCooldown", this.hideCooldown);
    }

    public EntitySize func_213305_a(Pose pose) {
        return super.func_213305_a(pose).func_220313_a(this.getSize());
    }

    public int getColor() {
        return (Integer)this.field_70180_af.func_187225_a(COLOR);
    }

    public void setColor(int color) {
        this.field_70180_af.func_187227_b(COLOR, (Object)color);
    }

    public float getSize() {
        return ((Float)this.field_70180_af.func_187225_a(SIZE)).floatValue();
    }

    public void setSize(float size, boolean updateHealth) {
        this.field_70180_af.func_187227_b(SIZE, (Object)Float.valueOf(size));
        this.func_110148_a(Attributes.field_233818_a_).func_111128_a(6.0 * (double)size);
        if (updateHealth) {
            this.func_70606_j(this.func_110138_aP());
        }
    }

    public boolean hasUpsideDownCooldown() {
        return this.upsideDownCooldown > 0;
    }

    public boolean hasHideCooldown() {
        return this.hideCooldown > 0;
    }

    protected float func_213348_b(Pose poseIn, EntitySize size) {
        return size.field_220316_b * 0.5f;
    }

    public Endimation[] getEndimations() {
        return new Endimation[]{BOOST_ANIMATION, SWIM_ANIMATION};
    }

    public void onEndimationStart(Endimation endimation) {
        float sizeForce;
        float f = sizeForce = this.getSize() < 0.6f ? 0.85f : this.getSize();
        if (endimation == SWIM_ANIMATION) {
            this.getRotationController().addVelocityForLookDirection(0.3f, sizeForce);
        } else if (endimation == BOOST_ANIMATION) {
            this.getRotationController().addVelocityForLookDirection(0.2f, sizeForce);
        }
    }

    @Override
    public AbstractJellyfishEntity.RotationController getRotationController() {
        return this.rotationController;
    }

    protected void setBucketData(ItemStack bucket) {
        if (this.func_145818_k_()) {
            bucket.func_200302_a(this.func_200201_e());
        }
        CassiopeaJellyfishData data = new CassiopeaJellyfishData(this.getColor(), this.getSize());
        bucket.func_196082_o().func_218657_a("JellyfishTag", (INBT)CassiopeaJellyfishData.write(data));
    }

    @Override
    public void readBucketData(CompoundNBT compound) {
        CassiopeaJellyfishData jellyData = CassiopeaJellyfishData.read(compound);
        this.setColor(jellyData.color);
        this.setSize(jellyData.size, true);
    }

    @Override
    public String getBucketName() {
        switch (this.getColor()) {
            default: {
                return "cassiopea";
            }
            case 1: {
                return "blue_cassiopea";
            }
            case 2: 
        }
        return "white_cassiopea";
    }

    @Override
    public JellyTorchBlock.JellyTorchType getJellyTorchType() {
        switch (this.getColor()) {
            default: {
                return JellyTorchBlock.JellyTorchType.GREEN;
            }
            case 1: {
                return JellyTorchBlock.JellyTorchType.BLUE;
            }
            case 2: 
        }
        return JellyTorchBlock.JellyTorchType.WHITE;
    }

    @Override
    public float getCooldownChance() {
        return this.getSize() < 1.0f ? 0.9f : 0.8f;
    }

    @Override
    public boolean stingEntity(LivingEntity livingEntity) {
        if ((this.func_70638_az() == livingEntity || this.func_70643_av() == livingEntity) && this.func_70681_au().nextFloat() < 0.5f) {
            return livingEntity.func_70097_a(UADamageSources.causeJellyfishDamage(this), (float)this.func_110148_a(Attributes.field_233823_f_).func_111126_e());
        }
        return false;
    }

    public int func_70641_bl() {
        return 3;
    }

    public static class CassiopeaJellyfishData
    extends AbstractJellyfishEntity.BucketData {
        private final int color;
        private final float size;

        public CassiopeaJellyfishData(int color, float size) {
            super("cassiopea_jellyfish");
            this.color = color;
            this.size = size;
        }

        public static CassiopeaJellyfishData read(CompoundNBT compound) {
            return new CassiopeaJellyfishData(compound.func_74762_e("Color"), compound.func_74760_g("Size"));
        }

        public static CompoundNBT write(CassiopeaJellyfishData data) {
            CompoundNBT compound = new CompoundNBT();
            compound.func_74778_a("EntityId", data.entityId);
            compound.func_74768_a("Color", data.color);
            compound.func_74776_a("Size", data.size);
            return compound;
        }
    }

    class SpawnData
    implements ILivingEntityData {
        public final float size;
        public final int color;

        public SpawnData(float size, int color) {
            this.size = size;
            this.color = color;
        }
    }
}

