/*
 * Decompiled with CFR 0.152.
 */
package com.minecraftabnormals.upgrade_aquatic.common.entities.thrasher;

import com.minecraftabnormals.upgrade_aquatic.api.EndimatedMonsterEntity;
import com.minecraftabnormals.upgrade_aquatic.common.entities.LionfishEntity;
import com.minecraftabnormals.upgrade_aquatic.common.entities.thrasher.GreatThrasherEntity;
import com.minecraftabnormals.upgrade_aquatic.common.entities.thrasher.ai.ThrasherFindDetectionPointGoal;
import com.minecraftabnormals.upgrade_aquatic.common.entities.thrasher.ai.ThrasherFireSonarGoal;
import com.minecraftabnormals.upgrade_aquatic.common.entities.thrasher.ai.ThrasherGrabGoal;
import com.minecraftabnormals.upgrade_aquatic.common.entities.thrasher.ai.ThrasherRandomSwimGoal;
import com.minecraftabnormals.upgrade_aquatic.common.entities.thrasher.ai.ThrasherThrashGoal;
import com.minecraftabnormals.upgrade_aquatic.core.registry.UAEntities;
import com.minecraftabnormals.upgrade_aquatic.core.registry.UAItems;
import com.minecraftabnormals.upgrade_aquatic.core.registry.UASounds;
import com.teamabnormals.abnormals_core.core.library.endimator.ControlledEndimation;
import com.teamabnormals.abnormals_core.core.library.endimator.Endimation;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.UUID;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.CreatureAttribute;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.Pose;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.attributes.ModifiableAttributeInstance;
import net.minecraft.entity.ai.controller.LookController;
import net.minecraft.entity.ai.controller.MovementController;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.passive.SquidEntity;
import net.minecraft.entity.passive.WaterMobEntity;
import net.minecraft.entity.passive.fish.PufferfishEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.pathfinding.PathNavigator;
import net.minecraft.pathfinding.SwimmerPathNavigator;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.biome.DeepFrozenOceanBiome;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class ThrasherEntity
extends EndimatedMonsterEntity {
    public static final Predicate<Entity> ENEMY_MATCHER = entity -> {
        if (entity == null) {
            return false;
        }
        if (entity instanceof PlayerEntity && !((PlayerEntity)entity).func_184812_l_() && !((PlayerEntity)entity).func_175149_v()) {
            return entity.func_70090_H();
        }
        return entity instanceof WaterMobEntity && !(entity instanceof IMob) && !(entity instanceof ThrasherEntity) && !(entity instanceof PufferfishEntity) && !(entity instanceof SquidEntity) && !(entity instanceof LionfishEntity) && entity.func_70090_H();
    };
    private static final UUID KNOCKBACK_RESISTANCE_MODIFIER_ID = UUID.fromString("3158fbca-89d7-4c15-b1ee-448cefd023b7");
    private static final AttributeModifier KNOCKBACK_RESISTANCE_MODIFIER = new AttributeModifier(KNOCKBACK_RESISTANCE_MODIFIER_ID, "Knockback Resistance", 4.0, AttributeModifier.Operation.MULTIPLY_BASE);
    private static final DataParameter<Boolean> MOVING = EntityDataManager.func_187226_a(ThrasherEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Integer> WATER_TIME = EntityDataManager.func_187226_a(ThrasherEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> STUN_TIME = EntityDataManager.func_187226_a(ThrasherEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> HITS_TILL_STUN = EntityDataManager.func_187226_a(ThrasherEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Optional<BlockPos>> POSSIBLE_DETECTION_POINT = EntityDataManager.func_187226_a(ThrasherEntity.class, (IDataSerializer)DataSerializers.field_187201_k);
    public static final Endimation SNAP_AT_PRAY_ANIMATION = new Endimation(10);
    public static final Endimation HURT_ANIMATION = new Endimation(10);
    public static final Endimation THRASH_ANIMATION = new Endimation(55);
    public static final Endimation SONAR_FIRE_ANIMATION = new Endimation(30);
    public final ControlledEndimation STUNNED_ANIMATION = new ControlledEndimation(10, 10);
    protected int ticksSinceLastSonarFire;
    protected float prevTailAnimation;
    protected float tailAnimation;
    protected float tailSpeed;
    protected float prevFinAnimation;
    protected float finAnimation;
    protected float finSpeed;

    public ThrasherEntity(EntityType<? extends ThrasherEntity> type, World world) {
        super(type, world);
        this.field_70728_aV = 30;
        this.field_70765_h = new ThrasherMoveController(this);
        this.field_70749_g = new ThrasherLookController(this);
        this.prevTailAnimation = this.tailAnimation = this.field_70146_Z.nextFloat();
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(1, (Goal)new ThrasherThrashGoal(this));
        this.field_70714_bg.func_75776_a(2, (Goal)new ThrasherFireSonarGoal(this));
        this.field_70714_bg.func_75776_a(3, (Goal)new ThrasherFindDetectionPointGoal(this));
        this.field_70714_bg.func_75776_a(4, (Goal)new ThrasherGrabGoal(this, 2.5, true));
        this.field_70714_bg.func_75776_a(5, (Goal)new ThrasherRandomSwimGoal(this, 1.1, 15));
    }

    public static AttributeModifierMap.MutableAttribute registerAttributes() {
        return MobEntity.func_233666_p_().func_233815_a_(Attributes.field_233823_f_, 5.0).func_233815_a_(Attributes.field_233821_d_, 0.55).func_233815_a_(Attributes.field_233819_b_, 32.0).func_233815_a_(Attributes.field_233818_a_, 50.0).func_233815_a_(Attributes.field_233820_c_, 1.25).func_233815_a_(Attributes.field_233826_i_, 8.0);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(MOVING, (Object)false);
        this.field_70180_af.func_187214_a(WATER_TIME, (Object)2500);
        this.field_70180_af.func_187214_a(STUN_TIME, (Object)0);
        this.field_70180_af.func_187214_a(HITS_TILL_STUN, (Object)0);
        this.field_70180_af.func_187214_a(POSSIBLE_DETECTION_POINT, Optional.empty());
    }

    public CreatureAttribute func_70668_bt() {
        return CreatureAttribute.field_203100_e;
    }

    public Endimation[] getEndimations() {
        return new Endimation[]{SNAP_AT_PRAY_ANIMATION, HURT_ANIMATION, THRASH_ANIMATION, SONAR_FIRE_ANIMATION};
    }

    public Endimation getHurtAnimation() {
        return HURT_ANIMATION;
    }

    @Nullable
    public ILivingEntityData func_213386_a(IWorld worldIn, DifficultyInstance difficultyIn, SpawnReason reason, @Nullable ILivingEntityData spawnDataIn, @Nullable CompoundNBT dataTag) {
        Random rand;
        this.func_70050_g(this.func_205010_bg());
        if (reason == SpawnReason.NATURAL && worldIn.func_226691_t_(this.func_233580_cy_()) instanceof DeepFrozenOceanBiome && (rand = new Random()).nextFloat() < 0.25f) {
            GreatThrasherEntity greatThrasher = (GreatThrasherEntity)((EntityType)UAEntities.GREAT_THRASHER.get()).func_200721_a(this.field_70170_p);
            greatThrasher.func_70012_b(this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), this.field_70177_z, this.field_70125_A);
            this.field_70170_p.func_217376_c((Entity)greatThrasher);
            this.func_70106_y();
        }
        return super.func_213386_a(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
    }

    public void func_184206_a(DataParameter<?> key) {
        if (HITS_TILL_STUN.equals(key) && this.field_70173_aa > 10 && this.getHitsLeftTillStun() == 0) {
            this.setStunned((this.func_70681_au().nextInt(2) + 2) * 20 + this.func_70681_au().nextInt(10));
        }
        super.func_184206_a(key);
    }

    public void func_184232_k(Entity passenger) {
        if (passenger instanceof LivingEntity) {
            float distance = this.getMountDistance();
            double dx = Math.cos((double)(this.field_70177_z + 90.0f) * Math.PI / 180.0) * (double)distance;
            double dy = -Math.sin((double)this.field_70125_A * (Math.PI / 180));
            double dz = Math.sin((double)(this.field_70177_z + 90.0f) * Math.PI / 180.0) * (double)distance;
            Vector3d riderPos = new Vector3d(this.func_226277_ct_() + dx, this.func_226278_cu_(), this.func_226281_cx_() + dz);
            double offset = passenger instanceof PlayerEntity ? this.func_70042_X() - 0.2 : this.func_70042_X() - 0.5;
            passenger.func_70107_b(riderPos.field_72450_a, this.func_226278_cu_() + dy + offset, riderPos.field_72449_c);
        } else {
            super.func_184232_k(passenger);
        }
    }

    public float getMountDistance() {
        return 1.2f;
    }

    public double func_70042_X() {
        return 0.5;
    }

    public boolean shouldRiderFaceForward(PlayerEntity player) {
        return true;
    }

    public boolean canRiderInteract() {
        return true;
    }

    public boolean shouldRiderSit() {
        return false;
    }

    public boolean func_205019_a(IWorldReader worldIn) {
        return worldIn.func_226668_i_((Entity)this);
    }

    public void onEndimationStart(Endimation animationStarted) {
        ModifiableAttributeInstance knockbackResistance;
        if (animationStarted == THRASH_ANIMATION && !(knockbackResistance = this.func_110148_a(Attributes.field_233820_c_)).func_180374_a(KNOCKBACK_RESISTANCE_MODIFIER)) {
            knockbackResistance.func_233767_b_(KNOCKBACK_RESISTANCE_MODIFIER);
        }
    }

    public void onEndimationEnd(Endimation animationEnded) {
        ModifiableAttributeInstance knockbackResistance;
        if (animationEnded == THRASH_ANIMATION && (knockbackResistance = this.func_110148_a(Attributes.field_233820_c_)).func_180374_a(KNOCKBACK_RESISTANCE_MODIFIER)) {
            knockbackResistance.func_111124_b(KNOCKBACK_RESISTANCE_MODIFIER);
        }
    }

    public void func_203004_j(boolean downwards) {
    }

    public void func_203002_i(boolean downwards) {
    }

    @Override
    public boolean func_70097_a(DamageSource source, float amount) {
        Entity entitySource = source.func_76346_g();
        if (entitySource instanceof LivingEntity) {
            Vector3d difference = new Vector3d(entitySource.func_226277_ct_() - this.func_226277_ct_(), entitySource.func_226278_cu_() - this.func_226278_cu_(), entitySource.func_226281_cx_() - this.func_226281_cx_());
            if (difference.func_72433_c() <= 8.0) {
                if (entitySource.func_70090_H()) {
                    if (entitySource instanceof PlayerEntity && !((PlayerEntity)entitySource).func_184812_l_() && !((PlayerEntity)entitySource).func_175149_v()) {
                        this.func_70624_b((LivingEntity)entitySource);
                    } else if (!(entitySource instanceof PlayerEntity)) {
                        this.func_70624_b((LivingEntity)entitySource);
                    }
                }
                if (this.getHitsLeftTillStun() > 0) {
                    int chance;
                    int difficultyDividend = 0;
                    switch (this.field_70170_p.func_175659_aa()) {
                        default: {
                            difficultyDividend = 10;
                            break;
                        }
                        case NORMAL: {
                            difficultyDividend = 12;
                            break;
                        }
                        case HARD: {
                            difficultyDividend = 16;
                        }
                    }
                    int n = chance = (double)amount >= this.getStunDamageThreshold() ? 1 : difficultyDividend / (int)Math.max(1.0f, amount);
                    if (this.func_70681_au().nextInt(chance) == 0) {
                        this.setHitsTillStun(this.getHitsLeftTillStun() - 1);
                    }
                }
            } else if (entitySource instanceof PlayerEntity && !((PlayerEntity)entitySource).func_184812_l_() && !((PlayerEntity)entitySource).func_175149_v()) {
                this.setPossibleDetectionPoint(entitySource.func_233580_cy_().func_177982_a(this.func_70681_au().nextInt(2), this.func_70681_au().nextInt(2), this.func_70681_au().nextInt(2)));
            } else if (!(entitySource instanceof PlayerEntity)) {
                this.setPossibleDetectionPoint(entitySource.func_233580_cy_().func_177982_a(this.func_70681_au().nextInt(2), this.func_70681_au().nextInt(2), this.func_70681_au().nextInt(2)));
            }
        }
        return super.func_70097_a(source, amount);
    }

    protected PathNavigator func_175447_b(World worldIn) {
        return new SwimmerPathNavigator((MobEntity)this, worldIn);
    }

    public int func_205010_bg() {
        return 4950;
    }

    protected int func_207300_l(int currentAir) {
        return this.func_205010_bg();
    }

    protected float func_213348_b(Pose poseIn, EntitySize sizeIn) {
        return 0.65f;
    }

    public int func_70646_bf() {
        return 1;
    }

    public int func_184649_cE() {
        return 1;
    }

    public boolean func_205710_ba() {
        return true;
    }

    public boolean func_70648_aU() {
        return true;
    }

    @OnlyIn(value=Dist.CLIENT)
    public float getTailAnimation(float ptc) {
        return MathHelper.func_219799_g((float)ptc, (float)this.prevTailAnimation, (float)this.tailAnimation);
    }

    @OnlyIn(value=Dist.CLIENT)
    public float getFinAnimation(float ptc) {
        return MathHelper.func_219799_g((float)ptc, (float)this.prevFinAnimation, (float)this.finAnimation);
    }

    public void func_213352_e(Vector3d p_213352_1_) {
        if (this.func_70613_aW() && this.func_70090_H()) {
            this.func_213309_a(0.1f, p_213352_1_);
            this.func_213315_a(MoverType.SELF, this.func_213322_ci());
            this.func_213317_d(this.func_213322_ci().func_186678_a(0.9));
            if (!this.isMoving() && this.func_70638_az() == null) {
                double ySpeed = !((ThrasherLookController)this.func_70671_ap()).isTurningForSonar() ? -0.005 : -0.0025;
                this.func_213317_d(this.func_213322_ci().func_72441_c(0.0, ySpeed, 0.0));
            }
        } else {
            super.func_213352_e(p_213352_1_);
        }
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.func_70638_az() != null && !this.func_70638_az().func_70089_S() && this.ticksSinceLastSonarFire >= 55 && this.func_70681_au().nextFloat() < 0.05f) {
            this.func_70624_b(null);
        }
        if (!this.func_175446_cd()) {
            this.ticksSinceLastSonarFire = this.isEndimationPlaying(SONAR_FIRE_ANIMATION) ? 0 : ++this.ticksSinceLastSonarFire;
            if (this.func_203008_ap()) {
                this.setWaterTime(2400);
            } else {
                this.setWaterTime(this.getWaterTime() - 1);
                if (this.getWaterTime() <= 0) {
                    this.func_70097_a(DamageSource.field_205132_u, 1.0f);
                }
                if (!this.func_70090_H() && !this.isStunned() && this.field_70122_E) {
                    this.func_213317_d(this.func_213322_ci().func_72441_c((double)((this.field_70146_Z.nextFloat() * 2.0f - 1.0f) * 0.2f), 0.5, (double)((this.field_70146_Z.nextFloat() * 2.0f - 1.0f) * 0.2f)));
                    this.field_70177_z = this.field_70146_Z.nextFloat() * 360.0f;
                    this.field_70125_A = this.field_70146_Z.nextFloat() * -50.0f;
                    this.field_70122_E = false;
                    this.field_70160_al = true;
                    this.func_184185_a(this.getFlopSound(), this.func_70599_aP(), this.func_70647_i());
                }
            }
            if (this.isWorldRemote() && !this.func_184188_bt().isEmpty() && this.isEndimationPlaying(THRASH_ANIMATION) && this.getAnimationTick() % 2 == 0 && this.getAnimationTick() > 5) {
                Entity passenger = (Entity)this.func_184188_bt().get(0);
                for (int i = 0; i < 3; ++i) {
                    if (!passenger.func_208600_a((ITag)FluidTags.field_206959_a)) continue;
                    this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197612_e, passenger.func_226277_ct_() + (this.func_70681_au().nextDouble() - 0.5) * (double)passenger.func_213311_cf(), passenger.func_226278_cu_(), passenger.func_226281_cx_() + (this.func_70681_au().nextDouble() - 0.5) * (double)passenger.func_213311_cf(), (this.func_70681_au().nextDouble() - 0.5) * 2.0, -this.func_70681_au().nextDouble(), (this.func_70681_au().nextDouble() - 0.5) * 2.0);
                }
            }
            if (!this.field_70170_p.field_72995_K && this.isStunned()) {
                if (!this.func_184188_bt().isEmpty()) {
                    this.func_184226_ay();
                }
                this.setStunned(this.getStunTime() - 1);
            }
        }
    }

    @Override
    public void func_70636_d() {
        if (this.func_70089_S()) {
            if (this.field_70170_p.field_72995_K) {
                this.prevTailAnimation = this.tailAnimation;
                this.prevFinAnimation = this.finAnimation;
                this.STUNNED_ANIMATION.update();
                if (!this.func_70090_H() || this.isEndimationPlaying(THRASH_ANIMATION) || this.isEndimationPlaying(SONAR_FIRE_ANIMATION)) {
                    this.tailSpeed = 1.1f;
                    this.finSpeed = 0.875f;
                } else if (this.isMoving()) {
                    this.tailSpeed = this.tailSpeed < 0.5f ? 2.2f : (this.tailSpeed += (0.25f - this.tailSpeed) * 0.1f);
                    this.finSpeed = this.finSpeed < 0.5f ? 0.875f : (this.finSpeed += (0.045f - this.tailSpeed) * 0.05f);
                } else {
                    this.tailSpeed += (0.125f - this.tailSpeed) * 0.1f;
                    this.finSpeed += (0.01125f - this.finSpeed) * 0.05f;
                }
                if (this.isStunned()) {
                    if (this.STUNNED_ANIMATION.getTick() >= 10) {
                        this.STUNNED_ANIMATION.setDecrementing(true);
                    } else if (this.STUNNED_ANIMATION.isDecrementing() && this.STUNNED_ANIMATION.getTick() <= 0) {
                        this.STUNNED_ANIMATION.setDecrementing(false);
                    }
                } else {
                    this.STUNNED_ANIMATION.setDecrementing(false);
                }
                this.STUNNED_ANIMATION.tick();
                this.tailAnimation += this.tailSpeed;
                this.finAnimation += this.finSpeed;
            }
            if (!this.isStunned()) {
                List nearbyEntities = this.field_70170_p.func_175647_a(LivingEntity.class, this.func_174813_aQ().func_186662_g(0.5), ENEMY_MATCHER);
                for (LivingEntity entities : nearbyEntities) {
                    if (this.func_70638_az() != null) continue;
                    this.func_70624_b(entities);
                }
            }
            if (this.isMoving() && this.func_70090_H()) {
                Vector3d vec3d1 = this.func_70676_i(0.0f);
                for (int i = 0; i < 2; ++i) {
                    this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197612_e, this.func_226277_ct_() + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.func_213311_cf() - vec3d1.field_72450_a * 1.5, this.func_226278_cu_() + this.field_70146_Z.nextDouble() * (double)this.func_213302_cg() - vec3d1.field_72448_b * 1.5, this.func_226281_cx_() + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.func_213311_cf() - vec3d1.field_72449_c * 1.5, 0.0, 0.0, 0.0);
                }
            }
        }
        super.func_70636_d();
    }

    public ItemStack getPickedResult(RayTraceResult target) {
        return new ItemStack((IItemProvider)UAItems.THRASHER_SPAWN_EGG.get());
    }

    @Override
    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return this.func_70090_H() ? (SoundEvent)UASounds.THRASHER_HURT.get() : (SoundEvent)UASounds.THRASHER_HURT_LAND.get();
    }

    @Override
    protected SoundEvent func_184615_bR() {
        return this.func_70090_H() ? (SoundEvent)UASounds.THRASHER_DEATH.get() : (SoundEvent)UASounds.THRASHER_DEATH_LAND.get();
    }

    @Nullable
    protected SoundEvent func_184639_G() {
        if (this.isEndimationPlaying(THRASH_ANIMATION)) {
            return null;
        }
        return this.func_70090_H() ? (SoundEvent)UASounds.THRASHER_AMBIENT.get() : (SoundEvent)UASounds.THRASHER_AMBIENT_LAND.get();
    }

    protected SoundEvent getFlopSound() {
        return (SoundEvent)UASounds.THRASHER_FLOP.get();
    }

    public SoundEvent getSonarFireSound() {
        return (SoundEvent)UASounds.THRASHER_SONAR_FIRE.get();
    }

    public SoundEvent getThrashingSound() {
        return (SoundEvent)UASounds.THRASHER_THRASH.get();
    }

    @Override
    protected SoundEvent func_184184_Z() {
        return SoundEvents.field_205211_bb;
    }

    protected void func_180429_a(BlockPos pos, BlockState blockIn) {
    }

    public int func_70627_aG() {
        return 100;
    }

    protected double getStunDamageThreshold() {
        return 6.0;
    }

    public int func_70641_bl() {
        return 1;
    }

    public boolean isMoving() {
        return (Boolean)this.field_70180_af.func_187225_a(MOVING);
    }

    private void setMoving(boolean moving) {
        this.field_70180_af.func_187227_b(MOVING, (Object)moving);
    }

    public int getWaterTime() {
        return (Integer)this.field_70180_af.func_187225_a(WATER_TIME);
    }

    public void setWaterTime(int ticks) {
        this.field_70180_af.func_187227_b(WATER_TIME, (Object)ticks);
    }

    public int getStunTime() {
        return (Integer)this.field_70180_af.func_187225_a(STUN_TIME);
    }

    private void setStunned(int ticks) {
        this.field_70180_af.func_187227_b(STUN_TIME, (Object)ticks);
    }

    public int getHitsLeftTillStun() {
        return (Integer)this.field_70180_af.func_187225_a(HITS_TILL_STUN);
    }

    public void setHitsTillStun(int hits) {
        this.field_70180_af.func_187227_b(HITS_TILL_STUN, (Object)hits);
    }

    public void setPossibleDetectionPoint(@Nullable BlockPos detectionPoint) {
        this.func_184212_Q().func_187227_b(POSSIBLE_DETECTION_POINT, Optional.ofNullable(detectionPoint));
    }

    @Nullable
    public BlockPos getPossibleDetectionPoint() {
        return ((Optional)this.func_184212_Q().func_187225_a(POSSIBLE_DETECTION_POINT)).orElse(null);
    }

    public int getTicksSinceLastSonarFire() {
        return this.ticksSinceLastSonarFire;
    }

    public boolean isStunned() {
        return this.getStunTime() > 0;
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74757_a("IsMoving", this.isMoving());
        compound.func_74768_a("WaterTicks", this.getWaterTime());
        compound.func_74768_a("StunnedTicks", this.getStunTime());
        compound.func_74768_a("TicksSinceLastSonarFire", this.getTicksSinceLastSonarFire());
        if (this.getPossibleDetectionPoint() != null) {
            compound.func_218657_a("DetectionPoint", (INBT)NBTUtil.func_186859_a((BlockPos)this.getPossibleDetectionPoint()));
        }
    }

    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        this.setMoving(compound.func_74767_n("IsMoving"));
        this.setWaterTime(compound.func_74762_e("WaterTicks"));
        this.setStunned(compound.func_74762_e("StunnedTicks"));
        this.ticksSinceLastSonarFire = compound.func_74762_e("TicksSinceLastSonarFire");
        if (this.getPossibleDetectionPoint() != null) {
            this.setPossibleDetectionPoint(NBTUtil.func_186861_c((CompoundNBT)compound.func_74775_l("DetectionPoint")));
        }
    }

    public class ThrasherLookController
    extends LookController {
        private int angleLimit;
        private boolean isTurningForSonar;

        public ThrasherLookController(ThrasherEntity thrasher) {
            super((MobEntity)thrasher);
        }

        public void func_75649_a() {
            int n = this.angleLimit = this.field_75659_a.func_184188_bt().isEmpty() ? 10 : 5;
            if (this.field_75655_d) {
                this.field_75655_d = false;
                if (this.isTurningForSonar) {
                    this.field_75659_a.field_70177_z = this.func_220675_a(this.field_75659_a.field_70177_z, this.func_220678_h(), this.field_75657_b);
                } else {
                    this.field_75659_a.field_70759_as = this.func_220675_a(this.field_75659_a.field_70759_as, this.func_220678_h(), this.field_75657_b);
                }
                this.field_75659_a.field_70125_A = this.func_220675_a(this.field_75659_a.field_70125_A, this.func_220677_g(), this.field_75658_c);
            } else {
                if (this.field_75659_a.func_70661_as().func_75500_f()) {
                    this.field_75659_a.field_70125_A = this.func_220675_a(this.field_75659_a.field_70125_A, 0.0f, 5.0f);
                }
                if (this.isTurningForSonar) {
                    this.field_75659_a.field_70177_z = this.func_220675_a(this.field_75659_a.field_70177_z, this.field_75659_a.field_70761_aq, this.field_75657_b);
                } else {
                    this.field_75659_a.field_70759_as = this.func_220675_a(this.field_75659_a.field_70759_as, this.field_75659_a.field_70761_aq, this.field_75657_b);
                }
            }
            float wrappedDegrees = MathHelper.func_76142_g((float)(this.field_75659_a.field_70759_as - this.field_75659_a.field_70761_aq));
            if (wrappedDegrees < (float)(-this.angleLimit)) {
                this.field_75659_a.field_70761_aq -= 4.0f;
            } else if (wrappedDegrees > (float)this.angleLimit) {
                this.field_75659_a.field_70761_aq += 4.0f;
            }
        }

        public void setTurningForSonar(boolean isTurning) {
            this.isTurningForSonar = isTurning;
        }

        public boolean isTurningForSonar() {
            return this.isTurningForSonar;
        }
    }

    static class ThrasherMoveController
    extends MovementController {
        private final ThrasherEntity thrasher;

        public ThrasherMoveController(ThrasherEntity thrasher) {
            super((MobEntity)thrasher);
            this.thrasher = thrasher;
        }

        public void func_75641_c() {
            if (this.field_188491_h == MovementController.Action.MOVE_TO && !this.thrasher.func_70661_as().func_75500_f() && this.thrasher.getStunTime() <= 0) {
                Vector3d vec3d = new Vector3d(this.field_75646_b - this.thrasher.func_226277_ct_(), this.field_75647_c - this.thrasher.func_226278_cu_(), this.field_75644_d - this.thrasher.func_226281_cx_());
                double d0 = vec3d.func_72433_c();
                double d1 = vec3d.field_72448_b / d0;
                float f = (float)(MathHelper.func_181159_b((double)vec3d.field_72449_c, (double)vec3d.field_72450_a) * 57.2957763671875) - 90.0f;
                this.thrasher.field_70761_aq = this.thrasher.field_70177_z = this.func_75639_a(this.thrasher.field_70177_z, f, 10.0f);
                this.thrasher.field_70759_as = this.thrasher.field_70177_z;
                float f1 = (float)(this.field_75645_e * this.thrasher.func_110148_a(Attributes.field_233821_d_).func_111126_e());
                float f2 = MathHelper.func_219799_g((float)0.125f, (float)this.thrasher.func_70689_ay(), (float)f1);
                this.thrasher.func_70659_e(f2);
                double d2 = Math.sin((double)(this.thrasher.field_70173_aa + this.thrasher.func_145782_y()) * 0.5) * 0.05;
                double d3 = Math.cos(this.thrasher.field_70177_z * ((float)Math.PI / 180));
                double d4 = Math.sin(this.thrasher.field_70177_z * ((float)Math.PI / 180));
                double d5 = Math.sin((double)(this.thrasher.field_70173_aa + this.thrasher.func_145782_y()) * 0.75) * 0.05;
                if (this.thrasher.func_70090_H()) {
                    float f3 = -((float)(MathHelper.func_181159_b((double)vec3d.field_72448_b, (double)MathHelper.func_76133_a((double)(vec3d.field_72450_a * vec3d.field_72450_a + vec3d.field_72449_c * vec3d.field_72449_c))) * 57.2957763671875));
                    f3 = MathHelper.func_76131_a((float)MathHelper.func_76142_g((float)f3), (float)-85.0f, (float)85.0f);
                    this.thrasher.field_70125_A = this.func_75639_a(this.thrasher.field_70125_A, f3, 5.0f);
                }
                this.thrasher.func_213317_d(this.thrasher.func_213322_ci().func_72441_c(d2 * d3, d5 * (d4 + d3) * 0.25 + (double)f2 * d1 * 0.1, d2 * d4));
                this.thrasher.setMoving(true);
            } else {
                this.thrasher.func_70659_e(0.0f);
                this.thrasher.setMoving(false);
            }
        }
    }
}

