/*
 * Decompiled with CFR 0.152.
 */
package com.minecraftabnormals.upgrade_aquatic.common.entities.thrasher.ai;

import com.minecraftabnormals.upgrade_aquatic.common.entities.thrasher.SonarWaveEntity;
import com.minecraftabnormals.upgrade_aquatic.common.entities.thrasher.ThrasherEntity;
import com.minecraftabnormals.upgrade_aquatic.core.registry.UAEntities;
import com.teamabnormals.abnormals_core.core.library.endimator.Endimation;
import com.teamabnormals.abnormals_core.core.utils.EntityUtils;
import com.teamabnormals.abnormals_core.core.utils.NetworkUtil;
import java.util.EnumSet;
import java.util.function.BiPredicate;
import javax.annotation.Nullable;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;

public class ThrasherFireSonarGoal
extends Goal {
    public ThrasherEntity thrasher;
    private int turnTicks;
    private int sonarTicks;
    private int sonarFireDuration;
    private float originalYaw;
    private float originalPitch;
    @Nullable
    private SonarPhase sonarPhase;

    public ThrasherFireSonarGoal(ThrasherEntity thrasher) {
        this.thrasher = thrasher;
        this.func_220684_a(EnumSet.of(Goal.Flag.LOOK, Goal.Flag.TARGET));
    }

    public boolean func_75250_a() {
        return SonarPhase.shouldContinueExecutingPhase(null, this.thrasher, this.sonarTicks) && this.thrasher.getTicksSinceLastSonarFire() > 55 && this.thrasher.isEndimationPlaying(ThrasherEntity.BLANK_ANIMATION);
    }

    public boolean func_75253_b() {
        boolean shouldContinue = SonarPhase.shouldContinueExecutingPhase(this.sonarPhase, this.thrasher, this.sonarTicks);
        return shouldContinue && (this.sonarPhase != SonarPhase.FIRE || this.thrasher.func_70638_az() == null && (this.sonarTicks == 0 || this.sonarTicks == this.sonarFireDuration) || this.sonarTicks < this.sonarFireDuration);
    }

    public void func_75249_e() {
        this.sonarPhase = SonarPhase.TURN;
        this.sonarFireDuration = this.thrasher.func_70681_au().nextInt(3) * 5 + 30;
    }

    public void func_75251_c() {
        this.sonarFireDuration = 0;
        this.sonarTicks = 0;
        this.turnTicks = 0;
        this.sonarPhase = null;
        this.thrasher.setPossibleDetectionPoint(null);
        ((ThrasherEntity.ThrasherLookController)this.thrasher.func_70671_ap()).setTurningForSonar(false);
    }

    public void func_75246_d() {
        this.thrasher.func_70661_as().func_75499_g();
        if (this.sonarPhase == SonarPhase.TURN) {
            ++this.turnTicks;
            BlockPos pos = this.thrasher.getPossibleDetectionPoint();
            ((ThrasherEntity.ThrasherLookController)this.thrasher.func_70671_ap()).setTurningForSonar(true);
            this.thrasher.func_70671_ap().func_75650_a((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), 90.0f, 90.0f);
            if (this.turnTicks > 50) {
                this.sonarPhase = SonarPhase.FIRE;
            }
        } else {
            if (this.sonarTicks == 0 && SonarPhase.shouldContinueExecutingPhase(SonarPhase.FIRE, this.thrasher, this.sonarTicks)) {
                this.originalYaw = this.thrasher.field_70177_z;
                this.originalPitch = this.thrasher.field_70125_A;
                NetworkUtil.setPlayingAnimationMessage((Entity)this.thrasher, (Endimation)ThrasherEntity.SONAR_FIRE_ANIMATION);
                this.thrasher.func_184185_a(this.thrasher.getSonarFireSound(), 3.5f, 1.0f);
            }
            ++this.sonarTicks;
            this.stablilizeDirection();
            if (this.sonarTicks % 5 == 0 && this.sonarTicks < this.sonarFireDuration) {
                SonarWaveEntity sonarWave = (SonarWaveEntity)((EntityType)UAEntities.SONAR_WAVE.get()).func_200721_a(this.thrasher.field_70170_p);
                sonarWave.fireSonarWave(this.thrasher);
                this.thrasher.field_70170_p.func_217376_c((Entity)sonarWave);
            }
        }
    }

    private void stablilizeDirection() {
        this.thrasher.field_70126_B = this.originalYaw;
        this.thrasher.field_70127_C = this.originalPitch;
        this.thrasher.field_70177_z = this.originalYaw;
        this.thrasher.field_70125_A = this.originalPitch;
    }

    static enum SonarPhase {
        TURN(null),
        FIRE((thrasher, sonarTicks) -> sonarTicks > 15 ? EntityUtils.rayTrace((Entity)thrasher, (double)32.0, (float)1.0f).func_216346_c() == RayTraceResult.Type.MISS : true);

        @Nullable
        private BiPredicate<ThrasherEntity, Integer> phaseCondition;

        private SonarPhase(BiPredicate<ThrasherEntity, Integer> phaseCondition) {
            this.phaseCondition = phaseCondition;
        }

        public static boolean shouldContinueExecutingPhase(@Nullable SonarPhase phase, ThrasherEntity thrasher, int sonarTicks) {
            boolean defaultCondition;
            boolean bl = defaultCondition = !thrasher.isStunned() && thrasher.func_70090_H() && thrasher.func_184188_bt().isEmpty() && thrasher.func_70638_az() == null && thrasher.getPossibleDetectionPoint() != null && thrasher.field_70170_p.func_180495_p(thrasher.func_233580_cy_().func_177977_b()).func_177230_c() == Blocks.field_150355_j;
            if (phase == null) {
                return defaultCondition;
            }
            return defaultCondition && (phase.phaseCondition != null && phase.phaseCondition.test(thrasher, sonarTicks) || phase.phaseCondition == null);
        }
    }
}

