/*
 * Decompiled with CFR 0.152.
 */
package com.minecraftabnormals.upgrade_aquatic.common.items;

import com.minecraftabnormals.upgrade_aquatic.common.entities.jellyfish.AbstractJellyfishEntity;
import com.minecraftabnormals.upgrade_aquatic.core.other.JellyfishRegistry;
import com.teamabnormals.abnormals_core.core.utils.ItemStackUtils;
import java.util.List;
import java.util.Random;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.Fluid;
import net.minecraft.item.BucketItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.Rarity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.registries.ForgeRegistries;

public class JellyfishBucketItem
extends BucketItem {
    public JellyfishBucketItem(Supplier<? extends Fluid> supplier, Item.Properties builder) {
        super(supplier, builder);
    }

    public void func_203792_a(World worldIn, ItemStack p_203792_2_, BlockPos pos) {
        if (!worldIn.field_72995_K) {
            this.placeEntity(worldIn, p_203792_2_, pos);
        }
    }

    protected void func_203791_b(@Nullable PlayerEntity player, IWorld worldIn, BlockPos pos) {
        worldIn.func_184133_a(player, pos, SoundEvents.field_203819_X, SoundCategory.NEUTRAL, 1.0f, 1.0f);
    }

    private void placeEntity(World world, ItemStack stack, BlockPos pos) {
        AbstractJellyfishEntity jellyfish = this.getEntityInStack(stack, world, pos);
        if (jellyfish != null) {
            jellyfish.setFromBucket(true);
        }
    }

    @Nullable
    public AbstractJellyfishEntity getEntityInStack(ItemStack stack, World world, @Nullable BlockPos pos) {
        CompoundNBT compoundnbt = stack.func_77978_p();
        if (compoundnbt != null && compoundnbt.func_74764_b("JellyfishTag")) {
            AbstractJellyfishEntity jellyfish;
            AbstractJellyfishEntity.BucketData bucketData = AbstractJellyfishEntity.BucketData.read(compoundnbt.func_74775_l("JellyfishTag"));
            Entity entity = pos != null ? ((EntityType)ForgeRegistries.ENTITIES.getValue(new ResourceLocation("upgrade_aquatic:" + bucketData.entityId))).func_220331_a(world, stack, null, pos, SpawnReason.BUCKET, true, false) : ((EntityType)ForgeRegistries.ENTITIES.getValue(new ResourceLocation("upgrade_aquatic:" + bucketData.entityId))).func_200721_a(world);
            AbstractJellyfishEntity abstractJellyfishEntity = jellyfish = entity instanceof AbstractJellyfishEntity ? (AbstractJellyfishEntity)entity : null;
            if (jellyfish == null) {
                return null;
            }
            jellyfish.readBucketData(compoundnbt.func_74775_l("JellyfishTag"));
            return jellyfish;
        }
        if (pos != null) {
            AbstractJellyfishEntity jellyfish = this.getRandomJellyfish(stack, world, pos);
            return jellyfish != null ? jellyfish : null;
        }
        return null;
    }

    private AbstractJellyfishEntity getRandomJellyfish(ItemStack stack, World world, @Nullable BlockPos pos) {
        Random rand = new Random();
        List<JellyfishRegistry.JellyfishEntry<?>> commonJellies = JellyfishRegistry.collectJelliesMatchingRarity(Rarity.COMMON);
        return (AbstractJellyfishEntity)commonJellies.get((int)rand.nextInt((int)commonJellies.size())).jellyfish.get().func_220331_a(world, stack, null, pos, SpawnReason.BUCKET, true, false);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        AbstractJellyfishEntity jellyfish;
        CompoundNBT compoundnbt = stack.func_77978_p();
        if (compoundnbt != null && compoundnbt.func_74764_b("JellyfishTag") && (jellyfish = this.getEntityInStack(stack, worldIn, null)) != null) {
            TextFormatting[] atextformatting = new TextFormatting[]{TextFormatting.ITALIC, TextFormatting.GRAY};
            tooltip.add((ITextComponent)new TranslationTextComponent("tooltip.upgrade_aquatic." + jellyfish.getBucketName() + "_jellyfish").func_240701_a_(atextformatting));
            tooltip.add(jellyfish.getYieldingTorchMessage());
        }
    }

    public void func_150895_a(ItemGroup group, NonNullList<ItemStack> items) {
        if (this.func_194125_a(group)) {
            int targetIndex = ItemStackUtils.findIndexOfItem((Item)Items.field_204272_aO, items);
            if (targetIndex != -1) {
                items.add(targetIndex + 1, (Object)new ItemStack((IItemProvider)this));
            } else {
                super.func_150895_a(group, items);
            }
        }
    }
}

