/*
 * Decompiled with CFR 0.152.
 */
package com.minecraftabnormals.upgrade_aquatic.core.other;

import com.google.common.collect.Maps;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.FallingBlockEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Util;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.registries.ForgeRegistries;

public class UAHooks {
    private static final Map<Supplier<Block>, Supplier<Block>> FALLABLES = (Map)Util.func_200696_a((Object)Maps.newHashMap(), fallables -> {
        fallables.put(() -> Blocks.field_150322_A, () -> Blocks.field_150354_m);
        fallables.put(() -> Blocks.field_180395_cM, () -> Blocks.field_196611_F);
        fallables.put(() -> Blocks.field_150347_e, () -> Blocks.field_150351_n);
    });
    private static final Map<Supplier<Block>, Supplier<Block>> ATMOSHPERIC_FALLABLES = ModList.get().isLoaded("atmospheric") ? (Map)Util.func_200696_a((Object)Maps.newHashMap(), fallables -> {
        fallables.put(() -> (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation("atmospheric:arid_sandstone")), () -> (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation("atmospheric:arid_sand")));
        fallables.put(() -> (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation("atmospheric:red_arid_sandstone")), () -> (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation("atmospheric:red_arid_sand")));
    }) : null;

    public static void addBubbleColumnBehaviors(BlockState state, ServerWorld world, BlockPos pos) {
        BlockPos abovePos = pos.func_177984_a();
        Block aboveBlock = world.func_180495_p(abovePos).func_177230_c();
        boolean noFallingBlockAbove = world.func_217357_a(FallingBlockEntity.class, new AxisAlignedBB(pos)).isEmpty();
        if (noFallingBlockAbove) {
            FALLABLES.forEach((inputBlock, outputBlock) -> {
                if (inputBlock.get() == aboveBlock) {
                    UAHooks.spawnFallingBlock(world, pos, (Block)outputBlock.get());
                }
            });
            if (ATMOSHPERIC_FALLABLES != null) {
                ATMOSHPERIC_FALLABLES.forEach((inputBlock, outputBlock) -> {
                    if (inputBlock.get() == aboveBlock) {
                        UAHooks.spawnFallingBlock(world, pos, (Block)outputBlock.get());
                    }
                });
            }
        }
    }

    private static void spawnFallingBlock(ServerWorld world, BlockPos pos, Block block) {
        FallingBlockEntity fallingblockentity = new FallingBlockEntity((World)world, (double)((float)pos.func_177958_n() + 0.5f), (double)pos.func_177956_o(), (double)((float)pos.func_177952_p() + 0.5f), block.func_176223_P());
        fallingblockentity.field_145812_b = 1;
        world.func_217376_c((Entity)fallingblockentity);
    }

    public static void makeBubbleColumnTickRandomly() {
        ObfuscationReflectionHelper.setPrivateValue(AbstractBlock.class, (Object)Blocks.field_203203_C, (Object)true, (String)"field_149789_z");
    }
}

