/*
 * Decompiled with CFR 0.152.
 */
package vectorwing.farmersdelight.blocks;

import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.IWaterLoggable;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.FluidState;
import net.minecraft.fluid.Fluids;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.BlockItem;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ShearsItem;
import net.minecraft.item.TieredItem;
import net.minecraft.item.TridentItem;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ItemParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import vectorwing.farmersdelight.registry.ModTileEntityTypes;
import vectorwing.farmersdelight.tile.CuttingBoardTileEntity;

public class CuttingBoardBlock
extends Block
implements IWaterLoggable {
    protected static final VoxelShape SHAPE = Block.func_208617_a((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)1.0, (double)15.0);
    public static final DirectionProperty FACING = BlockStateProperties.field_208157_J;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.field_208198_y;

    public CuttingBoardBlock() {
        super(AbstractBlock.Properties.func_200945_a((Material)Material.field_151575_d).func_200943_b(2.0f).func_200947_a(SoundType.field_185848_a));
        this.func_180632_j((BlockState)((BlockState)((BlockState)this.func_176194_O().func_177621_b()).func_206870_a((Property)FACING, (Comparable)Direction.NORTH)).func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return SHAPE;
    }

    public VoxelShape func_220071_b(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return SHAPE;
    }

    public ActionResultType func_225533_a_(BlockState state, World worldIn, BlockPos pos, PlayerEntity player, Hand handIn, BlockRayTraceResult hit) {
        TileEntity tileentity = worldIn.func_175625_s(pos);
        if (tileentity instanceof CuttingBoardTileEntity) {
            CuttingBoardTileEntity cuttingBoardTE = (CuttingBoardTileEntity)tileentity;
            ItemStack itemHeld = player.func_184586_b(handIn);
            ItemStack itemOffhand = player.func_184592_cb();
            if (cuttingBoardTE.isEmpty()) {
                if (!itemOffhand.func_190926_b() && handIn.equals((Object)Hand.MAIN_HAND) && !(itemHeld.func_77973_b() instanceof BlockItem)) {
                    return ActionResultType.PASS;
                }
                if (itemHeld.func_190926_b()) {
                    return ActionResultType.PASS;
                }
                if (cuttingBoardTE.addItem(player.field_71075_bZ.field_75098_d ? itemHeld.func_77946_l() : itemHeld)) {
                    worldIn.func_184148_a(null, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), SoundEvents.field_187891_gV, SoundCategory.BLOCKS, 1.0f, 0.8f);
                    return ActionResultType.SUCCESS;
                }
            } else {
                if (!itemHeld.func_190926_b()) {
                    ItemStack boardItem = cuttingBoardTE.getStoredItem().func_77946_l();
                    if (cuttingBoardTE.processItemUsingTool(itemHeld, player)) {
                        CuttingBoardBlock.spawnCuttingParticles(worldIn, pos, boardItem, 5);
                        return ActionResultType.SUCCESS;
                    }
                    return ActionResultType.PASS;
                }
                if (handIn.equals((Object)Hand.MAIN_HAND)) {
                    if (!player.func_184812_l_()) {
                        InventoryHelper.func_180173_a((World)worldIn, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), (ItemStack)cuttingBoardTE.removeItem());
                    } else {
                        cuttingBoardTE.removeItem();
                    }
                    worldIn.func_184148_a(null, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), SoundEvents.field_187889_gU, SoundCategory.BLOCKS, 0.25f, 0.5f);
                    return ActionResultType.SUCCESS;
                }
            }
        }
        return ActionResultType.PASS;
    }

    public static void spawnCuttingParticles(World worldIn, BlockPos pos, ItemStack stack, int count) {
        for (int i = 0; i < count; ++i) {
            Vector3d vec3d = new Vector3d(((double)worldIn.field_73012_v.nextFloat() - 0.5) * 0.1, Math.random() * 0.1 + 0.1, ((double)worldIn.field_73012_v.nextFloat() - 0.5) * 0.1);
            if (worldIn instanceof ServerWorld) {
                ((ServerWorld)worldIn).func_195598_a((IParticleData)new ItemParticleData(ParticleTypes.field_197591_B, stack), (double)((float)pos.func_177958_n() + 0.5f), (double)((float)pos.func_177956_o() + 0.1f), (double)((float)pos.func_177952_p() + 0.5f), 1, vec3d.field_72450_a, vec3d.field_72448_b + 0.05, vec3d.field_72449_c, 0.0);
                continue;
            }
            worldIn.func_195594_a((IParticleData)new ItemParticleData(ParticleTypes.field_197591_B, stack), (double)((float)pos.func_177958_n() + 0.5f), (double)((float)pos.func_177956_o() + 0.1f), (double)((float)pos.func_177952_p() + 0.5f), vec3d.field_72450_a, vec3d.field_72448_b + 0.05, vec3d.field_72449_c);
        }
    }

    public void func_196243_a(BlockState state, World worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
        if (state.func_177230_c() != newState.func_177230_c()) {
            TileEntity tileentity = worldIn.func_175625_s(pos);
            if (tileentity instanceof CuttingBoardTileEntity) {
                InventoryHelper.func_180173_a((World)worldIn, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), (ItemStack)((CuttingBoardTileEntity)tileentity).getStoredItem());
                worldIn.func_175666_e(pos, (Block)this);
            }
            super.func_196243_a(state, worldIn, pos, newState, isMoving);
        }
    }

    public boolean func_181623_g() {
        return true;
    }

    public BlockState func_196258_a(BlockItemUseContext context) {
        FluidState ifluidstate = context.func_195991_k().func_204610_c(context.func_195995_a());
        return (BlockState)((BlockState)this.func_176223_P().func_206870_a((Property)FACING, (Comparable)context.func_195992_f().func_176734_d())).func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(ifluidstate.func_206886_c() == Fluids.field_204546_a));
    }

    public BlockState func_196271_a(BlockState stateIn, Direction facing, BlockState facingState, IWorld worldIn, BlockPos currentPos, BlockPos facingPos) {
        if (((Boolean)stateIn.func_177229_b((Property)WATERLOGGED)).booleanValue()) {
            worldIn.func_205219_F_().func_205360_a(currentPos, (Object)Fluids.field_204546_a, Fluids.field_204546_a.func_205569_a((IWorldReader)worldIn));
        }
        return facing == Direction.DOWN && !stateIn.func_196955_c((IWorldReader)worldIn, currentPos) ? Blocks.field_150350_a.func_176223_P() : super.func_196271_a(stateIn, facing, facingState, worldIn, currentPos, facingPos);
    }

    public boolean func_196260_a(BlockState state, IWorldReader worldIn, BlockPos pos) {
        BlockPos blockpos = pos.func_177977_b();
        return CuttingBoardBlock.func_220064_c((IBlockReader)worldIn, (BlockPos)blockpos) || CuttingBoardBlock.func_220055_a((IWorldReader)worldIn, (BlockPos)blockpos, (Direction)Direction.UP);
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        super.func_206840_a(builder);
        builder.func_206894_a(new Property[]{FACING, WATERLOGGED});
    }

    public FluidState func_204507_t(BlockState state) {
        return (Boolean)state.func_177229_b((Property)WATERLOGGED) != false ? Fluids.field_204546_a.func_207204_a(false) : super.func_204507_t(state);
    }

    public boolean func_149740_M(BlockState state) {
        return true;
    }

    public int func_180641_l(BlockState blockState, World worldIn, BlockPos pos) {
        if (worldIn.func_175625_s(pos) instanceof CuttingBoardTileEntity) {
            ItemStack boardItem = ((CuttingBoardTileEntity)worldIn.func_175625_s(pos)).getStoredItem();
            return !boardItem.func_190926_b() ? 15 : 0;
        }
        return 0;
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    @Nullable
    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return ((TileEntityType)ModTileEntityTypes.CUTTING_BOARD_TILE.get()).func_200968_a();
    }

    @Mod.EventBusSubscriber(modid="farmersdelight", bus=Mod.EventBusSubscriber.Bus.FORGE)
    public static class ToolCarvingEvent {
        @SubscribeEvent
        public static void onSneakPlaceTool(PlayerInteractEvent.RightClickBlock event) {
            boolean success;
            World world = event.getWorld();
            BlockPos pos = event.getPos();
            PlayerEntity player = event.getPlayer();
            ItemStack heldItem = player.func_184614_ca();
            if (player.func_226563_dT_() && !heldItem.func_190926_b() && world.func_175625_s(event.getPos()) instanceof CuttingBoardTileEntity && (heldItem.func_77973_b() instanceof TieredItem || heldItem.func_77973_b() instanceof TridentItem || heldItem.func_77973_b() instanceof ShearsItem) && (success = ((CuttingBoardTileEntity)world.func_175625_s(event.getPos())).carveToolOnBoard(player.field_71075_bZ.field_75098_d ? heldItem.func_77946_l() : heldItem))) {
                world.func_184148_a(null, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), SoundEvents.field_187891_gV, SoundCategory.BLOCKS, 1.0f, 0.8f);
                event.setCanceled(true);
                event.setCancellationResult(ActionResultType.SUCCESS);
            }
        }
    }
}

