/*
 * Decompiled with CFR 0.152.
 */
package vectorwing.farmersdelight.blocks;

import java.util.Random;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.FarmlandBlock;
import net.minecraft.block.IGrowable;
import net.minecraft.entity.Entity;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.state.Property;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.FarmlandWaterManager;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.common.PlantType;
import vectorwing.farmersdelight.registry.ModBlocks;
import vectorwing.farmersdelight.utils.MathUtils;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class RichSoilFarmlandBlock
extends FarmlandBlock {
    public RichSoilFarmlandBlock(AbstractBlock.Properties builder) {
        super(builder);
    }

    public boolean isFertile(BlockState state, IBlockReader world, BlockPos pos) {
        if (this.getBlock() == this) {
            return (Integer)state.func_177229_b((Property)field_176531_a) > 0;
        }
        return false;
    }

    public void func_225534_a_(BlockState state, ServerWorld worldIn, BlockPos pos, Random rand) {
        if (!state.func_196955_c((IWorldReader)worldIn, pos)) {
            RichSoilFarmlandBlock.turnToRichSoil(state, (World)worldIn, pos);
        }
    }

    public void func_225542_b_(BlockState state, ServerWorld worldIn, BlockPos pos, Random random) {
        IGrowable growable;
        BlockState plant;
        int i = (Integer)state.func_177229_b((Property)field_176531_a);
        if (!RichSoilFarmlandBlock.hasWater((IWorldReader)worldIn, pos) && !worldIn.func_175727_C(pos.func_177984_a())) {
            if (i > 0) {
                worldIn.func_180501_a(pos, (BlockState)state.func_206870_a((Property)field_176531_a, (Comparable)Integer.valueOf(i - 1)), 2);
            }
        } else if (i < 7) {
            worldIn.func_180501_a(pos, (BlockState)state.func_206870_a((Property)field_176531_a, (Comparable)Integer.valueOf(7)), 2);
        } else if (i == 7 && (plant = worldIn.func_180495_p(pos.func_177984_a())).func_177230_c() instanceof IGrowable && MathUtils.RAND.nextInt(10) <= 3 && (growable = (IGrowable)plant.func_177230_c()).func_176473_a((IBlockReader)worldIn, pos.func_177984_a(), plant, false)) {
            growable.func_225535_a_(worldIn, worldIn.field_73012_v, pos.func_177984_a(), plant);
        }
    }

    public boolean canSustainPlant(BlockState state, IBlockReader world, BlockPos pos, Direction facing, IPlantable plantable) {
        PlantType type = plantable.getPlantType(world, pos.func_177972_a(facing));
        return type == PlantType.CROP || type == PlantType.PLAINS;
    }

    private static boolean hasWater(IWorldReader worldIn, BlockPos pos) {
        for (BlockPos blockpos : BlockPos.func_218278_a((BlockPos)pos.func_177982_a(-4, 0, -4), (BlockPos)pos.func_177982_a(4, 1, 4))) {
            if (!worldIn.func_204610_c(blockpos).func_206884_a((ITag)FluidTags.field_206959_a)) continue;
            return true;
        }
        return FarmlandWaterManager.hasBlockWaterTicket((IWorldReader)worldIn, (BlockPos)pos);
    }

    public BlockState func_196258_a(BlockItemUseContext context) {
        return !this.func_176223_P().func_196955_c((IWorldReader)context.func_195991_k(), context.func_195995_a()) ? ((Block)ModBlocks.RICH_SOIL.get()).func_176223_P() : super.func_196258_a(context);
    }

    public void func_180658_a(World worldIn, BlockPos pos, Entity entityIn, float fallDistance) {
    }

    public static void turnToRichSoil(BlockState state, World worldIn, BlockPos pos) {
        worldIn.func_175656_a(pos, RichSoilFarmlandBlock.func_199601_a((BlockState)state, (BlockState)((Block)ModBlocks.RICH_SOIL.get()).func_176223_P(), (World)worldIn, (BlockPos)pos));
    }
}

