/*
 * Decompiled with CFR 0.152.
 */
package vectorwing.farmersdelight.enchantments;

import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.enchantment.EnchantmentType;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import vectorwing.farmersdelight.registry.ModEnchantments;

public class BackstabbingEnchantment
extends Enchantment {
    public BackstabbingEnchantment(Enchantment.Rarity rarityIn, EnchantmentType typeIn, EquipmentSlotType ... slots) {
        super(rarityIn, typeIn, slots);
    }

    public int func_77319_d() {
        return 1;
    }

    public int func_77325_b() {
        return 3;
    }

    public int func_77321_a(int enchantmentLevel) {
        return 15 + (enchantmentLevel - 1) * 9;
    }

    public int func_223551_b(int enchantmentLevel) {
        return super.func_77321_a(enchantmentLevel) + 50;
    }

    public static boolean isLookingBehindTarget(LivingEntity target, Vector3d attackerLocation) {
        if (attackerLocation != null) {
            Vector3d vec3d = target.func_70676_i(1.0f);
            Vector3d vec3d1 = attackerLocation.func_178788_d(target.func_213303_ch()).func_72432_b();
            vec3d1 = new Vector3d(vec3d1.field_72450_a, 0.0, vec3d1.field_72449_c);
            return vec3d1.func_72430_b(vec3d) < -0.5;
        }
        return false;
    }

    public static float getBackstabbingDamagePerLevel(float amount, int level) {
        float multiplier = (float)level * 0.4f + 1.0f;
        return amount * multiplier;
    }

    @Mod.EventBusSubscriber(modid="farmersdelight", bus=Mod.EventBusSubscriber.Bus.FORGE)
    public static class BackstabbingEvent {
        @SubscribeEvent
        public static void onKnifeBackstab(LivingHurtEvent event) {
            Entity attacker = event.getSource().func_76346_g();
            if (attacker instanceof PlayerEntity) {
                ItemStack weapon = ((PlayerEntity)attacker).func_184614_ca();
                int level = EnchantmentHelper.func_77506_a((Enchantment)((Enchantment)ModEnchantments.BACKSTABBING.get()), (ItemStack)weapon);
                if (level > 0 && BackstabbingEnchantment.isLookingBehindTarget(event.getEntityLiving(), event.getSource().func_188404_v())) {
                    World world = event.getEntityLiving().func_130014_f_();
                    if (!world.field_72995_K) {
                        event.setAmount(BackstabbingEnchantment.getBackstabbingDamagePerLevel(event.getAmount(), level));
                        world.func_184148_a(null, attacker.func_226277_ct_(), attacker.func_226278_cu_(), attacker.func_226281_cx_(), SoundEvents.field_187718_dS, SoundCategory.BLOCKS, 1.0f, 1.0f);
                    }
                }
            }
        }
    }
}

